package org.monazilla.v2c;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class V2CReplaceStr
{

	static V2CReplaceStr[] getEntries(V2CThreadItem v2cthreaditem)
	{
		if (v2cthreaditem == null || (v2cthreaditem instanceof V2CNewThreadItem))
			return null;
		V2CReplaceStr av2creplacestr[] = getEntries(v2cthreaditem.isTwitter());
		int i = av2creplacestr.length;
		if (i == 0)
			return null;
		String s = v2cthreaditem.getTitle();
		String s1 = v2cthreaditem.getFormalURLString();
		ArrayList arraylist = new ArrayList();
		for (int j = 0; j < i; j++) {
			V2CReplaceStr v2creplacestr = av2creplacestr[j];
			if (v2creplacestr.isApplicable(s1, s))
				arraylist.add(v2creplacestr);
		}

		int k = arraylist.size();
		if (k == 0)
			return null;
		else
			return (V2CReplaceStr[]) (V2CReplaceStr[]) arraylist.toArray(new V2CReplaceStr[arraylist.size()]);
	}

	static synchronized void reloadEntries(boolean flag)
	{
		if (flag)
			vlTwReplaceStrTxt = null;
		else
			vlReplaceStrTxt = null;
		getEntries(flag);
		V2CThreadPanel.replaceStrTxtReloaded(flag);
	}

	static synchronized V2CReplaceStr[] getEntries(boolean flag)
	{
		V2CReplaceStr av2creplacestr[] = flag ? vlTwReplaceStrTxt : vlReplaceStrTxt;
		if (av2creplacestr == null) {
			ArrayList arraylist = new ArrayList();
			BufferedReader[] bufferedreader = {null, null, null};
			if (flag) {
				bufferedreader[0] = V2CLocalFileHandler.getUserConfigReader("ReplaceStr_TwU.txt", "UTF-8");
				if (bufferedreader[0] == null)
					bufferedreader[0] = V2CLocalFileHandler.getUserConfigReader("ReplaceStr_Tw.txt", "MS932");
			}
			else {
				File file0 = new File(V2CLauncher.getJarDir(), "ReplaceStr_B11_Dev.txt");
				if(file0.exists()){
					try {
						bufferedreader[0] = new BufferedReader(new InputStreamReader(new FileInputStream(file0), "MS932"));
						System.out.println("Use " + file0.getName());
					} catch (UnsupportedEncodingException e) {
						// TODO 自動生成された catch ブロック
						e.printStackTrace();
					} catch (FileNotFoundException e) {
						// TODO 自動生成された catch ブロック
						e.printStackTrace();
					}
				}
				File file1 = new File(V2CLauncher.getJarDir(), "ReplaceStr_B11.txt");
				if(bufferedreader[0] == null && file1.exists()){
					try {
						bufferedreader[1] = new BufferedReader(new InputStreamReader(new FileInputStream(file1), "MS932"));
						System.out.println("Use " + file1.getName());
					} catch (UnsupportedEncodingException e) {
						// TODO 自動生成された catch ブロック
						e.printStackTrace();
					} catch (FileNotFoundException e) {
						// TODO 自動生成された catch ブロック
						e.printStackTrace();
					}
				}
				bufferedreader[2] = V2CLocalFileHandler.getUserConfigReader("ReplaceStr.txt", "MS932");
			}
			for(int i=0; i<bufferedreader.length; i++)
			if (bufferedreader[i] != null)
				try {
					do {
						String s;
						if ((s = bufferedreader[i].readLine()) == null)
							break;
						if (s.length() > 3) {
							char c = s.charAt(0);
							if (c != ';' && c != '\'' && (c != '/' || s.charAt(1) != '/')) {
								String as[] = V2CMiscUtil.split(s, '\t', false);
								if (as != null) {
									V2CReplaceStr v2creplacestr = new V2CReplaceStr(as);
									if (v2creplacestr.bOK)
										arraylist.add(v2creplacestr);
								}
							}
						}
					} while (true);
				}
				catch (IOException ioexception) {
					ioexception.printStackTrace();
				}
				finally {
					V2CLocalFileHandler.closeReader(bufferedreader[i]);
				}
			av2creplacestr = (V2CReplaceStr[]) (V2CReplaceStr[]) arraylist.toArray(new V2CReplaceStr[arraylist.size()]);
			if (flag)
				vlTwReplaceStrTxt = av2creplacestr;
			else
				vlReplaceStrTxt = av2creplacestr;
		}
		return av2creplacestr;
	}

	private V2CReplaceStr(String as[])
	{
		int i = as.length;
		if (i < 2 || i > 4)
			return;
		if (i >= 3) {
			String s = as[2];
			boolean flag;
			boolean flag1;
			boolean flag2;
			if (s.length() > 0) {
				flag = flag1 = flag2 = false;
				if (s.indexOf(',') >= 0) {
					String as1[] = V2CMiscUtil.split(s, ',', false);
					for (int k = 0; k < as1.length; k++) {
						String s4 = as1[k];
						if (s4.equals("all"))
							flag = flag1 = flag2 = true;
						else if (s4.equals("name"))
							flag = true;
						else if (s4.equals("mail"))
							flag1 = true;
						else if (s4.equals("msg"))
							flag2 = true;
					}

				}
				else if (s.equals("all"))
					flag = flag2 = true;
				else if (s.equals("name"))
					flag = true;
				else if (s.equals("mail"))
					flag1 = true;
				else if (s.equals("msg"))
					flag2 = true;
				else
					return;
			}
			else {
				flag = flag1 = flag2 = true;
			}
			if (!flag && !flag1 && !flag2)
				return;
			bName = flag;
			bMail = flag1;
			bMessage = flag2;
		}
		String s1 = as[0];
		String s2 = as[1];
		int j = parseFirstType(s1);
		if (j > 0)
			s1 = s1.substring(j);
		if (bRegEx) {
			Pattern pattern;
			try {
				if (bCaseSens)
					pattern = Pattern.compile(s1);
				else
					pattern = Pattern.compile(s1, 2);
			}
			catch (Exception exception) {
				System.out.println(exception.getMessage());
				return;
			}
			mTarget = pattern.matcher("");
			s2 = V2CMiscUtil.convertJaneRegExp(s2);
		}
		else {
			if (!bCaseSens)
				s1 = V2CMiscUtil.normalizeCase(s1);
			sTarget = s1;
		}
		sReplace = s2;
		if (i == 4) {
			String s3 = as[3];
			if (parseTargetType(s3))
				s3 = s3.substring(3);
			if (s3.length() > 0) {
				if (bTargetRegEx)
					try {
						mTargetType = Pattern.compile(s3, 2).matcher("");
					}
					catch (Exception exception1) {
						System.out.println(exception1.getMessage());
						return;
					}
				else
					sTargetType = V2CMiscUtil.normalizeCase(s3);
				bTargetDefined = true;
			}
		}
		bOK = true;
	}

	int parseFirstType(String s)
	{
		if (s.length() < 5 || s.charAt(0) != '<' && s.charAt(2) != 'x')
			return 0;
		byte byte0 = 4;
		boolean flag = false;
		boolean flag1 = false;
		char c = s.charAt(3);
		if (c == '2' && s.charAt(4) == '>') {
			byte0 = 5;
			flag1 = true;
		}
		else if (c != '>')
			return 0;
		char c1 = s.charAt(1);
		if (c1 == 'r')
			flag = true;
		else if (c1 != 'e')
			return 0;
		bRegEx = flag;
		bCaseSens = flag1;
		return byte0;
	}

	boolean parseTargetType(String s)
	{
		if (s.length() < 3 || s.charAt(0) != '<' && s.charAt(2) != '>')
			return false;
		boolean flag = false;
		boolean flag1 = false;
		boolean flag2 = false;
		char c = s.charAt(1);
		switch (c - 48) {
			case 1: // '\001'
				flag2 = true;
				break;

			case 2: // '\002'
				flag1 = true;
				break;

			case 3: // '\003'
				flag2 = flag1 = true;
				break;

			case 4: // '\004'
				flag = true;
				break;

			case 5: // '\005'
				flag = flag2 = true;
				break;

			default:
				return false;

			case 0: // '\0'
				break;
		}
		bTargetRegEx = flag;
		bTargetMatch = flag1;
		bTargetInvert = flag2;
		return true;
	}

	V2CCharSequence replace(V2CCharSequence v2ccharsequence, int i)
    {
        switch(i)
        {
        case 0: // '\0'
            if(!bName)
                return v2ccharsequence;
            break;

        case 1: // '\001'
            if(!bMail)
                return v2ccharsequence;
            break;

        case 3: // '\003'
            if(!bMessage)
                return v2ccharsequence;
            break;

        case 2: // '\002'
        default:
            return v2ccharsequence;
        }
        if(bRegEx) {
        	StringBuffer stringbuffer = null;
	        Matcher matcher = mTarget;
	        synchronized (matcher) {
	        	matcher.reset(v2ccharsequence);
	        	while (matcher.find()) {
		            if(stringbuffer == null)
		                stringbuffer = new StringBuffer();
		            try
		            {
		                matcher.appendReplacement(stringbuffer, sReplace);
		            }
		            catch(Exception exception)
		            {
		                return v2ccharsequence;
		            }
		        }
	        	if(stringbuffer == null) {
	        		return v2ccharsequence;
	        	}
	        	matcher.appendTail(stringbuffer);
	        }
	        int j = stringbuffer.length();
	        char ac[] = new char[j + 2];
	        stringbuffer.getChars(0, j, ac, 0);
	        return new V2CCharSequence(ac, 0, j);
	    }
        String s = v2ccharsequence.toString();
        String s1 = bCaseSens ? s : V2CMiscUtil.normalizeCase(s);
        String s2 = sTarget;
        StringBuffer stringbuffer1 = null;
        for(int k = 0, l = 0, i1 = s2.length(); (k = s1.indexOf(s2, k)) >= 0; k += i1)
        {
            if(stringbuffer1 == null)
                stringbuffer1 = new StringBuffer(s);
            stringbuffer1.replace(k + l, k + l + i1, sReplace);
            l += sReplace.length() - i1;
        }

        if(stringbuffer1 == null)
        {
            return v2ccharsequence;
        } else
        {
            int j1 = stringbuffer1.length();
            char ac1[] = new char[j1 + 2];
            stringbuffer1.getChars(0, j1, ac1, 0);
            return new V2CCharSequence(ac1, 0, j1);
        }
    }

	boolean isApplicable(String s, String s1)
	{
		if (!bTargetDefined)
			return true;
		if (bTargetInvert)
			return !isApplicable(s) && !isApplicable(s1);
		else
			return isApplicable(s) || isApplicable(s1);
	}

	private boolean isApplicable(String s)
	{
		if (s == null)
			return false;
		boolean flag;
		if (bTargetRegEx) {
			Matcher matcher = mTargetType;
			synchronized (matcher) {
				matcher.reset(s);
				flag = matcher.find();
			}
		}
		else {
			s = V2CMiscUtil.normalizeCase(s);
			if (bTargetMatch)
				flag = s.equals(sTargetType);
			else
				flag = s.indexOf(sTargetType) >= 0;
		}
		return flag;
	}

	private static final String sFileName = "ReplaceStr.txt";
	private static final String sTwFileName = "ReplaceStr_Tw.txt";
	private static final String sTwUFileName = "ReplaceStr_TwU.txt";
	static final int TARGET_NAME = 0;
	static final int TARGET_MAIL = 1;
	static final int TARGET_MESSAGE = 3;
	static V2CReplaceStr vlReplaceStrTxt[];
	static V2CReplaceStr vlTwReplaceStrTxt[];
	boolean bRegEx;
	boolean bCaseSens;
	String sTarget;
	Matcher mTarget;
	String sReplace;
	boolean bName;
	boolean bMail;
	boolean bMessage;
	boolean bTargetDefined;
	boolean bTargetRegEx;
	boolean bTargetMatch;
	boolean bTargetInvert;
	String sTargetType;
	Matcher mTargetType;
	boolean bOK;
}
