package org.monazilla.v2c;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.text.NumberFormat;

import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class V2CProxySettingPanel extends JPanel implements ChangeListener
{

	public V2CProxySettingPanel(V2CProxySetting v2cproxysetting, V2CProxySetting v2cproxysetting1)
	{
		super(new GridBagLayout());
		psRead = v2cproxysetting;
		psWrite = v2cproxysetting1;
		GridBagConstraints gridbagconstraints = V2CSwingUtil.createGridBagConstraints();
		NumberFormat numberformat = NumberFormat.getIntegerInstance();
		numberformat.setGroupingUsed(false);
		JPanel jpanel = new JPanel(new GridBagLayout());
		jpanel.setBorder(new TitledBorder("\u8AAD\u307F\u8FBC\u307FProxy"));
		gridbagconstraints.gridx = 0;
		gridbagconstraints.gridy = 0;
		jcbUseReadProxy = new JCheckBox("Proxy\u3092\u4F7F\u7528\u3059\u308B", v2cproxysetting.proxyUsed());
		jcbUseReadProxy.setFocusable(false);
		gridbagconstraints.gridwidth = 0;
		gridbagconstraints.anchor = 17;
		jpanel.add(jcbUseReadProxy, gridbagconstraints);
		gridbagconstraints.gridwidth = 1;
		gridbagconstraints.gridx = 0;
		gridbagconstraints.gridy++;
		jpanel.add(new JLabel(" Host: "), gridbagconstraints);
		gridbagconstraints.gridx++;
		jtfReadHost = new V2CTextField(v2cproxysetting.getHost(), 20);
		jpanel.add(jtfReadHost, gridbagconstraints);
		gridbagconstraints.gridx++;
		jpanel.add(new JLabel("  Port: "), gridbagconstraints);
		gridbagconstraints.gridx++;
		jftfReadPort = new JFormattedTextField(numberformat);
		jftfReadPort.setHorizontalAlignment(4);
		jftfReadPort.setValue(new Integer(v2cproxysetting.getPort()));
		jftfReadPort.setColumns(6);
		jpanel.add(jftfReadPort, gridbagconstraints);
		gridbagconstraints.gridx = 0;
		gridbagconstraints.gridy++;
		jpanel.add(new JLabel(" ID: "), gridbagconstraints);
		gridbagconstraints.gridx++;
		jtfReadUser = new V2CTextField(v2cproxysetting.getID(), 15);
		jpanel.add(jtfReadUser, gridbagconstraints);
		gridbagconstraints.gridx = 0;
		gridbagconstraints.gridy++;
		jpanel.add(new JLabel(" PW: "), gridbagconstraints);
		gridbagconstraints.gridx++;
		jpfReadPass = new JPasswordField(v2cproxysetting.getPW(), 15);
		jpanel.add(jpfReadPass, gridbagconstraints);
		gridbagconstraints.gridx++;
		JPanel jpanel1 = new JPanel(new GridBagLayout());
		jpanel1.setBorder(new TitledBorder("\u66F8\u304D\u8FBC\u307FProxy"));
		gridbagconstraints.gridx = 0;
		gridbagconstraints.gridy = 0;
		jcbUseWriteProxy = new JCheckBox("Proxy\u3092\u4F7F\u7528\u3059\u308B", v2cproxysetting1.proxyUsed());
		jcbUseWriteProxy.setFocusable(false);
		gridbagconstraints.gridwidth = 0;
		jpanel1.add(jcbUseWriteProxy, gridbagconstraints);
		gridbagconstraints.gridwidth = 1;
		gridbagconstraints.gridy++;
		jpanel1.add(new JLabel(" Host: "), gridbagconstraints);
		gridbagconstraints.gridx++;
		jtfWriteHost = new V2CTextField(v2cproxysetting1.getHost(), 20);
		jpanel1.add(jtfWriteHost, gridbagconstraints);
		gridbagconstraints.gridx++;
		jpanel1.add(new JLabel("  Port: "), gridbagconstraints);
		gridbagconstraints.gridx++;
		jftfWritePort = new JFormattedTextField(numberformat);
		jftfWritePort.setHorizontalAlignment(4);
		jftfWritePort.setValue(new Integer(v2cproxysetting1.getPort()));
		jftfWritePort.setColumns(6);
		jpanel1.add(jftfWritePort, gridbagconstraints);
		gridbagconstraints.gridx = 0;
		gridbagconstraints.gridy++;
		jpanel1.add(new JLabel(" ID: "), gridbagconstraints);
		gridbagconstraints.gridx++;
		jtfWriteUser = new V2CTextField(v2cproxysetting1.getID(), 15);
		jpanel1.add(jtfWriteUser, gridbagconstraints);
		gridbagconstraints.gridx = 0;
		gridbagconstraints.gridy++;
		jpanel1.add(new JLabel(" PW: "), gridbagconstraints);
		gridbagconstraints.gridx++;
		jpfWritePass = new JPasswordField(v2cproxysetting1.getPW(), 15);
		jpanel1.add(jpfWritePass, gridbagconstraints);
		gridbagconstraints.gridx++;
		String s = System.getProperty("java.net.preferIPv6Addresses");
		String X = (s != null && s.equals("true")?"4":"6");
		JPanel jpanel2 = new JPanel(new GridBagLayout());
		jpanel2.setBorder(new TitledBorder("IPv"+X));
		gridbagconstraints.gridx = 0;
		gridbagconstraints.gridy = 0;
		Insets insets = gridbagconstraints.insets;
		gridbagconstraints.insets = new Insets(1, 2, 1, 2);
		JCheckBox jcheckbox = new JCheckBox(
				"\u66F8\u304D\u8FBC\u307F\u6642IPv"+X+"\u306E\u30A2\u30C9\u30EC\u30B9\u3092\u512A\u5148\u3059\u308B", V2CApp
						.getUserProperty().getBoolean("PreferIPv6Addresses"));
		jcbPreferIPv6Addresses = jcheckbox;
		jcheckbox.setFocusable(false);
		gridbagconstraints.fill = 2;
		gridbagconstraints.weightx = 1.0D;
		jpanel2.add(jcheckbox, gridbagconstraints);
		gridbagconstraints.fill = 0;
		gridbagconstraints.weightx = 0.0D;
		gridbagconstraints.insets = insets;
		gridbagconstraints.gridx = 0;
		gridbagconstraints.gridy = 0;
		if (V2CApp.isMacintosh()) {
			jcbUseSystemSetting = new JCheckBox("\u30B7\u30B9\u30C6\u30E0\u306EProxy\u8A2D\u5B9A\u3092\u4F7F\u7528\u3059\u308B");
			jcbUseSystemSetting.setFocusable(false);
			jcbUseSystemSetting.addChangeListener(this);
			jcbUseSystemSetting.setSelected(V2CProxySetting.getUseSystemSetting());
			add(jcbUseSystemSetting, gridbagconstraints);
			gridbagconstraints.gridy++;
			add(new JLabel(
					"    \uFF08\u3057\u306A\u3044\u2192\u3059\u308B\u306E\u5834\u5408\u306FV2C\u306E\u518D\u8D77\u52D5\u304C\u5FC5\u8981\uFF09"),
					gridbagconstraints);
			gridbagconstraints.gridy++;
		}
		add(jpanel, gridbagconstraints);
		gridbagconstraints.gridy++;
		add(jpanel1, gridbagconstraints);
		gridbagconstraints.gridy++;
		vHttpTimeoutSettingPanel = new V2CHttpTimeoutSettingPanel();
		gridbagconstraints.fill = 2;
		add(vHttpTimeoutSettingPanel, gridbagconstraints);
		gridbagconstraints.gridy++;
		add(jpanel2, gridbagconstraints);
		gridbagconstraints.gridy++;
	}

	boolean showPanel()
	{
		boolean flag = false;
		boolean flag1 = false;
		int i = 0;
		int j = 0;
		String s = null;
		String s1 = null;
		String s2 = null;
		String s3 = null;
		String s4 = null;
		String s5 = null;
		do {
			if (!V2CSwingUtil.showOKCancelDialog(this, "\u30CD\u30C3\u30C8\u30EF\u30FC\u30AF\u306E\u8A2D\u5B9A"))
				return false;
			flag = jcbUseReadProxy.isSelected();
			s = jtfReadHost.getText();
			s1 = V2CMiscUtil.trim(jtfReadUser.getText());
			s2 = V2CMiscUtil.trim(new String(jpfReadPass.getPassword()));
			i = V2CSwingUtil.getInt(jftfReadPort);
			flag1 = jcbUseWriteProxy.isSelected();
			s3 = jtfWriteHost.getText();
			j = V2CSwingUtil.getInt(jftfWritePort);
			s4 = V2CMiscUtil.trim(jtfWriteUser.getText());
			s5 = V2CMiscUtil.trim(new String(jpfWritePass.getPassword()));
			if (!flag || !flag1 || !s.equals(s3) || i != j || s1.equals(s4) && s2.equals(s5))
				break;
			Toolkit.getDefaultToolkit().beep();
			V2CSwingUtil
					.showErrorMessage("\u8AAD\u307F\u8FBC\u307F\u30FB\u66F8\u304D\u8FBC\u307FProxy\u304C\u540C\u3058\u5834\u5408\u3001\nID\u3068\u30D1\u30B9\u30EF\u30FC\u30C9\u3082\u540C\u3058\u8A2D\u5B9A\u306B\u3057\u3066\u304F\u3060\u3055\u3044\u3002");
		} while (true);
		if (jcbUseSystemSetting != null)
			V2CProxySetting.setUseSystemSetting(jcbUseSystemSetting.isSelected());
		psRead.setProxyUsed(flag);
		psRead.setHost(s);
		psRead.setPort(i);
		psRead.setID(s1);
		psRead.setPW(s2);
		psWrite.setProxyUsed(flag1);
		psWrite.setHost(s3);
		psWrite.setPort(j);
		psWrite.setID(s4);
		psWrite.setPW(s5);
		vHttpTimeoutSettingPanel.setTimeoutValues();
		V2CProperty v2cproperty = V2CApp.getUserProperty();
		if (jcbPreferIPv6Addresses.isSelected())
			v2cproperty.putBoolean("PreferIPv6Addresses", true);
		else
			v2cproperty.remove("PreferIPv6Addresses");
		V2CB11ScriptUtil.syncGlobalBooleanP2S("PreferIPv6Addresses");
		return true;
	}

	public void stateChanged(ChangeEvent changeevent)
	{
		boolean flag = jcbUseSystemSetting.isSelected();
		if (flag) {
			jcbUseReadProxy.setSelected(false);
			jcbUseWriteProxy.setSelected(false);
		}
		jcbUseReadProxy.setEnabled(!flag);
		jcbUseWriteProxy.setEnabled(!flag);
	}

	V2CProxySetting psRead;
	V2CProxySetting psWrite;
	JCheckBox jcbUseSystemSetting;
	JCheckBox jcbUseReadProxy;
	JTextField jtfReadHost;
	JFormattedTextField jftfReadPort;
	JTextField jtfReadUser;
	JPasswordField jpfReadPass;
	JCheckBox jcbUseWriteProxy;
	JTextField jtfWriteHost;
	JFormattedTextField jftfWritePort;
	JTextField jtfWriteUser;
	JPasswordField jpfWritePass;
	V2CHttpTimeoutSettingPanel vHttpTimeoutSettingPanel;
	JCheckBox jcbPreferIPv6Addresses;
}
