package org.monazilla.v2c;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class V2CProxySetting
{
	private static class MyAuthenticator
	{

		void resetIDPW()
		{
			paRead = createPasswordAuthentication(V2CProxySetting.vpsReadProxySetting);
			paWrite = createPasswordAuthentication(V2CProxySetting.vpsWriteProxySetting);
		}

		private static PasswordAuthentication createPasswordAuthentication(V2CProxySetting v2cproxysetting)
		{
			if (V2CProxySetting.bUseSystemSetting || !v2cproxysetting.bProxyUsed)
				return null;
			String s = v2cproxysetting.sID;
			if (s == null)
				s = "";
			String s1 = v2cproxysetting.sPW;
			char ac[] = s1 == null ? new char[0] : s1.toCharArray();
			return new PasswordAuthentication(s, ac);
		}

		private static boolean checkHostAndPort(V2CProxySetting v2cproxysetting, InetAddress inetaddress, int i)
		{
			if (!v2cproxysetting.bProxyUsed) {
				return false;
			}
			else {
				InetAddress inetaddress1 = v2cproxysetting.getSite();
				return inetaddress1 != null && inetaddress1.equals(inetaddress) && i == v2cproxysetting.nPort;
			}
		}

		PasswordAuthentication getPasswordAuthentication(InetAddress inetaddress, int i)
		{
			if (inetaddress == null)
				return null;
			if (checkHostAndPort(V2CProxySetting.vpsReadProxySetting, inetaddress, i))
				return paRead;
			if (checkHostAndPort(V2CProxySetting.vpsWriteProxySetting, inetaddress, i))
				return paWrite;
			else
				return null;
		}

		PasswordAuthentication paRead;
		PasswordAuthentication paWrite;

		private MyAuthenticator()
		{
		}

	}

	static PasswordAuthentication getProxyPasswordAuth(InetAddress inetaddress, int i)
	{
		return getUseProxySetting() ? myAuth.getPasswordAuthentication(inetaddress, i) : null;
	}

	static Vector getProxyItems()
	{
		if (bUseProperty)
			return null;
		if (bProxyItemsRestored)
			return vProxyItems;
		bProxyItemsRestored = true;
		Object obj = null;
		String s = V2CLocalFileHandler.restoreFromFile(V2CLocalFileHandler.getUserConfigFile("Proxy.txt"));
		Vector vector;
		if (s != null && s.length() > 0) {
			vector = new Vector();
			BufferedReader bufferedreader = new BufferedReader(new StringReader(s));
			vector.add(new V2CProxyItem());
			try {
				Matcher matcher = Pattern.compile("([\\dA-Za-z.-]+)(?::(\\d+))?(?:\\s|$)").matcher("");
				do {
					String s1;
					if ((s1 = bufferedreader.readLine()) == null)
						break;
					s1 = s1.trim();
					if (!s1.equalsIgnoreCase("[Write]")) {
						matcher.reset(s1);
						if (matcher.lookingAt()) {
							int i = V2CMiscUtil.parseInt(matcher.group(2));
							if (i > 0 && i <= 65535)
								vector.add(new V2CProxyItem(matcher.group(1), i, s1.substring(matcher.end())));
						}
					}
				} while (true);
				bufferedreader.close();
			}
			catch (IOException ioexception) {
			}
			if (vector.size() <= 1)
				vector = null;
		}
		else {
			vector = null;
		}
		vProxyItems = vector;
		return vector;
	}

	static void createSettings()
	{
		bUseSystemSetting = V2CApp.getUserProperty().getBoolean("Proxy.UseSystemSetting", V2CApp.isMacintosh());
		vpsReadProxySetting = new V2CProxySetting("Read");
		vpsWriteProxySetting = new V2CProxySetting("Write");
		resetStates();
	}

	static boolean getUseSystemSetting()
	{
		return bUseSystemSetting;
	}

	static boolean getUseProxySetting()
	{
		return !bUseSystemSetting && (vpsReadProxySetting.bProxyUsed || vpsWriteProxySetting.bProxyUsed);
	}

	static boolean isO2onUsed()
	{
		if (!V2CApp.isWinType())
			return false;
		V2CProxySetting v2cproxysetting = vpsReadProxySetting;
		if (!v2cproxysetting.bProxyUsed) {
			return false;
		}
		else {
			String s = v2cproxysetting.sHost;
			return s != null && (s.equals("127.0.0.1") || s.equals("localhost"));
		}
	}

	static void setUseSystemSetting(boolean flag)
	{
		if (bUseSystemSetting != flag) {
			bUseSystemSetting = flag;
			V2CMain.getUserProperty().putBoolean("Proxy.UseSystemSetting", flag);
		}
	}

	static void resetStates()
	{
		checkNeedSynch();
		myAuth.resetIDPW();
	}

	static void checkNeedSynch()
	{
		V2CProxySetting v2cproxysetting = vpsReadProxySetting;
		V2CProxySetting v2cproxysetting1 = vpsWriteProxySetting;
		boolean flag1 = true;
		boolean flag;
		if (bUseSystemSetting) {
			flag1 = false;
			flag = false;
		}
		else {
			if (v2cproxysetting.bProxyUsed && v2cproxysetting1.bProxyUsed && v2cproxysetting.sHost.equals(v2cproxysetting1.sHost)
					&& v2cproxysetting.nPort == v2cproxysetting1.nPort
					&& (!v2cproxysetting.sID.equals(v2cproxysetting1.sID) || !v2cproxysetting.sPW.equals(v2cproxysetting1.sPW))) {
				V2CSwingUtil
						.showErrorMessage("\u8AAD\u307F\u8FBC\u307F\u30FB\u66F8\u304D\u8FBC\u307FProxy\u306E\nID\u307E\u305F\u306F\u30D1\u30B9\u30EF\u30FC\u30C9\u3060\u3051\u3092\n\u9055\u3046\u8A2D\u5B9A\u306B\u3059\u308B\u3053\u3068\u306F\u3067\u304D\u307E\u305B\u3093\u3002");
				v2cproxysetting1.sID = v2cproxysetting.sID;
				v2cproxysetting1.sPW = v2cproxysetting.sPW;
			}
			if (bUseProperty) {
				flag = true;
				if (v2cproxysetting.bProxyUsed) {
					if (v2cproxysetting1.bProxyUsed && v2cproxysetting.sHost.equals(v2cproxysetting1.sHost)
							&& v2cproxysetting.nPort == v2cproxysetting1.nPort
							&& v2cproxysetting.sID.equals(v2cproxysetting1.sID)
							&& v2cproxysetting.sPW.equals(v2cproxysetting1.sPW)) {
						flag1 = false;
						flag = false;
						v2cproxysetting.setProperty();
					}
				}
				else if (!v2cproxysetting1.bProxyUsed)
					flag = false;
			}
			else {
				flag = false;
			}
		}
		bNeedSynch = flag;
		if (flag1)
			reset();
	}

	static void showSettingPanel()
	{
		boolean flag = bUseSystemSetting;
		V2CProxySettingPanel v2cproxysettingpanel = new V2CProxySettingPanel(vpsReadProxySetting, vpsWriteProxySetting);
		if (!v2cproxysettingpanel.showPanel()) {
			return;
		}
		else {
			resetStates();
			vpsReadProxySetting.save();
			vpsWriteProxySetting.save();
			return;
		}
	}

	static HttpURLConnection openReadConnection(URL url) throws IOException
	{
		setTLSHostInfo(url);
		HttpURLConnection httpurlconnection;
		if (bUseProperty) {
			if (bNeedSynch)
				setReadProxy();
			httpurlconnection = (HttpURLConnection) url.openConnection();
		}
		else {
			V2CProxySetting v2cproxysetting = vpsReadProxySetting;
			V2CProxyItem v2cproxyitem = null;
			if (!bUseSystemSetting && v2cproxysetting.bProxyUsed)
				v2cproxyitem = new V2CProxyItem(v2cproxysetting.sHost, v2cproxysetting.nPort);
			if (V2CApp.javaVersionEqualOrGreaterThan(1, 6))
				v2cproxyitem = V2CProxyScript.checkProxy(url, v2cproxyitem);
			if (v2cproxyitem != null)
				httpurlconnection = V2CJ2SE5Util.openConnection(url, v2cproxyitem.sHost, v2cproxyitem.nPort);
			else
				httpurlconnection = (HttpURLConnection) url.openConnection();
		}
		httpurlconnection.setUseCaches(false);
		return httpurlconnection;
	}

	static HttpURLConnection openWriteConnection(URL url) throws IOException
	{
		return openWriteConnection(url, null);
	}

	static HttpURLConnection openWriteConnection(URL url, V2CProxyItem v2cproxyitem) throws IOException
	{
		setTLSHostInfo(url);
		HttpURLConnection httpurlconnection;
		if (bUseProperty) {
			if (bNeedSynch)
				setWriteProxy();
			httpurlconnection = (HttpURLConnection) url.openConnection();
		}
		else {
			if (v2cproxyitem == null) {
				V2CProxySetting v2cproxysetting = vpsWriteProxySetting;
				if (!bUseSystemSetting && v2cproxysetting.bProxyUsed)
					v2cproxyitem = new V2CProxyItem(v2cproxysetting.sHost, v2cproxysetting.nPort);
				if (V2CApp.javaVersionEqualOrGreaterThan(1, 6))
					v2cproxyitem = V2CProxyScript.checkProxy(url, v2cproxyitem);
			}
			if (v2cproxyitem != null)
				httpurlconnection = V2CJ2SE5Util.openConnection(url, v2cproxyitem.sHost, v2cproxyitem.nPort);
			else
				httpurlconnection = (HttpURLConnection) url.openConnection();
		}
		httpurlconnection.setUseCaches(false);
		return httpurlconnection;
	}

	private static synchronized void setReadProxy()
	{
		do {
			if (vpsWriteProxySetting.nProcs <= 0)
				break;
			try {
				(org.monazilla.v2c.V2CProxySetting.class).wait();
			}
			catch (InterruptedException interruptedexception) {
				Thread.currentThread().interrupt();
				return;
			}
		} while (true);
		vpsReadProxySetting.inc();
	}

	private static synchronized void setWriteProxy()
	{
		do {
			if (vpsReadProxySetting.nProcs <= 0)
				break;
			try {
				(org.monazilla.v2c.V2CProxySetting.class).wait();
			}
			catch (InterruptedException interruptedexception) {
				Thread.currentThread().interrupt();
				return;
			}
		} while (true);
		vpsWriteProxySetting.inc();
	}

	static void resetReadProxy()
	{
		if (bUseProperty && bNeedSynch)
			vpsReadProxySetting.dec();
	}

	static void resetWriteProxy()
	{
		if (bUseProperty && bNeedSynch)
			vpsWriteProxySetting.dec();
	}

	static void reset()
	{
		System.setProperty("proxySet", "false");
		System.setProperty("http.proxyHost", "");
		System.setProperty("https.proxyHost", "");
		Authenticator.setDefault(null);
	}

	static void restore()
	{
		System.setProperty("proxySet", sProxySet);
		System.setProperty("http.proxyHost", sHttpProxyHost);
		System.setProperty("http.proxyPort", sHttpProxyPort);
		System.setProperty("https.proxyHost", sHttpsProxyHost);
		System.setProperty("https.proxyPort", sHttpsProxyPort);
		Authenticator.setDefault(null);
	}

	public V2CProxySetting(String s)
	{
		V2CProperty v2cproperty = V2CMain.getUserProperty();
		sUseProxyKey = "Proxy.Use" + s + "Proxy";
		sHostKey = "Proxy." + s + "Host";
		sPortKey = "Proxy." + s + "Port";
		sIDKey = "Proxy." + s + "ID";
		sPWKey = "Proxy." + s + "PW";
		bProxyUsed = v2cproperty.getBoolean(sUseProxyKey);
		sHost = v2cproperty.get(sHostKey, "");
		nPort = v2cproperty.getInt(sPortKey);
		sID = v2cproperty.get(sIDKey, "");
		if (sID.length() > 0)
			sID = V2CMiscUtil.hexDecode(sID);
		sPW = v2cproperty.get(sPWKey, "");
		if (sPW.length() > 0)
			sPW = V2CMiscUtil.hexDecode(sPW);
	}

	void setProperty()
	{
		String s = nPort <= 0 ? "" : String.valueOf(nPort);
		System.setProperty("proxySet", "true");
		System.setProperty("http.proxyHost", sHost);
		System.setProperty("http.proxyPort", s);
		System.setProperty("https.proxyHost", sHost);
		System.setProperty("https.proxyPort", s);
	}

	void inc()
	{
		if (!bProxyUsed) {
			reset();
			return;
		}
		if (nProcs == 0)
			setProperty();
		nProcs++;
	}

	void dec()
	{
		if (!bProxyUsed)
			return;
		synchronized (org.monazilla.v2c.V2CProxySetting.class) {
			nProcs--;
			if (nProcs == 0)
				(org.monazilla.v2c.V2CProxySetting.class).notifyAll();
		}
	}

	void save()
	{
		V2CProperty v2cproperty = V2CMain.getUserProperty();
		v2cproperty.putBoolean(sUseProxyKey, bProxyUsed);
		if (sHost != null && sHost.length() > 0)
			v2cproperty.put(sHostKey, sHost);
		else
			v2cproperty.remove(sHostKey);
		if (nPort > 0)
			v2cproperty.putInt(sPortKey, nPort);
		else
			v2cproperty.remove(sPortKey);
		if (sID != null && sID.length() > 0)
			v2cproperty.put(sIDKey, V2CMiscUtil.hexEncode(sID));
		else
			v2cproperty.remove(sIDKey);
		if (sPW != null && sPW.length() > 0)
			v2cproperty.put(sPWKey, V2CMiscUtil.hexEncode(sPW));
		else
			v2cproperty.remove(sPWKey);
	}

	boolean proxyUsed()
	{
		return bProxyUsed;
	}

	String getHost()
	{
		return sHost;
	}

	InetAddress getSite()
	{
		if (bProxyUsed && iAddress == null && sHost.length() > 0)
			try {
				iAddress = InetAddress.getByName(sHost);
			}
			catch (Exception exception) {
				exception.printStackTrace();
			}
		return iAddress;
	}

	int getPort()
	{
		return nPort;
	}

	String getID()
	{
		return sID;
	}

	String getPW()
	{
		return sPW;
	}

	void setProxyUsed(boolean flag)
	{
		bProxyUsed = flag;
	}

	void setHost(String s)
	{
		sHost = s == null ? "" : s;
		iAddress = null;
	}

	void setPort(int i)
	{
		nPort = i;
	}

	void setID(String s)
	{
		sID = s;
	}

	void setPW(String s)
	{
		sPW = s;
	}

	private static final boolean bDebug = false;
	static final String sKeyPrefix = "Proxy.";
	static final String sUseSystemSettingKey = "Proxy.UseSystemSetting";
	static final String sProxySetKey = "proxySet";
	static final String sHttpProxyHostKey = "http.proxyHost";
	static final String sHttpProxyPortKey = "http.proxyPort";
	static final String sHttpsProxyHostKey = "https.proxyHost";
	static final String sHttpsProxyPortKey = "https.proxyPort";
	static final String sProxySet;
	static final String sHttpProxyHost;
	static final String sHttpProxyPort;
	static final String sHttpsProxyHost;
	static final String sHttpsProxyPort;
	static final MyAuthenticator myAuth = new MyAuthenticator();
	static final boolean bUseProperty = V2CApp.javaVersionLessThan(1, 5);
	static V2CProxySetting vpsReadProxySetting;
	static V2CProxySetting vpsWriteProxySetting;
	static boolean bUseSystemSetting;
	static boolean bNeedSynch;
	private static Vector vProxyItems;
	private static boolean bProxyItemsRestored;
	final String sUseProxyKey;
	final String sHostKey;
	final String sPortKey;
	final String sIDKey;
	final String sPWKey;
	boolean bProxyUsed;
	String sHost;
	InetAddress iAddress;
	int nPort;
	String sID;
	String sPW;
	volatile int nProcs;

	static {
		String s = System.getProperty("proxySet");
		sProxySet = s == null ? "" : s;
		s = System.getProperty("http.proxyHost");
		sHttpProxyHost = s == null ? "" : s;
		s = System.getProperty("http.proxyPort");
		sHttpProxyPort = s == null ? "" : s;
		s = System.getProperty("https.proxyHost");
		sHttpsProxyHost = s == null ? "" : s;
		s = System.getProperty("https.proxyPort");
		sHttpsProxyPort = s == null ? "" : s;
	}
	
	private static void setTLSHostInfo(URL url){
		try {
			InetAddress addrList[] = InetAddress.getAllByName(url.toString().replaceAll("https?://", "").split("/")[0]);
			for(int i=0; i<addrList.length; ++i){
				String HostName = addrList[i].getHostName();
				String HostAddress = addrList[i].getHostAddress();
				if(V2CTLSSocketFactory.hmHostName.containsKey(HostAddress)){
					List HostList = (List) V2CTLSSocketFactory.hmHostName.get(HostAddress);
					if(!HostList.contains(HostName)){
						HostList.add(HostName);
						V2CTLSSocketFactory.hmHostName.put(HostAddress, HostList);
					}
				}else{
					List HostList = new ArrayList<String>();
					HostList.add(HostName);
					V2CTLSSocketFactory.hmHostName.put(HostAddress, HostList);
				}
			}
		} catch (UnknownHostException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}
	}
}
