package org.monazilla.v2c;

import java.net.URL;
import java.security.AccessControlContext;
import java.security.PrivilegedExceptionAction;

public class V2CProxyScript extends V2CSystemScript
{

	private static V2CProxyScript getInstance()
	{
		if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5))
			return null;
		if (!bLoadTried) {
			bLoadTried = true;
			vProxyScript = (V2CProxyScript) V2CScriptUtil.createSystemScript("proxy.js");
		}
		return vProxyScript;
	}

	static void reload()
	{
		if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5))
			return;
		V2CProxyScript v2cproxyscript = vProxyScript;
		if (v2cproxyscript != null) {
			v2cproxyscript.stop();
			vProxyScript = null;
		}
		V2CScriptUtil.printMessage("proxy.js\u3092\u8AAD\u307F\u8FBC\u3093\u3067\u3044\u307E\u3059\u2026");
		bLoadTried = false;
		v2cproxyscript = getInstance();
		V2CScriptUtil
				.printMessage("proxy.js\u3092\u8AAD\u307F\u8FBC"
						+ (v2cproxyscript == null ? "\u3081\u307E\u305B\u3093\u3067\u3057\u305F\u3002"
								: "\u307F\u307E\u3057\u305F\u3002"));
	}

	static V2CProxyScript createProxyScript(String s, V2CScriptClassLoader v2cscriptclassloader,
			AccessControlContext accesscontrolcontext)
	{
		s = s + createDefCheckScript(new String[] { "checkProxy" });
		V2CScriptApp v2cscriptapp = new V2CScriptApp("proxy.js");
		String s1 = null;
		PrivilegedExceptionAction privilegedexceptionaction = null;
		try {
			privilegedexceptionaction = V2CJSE6Util.createScriptAction("JavaScript", s, v2cscriptapp, v2cscriptclassloader,
					accesscontrolcontext, false);
		}
		catch (Exception exception) {
			s1 = exception.getMessage();
		}
		if (privilegedexceptionaction == null) {
			V2CScriptUtil
					.setErrorMessage(s1 == null ? "\u30A2\u30AF\u30B7\u30E7\u30F3\u306E\u4F5C\u6210\u306B\u5931\u6557\u3057\u307E\u3057\u305F\u3002"
							: s1);
			return null;
		}
		V2CProxyScript v2cproxyscript = new V2CProxyScript(privilegedexceptionaction, v2cscriptapp, v2cscriptclassloader,
				accesscontrolcontext);
		Object obj = v2cproxyscript.exec();
		if (obj instanceof boolean[]) {
			boolean aflag[] = (boolean[]) (boolean[]) obj;
			bCheckProxy = aflag[0];
		}
		else {
			bCheckProxy = false;
		}
		return v2cproxyscript;
	}

	static V2CProxyItem checkProxy(URL url, V2CProxyItem v2cproxyitem)
	{
		if (url == null)
			return v2cproxyitem;
		V2CProxyScript v2cproxyscript = getInstance();
		if (v2cproxyscript == null || !bCheckProxy)
			return v2cproxyitem;
		else
			return v2cproxyscript.checkProxy(url, new V2CScriptProxy(v2cproxyitem));
	}

	private V2CProxyScript(PrivilegedExceptionAction privilegedexceptionaction, V2CScriptApp v2cscriptapp,
			V2CScriptClassLoader v2cscriptclassloader, AccessControlContext accesscontrolcontext)
	{
		super(privilegedexceptionaction, v2cscriptapp, v2cscriptclassloader, accesscontrolcontext);
	}

	synchronized V2CProxyItem checkProxy(URL url, V2CScriptProxy v2cscriptproxy)
	{
		if (bReloading) {
			return v2cscriptproxy.getProxyItem();
		}
		else {
			V2CJSE6Util.setInvokeFunction(vPrivilegedExceptionAction, "checkProxy", new Object[] { url, v2cscriptproxy });
			exec();
			return v2cscriptproxy.getProxyItem();
		}
	}

	private static final String sScriptFileName = "proxy.js";
	private static boolean bLoadTried;
	private static V2CProxyScript vProxyScript;
	private static boolean bCheckProxy;
}
