package org.monazilla.v2c;

import java.security.AccessControlContext;
import java.security.PrivilegedExceptionAction;

public class V2CPostScript extends V2CSystemScript
{

	private static V2CPostScript getInstance()
	{
		if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5))
			return null;
		if (!bLoadTried) {
			bLoadTried = true;
			vPostScript = (V2CPostScript) V2CScriptUtil.createSystemScript("post.js");
		}
		return vPostScript;
	}

	static void reload()
	{
		if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5))
			return;
		V2CPostScript v2cpostscript = vPostScript;
		if (v2cpostscript != null) {
			v2cpostscript.stop();
			vPostScript = null;
		}
		V2CScriptUtil.printMessage("post.jsを読み込んでいます…");
		bLoadTried = false;
		v2cpostscript = getInstance();
		V2CScriptUtil
				.printMessage("post.jsを読み込"
						+ (v2cpostscript == null ? "めませんでした。"
								: "みました。"));
	}

	static V2CPostScript createPostScript(String s, V2CScriptClassLoader v2cscriptclassloader,
			AccessControlContext accesscontrolcontext)
	{
		s = s + createDefCheckScript(new String[] { "checkBeforeCreateThread", "checkBeforePost" });
		V2CScriptApp v2cscriptapp = new V2CScriptApp("post.js");
		String s1 = null;
		PrivilegedExceptionAction privilegedexceptionaction = null;
		try {
			privilegedexceptionaction = V2CJSE6Util.createScriptAction("JavaScript", s, v2cscriptapp, v2cscriptclassloader,
					accesscontrolcontext, false);
		}
		catch (Exception exception) {
			s1 = exception.getMessage();
		}
		if (privilegedexceptionaction == null) {
			V2CScriptUtil
					.setErrorMessage(s1 == null ? "アクションの作成に失敗しました。"
							: s1);
			return null;
		}
		V2CPostScript v2cpostscript = new V2CPostScript(privilegedexceptionaction, v2cscriptapp, v2cscriptclassloader,
				accesscontrolcontext);
		Object obj = v2cpostscript.exec();
		if (obj instanceof boolean[]) {
			boolean aflag[] = (boolean[]) (boolean[]) obj;
			bCheckBeforeCreateThread = aflag[0];
			bCheckBeforePost = aflag[1];
		}
		else {
			bCheckBeforeCreateThread = false;
			bCheckBeforePost = false;
		}
		return v2cpostscript;
	}

	static boolean checkBeforeCreateThread(V2CThreadPanel v2cthreadpanel, V2CWritePanel v2cwritepanel)
	{
		if (v2cthreadpanel == null || v2cwritepanel == null)
			return true;
		V2CPostScript v2cpostscript = getInstance();
		if (v2cpostscript == null || !bCheckBeforeCreateThread)
			return true;
		V2CScriptWritePanel v2cscriptwritepanel = V2CScriptWritePanel.createScriptWritePanel(v2cthreadpanel, v2cwritepanel, true);
		if (v2cscriptwritepanel == null)
			return false;
		else
			return v2cpostscript.checkBeforeCreateThread(v2cscriptwritepanel);
	}

	static boolean checkBeforePost(V2CThreadPanel v2cthreadpanel, V2CWritePanel v2cwritepanel)
	{
		if (v2cthreadpanel == null || v2cwritepanel == null)
			return true;
		V2CPostScript v2cpostscript = getInstance();
		if (v2cpostscript == null || !bCheckBeforePost)
			return true;
		V2CScriptWritePanel v2cscriptwritepanel = V2CScriptWritePanel.createScriptWritePanel(v2cthreadpanel, v2cwritepanel, true);
		if (v2cscriptwritepanel == null)
			return false;
		else
			return v2cpostscript.checkBeforePost(v2cscriptwritepanel);
	}

	private V2CPostScript(PrivilegedExceptionAction privilegedexceptionaction, V2CScriptApp v2cscriptapp,
			V2CScriptClassLoader v2cscriptclassloader, AccessControlContext accesscontrolcontext)
	{
		super(privilegedexceptionaction, v2cscriptapp, v2cscriptclassloader, accesscontrolcontext);
	}

	synchronized boolean checkBeforeCreateThread(V2CScriptWritePanel v2cscriptwritepanel)
	{
		if (bReloading) {
			return false;
		}
		else {
			V2CJSE6Util.setInvokeFunction(vPrivilegedExceptionAction, "checkBeforeCreateThread",
					new Object[] { v2cscriptwritepanel });
			Object obj = exec();
			return (obj instanceof Boolean) ? ((Boolean) obj).booleanValue() : false;
		}
	}

	synchronized boolean checkBeforePost(V2CScriptWritePanel v2cscriptwritepanel)
	{
		if (bReloading) {
			return false;
		}
		else {
			V2CJSE6Util.setInvokeFunction(vPrivilegedExceptionAction, "checkBeforePost", new Object[] { v2cscriptwritepanel });
			Object obj = exec();
			return (obj instanceof Boolean) ? ((Boolean) obj).booleanValue() : false;
		}
	}

	private static final String sScriptFileName = "post.js";
	private static boolean bLoadTried;
	private static V2CPostScript vPostScript;
	private static boolean bCheckBeforeCreateThread;
	private static boolean bCheckBeforePost;
}
