package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public final class V2COekaki extends V2CNameAndMail
{
	public V2COekaki(V2CWritePanel previewOekaki2) {
		super(previewOekaki2);
		// TODO 自動生成されたコンストラクター・スタブ
	}

	static String oekakiDir = V2CLocalFileHandler.v2cDir + java.io.File.separator + "oekaki" + java.io.File.separator;

	// V2CMOD-twZ by MCZ, Date:2019/08/25, お描書き機能強化
	private static final Pattern extpattern = Pattern
			.compile(".+\\.(jpe?g|png|gif|webp)$");

	// ---- END of V2CMOD-twZ ----
	public static String getOekakiOption(String BBSKeyTime, String s1){
		String s = "";
		String encodeSet = s1;

		try{
			if(!previewOekaki.isVisible()){
				return "";
			}
		} catch (NullPointerException e) {
			return "";
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		}
		
		param = get_param();
		
		if(param.get("OEKAKI_ENCODESET") != null){
			encodeSet = param.get("OEKAKI_ENCODESET");
		}
		
		String BBSKeyefn = getBBSkey_efn(BBSKeyTime);

		String pngImgFn = oekakiDir + "pictures" + java.io.File.separator + BBSKeyefn + ".png";
		File pngImg = new File(pngImgFn);
		
		if(!pngImg.exists()){
			return "";
		}

		BufferedImage readImage = null;
		ByteArrayOutputStream baos = new ByteArrayOutputStream();  
		try {
		  readImage = ImageIO.read(pngImg);
		  ImageIO.write(readImage, "png", baos);
		  baos.close();
		} catch (Exception e) {
		  e.printStackTrace();
		}

		byte[] encoded = null;
		try {
			encoded = V2CMiscUtil.encodeBase64(baos.toByteArray());
		} catch (Exception e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
			return "";
		}

  		s = "&oekaki_thread1=&oekaki=" + V2CJPConverter.urlEncode("data:image/png;base64," + new String(encoded), encodeSet);

  		return s;
	}

	static public void removeBBSOekakiDat(String BBSKeyTime)
	{
		try{
			if(!previewOekaki.isVisible()){
				return;
			}
		} catch (NullPointerException e) {
			return;
		} catch (Exception e) {
			e.printStackTrace();
			return;
		}

		String elms[] = BBSKeyTime.split("&");
		if(elms.length != 4){
			return;
		}
		String bbs = elms[1].split("=")[1];
		if(bbs == ""){
			return;
		}
		String key = elms[2].split("=")[1];
		if(key == ""){
			return;
		}

		String pngImgFn = oekakiDir + bbs + "_" + key + ".png";
		File pngImg = new File(pngImgFn);
		
		if(pngImg.exists()){
			pngImg.delete();
		}
  		previewOekaki.dispose();
  		previewOekaki = null;
  		try {
			v2coekakitimertask.timer_cancel();
		} catch (InterruptedException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}
	}

	public static void previewOekaki(String bbskeyefn){
		param = get_param();
		g_BBSKey_efn = bbskeyefn;
		
		V2COekaki V2COekaki = new V2COekaki(JpaneStab);
		boolean openJdialog = false;
		try{
			boolean a = previewOekaki.equals(null);
		}catch(NullPointerException e){
			openJdialog	= true;
		}
		if(openJdialog == false && previewOekaki.isValid() == false){
			openJdialog	= true;
		}
		if(openJdialog == true){
			previewOekaki = new JDialog(V2CMain.v2cMain, false);
			previewOekaki.setTitle(g_title);
			previewOekaki.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
			previewOekaki.setBounds(0, 0, 518, 290);
			previewOekaki.setLocationRelativeTo(null);
			previewOekaki.addKeyListener(V2COekaki.new Keyboard_input());
			previewOekaki.addWindowListener(new WindowAdapter() {
				@Override
				public void windowClosing(WindowEvent e) {
					super.windowClosing(e);
					previewOekaki.dispose();
					previewOekaki = null;
			  		try {
						v2coekakitimertask.timer_cancel();
					} catch (InterruptedException e1) {
						// TODO 自動生成された catch ブロック
						e1.printStackTrace();
					}
				}
			});
			p = new JPanel();
			p.setLayout(null);
//			p.addMouseListener(new V2CPopupListener("AttachOekaki", previewOekaki));
			new DropTarget(p, V2COekaki.new OekakiDropListener());
			previewOekaki.add(p);
			
			v2coekakitimertask = new V2COekakiTimerTask();
			try {
				v2coekakitimertask.timer_period();
			} catch (InterruptedException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
		}else{
			previewOekaki.setTitle(g_title);
		}

		label[0] = null;
	    File afile[] = MygetImageFiles();
	    MediaTracker tracker = new MediaTracker(previewOekaki);
	    
	    Component[] c = p.getComponents();
		if(c.length != 0){
			for(int i=0; i<c.length; i++){
				p.remove(c[i]);
			}
		}

	    if(afile != null){
			for(int i=0; i<afile.length; i++){
				byte[] b = new byte[10240];
				try{
					ImageIcon icon;

					FileInputStream fis = new FileInputStream(afile[i].getAbsolutePath());
					ByteArrayOutputStream baos = new ByteArrayOutputStream();
					while (fis.read(b) > 0) {
						baos.write(b);
					}
					baos.close();
					fis.close();
					icon = new ImageIcon(baos.toByteArray());

				    Image previewImg = icon.getImage().getScaledInstance(500, -1, Image.SCALE_SMOOTH);
				    tracker.addImage(previewImg,i);
				    ImageIcon previewIcon = new ImageIcon(previewImg);
				    try {
				        tracker.waitForAll();
				    } catch (InterruptedException e) {
				        System.out.println("なんかエラーでた。");
				    }
				    
//				    System.out.println(previewIcon);
				    
				    label[i] = new JLabel(previewIcon);
				    label[i].setBounds(5, 5, 500, 250);
				    label[i].addMouseListener(V2COekaki.new removeOekaki(i));

				    p.add(label[i]);
				}catch(IOException e){
			        System.err.println(e);
				}
			}
	    }
	    
	    if(openJdialog == true){
	    	previewOekaki.setVisible(true);
	    }else{
	    	c = p.getComponents();
	    	if(c.length != 0){
				previewOekaki.validate();
				previewOekaki.repaint();
	    	}else{
//	    		previewOekaki.dispose();
				previewOekaki.validate();
				previewOekaki.repaint();
	    	}
	    }
	}

	static Map<String, String> get_param(){
		Map<String, String> ppp = new HashMap<String, String>();

		File ini = V2CLocalFileHandler.getUserConfigFile("usrprops_tw.txt");
		if(ini.exists()){
			FileReader fr = null;
			BufferedReader br = null;
			try {
				br = new BufferedReader(new FileReader(ini));
		 
				String line;
				while ((line = br.readLine()) != null) {
					String w[] = line.replaceAll(" ", "").split("=");
					if(w.length == 2){
						ppp.put(w[0], w[1]);
					}
				}
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				try {
					br.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}			
		}

		File dir = new File(oekakiDir + "pictures");
		if(! dir.exists()){
			dir.mkdir();
		}

		return ppp;
	}

	static String getBBSkey_efn(String BBSKeyTime){
		String elms[] = BBSKeyTime.split("&");
		if(elms.length != 4){
			return "";
		}
		String bbs = elms[1].split("=")[1];
		if(bbs == ""){
			return "";
		}
		String key = elms[2].split("=")[1];
		if(key == ""){
			return "";
		}
		return bbs + "_" + key;
	}
	
	String getClipboardString() {
		Toolkit kit = Toolkit.getDefaultToolkit();
		Clipboard clip = kit.getSystemClipboard();

		try {
			return (String) clip.getData(DataFlavor.stringFlavor);
		} catch (UnsupportedFlavorException e) {
			return null;
		} catch (IOException e) {
			return null;
		}
	}

	Image getClipboardImage() {
		Toolkit kit = Toolkit.getDefaultToolkit();
		Clipboard clip = kit.getSystemClipboard();

		try {
			return (Image) clip.getData(DataFlavor.imageFlavor);
		} catch (UnsupportedFlavorException e) {
			return null;
		} catch (IOException e) {
			return null;
		}
	}


	static void postOekaki(File file)
	{
		addImageFile(file);
	}

	private static void addImageFile(File file)
	{
		String s = addImageFile0(file);
		if (s != null){
			V2CSwingUtil.showErrorMessage(s);
		}else{
			previewOekaki(g_BBSKey_efn);
		}
	}

	private static String addImageFile0(File file)
	{
		String efn = file.getAbsolutePath();
		if(!efn.endsWith(".png")){
			return "取り込める画像はpngだけです。";
		}
		
		long l = file.length();
		if (l == 0L)
			return "ファイルの内容が空です。";
//		if (l > Long.valueOf(param.get("OEKAKI_SIZE_LIMIT")).longValue())
//			return "サイズが上限（" + param.get("OEKAKI_SIZE_LIMIT")
//					+ "）を越えています\n(サイズ:" + l + ")";
		ArrayList arraylist = alImageFiles_Oekaki;
		File afile[] = MygetImageFiles();

		if (arraylist == null)
			alImageFiles_Oekaki = arraylist = new ArrayList();
		arraylist.add(file);
		return null;
	}

	int imageFileCount()
	{
		ArrayList arraylist = alImageFiles_Oekaki;
		return arraylist == null ? 0 : arraylist.size();
	}

	static File[] MygetImageFiles()
	{
    	String efn = oekakiDir + "pictures" + java.io.File.separator + g_BBSKey_efn + ".png";

    	ArrayList arraylist = new ArrayList();
    	File file = new File(efn);
    	if(file.exists()){
        	arraylist.add(file);
    	}
		return arraylist == null || arraylist.size() <= 0 ? null : (File[]) (File[]) arraylist
				.toArray(new File[arraylist.size()]);
	}

	class mouse_motion implements MouseListener{

		public void mouseClicked(MouseEvent e) {
			// TODO 自動生成されたメソッド・スタブ
			Desktop desktop = Desktop.getDesktop();

    		File localfile = new File(oekakiDir + "mini.html");
    		try {
    			URI uri = localfile.toURI();
    			desktop.browse(uri);
    		} catch (UnsupportedOperationException e1) {
    			System.out.println("UnsupportedOperationException");
    			e1.printStackTrace();
    		} catch (IOException e1) {
    			JOptionPane.showMessageDialog(
 					   V2CMain.v2cMain
 					  , "既定のブラウザが設定されていません。\n" +
 					    "または初期設定が終っていないなどで、使用可能な状態ではありません。"
 					  , "お絵描きプレビュー"
 					  , JOptionPane.ERROR_MESSAGE);
    		} catch (SecurityException e1) {
    			System.out.println("SecurityException");
    			e1.printStackTrace();
    		} catch (IllegalArgumentException e1) {
    			System.out.println("IllegalArgumentException");
    			e1.printStackTrace();
    		}
			
		}

		public void mouseEntered(MouseEvent e) {
			// TODO 自動生成されたメソッド・スタブ
			
		}

		public void mouseExited(MouseEvent e) {
			// TODO 自動生成されたメソッド・スタブ
			
		}

		public void mousePressed(MouseEvent e) {
			// TODO 自動生成されたメソッド・スタブ
			
		}

		public void mouseReleased(MouseEvent e) {
			// TODO 自動生成されたメソッド・スタブ
			
		}
	}

	class removeOekaki implements MouseListener{
		int idx;
		public removeOekaki(int i) {
			idx = i;
		}

		public void mouseClicked(MouseEvent e) {
			int btn = e.getButton();
			if(btn == MouseEvent.BUTTON1){
			    Component[] c = p.getComponents();
				int act = JOptionPane.showConfirmDialog(
										   V2CMain.v2cMain
										  ,"この画像を削除しますか？"
										  ,"お絵描きプレビュー 削除確認"
										  ,JOptionPane.YES_NO_OPTION
										  ,JOptionPane.INFORMATION_MESSAGE
										  ,null);
				if(act == 0){
			    	String efn = oekakiDir + "pictures" + java.io.File.separator + g_BBSKey_efn + ".png";
	                File file = new File(efn);
	                if(file.exists()){
		                file.delete();
	                }

	        		alImageFiles_Oekaki = null;
					previewOekaki(g_BBSKey_efn);
				}
			}
		}

		public void mouseEntered(MouseEvent e) {
		}

		public void mouseExited(MouseEvent e) {
		}

		public void mousePressed(MouseEvent e) {
		}

		public void mouseReleased(MouseEvent e) {
		}
	}

	class Keyboard_input implements KeyListener
	{
		public void keyPressed(KeyEvent event)
		{
	        if ((! V2CApp.isMacintosh() && event.isControlDown()) || (V2CApp.isMacintosh() && event.isMetaDown())) {
	            if (86 == event.getKeyCode()) {
	            	String t;
	                if((t = getClipboardString()) != null){
		                if(t.indexOf("data:image/png;base64,") != 0){
		                	JOptionPane.showMessageDialog(
		                						   V2CMain.v2cMain
		                						  , "お絵描きのエンコードが正しくありません"
		                						  , "お絵描きプレビュー"
		                						  , JOptionPane.ERROR_MESSAGE);
		                	return;
		                }
		                	                
					    try {
					    	String efn = oekakiDir + "pictures" + java.io.File.separator + g_BBSKey_efn + ".png";
							byte[] decoded = null;
							t = t.replace("data:image/png;base64,", "");
							decoded = V2CMiscUtil.decodeBase64(t.getBytes());

							BufferedImage fin = ImageIO.read(new ByteArrayInputStream(decoded));
			                BufferedImage BufImage = convertNoneTransparent(fin);
			                ImageIO.write(BufImage, "png", new File(efn));

			                List<File> list = Arrays.asList(new File(efn));
			                OekakiDropListener fileDropped = new OekakiDropListener();
						    fileDropped.fileDropped(list, true);

					    }catch(Exception e){
							e.printStackTrace();
		                	return;
	                	}
	                	return;
	                }

	                Image m;
	                if((m = getClipboardImage()) != null){
	                	try{
					    	String efn = oekakiDir + "pictures" + java.io.File.separator + g_BBSKey_efn + ".png";

					    	ImageIO.write((BufferedImage) m, "png", new File(efn));

			                List<File> list = Arrays.asList(new File(efn));
			                OekakiDropListener fileDropped = new OekakiDropListener();
						    fileDropped.fileDropped(list, true);

	                	}catch(IOException e){
		                	JOptionPane.showMessageDialog(
	     						   V2CMain.v2cMain
	     						  , "画像の取得に失敗しました(イメージのコピぺ)"
	     						  , "お絵描きプレビュー"
	     						  , JOptionPane.ERROR_MESSAGE);
		                	return;
	                    }
					    return;
	                }

	                Toolkit kit = Toolkit.getDefaultToolkit();
	                Clipboard clip = kit.getSystemClipboard();
	                try {
						List<File> list = (List<File>) clip.getData(DataFlavor.javaFileListFlavor);
						if(list != null){
							File file = new File(list.get(0).toString());
					    	String efn1 = oekakiDir + "pictures" + java.io.File.separator + g_BBSKey_efn + ".png";

					    	BufferedImage fin = ImageIO.read(file);
			                BufferedImage BufImage = convertNoneTransparent(fin);
			                ImageIO.write(BufImage, "png", new File(efn1));

						    List<File> list1 = Arrays.asList(new File(efn1));
			                OekakiDropListener fileDropped = new OekakiDropListener();
						    fileDropped.fileDropped(list1, true);

						    return;
						}
					} catch (Exception e) {
						JOptionPane.showMessageDialog(
		 						   V2CMain.v2cMain
		 						  , "画像の取得に失敗しました(ファイルのコピぺ)"
		 						  , "お絵描きプレビュー"
		 						  , JOptionPane.ERROR_MESSAGE);
							return;
					}

	                JOptionPane.showMessageDialog(
 						   V2CMain.v2cMain
  						  , "クリップボードの形式が貼り付け対象外です"
 						  , "お絵描きプレビュー"
 						  , JOptionPane.ERROR_MESSAGE);
                	return;
	            }
	        }
		}

		public void keyReleased(KeyEvent event)
		{
		}

		public void keyTyped(KeyEvent event)
		{
		}
	}

	/**
	 * 透過情報なしの画像転送
	 * @author seraphy
	 * http://d.hatena.ne.jp/seraphy/20110405
	 */
	public static BufferedImage convertNoneTransparent(BufferedImage org) {
		int w = org.getWidth();
		int h = org.getHeight();
		BufferedImage image = new BufferedImage(w, h, BufferedImage.TYPE_3BYTE_BGR);
		Graphics2D g = image.createGraphics();
		try {
			g.setBackground(Color.WHITE);
			g.clearRect(0, 0, w, h);
			g.drawImage(org, 0, 0, w, h, 0, 0, w, h, null);

		} finally {
			g.dispose();
		}
		return image;
	}
	public class OekakiDropListener extends V2CFileDropListener
	{

		boolean fileDropped(java.util.List list)
		{
			if (list == null || list.size() == 0)
				return false;

			for(int i=0; i<list.size(); i++){
				Object obj = list.get(i);
				if (!(obj instanceof File))
					return false;
				File file = (File) obj;
				if (!file.isFile() || !file.canRead()) {
					return false;
				}
				else {
			    	String efn1 = oekakiDir + "pictures" + java.io.File.separator + g_BBSKey_efn + ".png";

	                try {
	                	BufferedImage fin = ImageIO.read(file);
	                	BufferedImage BufImage = convertNoneTransparent(fin);
	                	ImageIO.write(BufImage, "png", new File(efn1));
					} catch (Exception e) {
						return false;
					}

	                postOekaki(new File(efn1));
				}
			}
			previewOekaki(g_BBSKey_efn);
			return true;
		}

		boolean fileDropped(java.util.List list, boolean x)
		{
			if (list == null || list.size() == 0)
				return false;

			for(int i=0; i<list.size(); i++){
				Object obj = list.get(i);
				if (!(obj instanceof File))
					return false;
				File file = (File) obj;
				if (!file.isFile() || !file.canRead()) {
					return false;
				}
				else {
					postOekaki(file);
				}
			}
			previewOekaki(g_BBSKey_efn);
			return true;
		}

		OekakiDropListener()
		{
			super();
		}

	}

	// V2CMOD-twZ by MCZ, Date:2019/08/25, お描書き機能強化
	public static void open(V2CThreadPanel v2cthreadpanel){
		open(v2cthreadpanel, null);
	}
	// ---- END of V2CMOD-twZ ----
	public static void open(V2CThreadPanel v2cthreadpanel, String imageUrl){
		if(v2cthreadpanel.getThreadItem().is2ch()){
			// V2CMOD-twZ by MCZ, Date:2019/08/25, お描書き機能強化
			if(imageUrl != null && imageUrl.length() != 0){
				boolean urlinValid = true;
				Matcher datMatcher = extpattern.matcher(imageUrl);
				while (datMatcher.find()) {
					urlinValid = false;
				}
				if(urlinValid){
					V2CSwingUtil.showErrorMessage("jpeｇ、png、gif、webpでのみ使用可能です");
					return;
				}
			}else{
				imageUrl = "";
			}
			// ---- END of V2CMOD-twZ ----
			String key = v2cthreadpanel.getThreadItem().getBoardItem().getBoardDir() + "_" + v2cthreadpanel.getThreadItem().getThreadKey();
			g_title = "[" + v2cthreadpanel.getThreadItem().getBoardItem().getName() + "] " + v2cthreadpanel.getThreadItem().getTitle();
			previewOekaki(key);
			File localfile = new java.io.File(oekakiDir + "mini.html");
			// V2CMOD-twZ by MCZ, Date:2019/08/25, お描書き機能強化
			if(imageUrl != ""){
				fileRW(imageUrl);
				localfile = new java.io.File(oekakiDir + "minie.html");
			}
			// ---- END of V2CMOD-twZ ----
			V2CMiscUtil.openLinkOutside(localfile.toURI().toString());
		}else{
			V2CSwingUtil.showErrorMessage("お絵描きができるのは、5ちゃんとBBSPINKだけです");
		}
	}

	public static void preview(V2CThreadPanel v2cthreadpanel){
		if(v2cthreadpanel.getThreadItem().is2ch()){
			String key = v2cthreadpanel.getThreadItem().getBoardItem().getBoardDir() + "_" + v2cthreadpanel.getThreadItem().getThreadKey();
			g_title = "[" + v2cthreadpanel.getThreadItem().getBoardItem().getName() + "] " + v2cthreadpanel.getThreadItem().getTitle();
			previewOekaki(key);
		}else{
			V2CSwingUtil.showErrorMessage("お絵描きができるのは、5ちゃんとBBSPINKだけです");
		}
	}
	
	static ArrayList alImageFiles_Oekaki;
	public static Map<String, String> param = new HashMap<String, String>();
	static public JDialog previewOekaki = null;
	static public V2CWritePanel JpaneStab = null;
	static JPanel p = null;
	static JLabel label[] = {null, null, null, null};
	static String g_BBSKey_efn = null;
	static String g_title = ""; 

	static V2COekakiTimerTask v2coekakitimertask = null;;

	// V2CMOD-twZ by MCZ, Date:2019/08/25, お描書き機能強化
	private static void fileRW(String imageUrl) {
		
		// 読み込むファイルの名前
		String inputFileName = "test.txt";
		// 書き込むファイルの名前
		String outputFileName = "test_utf8.txt";
		
		// ファイルオブジェクトの生成
		File inputFile = new java.io.File(oekakiDir + "mini.html");
		File outputFile = new java.io.File(oekakiDir + "minie.html");
		try {
			// 入力ストリームの生成
			FileInputStream fis = new FileInputStream(inputFile);
			InputStreamReader isr = new InputStreamReader(fis,"SJIS");
			BufferedReader br = new BufferedReader(isr);
			// 出力ストリームの生成
			FileOutputStream fos = new FileOutputStream(outputFile);
			OutputStreamWriter osw = new OutputStreamWriter(fos,"SJIS");
			PrintWriter pw = new PrintWriter(osw);
			// ファイルへの読み書き
			String msg;
			while ( ( msg = br.readLine()) != null ) {
				if(!msg.startsWith("/*imgurl*/")){
					pw.println(msg);
				}else{
					pw.println("\t\t\tvar src = '" + imageUrl + "'");
				}
			}
			
			// 後始末
			br.close();
			pw.close();
		 // エラーがあった場合は、スタックトレースを出力
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
	// ---- END of V2CMOD-twZ ----
}
