package org.monazilla.v2c;

import java.security.AccessControlContext;
import java.security.PrivilegedExceptionAction;
import javax.swing.JPopupMenu;

public class V2CMenuScript extends V2CSystemScript
{

	private static V2CMenuScript getInstance()
	{
		if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5))
			return null;
		if (!bLoadTried) {
			bLoadTried = true;
			vMenuScript = (V2CMenuScript) V2CScriptUtil.createSystemScript("menu.js");
		}
		return vMenuScript;
	}

	static void reload()
	{
		if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5))
			return;
		V2CMenuScript v2cmenuscript = vMenuScript;
		if (v2cmenuscript != null) {
			v2cmenuscript.stop();
			vMenuScript = null;
		}
		V2CScriptUtil.printMessage("menu.js\u3092\u8AAD\u307F\u8FBC\u3093\u3067\u3044\u307E\u3059\u2026");
		bLoadTried = false;
		v2cmenuscript = getInstance();
		V2CScriptUtil
				.printMessage("menu.js\u3092\u8AAD\u307F\u8FBC"
						+ (v2cmenuscript == null ? "\u3081\u307E\u305B\u3093\u3067\u3057\u305F\u3002"
								: "\u307F\u307E\u3057\u305F\u3002"));
		V2CMain.clearMenus();
	}

	static V2CMenuScript createMenuScript(String s, V2CScriptClassLoader v2cscriptclassloader,
			AccessControlContext accesscontrolcontext)
	{
		s = s + createDefCheckScript(new String[] { "popupMenuCreated" });
		V2CScriptApp v2cscriptapp = new V2CScriptApp("menu.js");
		String s1 = null;
		PrivilegedExceptionAction privilegedexceptionaction = null;
		try {
			privilegedexceptionaction = V2CJSE6Util.createScriptAction("JavaScript", s, v2cscriptapp, v2cscriptclassloader,
					accesscontrolcontext, false);
		}
		catch (Exception exception) {
			s1 = exception.getMessage();
		}
		if (privilegedexceptionaction == null) {
			V2CScriptUtil
					.setErrorMessage(s1 == null ? "\u30A2\u30AF\u30B7\u30E7\u30F3\u306E\u4F5C\u6210\u306B\u5931\u6557\u3057\u307E\u3057\u305F\u3002"
							: s1);
			return null;
		}
		V2CMenuScript v2cmenuscript = new V2CMenuScript(privilegedexceptionaction, v2cscriptapp, v2cscriptclassloader,
				accesscontrolcontext);
		Object obj = v2cmenuscript.exec();
		if (obj instanceof boolean[]) {
			boolean aflag[] = (boolean[]) (boolean[]) obj;
			bPopupMenuCreated = aflag[0];
		}
		else {
			bPopupMenuCreated = false;
		}
		return v2cmenuscript;
	}

	static void checkPopupMenu(JPopupMenu jpopupmenu, String s)
	{
		V2CMenuScript v2cmenuscript = getInstance();
		if (v2cmenuscript == null || !bPopupMenuCreated) {
			return;
		}
		else {
			v2cmenuscript.popupMenuCreated(jpopupmenu, s);
			return;
		}
	}

	private V2CMenuScript(PrivilegedExceptionAction privilegedexceptionaction, V2CScriptApp v2cscriptapp,
			V2CScriptClassLoader v2cscriptclassloader, AccessControlContext accesscontrolcontext)
	{
		super(privilegedexceptionaction, v2cscriptapp, v2cscriptclassloader, accesscontrolcontext);
	}

	synchronized void popupMenuCreated(JPopupMenu jpopupmenu, String s)
	{
		if (bReloading) {
			return;
		}
		else {
			V2CJSE6Util.setInvokeFunction(vPrivilegedExceptionAction, "popupMenuCreated", new Object[] { jpopupmenu, s });
			exec();
			return;
		}
	}

	private static final String sScriptFileName = "menu.js";
	private static boolean bLoadTried;
	private static V2CMenuScript vMenuScript;
	private static boolean bPopupMenuCreated;
}
