package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class V2CLogViewer extends JTextPane
{

	public V2CLogViewer()
	{
		setMargin(new Insets(5, 5, 5, 10));
		setFont(V2CSSFont.getDefaultFont().getAwtFont());
		StyledDocument styleddocument = getStyledDocument();
		Style style = StyleContext.getDefaultStyleContext().getStyle("default");
		StyleConstants.setBold(style, true);
		Style style1 = styleddocument.addStyle("time", style);
		stylTime = new Style[3];
		stylTime[0] = styleddocument.addStyle("time_info", style1);
		StyleConstants.setBackground(stylTime[0], new Color(0x98fb98));
		stylTime[1] = styleddocument.addStyle("time_warn", style1);
		StyleConstants.setBackground(stylTime[1], Color.YELLOW);
		stylTime[2] = styleddocument.addStyle("time_error", style1);
		StyleConstants.setBackground(stylTime[2], Color.RED);
		styURL = styleddocument.addStyle("url", style);
		styMessage = styleddocument.addStyle("message", style);
		StyleConstants.setBold(styMessage, false);
		styExpand = styleddocument.addStyle("message", styMessage);
		StyleConstants.setBackground(styExpand, new Color(0x87ceeb));
		vlLogEvent = V2CLogger.getEventArray();
		for (int i = 0; i < vlLogEvent.length; i++) {
			V2CLogEvent v2clogevent = vlLogEvent[i];
			addEvent(styleddocument, v2clogevent);
		}

		addMouseListener(new MouseAdapter() {

			public void mouseClicked(MouseEvent mouseevent)
			{
				checkMouseClick(mouseevent);
			}
		});
	}

	private void addEvent(StyledDocument styleddocument, V2CLogEvent v2clogevent)
	{
		v2clogevent.reset();
		Style style = stylTime[Math.min(v2clogevent.getLevel(), stylTime.length - 1)];
		int i = styleddocument.getLength();
		try {
			styleddocument.insertString(i, v2clogevent.getTimeString(), style);
			styleddocument.insertString(styleddocument.getLength(), "   " + v2clogevent.getURLString() + "\n", styURL);
			styleddocument.insertString(styleddocument.getLength(), "    ", styMessage);
			i = styleddocument.getLength();
			if (v2clogevent.hasSubMessage())
				styleddocument.insertString(i, "+", styExpand);
			String s = v2clogevent.getMessage();
			styleddocument.insertString(styleddocument.getLength(), s, styMessage);
		}
		catch (BadLocationException badlocationexception) {
		}
		v2clogevent.setMessageBound(i, styleddocument.getLength());
	}

	void _showDialog()
	{
		JScrollPane jscrollpane = new JScrollPane(this);
		Rectangle rectangle = V2CMain.v2cMain.getBounds();
		Rectangle rectangle1 = V2CSwingUtil.getScreenBoundsAt(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height
				/ 2);
		Dimension dimension = new Dimension((2 * rectangle1.width) / 3, (2 * rectangle1.height) / 3);
		jscrollpane.setPreferredSize(dimension);
		String as[] = { "閉じる", "クリア" };
		Object aobj[] = V2CSwingUtil.createJButtonForOptionPane(as);
		int i = JOptionPane.showOptionDialog(V2CMain.v2cMain, jscrollpane, "ネットワークログ",
				-1, -1, null, aobj, aobj[0]);
		if (i == 1)
			V2CLogger.clear();
	}

	void checkMouseClick(MouseEvent mouseevent)
	{
		if (!V2CSwingUtil.isSimpleClick(mouseevent))
			return;
		Point point = mouseevent.getPoint();
		int i = viewToModel(point);
		Rectangle rectangle = null;
		try {
			rectangle = modelToView(i);
		}
		catch (BadLocationException badlocationexception) {
		}
		if (rectangle == null)
			return;
		int j = point.x;
		int k = point.y;
		if (j < rectangle.x - rectangle.height || j > rectangle.x + rectangle.height || k < rectangle.y
				|| k > rectangle.y + rectangle.height)
			return;
		boolean flag = false;
		int l = 0;
		for (int i1 = 0; i1 < vlLogEvent.length; i1++) {
			V2CLogEvent v2clogevent = vlLogEvent[i1];
			if (!flag) {
				if (!v2clogevent.containdInMessage(i))
					continue;
				flag = true;
				String s = v2clogevent.getSubMessage();
				if (s == null || s.length() == 0)
					return;
				l = s.length() - 1;
				StyledDocument styleddocument = getStyledDocument();
				try {
					styleddocument.insertString(v2clogevent.getMessageEnd(), s, styMessage);
					styleddocument.remove(v2clogevent.getMessageStart(), 1);
				}
				catch (BadLocationException badlocationexception1) {
					return;
				}
			}
			else {
				v2clogevent.shiftMessagePos(l);
			}
		}

	}

	Style stylTime[];
	Style styURL;
	Style styMessage;
	Style styExpand;
	V2CLogEvent vlLogEvent[];

	static JDialog jDialog = null;
	static boolean packnrepaint = false;
	void showDialog()
	{
		JScrollPane jscrollpane = new JScrollPane(this);
		Rectangle rectangle = V2CMain.v2cMain.getBounds();
		Rectangle rectangle1 = V2CSwingUtil.getScreenBoundsAt(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height
				/ 2);
		Dimension dimension = new Dimension((1 * rectangle1.width) / 2, (2 * rectangle1.height) / 3);
		jscrollpane.setPreferredSize(dimension);

		JDialog jdialog = null;
		if(jDialog == null){
			jdialog = new JDialog(V2CMain.v2cMain, "ネットワークログ", false);			
		}else{
			for(int i=0; i<jDialog.getContentPane().getComponentCount(); i++){
				jDialog.getContentPane().removeAll();
			}
			jdialog = jDialog;
		}
		jDialog = jdialog;
		jdialog.setDefaultCloseOperation(2);
		jdialog.setResizable(false);

		JPanel jpanel = new JPanel(new GridBagLayout());

		GridBagConstraints gridbagconstraints = V2CSwingUtil.createGridBagConstraints();
		gridbagconstraints.gridwidth = 0;
		gridbagconstraints.gridy = 0;
		gridbagconstraints.gridx = 0;
		gridbagconstraints.insets = gridbagconstraints.insets = new Insets(8, 5, 5, 5);
		jpanel.add(jscrollpane, gridbagconstraints);

		gridbagconstraints.weightx = 1.0D;
		JPanel jpanel1 = new JPanel(new GridBagLayout());
		jpanel1.setLayout(new FlowLayout(FlowLayout.CENTER, 10, 0));
		
		JButton jbutton1 = new JButton("閉じる");
		jbutton1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				jDialog.dispose();
			}});
		JButton jbutton2 = new JButton("クリア");
		jbutton2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				V2CLogger.clear();
				V2CLogViewer v2clogviewer = new V2CLogViewer();
				packnrepaint = true;
				v2clogviewer.showDialog();
				packnrepaint = false;
			}});
		JButton jbutton3 = new JButton("最 新");
		jbutton3.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				V2CLogViewer v2clogviewer = new V2CLogViewer();
				packnrepaint = true;
				v2clogviewer.showDialog();
				packnrepaint = false;
			}});
		jbutton1.setFocusable(false);
		jbutton2.setFocusable(false);
		jbutton3.setFocusable(false);
		gridbagconstraints.gridy = 0;
		gridbagconstraints.gridx = 0;
		jpanel1.add(jbutton1);
		gridbagconstraints.gridx++;
		jpanel1.add(jbutton2);
		gridbagconstraints.gridx++;
		jpanel1.add(jbutton3);

		gridbagconstraints.insets = gridbagconstraints.insets = new Insets(5, 5, 15, 5);
		gridbagconstraints.anchor = GridBagConstraints.CENTER;
		gridbagconstraints.gridy = 1;
		gridbagconstraints.gridx = 0;
		jpanel.add(jpanel1, gridbagconstraints);
		jdialog.add(jpanel);

		if (jdialog.isVisible()) {
			jdialog.toFront();
			if(packnrepaint){
				jdialog.pack();
				jdialog.repaint();
			}
		}
		else {
			if (rectangle != null) {
				V2CSwingUtil.checkWindowPosition(rectangle);
				jdialog.setBounds(rectangle);
				jdialog.pack();
			}
			else {
				jdialog.pack();
			}
			jdialog.setLocationRelativeTo(V2CMain.v2cMain);
			jdialog.setVisible(true);
		}
	}
}
