package org.monazilla.v2c;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class V2CLockedThreadList
{
	static public HashMap LockedThreadMap = new HashMap <String, List <Integer>> ();
	static private String fname = "2ch_api_LockedThreadList.txt";
	private static final Pattern patternReadCGI = Pattern
			.compile("https?://([^\\.]*)(\\.[25]ch\\.net|\\.bbspink\\.com)/test/read\\.cgi/([^/]*)/([0-9]*).*");
	private static final Pattern pattern = Pattern
			.compile("https?://([^\\.]*)(\\.[25]ch\\.net|\\.bbspink\\.com)/([^/]*)/dat/([0-9]*)\\.dat");
	
	static public List read(){
		List <String> ret= new ArrayList <String>();

		V2CProperty v2cproperty = V2CMain.getUserProperty();
		File file = new File(v2cproperty.fParentFolder.getAbsolutePath()
				+ "/2ch_api_LockedThreadList.txt");
		
		if(file.exists()){
			BufferedReader br = null;
			try {
				br = new BufferedReader(new FileReader(file));
		 
				String line;
				while ((line = br.readLine()) != null) {
					if(line.length() != 0) ret.add(line);
				}
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				try {
					br.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			br = null;
		}
		return ret;
	}

	static public void write(List LockedThreadList){
		V2CProperty v2cproperty = V2CMain.getUserProperty();
		File file = new File(v2cproperty.fParentFolder.getAbsolutePath()
				+ "/2ch_api_LockedThreadList.txt");

		if(LockedThreadList.size() == 0){
			file.delete();
			return;
		}

		BufferedWriter wr = null;
		Collections.sort(LockedThreadList);
		try {
			wr = new BufferedWriter(new FileWriter(file));
		 
			for(int i=0; i<LockedThreadList.size(); i++){
				if(((String) LockedThreadList.get(i)) != null && ((String) LockedThreadList.get(i)) != ""){
					if(threadExists((String) LockedThreadList.get(i))){
						wr.write((String) LockedThreadList.get(i));
						wr.newLine();
					}
				}
			}
		} catch (FileNotFoundException e) {
			try {
				wr.close();
			} catch (IOException e1) {
				e1.printStackTrace();
			}
			e.printStackTrace();
		} catch (IOException e) {
			try {
				wr.close();
			} catch (IOException e1) {
				e1.printStackTrace();
			}
			e.printStackTrace();
		} catch (OutOfMemoryError e) {
			try {
				wr.close();
			} catch (IOException e1) {
				e1.printStackTrace();
			}
			e.printStackTrace();
		} finally {
			try {
				wr.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		wr = null;
		file = null;
	}

	static private void create(List LockedThreadList){
		LockedThreadMap = new HashMap <String, List <Integer>> ();
		for(int i=0; i<LockedThreadList.size(); i++){
			Matcher matcher = patternReadCGI.matcher((String) LockedThreadList.get(i));
			if (matcher.matches()) {
				String bd  = matcher.group(3);
				String th  = matcher.group(4);
				if(!LockedThreadMap.containsKey(bd)){
					LockedThreadMap.put(bd, new ArrayList <Integer> ());
				}
				((List)LockedThreadMap.get(bd)).add(Integer.valueOf(th));
			}
		}
	}

	static private List mtn(List LockedThreadList, String add, String remove){
		List <String> LockedThreadListNew = LockedThreadList;

		if(add != null && add != ""){
			if(!LockedThreadListNew.contains(add)){
				LockedThreadListNew.add(add);
			}
		}else

		if(remove != null && remove != ""){
			if(LockedThreadListNew.contains(remove)){
				LockedThreadListNew.remove(remove);
			}
		}

		return LockedThreadListNew;
	}

	static public void init(){
		List <String> LockedThreadList = read();
		create(LockedThreadList);
	}

	static public void update(List LockedThreadList, String add, String remove){
		write(mtn((LockedThreadList!=null?LockedThreadList:read()), add, remove));
		LockedThreadList = read();
		create(LockedThreadList);
	}

	static public boolean locked(String url){
		Matcher matcher = pattern.matcher(url);
		if (matcher.matches()) {
			String bd  = matcher.group(3);
			String th  = matcher.group(4);
			if(LockedThreadMap.containsKey(bd)){
				if(((List)LockedThreadMap.get(bd)).contains(Integer.valueOf(th))){
					return true;
				}
			}
		}
		return false;
	}
	
	static private boolean threadExists(String s){
		V2CBoardItem v2cboarditem = V2C2chBBS.getBoardItem( s);
		V2CThreadItem v2cthreaditem = null;
		if(v2cboarditem != null){
			Matcher matcher = patternReadCGI.matcher(s);
			if (matcher.matches()) {
				v2cthreaditem = v2cboarditem.getThreadItem(matcher.group(4) + ".dat");
				if(v2cthreaditem != null){
					return true;
				}
			}
		}
		return false;
	}
}
