package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class V2CKakoLogWarehouse extends JPanel implements ActionListener, Runnable
{
	private static class KLWEntry
	{

		public String toString()
		{
			return sLabel;
		}

		private static final SimpleDateFormat vWHFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");
		final String sURL;
		final String sLabel;

		KLWEntry(String s)
		{
			sURL = s;
			sLabel = "999999999 以前";
		}

		KLWEntry(String s, String s2)
		{
			sURL = s2;
			sLabel = s;
		}

		KLWEntry(String s, String s2, int format)
		{
			sURL = s2;
			sLabel = s 
					+ (format == 1?
						" [" + vWHFormat.format(new Date(Long.valueOf(s) * 100000L * 1000)) + "〜" + "]"
							:""
					);
		}

		KLWEntry(String s, String s1, String s2, String s3)
		{
			sURL = s2;
			int i = V2CMiscUtil.parseInt(s);
			int j = V2CMiscUtil.parseInt(s1);
			if (i < 2000)
				i *= 10;
			if (j < 2000)
				j *= 10;
//			sLabel = s + " [" + vWHFormat.format(new Date((long) i * 0x5f5e100L)) + "〜] (" + s1 + ')';
			sLabel = s3 
					+ " " + s + "〜" + s1
					+ " [" + vWHFormat.format(new Date((long) i * 1000)) + "〜" + vWHFormat.format(new Date((long) j * 1000)) + "]"
					;
		}
	}

	private static class SKLWEntry
	{
		final String sURL;
		final String sLabel;
		public String toString()
		{
			return sLabel;
		}
		SKLWEntry(String url, int idx, int thcnt)
		{
			if (idx == 0) {
				sLabel = "フォルダ選択";
				sURL = null;
			} else {
				sLabel = String.valueOf(idx) + " (" + String.valueOf(thcnt) + "～)";
				sURL = url;
			}
		}
	}

	private static class SABAEntry
	{

		public String toString()
		{
			return sLabel;
		}

		final String sURL;
		final String sLabel;

		SABAEntry(String s)
		{
			sURL = s;
			sLabel = s;
		}

		public String getURL()
		{
			return sURL;
		}

		private static final SimpleDateFormat vWHFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");
		SABAEntry(String s, int format)
		{
			sURL = s;
			sLabel = s 
					+ (format == 1?
						" [" + vWHFormat.format(new Date(Long.valueOf(s) * 1000000L * 1000)) + "〜" + "]"
							:""
					);
		}

		SABAEntry(String s, String sl)
		{
			sURL = s;
			sLabel = sl;
		}
	}

	static void showKakoLogWarehouse(Component component)
	{
		b0ch = false;
		btablist = false;
		bMachiBBS = false;
		V2CBoardItem v2cboarditem = null;
		// V2CMOD-twZ by MCZ, Date:2017/06/06, スレビューからの過去ログ倉庫呼び出し
		V2CThreadItem v2cthreaditem0 = null;
		boolean isFromThread = false;
		// ---- END of V2CMOD-twZ ----
		if (component instanceof V2CBoardTree)
			v2cboarditem = ((V2CBoardTree) component).getSelectedBoardItem();
		else if (component instanceof V2CFavoritePanel) {
			Object obj = ((V2CFavoritePanel) component).getSelectedItem();
			if (obj instanceof V2CBoardItem)
				v2cboarditem = (V2CBoardItem) obj;
		}
		else if (component instanceof JMenuBar) {
			V2CThreadList v2cthreadlist = V2CThreadList.getActivePanel();
			if (!(v2cthreadlist instanceof V2CBoardList)) {
				V2CSwingUtil
						.showErrorMessage("板のスレ一覧が選択されていません。");
				return;
			}
			v2cboarditem = ((V2CBoardList) v2cthreadlist).getBoardItem();
		}
		// V2CMOD-twZ by MCZ, Date:2017/06/06, スレビューからの過去ログ倉庫呼び出し
		else if (component instanceof V2CThreadPanel) {
			v2cboarditem = ((V2CThreadPanel) component).getThreadItem().getBoardItem();
			v2cthreaditem0 = ((V2CThreadPanel) component).getThreadItem();
			isFromThread = true;
		}
		// ---- END of V2CMOD-twZ ----
		if (v2cboarditem == null)
			return;
		V2CBBS v2cbbs = v2cboarditem.getBBS();
		String s = v2cboarditem.getURLString();
		String s1 = v2cboarditem.getName() + "板 過去ログ倉庫";
		boolean flag = false;
		boolean flag1;
		if (v2cbbs.is2ch()) {
			flag1 = true;
			URL url = v2cboarditem.getURL();
			// V2CMOD-twZ by MCZ, Date:2017/06/06, スレビューからの過去ログ倉庫呼び出し
			if(isFromThread){
				url = v2cthreaditem0.getURL();
			}
			v2cthreaditem0 = null;
			// ---- END of V2CMOD-twZ ----
			if (url != null) {
				String s2 = url.getHost();
				int i = s2.indexOf('.');
				if (i > 0) {
					String s4 = s2.substring(0, i);
					V2CInputDialog v2cinputdialog = new V2CInputDialog(null, "サーバ（" + s2.substring(i)
							+ "）：", null, s4, 10, s1);
					String s9 = v2cinputdialog.showDialog();
					if (s9 == null || !s9.matches("\\p{Alnum}+"))
						return;
					if (!s9.equals(s4))
						s = "http://" + s9 + s2.substring(i) + url.getPath();
					// V2CMOD-twZ by MCZ, Date:2017/06/06, スレビューからの過去ログ倉庫呼び出し
					if (isFromThread){
						String[] sss = (""+url.getPath()).split("/");
						s = "http://" + s9 + s2.substring(i) + "/" + sss[1] + "/";
					}
					// ---- END of V2CMOD-twZ ----
				}
			}
		}
		else if (v2cbbs.is2chEq()) {
			flag1 = s.matches("http://yy\\d{2,3}\\.(?:60\\.kg|kakiko\\.com)/[0-9a-z]{4,16}/");
			if (!flag1 && s.matches("http://ex14\\.vip[25]ch\\.com/\\p{Alnum}+/")) {
				flag1 = true;
				flag = true;
			}
		}
		else {
			flag1 = false;
		}
		ArrayList arraylist = new ArrayList();
		boolean flag2 = false;
		ArrayList al2 = new ArrayList();
		SABAList = new ArrayList();
		String s6_ = null;
		if (flag1) {
			flag2 = true;
			String s3 = s + "kako/";
			V2CHttpUtil.CAndC candc = V2CHttpUtil.getHTTPFileBG("過去ログ倉庫取得中…",
					s1, s3 + "kako0000.html", "MS932", "text/html", 0L);
			String s6 = null;
			if (candc == null || (s6 = candc.getContents()) == null) {
				String s10 = null;
				if (candc != null)
					s10 = candc.getErrorMessage();
				if (s10 == null)
					s10 = "unknown reason";
				V2CSwingUtil
						.showErrorMessage("過去ログ倉庫取得エラー\n(" + s10 + ")");
				return;
			}
			int k = 0;
			int l = 0;
			String s12;
			if (flag)
				s12 = ">#" + v2cboarditem.getBoardDir()
						+ "(\\d+)</a></td><td[^>]*>\\1 \\((\\d+)\\)</td>(?:.+<a href=\"(\\w+\\1/subject.txt)\">)?";
			else
//				s12 = ">#" + v2cboarditem.getBoardDir()
//						+ "(\\d+)</a></td><td[^>]*>(\\d+)</td>(?:.+<a href=\"(\\w+\\1/subject.txt)\">)?";
			{
				String s16;
				s12 = "https?://([^.]+)\\.([25]ch\\.net|bbspink\\.com)";
				for (Matcher matcher = Pattern.compile(s12, 2).matcher(s); matcher.find(); SABAList.add(new SABAEntry(matcher
						.group(1)))) {
				}
				s12 = "<p class=\"menu_link\"><a href=\"//([^.]+)\\.([25]ch\\.net|bbspink\\.com)";
				for (Matcher matcher = Pattern.compile(s12, 2).matcher(s6); matcher.find(); SABAList.add(new SABAEntry(matcher
						.group(1)))) {
				}

				s12 = "(<p class=\"menu_here\">)(\\d+)-(\\d+)";
				for (Matcher matcher = Pattern.compile(s12, 2).matcher(s6); matcher.find(); arraylist.add(new KLWEntry(matcher
						.group(2), matcher.group(3), s16, "0000"))) {
					String s15 ="0000";
					if (s15 != null) {
						s16 = s3 + "kako" + s15 + ".html";
						k++;
					}
					else {
						s16 = s3 + matcher.group(1) + '/';
						l++;
					}
				}
				s12 = "<p class=\"menu_link\"><a href=\"./kako(\\d+)\\.html\">(\\d+)-(\\d+)</a>";
			}
			String s16;
			for (Matcher matcher = Pattern.compile(s12, 2).matcher(s6); matcher.find(); arraylist.add(new KLWEntry(matcher
					.group(2), matcher.group(3), s16, matcher.group(1)))) {
				String s15 = matcher.group(1);
				if (s15 != null) {
					s16 = s3 + "kako" + s15 + ".html";
					k++;
				}
				else {
					s16 = s3 + matcher.group(1) + '/';
					l++;
				}
			}

			if (k == 0 && s6.indexOf("倉庫番号 <A HREF=\"index9.html\">999999999 以前</A>") > 0) {
				arraylist.add(new KLWEntry(s3 + "index9.html"));
				l++;
			}
/*
			if (l > 0)
				if (k == 0) {
					Object obj2;
					if (arraylist.size() > 1)
						obj2 = V2CSwingUtil
								.showComboBoxDialog(
										arraylist,
										arraylist.get(0),
										"中間フォルダを選択してください。",
										s1);
					else
						obj2 = arraylist.get(0);
					if (!(obj2 instanceof KLWEntry))
						return;
					arraylist.clear();
					String s17 = ((KLWEntry) obj2).sURL;
					V2CHttpUtil.CAndC candc1 = V2CHttpUtil.getHTTPFileBG(
							"過去ログ倉庫取得中…", s1, s17, "MS932", "text/html", 0L);
					String s7 = null;
					if (candc1 == null || (s7 = candc1.getContents()) == null) {
						String s19 = null;
						if (candc1 != null)
							s19 = candc1.getErrorMessage();
						if (s19 == null)
							s19 = "unknown reason";
						V2CSwingUtil.showErrorMessage("過去ログ倉庫取得エラー\n("
								+ s19 + ")");
						return;
					}
					if (!s17.endsWith(".html"))
						s3 = s17;
					String s13;
					if (flag)
						s13 = ">#(\\d+)</a></TD><TD>\\1 \\((\\d+)\\)</TD><TD><a href=\"\\1/subject.txt\"";
					else
						s13 = ">#" + v2cboarditem.getBoardDir() + "(\\d+)</a> - (\\d+)[/ ]";
					String s20;
					for (Matcher matcher1 = Pattern.compile(s13, 2).matcher(s7); matcher1.find(); arraylist.add(new KLWEntry(s20,
							matcher1.group(2), s3 + s20 + "/subject.txt")))
						s20 = matcher1.group(1);

				}
				else {
					arraylist.clear();
				}
*/
		}
		else if (v2cbbs.isJBBSShitarabaBBS()) {

			int j = s.indexOf('/', 7);
			if (j < 0)
				return;
			String s5 = s.substring(j);
			String s8 = s.substring(0, j) + "/bbs/storage.cgi" + s5;
			V2CHttpUtil.CAndC candc2 = V2CHttpUtil.getHTTPFileBG("過去ログ倉庫取得中…",
					s1, s8, "UTF-8", "text/html", 0L);
			String s11 = null;
			if (candc2 == null || (s11 = candc2.getContents()) == null) {
				String s14 = null;
				if (candc2 != null)
					s14 = candc2.getErrorMessage();
				if (s14 == null)
					s14 = "unknown reason";
				V2CSwingUtil
						.showErrorMessage("過去ログ倉庫取得エラー\n(" + s14 + ")");
				return;
			}
			Object obj1 = v2cboarditem.checkSubjectTxtLoaded();
			// V2CMOD-twZ by MCZ, Date:2016/12/03, したらば過去ログ倉庫取得
//			Matcher matcher2 = Pattern.compile("<a href=\"http://[^/]+?/bbs/read_archive.cgi" + s5 + "(\\d+)/-100\">\\n +([^<>]*)\\((\\d+)\\)\\n\\s+?</a>", 2)
//					.matcher(s11);
			Matcher matcher2 = Pattern.compile("<a href=\"https?://[^/]+?/bbs/read_archive.cgi" + s5 + "(\\d+)/.*?\">\\n +([^<>]*)\\((\\d+)\\)\\n\\s+?</a>", 2)
					.matcher(s11);
			// ---- END of V2CMOD-twZ ----
			do {
				if (!matcher2.find())
					break;
				int i1 = V2CMiscUtil.parseInt(matcher2.group(3));
				if (i1 > 0) {
					String s18 = matcher2.group(1) + ".cgi";
					V2CThreadItem v2cthreaditem = v2cboarditem.getThreadItem(s18);
					if (v2cthreaditem == null) {
						v2cthreaditem = new V2CThreadItem(s18, v2cboarditem, s);
						v2cthreaditem.setTitle(V2CResItem.replaceEscapes(matcher2.group(2)));
					}
					v2cthreaditem.setNRes(i1);
					arraylist.add(v2cthreaditem);
				}
			} while (true);
			if (arraylist.size() > 0) {
				matcher2 = Pattern.compile("<p>(\\d+)個のログがあります</p>").matcher(s11);
				if (matcher2.find()) {
					int log_cnt = V2CMiscUtil.parseInt(matcher2.group(1));
					int x = log_cnt / 100 + (log_cnt % 100 > 0 ? 1 : 0);
					for (int i = 1; i <= x; i++) {
						int cnt2 = (x - (i - 1)) * 100 - 99;
						al2.add(new SKLWEntry(s8 + String.valueOf(i), i, cnt2));
					}
				}
			}
			v2cboarditem.releaseSubjectHoldKey(obj1);

		}
		else if (v2cbbs.isMachiBBS()) {

			if((s6_ = getMachiBBSKakoLogWarehouse(s, s1)) != null){
				bMachiBBS = true;
				flag2 = true;
				String s12 = "<a href=\"?\\.+/([^\">]+)[\">]([^<]+)";
				for (Matcher matcher = Pattern.compile(s12, 2).matcher(s6_); matcher.find(); SABAList.add(new SABAEntry(s + matcher
						.group(1), matcher.group(2)))) {
				}

				String s3 = ((SABAEntry) SABAList.get(0)).getURL();
				arraylist.add(new KLWEntry("【全て】", s3));
				s6_ = getMachiBBSKakoLogWarehouseSub(s3);
				s12 = "(【[^】]+】)<br>";
				for (Matcher matcher = Pattern.compile(s12, 2).matcher(s6_); matcher.find(); arraylist.add(new KLWEntry(
						MachiBBSZeroPadding(matcher.group(1)), s3))) {
				}
			}
		}
		else if((s6_ = get0chBBSKakoLogWarehouse(s, s1)) != null){
			b0ch = true;
			flag2 = true;
			String s3 = s + "kako/";
			String s12 = "<td><a href=\"([^\"/]+)";
			for (Matcher matcher = Pattern.compile(s12, 2).matcher(s6_); matcher.find(); SABAList.add(new SABAEntry(matcher
					.group(1), 1))) {
			}

			s6_ = get0chBBSKakoLogWarehouseSub(s3 + ((SABAEntry) SABAList.get(0)).getURL() + "/");
			for (Matcher matcher = Pattern.compile(s12, 2).matcher(s6_); matcher.find(); arraylist.add(new KLWEntry(matcher
					.group(1), s3 + ((SABAEntry) SABAList.get(0)).getURL() + "/" + matcher.group(1) + "/", 1))) {
			}
		}
		else if((s6_ = gettablistBBSKakoLogWarehouse(s, s1)) != null){
			btablist = true;
			flag2 = true;
			String s3 = s + "kakologs/";
			String s12 = "\\?page=(\\d+)\">Last</a>";
			Pattern p = Pattern.compile(s12, 2);
			Matcher m = p.matcher(s6_);
			int n = 1;
			while(m.find()){
				n = Integer.valueOf(m.group(1));
			}
			SABAList.add(new SABAEntry(""));
			for(int i=1; i<=n; i++){
				arraylist.add(new KLWEntry(""+i, s3.replace("ban/kakologs/", "api/kakologs") + "?page=" + i));
			}
		}
		else {
			V2CSwingUtil
					.showErrorMessage(
							"この板では過去ログ倉庫を表示することができません。",
							s1);
			return;
		}
		if (arraylist.size() == 0) {
			V2CSwingUtil.showErrorMessage("過去ログ倉庫"
					+ (flag2 ? "" : "のスレッド") + "が存在しません。", s1);
			return;
		}
		else {
			v2ckakologwarehouse = new V2CKakoLogWarehouse(v2cboarditem, s, arraylist, flag2, al2, SABAList);
			v2ckakologwarehouse.showDialog();
			V2CThreadList.addDialogThreadList(v2ckakologwarehouse.vDialogBoardList);
			return;
		}
	}

	private V2CKakoLogWarehouse(V2CBoardItem v2cboarditem, String s, ArrayList arraylist, boolean flag, ArrayList al_sklwentry, ArrayList SABA)
	{
		super(new GridBagLayout());
		vBoardItem = v2cboarditem;
		bShitaraba = !flag;
		sURL = s;
		GridBagConstraints gridbagconstraints = V2CSwingUtil.createGridBagConstraints();
		gridbagconstraints.insets = new Insets(3, 3, 3, 3);
		// mod by ere
		ArrayList al = (flag) ? arraylist : al_sklwentry;
		if (flag)
			al.add(0, "フォルダを選択");

		JComboBox jcomboboxSaba = null;
		if(flag){
			jcomboboxSaba = V2CSwingUtil.createComboBox(SABA.toArray());
			jcbSabaDirs = jcomboboxSaba;
			jcomboboxSaba.setFocusable(false);
			jcomboboxSaba.addActionListener(this);
			add(jcomboboxSaba, gridbagconstraints);
			gridbagconstraints.gridx++;
		}

		JComboBox jcombobox = V2CSwingUtil.createComboBox(al.toArray());
		jcbDirs = jcombobox;
		jcombobox.setFocusable(false);
		jcombobox.addActionListener(this);
		add(jcombobox, gridbagconstraints);
		gridbagconstraints.gridy++;

		gridbagconstraints.gridx = 0;

		V2CDialogBoardList v2cdialogboardlist = new V2CDialogBoardList(v2cboarditem, false);
		vDialogBoardList = v2cdialogboardlist;
		if (!flag)
			v2cdialogboardlist.setThreads(arraylist);
		v2cdialogboardlist.addMouseListener(new V2CTablePopupListener("KakoLogSoko", this, v2cdialogboardlist));
		v2cdialogboardlist.addMouseListener(new MouseAdapter() {

			public void mouseClicked(MouseEvent mouseevent)
			{
				if (mouseevent.getClickCount() == 2)
					openSelectedThreads();
			}
		});
		JScrollPane jscrollpane = new JScrollPane(v2cdialogboardlist);
		jScrollPane = jscrollpane;
		jscrollpane.setVerticalScrollBarPolicy(22);
		setSPPreferredSize();
		gridbagconstraints.gridwidth = 0;
		gridbagconstraints.weightx = 1.0D;
		gridbagconstraints.weighty = 1.0D;
		gridbagconstraints.fill = 1;
		add(jscrollpane, gridbagconstraints);
		gridbagconstraints.weightx = 0.0D;
		gridbagconstraints.weighty = 0.0D;
		gridbagconstraints.fill = 0;
		gridbagconstraints.anchor = 10;
		gridbagconstraints.gridy++;
		JButton jbutton = new JButton("閉じる");
		jbClose = jbutton;
		jbutton.setFocusable(false);
		jbutton.addActionListener(this);
		add(jbutton, gridbagconstraints);
		gridbagconstraints.gridy = 0;
		gridbagconstraints.gridx = 1;
		gridbagconstraints.gridwidth = 1;
		gridbagconstraints.anchor = 13;
		final V2CAbstractMiniSearch ams = V2CAbstractMiniSearch.createInstanceForDialog(v2cdialogboardlist);
		add(ams, gridbagconstraints);
		JDialog jdialog = new JDialog(V2CMain.v2cMain, v2cboarditem.getName() + "板 過去ログ倉庫",
				false);
		jDialog = jdialog;
		jdialog.setDefaultCloseOperation(2);
		V2CSwingUtil.registerESCToDialog(jdialog);
		jdialog.setContentPane(this);
		jdialog.addWindowListener(new WindowAdapter() {

			public void windowClosed(WindowEvent windowevent)
			{
				ams.saveState();
				try {
					timer_cancel();
				} catch (InterruptedException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
				}
			}
		});
	}

	private void setSPPreferredSize()
	{
		JScrollPane jscrollpane = jScrollPane;
		Insets insets = jscrollpane.getInsets();
		Dimension dimension = vDialogBoardList.getPreferredSize();
		int i = jscrollpane.getVerticalScrollBar().getPreferredSize().width;
		jscrollpane.setPreferredSize(new Dimension(dimension.width + insets.left + insets.right + i + 60, 450));
	}

	void showDialog()
	{
		JDialog jdialog = jDialog;
		jdialog.pack();
		Rectangle rectangle = V2CMain.v2cMain.getBounds();
		Dimension dimension = jdialog.getPreferredSize();
		jdialog.setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y
				+ (rectangle.height - dimension.height) / 2);
		jdialog.setVisible(true);
	}

	public void run()
	{
		Thread thread = Thread.currentThread();
		String s = sTargetURL;
		String sl = sTargetLabel;

		V2CHttpUtil.CAndC candc = (bShitaraba || b0ch || bMachiBBS)
				? V2CHttpUtil.getHTTPFile(s, null, (!(b0ch || bMachiBBS))?"UTF-8":"MS932", "text/html", 0L, 2)
				: (!btablist ? V2CHttpUtil.getGenTextFile(s, "UTF-8") : V2CHttpUtil.getRawHTTPFile(s));
		if (thread.isInterrupted())
			return;
		String s1 = null;
		if(!btablist){
			if (candc == null || (s1 = candc.getContents()) == null) {
				String s2 = null;
				if (candc != null)
					s2 = candc.getErrorMessage();
				if (s2 == null)
					s2 = "unknown reason";
				V2CSwingUtil.showErrorMessage("過去ログ倉庫取得エラー\n(" + s2 + ")");
				return;
			}
		}else{
			s1 = tablistHtmlRebuild(candc, vBoardItem.getURLString());
		}
		V2CBoardItem v2cboarditem = vBoardItem;
		Pattern pattern;
		Pattern patternRange;
		String s3;
		if (bShitaraba) {
			// V2CMOD-twZ by MCZ, Date:2016/12/03, したらば過去ログ倉庫取得
//			pattern = Pattern.compile("<a href=\"http://[^/]+?/bbs/read_archive.cgi/\\w+/\\d+/(\\d+)/-100\">\\n +([^<>]*)\\((\\d+)\\)\\n\\s+?</a>", 2);
			pattern = Pattern.compile("<a href=\"https?://[^/]+?/bbs/read_archive.cgi/\\w+/\\d+/(\\d+)/.*?\">\\n +([^<>]*)\\((\\d+)\\)\\n\\s+?</a>", 2);
			// ---- END of V2CMOD-twZ ----
			s3 = v2cboarditem.getBBS().getDatExt();
		} else if(b0ch){
			s1 = s1.replaceAll("</a>", "(1)</a>");
			pattern = Pattern.compile("<td><a href=\"(\\d+)\\.html.+?>([^\\(]*)\\((\\d*)\\)</a>", 2);
			s3 = v2cboarditem.getBBS().getDatExt();
		} else if(btablist){
			pattern = Pattern.compile("<td>(\\d+)</td><td>(.+)?</td><td>\\((\\d*)\\)</td>", 2);
			s3 = v2cboarditem.getBBS().getDatExt();
		} else if(bMachiBBS){
			sl = sl.replace("年0", "年").replace("月0", "月");
			patternRange = Pattern.compile(sl +"([\\s\\S]+?(?:【[^】]+】<br>|$))", 2);
			Matcher matcher = patternRange.matcher(s1);
			if (matcher.find()){
				s1 = matcher.group(1);
			}
			pattern = Pattern.compile("<a href=\\.+/[^/]+/[^/]+/[^/]+/([^/]+)/>([^<]+)</a>", 2);
			s3 = v2cboarditem.getBBS().getDatExt();
		} else {
			if ((s1.startsWith("<html>") || s1.startsWith("<!DOCTYPE html>")) && s.endsWith(".html")) {
/*
				V2CHttpUtil.CAndC candc1 = V2CHttpUtil.getGenTextFile(s.substring(0, s.length() - 11), "MS932");
				if (thread.isInterrupted())
					return;
				s1 = null;
				if (candc1 == null || (s1 = candc1.getContents()) == null) {
					String s4 = null;
					if (candc1 != null)
						s4 = candc1.getErrorMessage();
					if (s4 == null)
						s4 = "unknown reason";
					V2CSwingUtil.showErrorMessage("過去ログ倉庫取得エラー\n(" + s4 + ")");
					return;
				}
*/
//				pattern = Pattern.compile("<A HREF=\"(\\d+).html\">([^<]*) \\((\\d+)\\)</A>", 2);
				if(s.indexOf(".bbspink.com/") == -1){
					pattern = Pattern.compile("<a href=\"/test/read\\.cgi/[^/]+/(\\d+).*?>([^<]*)</a>.*?<span class=\"lines\">(\\d+)</span>", 2);
				}else{
					pattern = Pattern.compile("<a href=\"/test/read\\.cgi/[^/]+/(\\d+).*?>[^<]*</a>.*?class=\"title\">([^<]*)</span><span class=\"lines\">(\\d+)</span>", 2);
				}
				s3 = v2cboarditem.getBBS().getDatExt();
			}
			else {
				pattern = Pattern.compile('^' + V2CBBS.get2chBBS().getSubjectPattern(v2cboarditem).pattern() + '$', 8);
				s3 = null;
			}
		}
		final ArrayList al = new ArrayList();
		Object obj = v2cboarditem.checkSubjectTxtLoaded();
		Matcher matcher = pattern.matcher(s1);
		do {
			if (!matcher.find())
				break;
			int i = 0;
			try {
				i = V2CMiscUtil.parseInt(matcher.group(3));
			} catch(IndexOutOfBoundsException e){
				if(bMachiBBS) i = 1;
			}
			if (i > 0) {
				String s5 = matcher.group(1);
				if (s3 != null)
					s5 = s5 + s3;
				V2CThreadItem v2cthreaditem = v2cboarditem.getThreadItem(s5);
				if (v2cthreaditem == null) {
					v2cthreaditem = new V2CThreadItem(s5, v2cboarditem, sURL);
					v2cthreaditem.setTitle(V2CResItem.replaceEscapes(matcher.group(2).trim()));
				}
				v2cthreaditem.setNRes(i);
				al.add(v2cthreaditem);
			}
		} while (true);
		v2cboarditem.releaseSubjectHoldKey(obj);
		if (thread.isInterrupted()) {
			return;
		}
		else {
			SwingUtilities.invokeLater(new Runnable() {

				public void run()
				{
					vDialogBoardList.setThreads(al);
					if (al.size() > 0)
						vDialogBoardList.setRowSelectionInterval(0, 0);
					setSPPreferredSize();
					java.awt.Window window = SwingUtilities.getWindowAncestor(V2CKakoLogWarehouse.this);
					if (window instanceof JDialog)
						((JDialog) window).pack();
				}
			});
			return;
		}
	}

	private void openSelectedThreads()
	{
		int ai[] = vDialogBoardList.getSelectedRows();
		int i = ai.length;
		if (i == 0)
			return;
		V2CThreadListTableModel v2cthreadlisttablemodel = vDialogBoardList.vtlTableModel;
		ArrayList arraylist = new ArrayList();
		for (int j = i - 1; j >= 0; j--) {
			V2CThreadItem v2cthreaditem = v2cthreadlisttablemodel.getThreadItem(ai[j]);
			if (vDialogBoardList.getThreadVisibility(v2cthreaditem))
				arraylist.add(v2cthreaditem);
		}

		int k = arraylist.size();
		if (k == 0) {
			return;
		}
		else {
			V2CThreadItem av2cthreaditem[] = (V2CThreadItem[]) (V2CThreadItem[]) arraylist.toArray(new V2CThreadItem[k]);
			V2CThreadOpenRequest v2cthreadopenrequest = new V2CThreadOpenRequest();
			v2cthreadopenrequest.setUpdateAll(true);
			v2cthreadopenrequest.setForceUpdate(true);
			V2CThreadItem.open(av2cthreaditem, true, true, v2cthreadopenrequest);
			try {
				if(!timerOn){
					timer_period();
					timerOn = true;
				}
			} catch (InterruptedException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
			return;
		}
	}

	void performAction(String s, ActionEvent actionevent)
	{
		if (s == null)
			return;
		if (s.equals("Open"))
			openSelectedThreads();
		else if (s.equals("FS"))
			vDialogBoardList.hideUnselectedThread();
	}

	public void actionPerformed(ActionEvent actionevent)
	{
		Object obj = actionevent.getSource();
		if (obj == jcbDirs) {
			Object obj1 = jcbDirs.getSelectedItem();
			if (obj1 instanceof KLWEntry) {
				if (jcbDirs.getItemAt(0) instanceof String)
					jcbDirs.removeItemAt(0);
				KLWEntry klwentry = (KLWEntry) obj1;
				Thread thread = vHttpThread;
				if (thread != null) {
					vHttpThread = null;
					thread.interrupt();
				}
				sTargetURL = klwentry.sURL;
				sTargetLabel = klwentry.sLabel;
				thread = new Thread(this);
				vHttpThread = thread;
				thread.run();
			} else if (obj1 instanceof SKLWEntry) {
				if (jcbDirs.getItemAt(0) instanceof String)
					jcbDirs.removeItemAt(0);
				SKLWEntry entry = (SKLWEntry)obj1;
				Thread th = vHttpThread;
				if (th != null) {
					vHttpThread = null;
					th.interrupt();
				}
				sTargetURL = entry.sURL;
				sTargetLabel = entry.sLabel;
				th = new Thread(this);
				vHttpThread = th;
				th.run();
			}
		}
		else if (obj == jcbSabaDirs) {
			Object obj1 = jcbSabaDirs.getSelectedItem();
			if (obj1 instanceof SABAEntry) {
				if(b0ch){
					showKakoLogWarehouseOverride0ch(vBoardItem, ((SABAEntry) obj1).sURL);
				}else if(bMachiBBS){
					showKakoLogWarehouseOverrideMachiBBS(vBoardItem, ((SABAEntry) obj1).sURL);
				}else{
					showKakoLogWarehouseOverride(vBoardItem, ((SABAEntry) obj1).sURL);
				}
			}
		}
		else if (obj == jbClose)
		{
			try {
				timer_cancel();
			} catch (InterruptedException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
			jDialog.dispose();
		}
	}

	final V2CBoardItem vBoardItem;
	String sURL;
	JDialog jDialog;
	JComboBox jcbDirs;
	JComboBox jcbSabaDirs;
	final V2CDialogBoardList vDialogBoardList;
	JScrollPane jScrollPane;
	JButton jbClose;
	String sTargetURL;
	String sTargetLabel;
	boolean bShitaraba;
	Thread vHttpThread;
	static ArrayList SABAList = new ArrayList();

	void showKakoLogWarehouseOverride(V2CBoardItem v2cboarditem, String saba){
		V2CBBS v2cbbs = v2cboarditem.getBBS();
		String s = v2cboarditem.getURLString();
		String s1 = v2cboarditem.getName() + "板 過去ログ倉庫";

		boolean flag1 = true;
		boolean flag2 = false;
		ArrayList arraylist = new ArrayList();
		ArrayList al2 = new ArrayList();

		String a145 = "(https?://)[^.]+(.+)";
		for (Matcher matcher = Pattern.compile(a145, 2).matcher(s); matcher.find();
			s = matcher.group(1) + saba + matcher.group(2)) {
		}
		sURL = s;
		if (flag1) {
			flag2 = true;
			String s3 = s + "kako/";
			V2CHttpUtil.CAndC candc = V2CHttpUtil.getHTTPFileBG("過去ログ倉庫取得中…",
					s1, s3, "MS932", "text/html", 0L);
			String s6 = null;
			if (candc == null || (s6 = candc.getContents()) == null) {
				String s10 = null;
				if (candc != null)
					s10 = candc.getErrorMessage();
				if (s10 == null)
					s10 = "unknown reason";
				V2CSwingUtil
						.showErrorMessage("過去ログ倉庫取得エラー\n(" + s10 + ")");
				return;
			}
			int k = 0;
			int l = 0;
			String s12;
//				s12 = ">#" + v2cboarditem.getBoardDir()
//						+ "(\\d+)</a></td><td[^>]*>(\\d+)</td>(?:.+<a href=\"(\\w+\\1/subject.txt)\">)?";
			{
				String s16;
				s12 = "(<p class=\"menu_here\">)(\\d+)-(\\d+)";
				for (Matcher matcher = Pattern.compile(s12, 2).matcher(s6); matcher.find(); arraylist.add(new KLWEntry(matcher
						.group(2), matcher.group(3), s16, "0000"))) {
					String s15 ="0000";
					if (s15 != null) {
						s16 = s3 + "kako" + s15 + ".html";
						k++;
					}
					else {
						s16 = s3 + matcher.group(1) + '/';
						l++;
					}
				}
				s12 = "<p class=\"menu_link\"><a href=\"./kako(\\d+)\\.html\">(\\d+)-(\\d+)</a>";
			}
			String s16;
			for (Matcher matcher = Pattern.compile(s12, 2).matcher(s6); matcher.find(); arraylist.add(new KLWEntry(matcher
					.group(2), matcher.group(3), s16, matcher.group(1)))) {
				String s15 = matcher.group(1);
				if (s15 != null) {
					s16 = s3 + "kako" + s15 + ".html";
					k++;
				}
				else {
					s16 = s3 + matcher.group(1) + '/';
					l++;
				}
			}

			if (k == 0 && s6.indexOf("倉庫番号 <A HREF=\"index9.html\">999999999 以前</A>") > 0) {
				arraylist.add(new KLWEntry(s3 + "index9.html"));
				l++;
			}
		}
		if (arraylist.size() == 0) {
			V2CSwingUtil.showErrorMessage("過去ログ倉庫"
					+ (flag2 ? "" : "のスレッド") + "が存在しません。", s1);
			return;
		}
		else {
			Component[] c = v2ckakologwarehouse.getComponents();
			for(int i=0; i<c.length; i++){
				if((Object) c[i] == jcbDirs){
					((JComboBox) c[i]).removeAllItems();
					arraylist.add(0, "フォルダを選択");
					for(int j=0; j<arraylist.size(); j++){
						((JComboBox) c[i]).addItem(arraylist.get(j));
					}
				}else if(c[i] instanceof JScrollPane){
					Component[] c1 = ((JScrollPane) c[i]).getComponents();
					for(int j=0; j<c1.length; j++){
						if(c1[j] instanceof JViewport){
							Component[] c2 = ((JViewport) c1[j]).getComponents();
							for(int k=0; k<c2.length; k++){
								if(c2[k] instanceof V2CDialogBoardList){
									((V2CDialogBoardList) c2[k]).setThreads(new ArrayList());
									((V2CDialogBoardList) c2[k]).repaint();
								}
							}
						}
					}
				}
			}
			return;
		}
	}
	static V2CKakoLogWarehouse v2ckakologwarehouse;
	
	static boolean b0ch;
	static String get0chBBSKakoLogWarehouse(String s, String s1){
		Pattern Zeroch = Pattern.compile("0ch\\+ BBS", 2);
		String s3 = s + "kako/";
		V2CHttpUtil.CAndC candc = V2CHttpUtil.getHTTPFileBG("過去ログ倉庫取得中…",
				s1, s3, "MS932", "text/html", 0L);
		String s6 = null;
		if (candc == null || (s6 = candc.getContents()) == null) {
			String s10 = null;
			if (candc != null)
				s10 = candc.getErrorMessage();
			if (s10 == null)
				s10 = "unknown reason";
			if(candc.getResponseCode() != 404)
				V2CSwingUtil
					.showErrorMessage("過去ログ倉庫取得エラー\n(" + s10 + ")");
			return null;
		}

		Matcher matcher = Zeroch.matcher(s6);
		boolean ZerochFound = false;
		while(matcher.find()){
			ZerochFound = true;
		}
		if(!ZerochFound){
			return null;
		}
		
		return s6;
	}

	static String get0chBBSKakoLogWarehouseSub(String s){
		Pattern Zeroch = Pattern.compile("0ch\\+ BBS", 2);
		String s3 = s + "kako/";
		V2CHttpUtil.CAndC candc = V2CHttpUtil.getHTTPFile(s, null, "MS932", "text/html", 0L, 2);
		String s6 = null;
		if (candc == null || (s6 = candc.getContents()) == null) {
			String s10 = null;
			if (candc != null)
				s10 = candc.getErrorMessage();
			if (s10 == null)
				s10 = "unknown reason";
			V2CSwingUtil
					.showErrorMessage("過去ログ倉庫取得エラー\n(" + s10 + ")");
			return null;
		}

		Matcher matcher = Zeroch.matcher(s6);
		boolean ZerochFound = false;
		while(matcher.find()){
			ZerochFound = true;
		}
		if(!ZerochFound){
			return null;
		}
		
		return s6;
	}

	void showKakoLogWarehouseOverride0ch(V2CBoardItem v2cboarditem, String saba){
		V2CBBS v2cbbs = v2cboarditem.getBBS();
		String s = v2cboarditem.getURLString();
		String s1 = v2cboarditem.getName() + "板 過去ログ倉庫";

		boolean flag1 = true;
		boolean flag2 = false;
		ArrayList arraylist = new ArrayList();
		ArrayList al2 = new ArrayList();

		sURL = s;
		if (flag1) {
			flag2 = true;
			String s3 = s + "kako/";
			V2CHttpUtil.CAndC candc = V2CHttpUtil.getHTTPFileBG("過去ログ倉庫取得中…",
					s1, s3 + saba + "/", "MS932", "text/html", 0L);
			String s6 = null;
			if (candc == null || (s6 = candc.getContents()) == null) {
				String s10 = null;
				if (candc != null)
					s10 = candc.getErrorMessage();
				if (s10 == null)
					s10 = "unknown reason";
				V2CSwingUtil
						.showErrorMessage("過去ログ倉庫取得エラー\n(" + s10 + ")");
				return;
			}
			String s12 = "<td><a href=\"([^\"/]+)";
			for (Matcher matcher = Pattern.compile(s12, 2).matcher(s6); matcher.find(); arraylist.add(new KLWEntry(matcher
					.group(1), s3 + saba + "/" + matcher.group(1) + "/", 1))) {
			}
		}
		if (arraylist.size() == 0) {
			V2CSwingUtil.showErrorMessage("過去ログ倉庫"
					+ (flag2 ? "" : "のスレッド") + "が存在しません。", s1);
			return;
		}
		else {
			Component[] c = v2ckakologwarehouse.getComponents();
			for(int i=0; i<c.length; i++){
				if((Object) c[i] == jcbDirs){
					((JComboBox) c[i]).removeAllItems();
					arraylist.add(0, "フォルダを選択");
					for(int j=0; j<arraylist.size(); j++){
						((JComboBox) c[i]).addItem(arraylist.get(j));
					}
				}else if(c[i] instanceof JScrollPane){
					Component[] c1 = ((JScrollPane) c[i]).getComponents();
					for(int j=0; j<c1.length; j++){
						if(c1[j] instanceof JViewport){
							Component[] c2 = ((JViewport) c1[j]).getComponents();
							for(int k=0; k<c2.length; k++){
								if(c2[k] instanceof V2CDialogBoardList){
									((V2CDialogBoardList) c2[k]).setThreads(new ArrayList());
									((V2CDialogBoardList) c2[k]).repaint();
								}
							}
						}
					}
				}
			}
			return;
		}
	}

	static boolean btablist;
	static String gettablistBBSKakoLogWarehouse(String s, String s1){
		Pattern Zeroch = Pattern.compile("<div class=\"card\" v-for=\"kakolog in kakologs\">", 2);
		String s3 = s + "kakologs/";
		V2CHttpUtil.CAndC candc = V2CHttpUtil.getHTTPFileBG("過去ログ倉庫取得中…",
				s1, s3, "MS932", "text/html", 0L);
		String s6 = null;
		if (candc == null || (s6 = candc.getContents()) == null) {
			String s10 = null;
			if (candc != null)
				s10 = candc.getErrorMessage();
			if (s10 == null)
				s10 = "unknown reason";
			V2CSwingUtil
					.showErrorMessage("過去ログ倉庫取得エラー\n(" + s10 + ")");
			return null;
		}

		Matcher matcher = Zeroch.matcher(s6);
		boolean ZerochFound = false;
		while(matcher.find()){
			ZerochFound = true;
		}
		if(!ZerochFound){
			return null;
		}
		
		return s6;
	}

	static private String tablistHtmlRebuild(V2CHttpUtil.CAndC candc, String url){
		String s1 = "";
		Object localObject13 = candc.getConnection();
		if (localObject13 == null) {
			return s1;
		}
		String str3 = ((HttpURLConnection) localObject13).getContentType();
		if ((str3 == null) || (!str3.startsWith("application/json"))) {
			return s1;
		}
		Object localObject14 = candc.getRawContents();
		Object localObject16;
		try {
			localObject16 = V2CJSONUtil.parse((byte[]) localObject14);
		}
		catch (IllegalArgumentException localIllegalArgumentException2) {
			localIllegalArgumentException2.printStackTrace();
			return s1;
		}
		if (!(localObject16 instanceof Map)){
			return s1;
		}
		Pattern p = Pattern.compile("https?://[^/]+/([^/]+)/.*");
		Matcher mu = p.matcher(url);
		String bbsKey = "";
		while(mu.find()){
			bbsKey = mu.group(1);
		}
		List data = (List) ((Map) localObject16).get("data");
		for(int i=0; i<data.size(); i++){
			Map m = (Map) data.get(i);
			if(bbsKey != "" && bbsKey.equals((String) m.get("bbs"))){
				s1 += "<td>" + m.get("key") + "</td><td>" + m.get("title") + "</td><td>(1)</td>\n";
			}
		}
		return s1;
	}

	static boolean bMachiBBS;
	static String getMachiBBSKakoLogWarehouse(String s, String s1){
		String s3 = s + "log.html";
		V2CHttpUtil.CAndC candc = V2CHttpUtil.getHTTPFileBG("過去ログ倉庫取得中…",
				s1, s3, "MS932", "text/html", 0L);
		String s6 = null;
		if (candc == null || (s6 = candc.getContents()) == null) {
			String s10 = null;
			if (candc != null)
				s10 = candc.getErrorMessage();
			if (s10 == null)
				s10 = "unknown reason";
			if(candc.getResponseCode() != 404)
				V2CSwingUtil
					.showErrorMessage("過去ログ倉庫取得エラー\n(" + s10 + ")");
			return null;
		}

		return s6;
	}

	static String getMachiBBSKakoLogWarehouseSub(String s){
		V2CHttpUtil.CAndC candc = V2CHttpUtil.getHTTPFile(s, null, "MS932", "text/html", 0L, 2);
		String s6 = null;
		if (candc == null || (s6 = candc.getContents()) == null) {
			String s10 = null;
			if (candc != null)
				s10 = candc.getErrorMessage();
			if (s10 == null)
				s10 = "unknown reason";
			V2CSwingUtil
					.showErrorMessage("過去ログ倉庫取得エラー\n(" + s10 + ")");
			return null;
		}

		return s6;
	}

	void showKakoLogWarehouseOverrideMachiBBS(V2CBoardItem v2cboarditem, String saba){
		V2CBBS v2cbbs = v2cboarditem.getBBS();
		String s = v2cboarditem.getURLString();
		String s1 = v2cboarditem.getName() + "板 過去ログ倉庫";

		boolean flag1 = true;
		boolean flag2 = false;
		ArrayList arraylist = new ArrayList();
		ArrayList al2 = new ArrayList();

		sURL = s;
		if (flag1) {
			flag2 = true;
			V2CHttpUtil.CAndC candc = V2CHttpUtil.getHTTPFileBG("過去ログ倉庫取得中…",
					s1, saba, "MS932", "text/html", 0L);
			String s6 = null;
			if (candc == null || (s6 = candc.getContents()) == null) {
				String s10 = null;
				if (candc != null)
					s10 = candc.getErrorMessage();
				if (s10 == null)
					s10 = "unknown reason";
				V2CSwingUtil
						.showErrorMessage("過去ログ倉庫取得エラー\n(" + s10 + ")");
				return;
			}
			String s12 = "(【[^】]+】)<br>";
			for (Matcher matcher = Pattern.compile(s12, 2).matcher(s6); matcher.find(); arraylist.add(new KLWEntry(
					MachiBBSZeroPadding(matcher.group(1)), saba))) {
			}
		}
		if (arraylist.size() == 0) {
			V2CSwingUtil.showErrorMessage("過去ログ倉庫"
					+ (flag2 ? "" : "のスレッド") + "が存在しません。", s1);
			return;
		}
		else {
			Component[] c = v2ckakologwarehouse.getComponents();
			for(int i=0; i<c.length; i++){
				if((Object) c[i] == jcbDirs){
					((JComboBox) c[i]).removeAllItems();
					arraylist.add(0, "フォルダを選択");
					for(int j=0; j<arraylist.size(); j++){
						((JComboBox) c[i]).addItem(arraylist.get(j));
					}
				}else if(c[i] instanceof JScrollPane){
					Component[] c1 = ((JScrollPane) c[i]).getComponents();
					for(int j=0; j<c1.length; j++){
						if(c1[j] instanceof JViewport){
							Component[] c2 = ((JViewport) c1[j]).getComponents();
							for(int k=0; k<c2.length; k++){
								if(c2[k] instanceof V2CDialogBoardList){
									((V2CDialogBoardList) c2[k]).setThreads(new ArrayList());
									((V2CDialogBoardList) c2[k]).repaint();
								}
							}
						}
					}
				}
			}
			return;
		}
	}
	
	private static String MachiBBSZeroPadding(String s){
		return s.replaceAll("年(\\d)月", "年0$1月").replaceAll("月(\\d)日", "月0$1日");
	}

	TimerTask favoriteRegistrationChanged()
	{
		TimerTask timertask = new TimerTask() {
			public void run()
			{
				int i = vDialogBoardList.vtlTableModel.getRowCount(true);
				for (int j = 0; j < i; j++) {
					V2CThreadItem v2cthreaditem = vDialogBoardList.vtlTableModel.getThreadItem(j, true);
					if(v2cthreaditem != null){
						favoriteRegistrationChanged(j, v2cthreaditem);
					}
				}
				if(timerCnt++ > 1200){
					System.out.println("過去ログ倉庫リアルタイム監視タイマー実行中");
					timerCnt = 0;
				}
			}

		};
		return timertask;
	}

	void favoriteRegistrationChanged(V2CThreadItem v2cthreaditem)
	{
		int i = vDialogBoardList.vtlTableModel.getRowIndexOf(v2cthreaditem, true);
		if (i < 0) {
			return;
		}
		else {
			favoriteRegistrationChanged(i, v2cthreaditem);
			return;
		}
	}

	void favoriteRegistrationChanged(int i, V2CThreadItem v2cthreaditem)
	{
		Object aobj[] = vDialogBoardList.vtlTableModel.getRow(i, true);
		int j = V2CFavoritePanel.numFavoriteRegister(v2cthreaditem);
		String s;
		if (j > 0)
			s = String.valueOf(j);
		else
			s = null;
		aobj[0] = s;
		final int ir = vDialogBoardList.vtlTableModel.getRowIndexOf(v2cthreaditem);
		if (isShowing() && vDialogBoardList.vtlTableModel.isRawColumnDisplayed(0) && ir >= 0)
			if (SwingUtilities.isEventDispatchThread())
				vDialogBoardList.vtlTableModel.fireTableRowsUpdated(ir, ir);
			else
				SwingUtilities.invokeLater(new Runnable() {

					public void run()
					{
						vDialogBoardList.vtlTableModel.fireTableRowsUpdated(ir, ir);
					}
				});
	}

	Timer t = new Timer();
	boolean timerOn = false;
	int timerCnt = 0;

	void timer_period() throws InterruptedException {
		t.schedule( favoriteRegistrationChanged(), 0L, 1000L);
	}

	void timer_cancel() throws InterruptedException {
		t.cancel();
	}
}
