package org.monazilla.v2c;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class V2CJava5SubjectReplace
{

	private static List<String> SENSITIVE = null;
	private static List<String> regex = null;
	private static List<String> replacement = null;

	private static final String efn = "ReplaceStr_Subject.txt";
	public static boolean subjectrb = (new File(V2CLauncher.getJarDir(), efn)).exists();
	public static final Pattern patternCheckSubjectUrl = Pattern
			.compile("https?://([^\\.]*)(\\.[25]ch\\.net|\\.bbspink\\.com)/([^/]*)/subject\\.txt");
	
	public static void load(){		
		SENSITIVE = new ArrayList<String>();;
		regex = new ArrayList<String>();
		replacement = new ArrayList<String>();

		BufferedReader br = null;
		try {
			br = new BufferedReader(new InputStreamReader(new FileInputStream(new File(V2CLauncher.getJarDir(), efn)), "MS932"));
	 
			String line;
			int i = 0;
			while ((line = br.readLine()) != null) {
				String w[] = line.split("\t");
				if(w.length >= 1){
					if(w[0].indexOf("<rx2>") == 0 || w[0].indexOf("<rx>") == 0){
						if(w[0].indexOf("<rx2>") == 0){
							SENSITIVE.add("<rx2>");
							regex.add(w[0].replace("<rx2>", ""));
						}
						if(w[0].indexOf("<rx>") == 0){
							SENSITIVE.add("<rx>");
							regex.add(w[0].replace("<rx>", ""));
						}
						if(w.length >= 2){
							replacement.add(w[1]);
						}
						if(w.length == 1){
							replacement.add("");
						}
					}
				}
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				br.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}			
	}

	public static String exec(String list){
		if(SENSITIVE == null){
			load();
		}
		for(int i=0; i<regex.size(); i++){
			if(regex.get(i).length() != 0){
				Pattern patternCheckSubject = Pattern.compile(regex.get(i));
				Matcher ml = patternCheckSubject.matcher(list);
				if(ml.find()){
					if(SENSITIVE.get(i).equals("<rx2>")){
						// 大文字と小文字を区別する
						list = Pattern.compile(regex.get(i)).matcher(list).replaceAll(replacement.get(i));
					}else
					if(SENSITIVE.get(i).equals("<rx>")){
						// 大文字と小文字を区別しない
						list = Pattern.compile(regex.get(i),Pattern.CASE_INSENSITIVE).matcher(list).replaceAll(replacement.get(i));
					}
				}
			}
		}
		return list;
	}

}
