package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.File;
import java.lang.reflect.Field;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.PrivilegedExceptionAction;

import javax.script.Compilable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JTabbedPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class V2CJSE6Util
{

	public V2CJSE6Util()
	{
	}

	static long[] getFileSystemSpaces(File file)
	{
		long al[] = new long[3];
		al[0] = file.getTotalSpace();
		al[1] = file.getFreeSpace();
		al[2] = file.getUsableSpace();
		return al;
	}

	static void removeAATextProperty(boolean flag, boolean flag1, boolean flag2)
	{
		Object obj = oAATextPropertyKey;
		if (obj == null)
			try {
				Class class1 = Class.forName("sun.swing.SwingUtilities2");
				Field field = class1.getField("AA_TEXT_PROPERTY_KEY");
				obj = field.get(null);
				oAATextPropertyKey = obj;
			}
			catch (Exception exception) {
				exception.printStackTrace();
				return;
			}
		if (obj != null) {
			UIDefaults uidefaults = UIManager.getDefaults();
			if (!bAATextPropertySaved && flag || flag2) {
				bAATextPropertySaved = true;
				oAATextProperty = uidefaults.get(obj);
			}
			if (flag1 || flag && flag2) {
				Object obj1 = flag ? null : oAATextProperty;
				uidefaults.put(obj, obj1);
				UIManager.getLookAndFeelDefaults().put(obj, obj1);
			}
		}
	}

	static void setTabComponentAt(JTabbedPane jtabbedpane, int i, Component component)
	{
		jtabbedpane.setTabComponentAt(i, component);
	}

	static Component getTabComponentAt(JTabbedPane jtabbedpane, int i)
	{
		return jtabbedpane.getTabComponentAt(i);
	}

	static String addTrayIcon(Image aimage[], boolean flag, MouseListener mouselistener, ActionListener actionlistener)
	{
		vTrayIcon = V2CTrayIcon.getInstance(aimage, flag, mouselistener, actionlistener);
		if (vTrayIcon == null)
			return "JREでTrayIconがサポートされていません。";
		if (vTrayIcon.addToSystemTray()) {
			return null;
		}
		else {
			vTrayIcon = null;
			return "Trayにアイコンを追加できませんでした。";
		}
	}

	static void removeTrayIcon()
	{
		V2CTrayIcon v2ctrayicon = vTrayIcon;
		if (v2ctrayicon != null) {
			vTrayIcon = null;
			try {
				v2ctrayicon.removeFromSystemTray();
			}
			catch (Exception exception) {
				exception.printStackTrace();
			}
		}
	}

	static boolean checkTrayIcon()
	{
		return vTrayIcon != null && vTrayIcon.checkTrayIcon();
	}

	static void displayTrayMessage(String s, String s1)
	{
		if (vTrayIcon != null)
			vTrayIcon.displayTrayMessage(s, s1);
	}

	static void notifyAutoUpdateCheckState(boolean flag, String s, String s1)
	{
		if (vTrayIcon != null)
			vTrayIcon.stateChanged(flag, s, s1);
	}

	static boolean setExecutable(File file, boolean flag)
	{
		return file.setExecutable(flag);
	}

	static boolean isAlwaysOnTopSupported()
	{
		return Toolkit.getDefaultToolkit().isAlwaysOnTopSupported();
	}

	static void setIconImage(Window window, Image image)
	{
		window.setIconImage(image);
	}

	static byte[] getHardwareAddress(NetworkInterface networkinterface)
	{
		try {
			return networkinterface.getHardwareAddress();
		}
		catch (SocketException socketexception) {
			return null;
		}
	}

	static boolean isLoopback(NetworkInterface networkinterface)
	{
		try {
			return networkinterface.isLoopback();
		}
		catch (SocketException socketexception) {
			return false;
		}
	}

	static boolean browse(String s)
	{
		if (!Desktop.isDesktopSupported())
			return false;
		Desktop desktop = Desktop.getDesktop();
		try {
			desktop.browse(new URI(s));
		}
		catch (Exception exception) {
			return false;
		}
		return true;
	}

	static PrivilegedExceptionAction createScriptAction(final String scn, String s1, Object obj, ClassLoader classloader,
			AccessControlContext accesscontrolcontext, boolean flag) throws IllegalArgumentException
	{
//		final ScriptEngineManager sem = new ScriptEngineManager(classloader);
//		Object obj1 = null;
//		try {
//			obj1 = AccessController.doPrivileged(new PrivilegedAction() {
//
//				public Object run()
//				{
//					return sem.getEngineByName(scn);
//				}
//			}, accesscontrolcontext);
//		}
//		catch (Exception exception) {
//		}
		final ScriptEngineManager sem = new ScriptEngineManager();
		Object obj1 = null; 
		obj1 = sem.getEngineByName(scn);
		if (!(obj1 instanceof ScriptEngine))
			throw new IllegalArgumentException("スクリプト名 " + scn
					+ " のScriptEngineを取得できませんでした。");
		ScriptEngine scriptengine = (ScriptEngine) obj1;
		String s2 = scriptengine.getFactory().getEngineName();
		if (s2 == null || s2.indexOf("Rhino") < 0) {
			scriptengine = null;
			java.util.List list = sem.getEngineFactories();
			int i = list.size();
			int j = 0;
			do {
				if (j >= i)
					break;
				ScriptEngineFactory scriptenginefactory = (ScriptEngineFactory) list.get(j);
				String s3 = scriptenginefactory.getEngineName();
				if (s3 != null && s3.indexOf("Rhino") >= 0) {
					scriptengine = scriptenginefactory.getScriptEngine();
					break;
				}
				j++;
			} while (true);
			if (scriptengine == null)
				throw new IllegalArgumentException(
						"Rhino ScriptEngineを取得できませんでした。");
		}
		javax.script.CompiledScript compiledscript;
		if (scriptengine instanceof Compilable)
			try {
				compiledscript = ((Compilable) scriptengine).compile(s1);
			}
			catch (ScriptException scriptexception) {
				String s4 = scriptexception.getMessage();
				String s5 = "スクリプトのコンパイルに失敗しました。\n\n";
				if (s4 != null)
					s5 = s5 + "\n\n" + s4;
				throw new IllegalArgumentException(s5);
			}
		else
			compiledscript = null;
		return new V2CEvalScriptAction(s1, scriptengine, compiledscript, obj, flag);
	}

	static void setRedirectURL(PrivilegedExceptionAction privilegedexceptionaction, URL url)
	{
		((V2CEvalScriptAction) privilegedexceptionaction).setRedirectURL(url);
	}

	static void setFormData(PrivilegedExceptionAction privilegedexceptionaction, URL url, String s, String s1)
	{
		((V2CEvalScriptAction) privilegedexceptionaction).setFormData(url, s, s1);
	}

	static void setInvokeFunction(PrivilegedExceptionAction privilegedexceptionaction, String s, Object aobj[])
	{
		((V2CEvalScriptAction) privilegedexceptionaction).setInvokeFunction(s, aobj);
	}

	static boolean bAATextPropertySaved;
	static Object oAATextProperty;
	static V2CTrayIcon vTrayIcon;
	static Object oAATextPropertyKey;
}
