package org.monazilla.v2c;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class V2CInsteadOfThreadldJs
{
	private static final Pattern patternHeadline = Pattern
			.compile("(https?)://headline\\.[25]ch.net/test/read\\.cgi/([^/]+)/([^/]+)");
	private static final Pattern patternLogsoku = Pattern
			.compile("(?:https?)://logsoku\\.([^/]+)/test/read.cgi/([^/]+)/([^/]+)");
	private static final Pattern patternLogsokuR = Pattern
			.compile("(.+)_([A-Za-z0-9]+)$");

	static String resolveUrl(String s){
		String s1 = resolveUrlHeadline(s);
		if(s1 != null && s1.length() != 0){
			return s1;
		}

		s1 = resolveUrlLogsoku(s);
		if(s1 != null && s1.length() != 0){
			return s1;
		}

		return s;
	}

	static String resolveUrlHeadline(String s){
		Matcher m = patternHeadline.matcher(s);
		while (m.find()) {
			String protocol = m.group(1) + "://";
			String board    = m.group(2);
			String key      = m.group(3);
			
			String url = protocol + "headline.5ch.net/" + board + "/news.rss";
			String ret = resolveUrlHeadlineSub(url, key);
			if(ret != null && ret.length() != 0){
				return ret;
			}

			url = protocol + "headline.5ch.net/" + board + "/";
			ret = resolveUrlHeadlineSub(url, key);
			if(ret != null && ret.length() != 0){
				return ret;
			}
		}
		return null;
	}

	static String resolveUrlHeadlineSub(String url, String key){
		V2CHttpUtil.CAndC candc = V2CHttpUtil.getRawHTTPFile(url);
		if (Thread.currentThread().isInterrupted()) {
			return null;
		}
		if (candc != null) {
			byte abyte0[] = candc.getRawContents();
			if (abyte0 != null && abyte0.length != 0) {
				// 検索がスレ一覧に出ないのはgetCharsetFromCAndC で文字コード変換例外によるnullが原因
				String s2 = V2CHttpUtil.getCharsetFromCAndC(candc);
				if (s2 == null) {
					s2 = "MS932";
				}
				String html = null;
				try {
					html = new String(abyte0, s2);
					if(html != "" && html != null){
						Pattern patternRealUrl = Pattern
								.compile("(https?://[^\\.]+?(?:\\.[25]ch\\.net|\\.bbspink\\.com)/test/read\\.cgi/[^/]+/" + key + ")", 2);
						Matcher m1 = patternRealUrl.matcher(html);
						while (m1.find()) {
							V2CThreadItem v2cthreaditemTop = V2CThreadViewHistory.getTopThreadItem();
							if(v2cthreaditemTop.getNRes() == 0){
								v2cthreaditemTop.deleteLog(true);
							}
							String Rurl = m1.group(1).replace("https://", "http://").replace("5ch.net","2ch.net");
							return Rurl;
						}
					}
				}
				catch (UnsupportedEncodingException unsupportedencodingexception) {
				}
			}
		}
		return null;
	}

	static String resolveUrlLogsoku(String s){
		Matcher m = patternLogsoku.matcher(s);
		while (m.find()) {
			String protocol = "https://";
			String  r       = "";
			String site     = m.group(1);
			String board    = m.group(2);
			String key      = m.group(3);

			Matcher m1 = patternLogsokuR.matcher(board);
			while (m1.find()) {
				board    = m1.group(1);
				r        = m1.group(2);
			}
			
			String url = protocol + "www.logsoku.com/" + r + "/" + site + "/" + board + "/" + key +"/";
			String ret = resolveUrlLogsokuSub(url, site, key);
			if(ret != null && ret.length() != 0){
				return ret;
			}
		}
		return null;
	}

	static String resolveUrlLogsokuSub(String url, String site, String key){
		byte abyte0[] = null;

		if(V2CApp.javaVersionEqualTo(1, 6)){
			V2CScriptApp.putProperty("B11_Use_JavaVersion", 6);
		}else if(V2CApp.javaVersionEqualTo(1, 5)){
			V2CScriptApp.putProperty("B11_Use_JavaVersion", 6);
		}else{
			V2CScriptApp.putProperty("B11_Use_JavaVersion", 7);
		}
		V2CHttpUtil.CAndC candc = V2CHttpUtil.getRawHTTPFile(url);
		if (Thread.currentThread().isInterrupted()) {
			return null;
		}
		if (candc != null) {
			abyte0 = candc.getRawContents();
		}
		if (abyte0 != null && abyte0.length != 0) {
			// 検索がスレ一覧に出ないのはgetCharsetFromCAndC で文字コード変換例外によるnullが原因
			String s2 = "UTF-8";
			String html = null;
			try {
				html = new String(abyte0, s2);
				if(html != "" && html != null){
					Pattern patternRealUrl = Pattern
							.compile("(https?://[^\\.]+?\\." + (""+site).replace(".", "\\.") + "/test/read\\.cgi/[^/]+/" + key + ")", 2);
					Matcher m1 = patternRealUrl.matcher(html);
					while (m1.find()) {
						V2CThreadItem v2cthreaditemTop = V2CThreadViewHistory.getTopThreadItem();
						if(v2cthreaditemTop.getNRes() == 0){
							v2cthreaditemTop.deleteLog(true);
						}
						String Rurl = m1.group(1).replace("https://", "http://").replace("5ch.net","2ch.net") + "/";
						return Rurl;
					}
				}
			}
			catch (UnsupportedEncodingException unsupportedencodingexception) {
			}
		}
		return null;
	}
}
