package org.monazilla.v2c;

import java.io.File;
import java.util.HashMap;

public class V2CInlineMsgImgTextSegment extends V2CTextSegment
{

	static V2CInlineMsgImgTextSegment getInstance(String s, int i)
	{
		if (s == null)
			return null;
		HashMap hashmap = hmImags;
		V2CImageSet v2cimageset;
		synchronized (hashmap) {
			v2cimageset = (V2CImageSet) hashmap.get(s);
			if (v2cimageset == null) {
				v2cimageset = V2CLocalFileHandler.getInlineMsgImg(s);
				if (v2cimageset == null)
					v2cimageset = V2CLink.getErrorImageSet(false);
			}
			if(v2cimageset.fOriginalFile == null){
				v2cimageset.fOriginalFile = new File(V2CLocalFileHandler.fInlineMsgImgDir, replaceFileSeparators(s));
			}
			hashmap.put(s, v2cimageset);
		}
		return new V2CInlineMsgImgTextSegment(v2cimageset, i);
	}

	private V2CInlineMsgImgTextSegment(V2CImageSet v2cimageset, int i)
	{
		super(i, 0x400000);
		vInlineMsgImg = v2cimageset;
	}

	V2CImageSet getImageSet()
	{
		return vInlineMsgImg;
	}

	int getWidth()
	{
		return vInlineMsgImg == null ? 0 : vInlineMsgImg.getWidth();
	}

	int getHeight()
	{
		return vInlineMsgImg == null ? 0 : vInlineMsgImg.getHeight();
	}

	static final HashMap hmImags = new HashMap();
	final V2CImageSet vInlineMsgImg;

	private static String replaceFileSeparators(String s)
	{
		String s1 = V2CLocalFileHandler.sFileSeparator;
		if (!s1.equals("/"))
			s = V2CMiscUtil.replaceAll(s, "/", s1);
		if (!s1.equals("\\"))
			s = V2CMiscUtil.replaceAll(s, "\\", s1);
		return s;
	}
}
