package org.monazilla.v2c;

import java.awt.*;
import java.io.*;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.*;

public class V2CImageInfo
{
	private static class ByteArrayWithPointer
	{

		boolean checkLength(int i)
		{
			return blBytes.length >= iPointer + i;
		}

		void setPointer(int i)
		{
			iPointer = i;
		}

		void skip(int i)
		{
			iPointer += i;
		}

		int getTIFFSLong()
		{
			int i = 0;
			if (bBigEndian) {
				for (int j = 0; j < 4; j++)
					i = (i << 8) + (blBytes[iPointer + j] & 0xff);

			}
			else {
				for (int k = 3; k >= 0; k--)
					i = (i << 8) + (blBytes[iPointer + k] & 0xff);

			}
			return i;
		}

		long getTIFFLong()
		{
			long l = 0L;
			if (bBigEndian) {
				for (int i = 0; i < 4; i++)
					l = (l << 8) + (long) (blBytes[iPointer + i] & 0xff);

			}
			else {
				for (int j = 3; j >= 0; j--)
					l = (l << 8) + (long) (blBytes[iPointer + j] & 0xff);

			}
			return l;
		}

		long getTIFFLong(long l)
		{
			if (blBytes.length < iPointer + 4) {
				return l;
			}
			else {
				long l1 = getTIFFLong();
				iPointer += 4;
				return l1;
			}
		}

		int getTIFFShort()
		{
			if (bBigEndian)
				return ((blBytes[iPointer] & 0xff) << 8) + (blBytes[iPointer + 1] & 0xff);
			else
				return ((blBytes[iPointer + 1] & 0xff) << 8) + (blBytes[iPointer] & 0xff);
		}

		int getTIFFShort(int i)
		{
			if (blBytes.length < iPointer + 2) {
				return i;
			}
			else {
				int j = getTIFFShort();
				iPointer += 2;
				return j;
			}
		}

		String getTIFFEntryString(int i)
		{
			int j = i > 4 ? (int) getTIFFLong() : iPointer;
			iPointer += 4;
			if (j <= 0 || blBytes.length < j + i)
				return null;
			if (blBytes[(j + i) - 1] != 0) {
				i++;
				if (blBytes.length < j + i)
					return null;
			}
			else {
				for (int k = (j + i) - 2; k >= j && blBytes[k] == 0; k--)
					i--;

			}
			return i <= 1 || blBytes[(j + i) - 1] != 0 ? null : new String(blBytes, j, i - 1);
		}

		int getTIFFEntryShort()
		{
			int i = getTIFFShort();
			iPointer += 4;
			return i;
		}

		long getTIFFEntryLong()
		{
			long l = getTIFFLong();
			iPointer += 4;
			return l;
		}

		String getTIFFEntryRational()
		{
			if (!setTIFFEntryRationalNumbers()) {
				return null;
			}
			else {
				reduceRational();
				return String.valueOf(lRational0) + "/" + String.valueOf(lRational1);
			}
		}

		long getTIFFEntryRationalNumerator()
		{
			return lRational0;
		}

		long getTIFFEntryRationalDenominator()
		{
			return lRational1;
		}

		double getTIFFEntryRationalValue()
		{
			return (double) lRational0 / (double) lRational1;
		}

		boolean setTIFFEntryRationalNumbers()
		{
			int i = (int) getTIFFLong();
			iPointer += 4;
			if (i <= 0 || blBytes.length < i + 8) {
				return false;
			}
			else {
				int j = iPointer;
				iPointer = i;
				lRational0 = getTIFFLong();
				iPointer += 4;
				lRational1 = getTIFFLong();
				iPointer = j;
				return true;
			}
		}

		void reduceRational()
		{
			if (lRational0 == 0L || lRational1 == 0L)
				return;
			if (lRational0 == lRational1) {
				lRational0 = 1L;
				lRational1 = 1L;
			}
			else if (lRational0 < lRational1) {
				if (lRational1 % lRational0 == 0L) {
					lRational1 /= lRational0;
					lRational0 = 1L;
				}
			}
			else if (lRational0 % lRational1 == 0L) {
				lRational0 /= lRational1;
				lRational1 = 1L;
			}
			if (lRational0 == 1L || lRational1 == 1L)
				return;
			boolean flag = lRational0 < lRational1;
			long l;
			long l1;
			if (flag) {
				l = lRational0;
				l1 = lRational1;
			}
			else {
				l = lRational1;
				l1 = lRational0;
			}
			if (l > 0xffffffL)
				return;
			boolean flag1;
			do {
				flag1 = false;
				long l2 = l / 2L;
				long l3 = 2L;
				do {
					if (l3 >= l2)
						break;
					if (l % l3 == 0L && l1 % l3 == 0L) {
						l /= l3;
						l1 /= l3;
						flag1 = true;
						break;
					}
					l3++;
				} while (true);
			} while (flag1);
			if (flag) {
				lRational0 = l;
				lRational1 = l1;
			}
			else {
				lRational0 = l1;
				lRational1 = l;
			}
		}

		byte[] getTIFFEntryUndefined(int i)
		{
			if (i <= 0) {
				iPointer += 4;
				return null;
			}
			int j;
			if (i <= 4)
				j = iPointer;
			else
				j = (int) getTIFFLong();
			iPointer += 4;
			if (j <= 0 || j + i > blBytes.length) {
				return null;
			}
			else {
				byte abyte0[] = new byte[i];
				System.arraycopy(blBytes, j, abyte0, 0, i);
				return abyte0;
			}
		}

		String getTIFFEntrySRational()
		{
			if (!setTIFFEntrySRationalNumbers()) {
				return null;
			}
			else {
				reduceSRational();
				return String.valueOf(iRational0) + "/" + String.valueOf(iRational1);
			}
		}

		int getTIFFEntrySRationalNumerator()
		{
			return iRational0;
		}

		int getTIFFEntrySRationalDenominator()
		{
			return iRational1;
		}

		double getTIFFEntrySRationalValue()
		{
			return (double) iRational0 / (double) iRational1;
		}

		boolean setTIFFEntrySRationalNumbers()
		{
			int i = (int) getTIFFLong();
			iPointer += 4;
			if (i <= 0 || blBytes.length < i + 8) {
				return false;
			}
			else {
				int j = iPointer;
				iPointer = i;
				iRational0 = getTIFFSLong();
				iPointer += 4;
				iRational1 = getTIFFSLong();
				iPointer = j;
				return true;
			}
		}

		void reduceSRational()
		{
			if (iRational0 <= 0 || iRational1 <= 0)
				return;
			if (iRational0 == iRational1) {
				iRational0 = 1;
				iRational1 = 1;
			}
			else if (iRational0 < iRational1) {
				if (iRational1 % iRational0 == 0) {
					iRational1 /= iRational0;
					iRational0 = 1;
				}
			}
			else if (iRational0 % iRational1 == 0) {
				iRational0 /= iRational1;
				iRational1 = 1;
			}
			if (iRational0 == 1 || iRational1 == 1)
				return;
			boolean flag = iRational0 < iRational1;
			int i;
			int j;
			if (flag) {
				i = iRational0;
				j = iRational1;
			}
			else {
				i = iRational1;
				j = iRational0;
			}
			boolean flag1;
			do {
				flag1 = false;
				int k = i / 2;
				int l = 2;
				do {
					if (l >= k)
						break;
					if (i % l == 0 && j % l == 0) {
						i /= l;
						j /= l;
						flag1 = true;
						break;
					}
					l++;
				} while (true);
			} while (flag1);
			if (flag) {
				iRational0 = i;
				iRational1 = j;
			}
			else {
				iRational0 = j;
				iRational1 = i;
			}
		}

		byte blBytes[];
		int iPointer;
		boolean bBigEndian;
		int iRational0;
		int iRational1;
		long lRational0;
		long lRational1;

		ByteArrayWithPointer(ByteArrayWithPointer bytearraywithpointer)
		{
			blBytes = bytearraywithpointer.blBytes;
			iPointer = bytearraywithpointer.iPointer;
			bBigEndian = bytearraywithpointer.bBigEndian;
		}

		ByteArrayWithPointer(byte abyte0[], int i, boolean flag)
		{
			blBytes = abyte0;
			iPointer = i;
			bBigEndian = flag;
		}
	}

	private static int readInt(BufferedInputStream bufferedinputstream) throws IOException
	{
		int i = bufferedinputstream.read();
		int j = bufferedinputstream.read();
		int k = bufferedinputstream.read();
		int l = bufferedinputstream.read();
		return i < 0 || j < 0 || k < 0 || l < 0 ? -1 : i << 24 | j << 16 | k << 8 | l;
	}

	private static int readIntR(BufferedInputStream bufferedinputstream) throws IOException
	{
		int i = bufferedinputstream.read();
		int j = bufferedinputstream.read();
		int k = bufferedinputstream.read();
		int l = bufferedinputstream.read();
		return i < 0 || j < 0 || k < 0 || l < 0 ? -1 : l << 24 | k << 16 | j << 8 | i;
	}

	private static int readShort(BufferedInputStream bufferedinputstream) throws IOException
	{
		int i = bufferedinputstream.read();
		int j = bufferedinputstream.read();
		return i < 0 || j < 0 ? -1 : i << 8 | j;
	}

	private static int readShortR(BufferedInputStream bufferedinputstream) throws IOException
	{
		int i = bufferedinputstream.read();
		int j = bufferedinputstream.read();
		return i < 0 || j < 0 ? -1 : j << 8 | i;
	}

	private static void restoreTagName()
	{
		BufferedReader bufferedreader = V2CLocalFileHandler.getConfigReader("exif.txt");
		if (bufferedreader == null) {
			System.out.println("cannot read exif.txt !");
			return;
		}
		try {
			Integer integer = null;
			do {
				String s;
				if ((s = bufferedreader.readLine()) == null)
					break;
				if (s.length() == 0 || s.charAt(0) == '#')
					continue;
				char c = s.charAt(0);
				if (c == 'F') {
					if (integer != null)
						hmFormats.put(integer, new DecimalFormat(s.substring(1)));
					continue;
				}
				if (c == 'P') {
					if (integer != null) {
						String as[] = V2CMiscUtil.split(s.substring(1));
						hmParameters.put(integer, as);
					}
					continue;
				}
				if (c == 'U') {
					if (integer != null) {
						String as1[] = V2CMiscUtil.split(s.substring(1));
						if (as1.length == 2)
							hmUnits.put(integer, as1);
					}
					continue;
				}
				if (c == 'T') {
					String as2[] = V2CMiscUtil.split(s.substring(1));
					int i = as2.length;
					if (i != 3)
						continue;
					int j = 0;
					try {
						j = V2CMiscUtil.parseHexString(as2[0]);
					}
					catch (NumberFormatException numberformatexception) {
						continue;
					}
					integer = new Integer(j);
					hmTagNames.put(integer, as2[2]);
				}
				else {
					System.out.println("unknown type: " + s);
				}
			} while (true);
		}
		catch (IOException ioexception) {
			System.out.println(ioexception.getMessage());
		}
		finally {
			try {
				bufferedreader.close();
			}
			catch (IOException ioexception1) {
			}
		}
	}

	private static void appendToSB(String s, StringBuffer stringbuffer)
	{
		if (stringbuffer != null)
			stringbuffer.append(s);
	}

	private boolean appendIFDInfo(ByteArrayWithPointer bytearraywithpointer, StringBuffer stringbuffer, int ai[], String s)
	{
		int i = bytearraywithpointer.getTIFFShort(-1);
		if (i == -1)
			return false;
		if (!bytearraywithpointer.checkLength(2 + i * 12 + 4)) {
			stringbuffer.append(" [Error: too many directory entries]");
			return false;
		}
		label0: for (int j = 0; j < i; j++) {
			int k = bytearraywithpointer.getTIFFShort(0);
			if (k == 0)
				return false;
			int l = bytearraywithpointer.getTIFFShort(0);
			if (l == 0)
				return false;
			int i1 = (int) bytearraywithpointer.getTIFFLong(0L);
			if (i1 == 0)
				return false;
			if (k == 59932 && l == 7) {
				bytearraywithpointer.getTIFFEntryUndefined(i1);
				continue;
			}
			stringbuffer.append('\n');
			stringbuffer.append(s);
			Integer integer = new Integer(k);
			String s1 = (String) hmTagNames.get(integer);
			if (s1 != null) {
				stringbuffer.append(s1);
			}
			else {
				stringbuffer.append("0x");
				stringbuffer.append(Integer.toHexString(k));
			}
			stringbuffer.append("： ");
			if (k == 34665 || k == 40965) {
				ByteArrayWithPointer bytearraywithpointer1 = new ByteArrayWithPointer(bytearraywithpointer);
				int j1 = (int) bytearraywithpointer.getTIFFLong(0L);
				if (j1 == 0)
					return false;
				if (ai[0] >= ai.length - 1) {
					stringbuffer.append(" [Error: stack overflow]");
					continue;
				}
				int k1 = ai[0] + 1;
				for (int i2 = 1; i2 < k1; i2++)
					if (ai[i2] == j1) {
						stringbuffer.append(" [Error: directory loop]");
						continue label0;
					}

				ai[k1] = j1;
				ai[0] = k1;
				bytearraywithpointer1.setPointer(j1);
				boolean flag = appendIFDInfo(bytearraywithpointer1, stringbuffer, ai, s + "  ");
				ai[0]--;
				if (!flag)
					return false;
				continue;
			}
			String as[] = (String[]) (String[]) hmUnits.get(integer);
			if (as != null) {
				String s2 = as[0];
				if (s2 != null && s2.length() > 0)
					stringbuffer.append(s2);
			}
			DecimalFormat decimalformat = (DecimalFormat) hmFormats.get(integer);
			if (l == 2) {
				String s3 = bytearraywithpointer.getTIFFEntryString(i1);
				if (s3 != null)
					stringbuffer.append(s3);
			}
			else if (l == 3) {
				if (i1 == 1) {
					int l1 = bytearraywithpointer.getTIFFEntryShort();
					if (k == 274)
						nOrientation = l1;
					String as1[] = (String[]) (String[]) hmParameters.get(integer);
					if (as1 != null) {
						String s7 = null;
						if (l1 >= 0 && l1 < as1.length)
							s7 = as1[l1];
						if (s7 != null && s7.length() > 0)
							stringbuffer.append(s7);
						else
							stringbuffer.append(l1);
					}
					else if (k == 40961) {
						if (l1 == 1)
							stringbuffer.append("sRGB");
						else if (l1 == 2)
							stringbuffer.append("Adobe RGB");
						else if (l1 == 65533)
							stringbuffer.append("Wide Gamut RGB");
						else if (l1 == 65534)
							stringbuffer.append("ICC Profile");
						else if (l1 == 65535)
							stringbuffer.append("Uncalibrated");
						else
							stringbuffer.append(l1);
					}
					else if (k == 37385) {
						stringbuffer.append("発光");
						if ((l1 & 1) == 0)
							stringbuffer.append("せず");
						stringbuffer.append("、リターン検出");
						byte byte0 = (byte) (l1 & 6);
						if (byte0 == 0)
							stringbuffer.append("機能なし");
						else if (byte0 == 2)
							stringbuffer.append("されず");
						byte byte1 = (byte) (l1 >> 3 & 3);
						stringbuffer.append("、モード：");
						if (byte1 == 0)
							stringbuffer.append("不明");
						else if (byte1 == 1)
							stringbuffer.append("強制発光");
						else if (byte1 == 2)
							stringbuffer.append("発光禁止");
						else if (byte1 == 3)
							stringbuffer.append("オート");
						if ((l1 & 0x20) != 0)
							stringbuffer.append("、赤目軽減モード");
					}
					else if (k == 41989) {
						if (l1 == 0)
							stringbuffer.append("不明");
						else
							stringbuffer.append(l1);
					}
					else {
						stringbuffer.append(l1);
					}
				}
				else {
					bytearraywithpointer.skip(4);
					appendMultiParameterMessage(l, i1, stringbuffer);
				}
			}
			else if (l == 4) {
				if (i1 == 1) {
					long l2 = bytearraywithpointer.getTIFFEntryLong();
					if (k == 256) {
						if (nWidth <= 0)
							nWidth = (int) l2;
					}
					else if (k == 257 && nHeight <= 0)
						nHeight = (int) l2;
					stringbuffer.append(l2);
				}
				else {
					bytearraywithpointer.skip(4);
					appendMultiParameterMessage(l, i1, stringbuffer);
				}
			}
			else if (l == 5) {
				if (i1 == 1) {
					String s4 = bytearraywithpointer.getTIFFEntryRational();
					if (s4 != null)
						if (k == 33437 || k == 37381) {
							if (bytearraywithpointer.getTIFFEntryRationalDenominator() != 0L)
								appendRationalValue(bytearraywithpointer, decimalformat, s4, stringbuffer);
							else
								stringbuffer.append("不明");
						}
						else if (k == 37382) {
							long l3 = bytearraywithpointer.getTIFFEntryRationalNumerator();
							if (l3 == 0xffffffffL)
								stringbuffer.append("∞");
							else if (l3 == 0L)
								stringbuffer.append("不明");
							else
								appendRationalValue(bytearraywithpointer, decimalformat, s4, stringbuffer);
						}
						else if (k == 41988) {
							if (s4.startsWith("0/"))
								stringbuffer.append("not used");
							else
								appendRationalValue(bytearraywithpointer, decimalformat, s4, stringbuffer);
						}
						else {
							appendRationalValue(bytearraywithpointer, decimalformat, s4, stringbuffer);
						}
				}
				else {
					bytearraywithpointer.skip(4);
					appendMultiParameterMessage(l, i1, stringbuffer);
				}
			}
			else if (l == 7) {
				byte abyte0[] = bytearraywithpointer.getTIFFEntryUndefined(i1);
				if (abyte0 != null && k != 37500 && k != 50341) {
					if (k == 37121 && i1 == 4) {
						String as2[] = { "無し", "Y", "Cb", "Cr", "R", "G", "B" };
						for (int j2 = 0; j2 < 4; j2++) {
							byte byte2 = abyte0[j2];
							if (byte2 >= 0 && byte2 <= 6)
								stringbuffer.append(as2[byte2]);
							else
								stringbuffer.append(byte2);
							stringbuffer.append(',');
						}

						stringbuffer.setLength(stringbuffer.length() - 1);
					}
					else if (k == 41730 && i1 == 8) {
						boolean flag1 = true;
						int k2 = 0;
						do {
							if (k2 >= 4)
								break;
							if (abyte0[k2] != 0 && abyte0[k2] != 2) {
								flag1 = false;
								break;
							}
							k2++;
						} while (true);
						if (flag1) {
							stringbuffer.append("[[");
							stringbuffer.append(getFilterColor(abyte0[4]));
							stringbuffer.append(',');
							stringbuffer.append(getFilterColor(abyte0[5]));
							stringbuffer.append("],[");
							stringbuffer.append(getFilterColor(abyte0[6]));
							stringbuffer.append(',');
							stringbuffer.append(getFilterColor(abyte0[7]));
							stringbuffer.append("]]");
						}
						else {
							appendMultiParameterMessage(l, i1, stringbuffer);
						}
					}
					else if (k == 41728) {
						if (abyte0.length == 1 && abyte0[0] == 3)
							stringbuffer.append("DSC");
						else
							appendUndefinedByteArray(abyte0, stringbuffer);
					}
					else if (k == 41729) {
						if (abyte0.length == 1 && abyte0[0] == 1)
							stringbuffer.append("直接撮影された画像");
						else
							appendUndefinedByteArray(abyte0, stringbuffer);
					}
					else if (k == 37510)
						appendUserComment(abyte0, stringbuffer);
					else
						appendUndefinedByteArray(abyte0, stringbuffer);
				}
				else {
					appendMultiParameterMessage(l, i1, stringbuffer);
				}
			}
			else if (l == 10) {
				if (i1 == 1) {
					String s5 = bytearraywithpointer.getTIFFEntrySRational();
					if (s5 != null)
						if (k == 37379) {
							if (bytearraywithpointer.getTIFFEntrySRationalNumerator() == -1)
								stringbuffer.append("不明");
							else
								appendSRationalValue(bytearraywithpointer, decimalformat, s5, stringbuffer);
						}
						else {
							appendSRationalValue(bytearraywithpointer, decimalformat, s5, stringbuffer);
						}
				}
				else {
					bytearraywithpointer.skip(4);
					appendMultiParameterMessage(l, i1, stringbuffer);
				}
			}
			else {
				bytearraywithpointer.skip(4);
				appendMultiParameterMessage(l, i1, stringbuffer);
			}
			if (as == null)
				continue;
			String s6 = as[1];
			if (s6 != null && s6.length() > 0)
				stringbuffer.append(s6);
		}

		return true;
	}

	private static void appendRationalValue(ByteArrayWithPointer bytearraywithpointer, DecimalFormat decimalformat, String s,
			StringBuffer stringbuffer)
	{
		if (bytearraywithpointer.getTIFFEntryRationalDenominator() != 0L) {
			if (decimalformat != null)
				stringbuffer.append(decimalformat.format(bytearraywithpointer.getTIFFEntryRationalValue()));
			else
				stringbuffer.append(s);
		}
		else {
			stringbuffer.append(s);
		}
	}

	private static char getFilterColor(byte byte0)
	{
		if (byte0 < 0 || byte0 > 6)
			return '?';
		else
			return clFilterColor[byte0];
	}

	private static void appendSRationalValue(ByteArrayWithPointer bytearraywithpointer, DecimalFormat decimalformat, String s,
			StringBuffer stringbuffer)
	{
		if (bytearraywithpointer.getTIFFEntrySRationalDenominator() != 0) {
			if (decimalformat != null)
				stringbuffer.append(decimalformat.format(bytearraywithpointer.getTIFFEntrySRationalValue()));
			else
				stringbuffer.append(s);
		}
		else {
			stringbuffer.append(s);
		}
	}

	private static void appendUndefinedByteArray(byte abyte0[], StringBuffer stringbuffer)
	{
		if (abyte0 == null || abyte0.length == 0)
			return;
		boolean flag = true;
		int i = 0;
		do {
			if (i >= abyte0.length)
				break;
			if (abyte0[i] != 0) {
				flag = false;
				break;
			}
			i++;
		} while (true);
		if (flag) {
			stringbuffer.append(abyte0.length);
			stringbuffer.append("bytes of 0's [TYPE:UNDEFINED]");
			return;
		}
		boolean flag1 = true;
		int j = 0;
		do {
			if (j >= abyte0.length)
				break;
			byte byte0 = abyte0[j];
			if (byte0 < 32 || byte0 > 126) {
				flag1 = false;
				break;
			}
			j++;
		} while (true);
		if (flag1) {
			stringbuffer.append(new String(abyte0, 0, abyte0.length));
		}
		else {
			for (int k = 0; k < abyte0.length; k++) {
				stringbuffer.append("0x");
				stringbuffer.append(Integer.toHexString(abyte0[k] & 0xff));
				stringbuffer.append(',');
			}

			stringbuffer.setLength(stringbuffer.length() - 1);
			stringbuffer.append(" [TYPE:UNDEFINED]");
		}
	}

	private static void appendUserComment(byte abyte0[], StringBuffer stringbuffer)
	{
		if (abyte0.length < 8) {
			appendUndefinedByteArray(abyte0, stringbuffer);
			return;
		}
		int i = 8;
		String s = null;
		int j = 1;
		do {
			if (j >= 8)
				break;
			if (abyte0[j] == 0) {
				i = j;
				break;
			}
			j++;
		} while (true);
		if (i > 0)
			s = new String(abyte0, 0, i);
		if (s != null)
			if (s.equalsIgnoreCase("ASCII"))
				s = "ASCII";
			else if (s.equalsIgnoreCase("JIS"))
				s = "ISO2022JP";
			else if (s.equalsIgnoreCase("UNICODE"))
				s = "UTF-8";
			else
				s = null;
		j = 0;
		int k = 8;
		do {
			if (k >= abyte0.length)
				break;
			if (abyte0[k] == 0) {
				j = k - 8;
				break;
			}
			k++;
		} while (true);
		if (j > 0)
			System.arraycopy(abyte0, 8, abyte0, 0, j);
		else
			return;
		String s1 = null;
		if (s != null)
			try {
				s1 = new String(abyte0, 0, j, s);
			}
			catch (UnsupportedEncodingException unsupportedencodingexception) {
			}
		else
			s1 = V2CMiscUtil.jisAutoDetect(abyte0, j);
		if (s1 == null)
			return;
		int l = -1;
		int i1 = s1.length() - 1;
		do {
			if (i1 < 0)
				break;
			if (s1.charAt(i1) != ' ') {
				l = i1;
				break;
			}
			i1--;
		} while (true);
		if (l < 0)
			return;
		if (++l < s1.length())
			s1 = s1.substring(0, l);
		stringbuffer.append(s1);
	}

	private static void appendMultiParameterMessage(int i, int j, StringBuffer stringbuffer)
	{
		String s;
		if (i > 0 && i < slFormatNames.length)
			s = slFormatNames[i];
		else
			s = slFormatNames[0];
		stringbuffer.append(j);
		stringbuffer.append("*[");
		stringbuffer.append(s);
		stringbuffer.append(']');
	}

	private void appendExifInfo(byte abyte0[], int i, StringBuffer stringbuffer)
	{
		if (i < 10)
			return;
		if (abyte0[0] != 69 || abyte0[1] != 120 || abyte0[2] != 105 || abyte0[3] != 102 || abyte0[4] != 0)
			return;
		System.arraycopy(abyte0, 6, abyte0, 0, i - 6);
		boolean flag;
		if (abyte0[0] == 77 && abyte0[1] == 77)
			flag = true;
		else if (abyte0[0] == 73 && abyte0[1] == 73)
			flag = false;
		else
			return;
		ByteArrayWithPointer bytearraywithpointer = new ByteArrayWithPointer(abyte0, 2, flag);
		int j = bytearraywithpointer.getTIFFShort(0);
		if (j != 42 && j != 10752)
			return;
		bExif = true;
		stringbuffer.append("Exif：");
		int ai[] = new int[5];
		int k = (int) bytearraywithpointer.getTIFFLong(0L);
		if (k <= 0) {
			if (k < 0) {
				stringbuffer.append("\nIFDオフセットエラー： ");
				stringbuffer.append(k);
				stringbuffer.append("\n\n");
			}
			return;
		}
		else {
			bytearraywithpointer.setPointer(k);
			ai[0] = 1;
			ai[1] = k;
			appendIFDInfo(bytearraywithpointer, stringbuffer, ai, "  ");
			return;
		}
	}

	private static boolean appendJFIFInfo(byte abyte0[], int i, StringBuffer stringbuffer)
	{
		if (i < 14) {
			stringbuffer.append("フォーマットエラー");
			stringbuffer.append("\n\n");
			return false;
		}
		if (abyte0[0] != 74 || abyte0[1] != 70 || abyte0[2] != 73 || abyte0[3] != 70 || abyte0[4] != 0) {
			for (int j = 0; j < 5 && abyte0[j] != 0; j++)
				stringbuffer.append((char) abyte0[j]);

			stringbuffer.append("\n\n");
			return false;
		}
		String s;
		if (abyte0[7] == 1)
			s = "/inch";
		else if (abyte0[7] == 2)
			s = "/cm";
		else
			s = null;
		stringbuffer.append("JFIF Ver.");
		stringbuffer.append(abyte0[5]);
		stringbuffer.append('.');
		stringbuffer.append(abyte0[6]);
		stringbuffer.append("\n  水平ピクセル密度： ");
		stringbuffer.append(((abyte0[8] & 0xff) << 8) + (abyte0[9] & 0xff));
		if (s != null)
			stringbuffer.append(s);
		stringbuffer.append("\n  垂直ピクセル密度： ");
		stringbuffer.append(((abyte0[10] & 0xff) << 8) + (abyte0[11] & 0xff));
		if (s != null)
			stringbuffer.append(s);
		stringbuffer.append("\n  サムネイル： ");
		byte byte0 = abyte0[12];
		byte byte1 = abyte0[13];
		if (byte0 == 0 || byte1 == 0) {
			stringbuffer.append("なし");
		}
		else {
			stringbuffer.append(byte0);
			stringbuffer.append('\327');
			stringbuffer.append(byte1);
		}
		stringbuffer.append("\n\n");
		return true;
	}

	private byte[] checkBLSize(byte abyte0[], int i)
	{
		return abyte0.length < i ? new byte[i] : abyte0;
	}

	private int getColorModel(int components, int color_trans)
	{
		int model = COLORMODEL_RGB;
		if (components != 4) {
			model = COLORMODEL_NATIVE;
		} else {
			switch (color_trans)
			{
				case 0:
				default:
					model = COLORMODEL_CMYK;
					break;
				case 1:
					model = COLORMODEL_YCBCR;
					break;
				case 2:
					model = COLORMODEL_YCCK;
					break;
			}
		}
		return model;
	}

	private boolean appendJPEGInfo(BufferedInputStream bufferedinputstream, StringBuffer stringbuffer) throws IOException
	{
		byte abyte0[] = new byte[64];
		int nSof0ColorComponets = -1;
		int nApp14AdobeColorTransform = -1;
		do {
			if (bufferedinputstream.read() != 255)
				break;
			int i = bufferedinputstream.read();
			if (i == 0 || i == 255 || i == 217 || i == 218)
				break;
			int j = readShort(bufferedinputstream) - 2;
			if (j < 0)
				return false;
			if (i == 0xc0) {
				bufferedinputstream.read();
				nHeight = readShort(bufferedinputstream);
				nWidth = readShort(bufferedinputstream);
				nSof0ColorComponets = bufferedinputstream.read();
				if (!V2CLocalFileHandler.skipInputStream(bufferedinputstream, j - 4))
					return false;
			}
			else if ((i & 0xf0) == 0xe0) {
				int k = i & 0xf;
				if (k == 0) { // app00 0xffe0
					abyte0 = checkBLSize(abyte0, j);
					if (bufferedinputstream.read(abyte0, 0, j) != j)
						return false;
					bJFIF = appendJFIFInfo(abyte0, j, stringbuffer);
					j = 0;
				}
				else if (k == 1) { // app01 0xffe1
					abyte0 = checkBLSize(abyte0, j);
					if (bufferedinputstream.read(abyte0, 0, j) != j)
						return false;
					appendExifInfo(abyte0, j, stringbuffer);
					j = 0;
				}
				else if (k == 2 && j > 12) { // app02 0xffe2
					if (bufferedinputstream.read(abyte0, 0, 12) != 12)
						return false;
					if (abyte0[11] == 0 && (new String(abyte0, 0, 11)).equals("ICC_PROFILE")) {
						bICC = true;
						bJFIFBeforeICC = bJFIF;
					}
					j -= 12;
				}
				else if (k == 14 && j == 12) { // APP14 0xffee
					if (bufferedinputstream.read(abyte0, 0, 12) != 12)
						return false;
					if (abyte0[5] == 0 && (new String(abyte0, 0, 5)).equals("Adobe")) {
						nApp14AdobeColorTransform = abyte0[11];
					}
					j -= 12;
				}
			}
			if (j > 0 && !V2CLocalFileHandler.skipInputStream(bufferedinputstream, j))
				return false;
		} while (true);
		if (nSof0ColorComponets != -1 && nApp14AdobeColorTransform != -1) {
			nColorModel = getColorModel(nSof0ColorComponets, nApp14AdobeColorTransform);
		}
		return true;
	}

	private boolean appendGIFInfo(BufferedInputStream bufferedinputstream, StringBuffer stringbuffer) throws IOException
	{
		if (bufferedinputstream.read() != 70)
			return false;
		if (!V2CLocalFileHandler.skipInputStream(bufferedinputstream, 3))
			return false;
		int i = readShortR(bufferedinputstream);
		int j = readShortR(bufferedinputstream);
		if (i <= 0 || j <= 0) {
			return false;
		}
		else {
			nWidth = i;
			nHeight = j;
			return true;
		}
	}

	private boolean appendPNGInfo(BufferedInputStream bufferedinputstream, StringBuffer stringbuffer) throws IOException
	{
		String s = "NG\r\n\032\n";
		for (int i = 0; i < s.length(); i++)
			if (bufferedinputstream.read() != s.charAt(i))
				return false;

		int j;
		while ((j = readInt(bufferedinputstream)) >= 0) {
			int k = readInt(bufferedinputstream);
			if (k < 0)
				return false;
			if (k == 0x49484452) {
				int l = readInt(bufferedinputstream);
				int i1 = readInt(bufferedinputstream);
				if (l <= 0 || i1 <= 0) {
					return false;
				}
				else {
					nWidth = l;
					nHeight = i1;
					return true;
				}
			}
			if (!V2CLocalFileHandler.skipInputStream(bufferedinputstream, k + 4))
				return false;
		}
		return false;
	}

	private boolean appendBMPInfo(BufferedInputStream bufferedinputstream, StringBuffer stringbuffer) throws IOException
	{
		if (!V2CLocalFileHandler.skipInputStream(bufferedinputstream, 16))
			return false;
		int i = readIntR(bufferedinputstream);
		int j = readIntR(bufferedinputstream);
		if (i <= 0 || j <= 0) {
			return false;
		}
		else {
			nWidth = i;
			nHeight = j;
			return true;
		}
	}

	void parse(boolean flag, boolean flag1)
	{
		parse(flag, flag1, 0, 0);
	}

	void parse(boolean flag, boolean flag1, int i, int j)
    {
        int k;
        BufferedInputStream bufferedinputstream;
        StringBuffer stringbuffer;
        nWidth = i;
        nHeight = j;
        if(fImageFile == null)
            return;
        k = (int)fImageFile.length();
        if(k == 0)
            return;
        bufferedinputstream = null;
        stringbuffer = flag1 ? new StringBuffer() : null;
        byte abyte0[];
        try
        {
	        bufferedinputstream = new BufferedInputStream(new FileInputStream(fImageFile));
	        abyte0 = new byte[2];
	        if(bufferedinputstream.read(abyte0) != 2)
	        {
	            sInfoString = "フォーマットエラー";
	            return;
	        }

            String s = null;
            boolean flag2 = false;
            if(abyte0[0] == -1 && abyte0[1] == -40)
            {
                nFormat = 1;
                s = "JPEG";
                flag2 = appendJPEGInfo(bufferedinputstream, stringbuffer);
            } else
            if(abyte0[0] == -119 && abyte0[1] == 80)
            {
                nFormat = 2;
                s = "PNG";
                flag2 = appendPNGInfo(bufferedinputstream, stringbuffer);
            } else
            if(abyte0[0] == 71 && abyte0[1] == 73)
            {
                nFormat = 3;
                s = "GIF";
                flag2 = appendGIFInfo(bufferedinputstream, stringbuffer);
            } else
            if(abyte0[0] == 66 && abyte0[1] == 77)
            {
                nFormat = 4;
                s = "BMP";
                flag2 = appendBMPInfo(bufferedinputstream, stringbuffer);
            } else
            if(abyte0[0] == 82 && abyte0[1] == 73)
            {
                nFormat = 5;
                s = "WEBP";
                flag2 = true;
            }
            sFormatName = s;
            if(flag && (nWidth <= 0 || nHeight <= 0))
            {
                Dimension dimension = getImageSize(fImageFile);
                if(dimension != null)
                {
                    nWidth = dimension.width;
                    nHeight = dimension.height;
                }
            }
            if(stringbuffer != null)
            {
                if(!flag2)
                    stringbuffer.append("フォーマットエラー");
                if(s != null)
                {
                    StringBuffer stringbuffer1 = new StringBuffer();
                    stringbuffer1.append(s);
                    if(nWidth > 0 && nHeight > 0)
                        appendGeneralInfo(stringbuffer1, k, nWidth, nHeight);
                    stringbuffer1.append("\n\n");
                    stringbuffer1.append(stringbuffer.toString());
                    stringbuffer = stringbuffer1;
                }
            }
        }
        catch(IOException ioexception) { }
        finally
        {
        	V2CLocalFileHandler.closeInputStream(bufferedinputstream);
        }
        if(flag1)
            sInfoString = stringbuffer.toString();
        return;
    }

	private static void appendGeneralInfo(StringBuffer stringbuffer, int i, int j, int k)
	{
		DecimalFormat decimalformat = new DecimalFormat(",##0");
		stringbuffer.append("\n  ファイルサイズ： ");
		stringbuffer.append(decimalformat.format(i));
		stringbuffer.append("\n  幅\327高さ： ");
		stringbuffer.append(decimalformat.format(j));
		stringbuffer.append("\327");
		stringbuffer.append(decimalformat.format(k));
	}

	boolean isJPEG()
	{
		return nFormat == 1;
	}

	private static Dimension getImageSize(File file)
	{
		ImageReader imagereader = null;
		ImageInputStream imageinputstream = null;
		int i = 0;
		int j = 0;
		try {
			imageinputstream = ImageIO.createImageInputStream(file);
			if (imageinputstream != null) {
				Iterator iterator = ImageIO.getImageReaders(imageinputstream);
				if (iterator.hasNext()) {
					imagereader = (ImageReader) iterator.next();
					imagereader.setInput(imageinputstream);
					i = imagereader.getWidth(0);
					j = imagereader.getHeight(0);
				}
			}
		}
		catch (IOException ioexception) {
		}
		finally {
			if (imagereader != null)
				imagereader.dispose();
			if (imageinputstream != null)
				try {
					imageinputstream.close();
				}
				catch (IOException ioexception1) {
				}
		}
		return new Dimension(i, j);
	}

	static V2CImageInfo getImageInfo(File file, boolean flag, boolean flag1)
	{
		V2CImageInfo v2cimageinfo = new V2CImageInfo(file);
		v2cimageinfo.parse(flag, flag1);
		return v2cimageinfo;
	}

	static void showPanel(File file, int i, int j)
	{
		showPanel(null, file, i, j);
	}

	static void showPanel(Component component, File file, int i, int j)
	{
		V2CImageInfo v2cimageinfo = new V2CImageInfo(file);
		v2cimageinfo.parse(true, true, i, j);
		String s = v2cimageinfo.sInfoString;
		if (s == null || s.length() == 0)
			s = "情報がありません";
		JTextArea jtextarea = new JTextArea(s);
		jtextarea.setMargin(new Insets(5, 5, 5, 10));
		jtextarea.setEditable(false);
		jtextarea.setFont(V2CSSFont.getDefaultFont().getAwtFont());
		Dimension dimension = jtextarea.getPreferredSize();
		JScrollPane jscrollpane = new JScrollPane(jtextarea);
		Insets insets = jscrollpane.getInsets();
		Rectangle rectangle = V2CMain.v2cMain.getBounds();
		Rectangle rectangle1 = V2CSwingUtil.getScreenBoundsAt(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height
				/ 2);
		int k = dimension.width + insets.left + insets.right;
		int l = (2 * rectangle1.width) / 3;
		int i1 = dimension.height + insets.top + insets.bottom;
		int j1 = (2 * rectangle1.height) / 3;
		int k1 = UIManager.getInt("ScrollBar.width");
		if (V2CApp.isMacintosh()) {
			k += k1;
			i1 += k1;
		}
		if (k > l)
			i1 += k1;
		if (i1 > j1)
			k += k1;
		if (k > l)
			k = l;
		if (i1 > j1)
			i1 = j1;
		Dimension dimension1 = new Dimension(k, i1);
		jscrollpane.setPreferredSize(dimension1);
		jscrollpane.setMaximumSize(dimension1);
		jtextarea.setLineWrap(true);
		JOptionPane.showMessageDialog(((Component) (component == null ? ((Component) (V2CMain.v2cMain)) : component)),
				jscrollpane, "Image Info", -1);
	}

	private V2CImageInfo(File file)
	{
		nColorModel = -1;	// for jpeg
		fImageFile = file;
	}

	private static final String sTagNameFile = "exif.txt";
	private static final String slFormatNames[] = { "UNKNOWN", "BYTE", "ASCII", "SHORT", "LONG", "RATIONAL", "SBYTE",
			"UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "FLOAT", "DOUBLE" };
	private static final String sFormatError = "フォーマットエラー";
	private static final HashMap hmTagNames = new HashMap();
	private static final HashMap hmFormats = new HashMap();
	private static final HashMap hmParameters = new HashMap();
	private static final HashMap hmUnits = new HashMap();
	static final int FORMAT_JPEG = 1;
	static final int FORMAT_PNG = 2;
	static final int FORMAT_GIF = 3;
	static final int FORMAT_BMP = 4;
	static final int FORMAT_WEBP = 5;
	final File fImageFile;
	int nFormat;
	String sFormatName;
	int nWidth;
	int nHeight;
	boolean bExif;
	int nOrientation;
	boolean bJFIF;
	boolean bICC;
	boolean bJFIFBeforeICC;
	int nColorModel;
	static final int COLORMODEL_UNKNOWN = -1;	// not jpeg
	static final int COLORMODEL_NATIVE = 0;
	static final int COLORMODEL_RGB = 0;
	static final int COLORMODEL_CMYK = 1;
	static final int COLORMODEL_YCCK = 2;
	static final int COLORMODEL_YCBCR = 3;
	String sInfoString;
	private static final char clFilterColor[] = { 'R', 'G', 'B', 'C', 'M', 'Y', 'W' };

	static {
		restoreTagName();
	}
}
