package org.monazilla.v2c;

import java.security.AccessControlContext;
import java.security.PrivilegedExceptionAction;

public class V2CImageCacheScript extends V2CSystemScript
{

	private static V2CImageCacheScript getInstance()
	{
		if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5))
			return null;
		if (!bLoadTried) {
			bLoadTried = true;
			vImageCacheScript = (V2CImageCacheScript) V2CScriptUtil.createSystemScript("imgcache.js");
		}
		return vImageCacheScript;
	}

	static void reload()
	{
		if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5)) {
			return;
		}
		else {
			Thread thread = new Thread(new Runnable() {

				public void run()
				{
					V2CImageCacheScript v2cimagecachescript = V2CImageCacheScript.vImageCacheScript;
					if (v2cimagecachescript != null) {
						v2cimagecachescript.stop();
						V2CImageCacheScript.vImageCacheScript = null;
					}
					V2CScriptUtil.printMessage("imgcache.js\u3092\u8AAD\u307F\u8FBC\u3093\u3067\u3044\u307E\u3059\u2026");
					V2CImageCacheScript.bLoadTried = false;
					v2cimagecachescript = V2CImageCacheScript.getInstance();
					V2CScriptUtil
							.printMessage(v2cimagecachescript == null ? "imgcache.js\u3092\u8AAD\u307F\u8FBC\u3081\u307E\u305B\u3093\u3067\u3057\u305F\u3002"
									: "imgcache.js\u3092\u8AAD\u307F\u8FBC\u307F\u307E\u3057\u305F\u3002");
				}

			});
			thread.start();
			return;
		}
	}

	static V2CImageCacheScript createImageCacheScript(String s, V2CScriptClassLoader v2cscriptclassloader,
			AccessControlContext accesscontrolcontext)
	{
		String s1 = V2CLocalFileHandler.restoreTextResource("org/monazilla/v2c/script/imgcheft.js");
		if (s1 == null)
			return null;
		V2CScriptApp v2cscriptapp = new V2CScriptApp("imgcache.js");
		String s2 = null;
		PrivilegedExceptionAction privilegedexceptionaction = null;
		try {
			privilegedexceptionaction = V2CJSE6Util.createScriptAction("JavaScript", s + s1, v2cscriptapp, v2cscriptclassloader,
					accesscontrolcontext, false);
		}
		catch (Exception exception) {
			s2 = exception.getMessage();
		}
		if (privilegedexceptionaction == null) {
			V2CScriptUtil
					.setErrorMessage(s2 == null ? "\u30A2\u30AF\u30B7\u30E7\u30F3\u306E\u4F5C\u6210\u306B\u5931\u6557\u3057\u307E\u3057\u305F\u3002"
							: s2);
			return null;
		}
		else {
			V2CImageCacheScript v2cimagecachescript = new V2CImageCacheScript(privilegedexceptionaction, v2cscriptapp,
					v2cscriptclassloader, accesscontrolcontext);
			v2cimagecachescript.exec();
			return v2cimagecachescript;
		}
	}

	static boolean getLimits(V2CThreadPanel v2cthreadpanel, int ai[])
	{
		V2CImageCacheScript v2cimagecachescript = getInstance();
		if (v2cimagecachescript == null)
			return false;
		V2CScriptThread v2cscriptthread = V2CScriptThread.createScriptThread(v2cthreadpanel);
		if (v2cscriptthread == null)
			return false;
		else
			return v2cimagecachescript.getLimits(v2cscriptthread, ai);
	}

	private V2CImageCacheScript(PrivilegedExceptionAction privilegedexceptionaction, V2CScriptApp v2cscriptapp,
			V2CScriptClassLoader v2cscriptclassloader, AccessControlContext accesscontrolcontext)
	{
		super(privilegedexceptionaction, v2cscriptapp, v2cscriptclassloader, accesscontrolcontext);
	}

	synchronized boolean getLimits(V2CScriptThread v2cscriptthread, int ai[])
	{
		if (bReloading) {
			return false;
		}
		else {
			V2CJSE6Util.setInvokeFunction(vPrivilegedExceptionAction, "_v2c_getDownloadNewImagesLimit", new Object[] {
					v2cscriptthread, ai });
			exec();
			return true;
		}
	}

	private static final String sScriptFileName = "imgcache.js";
	private static boolean bLoadTried;
	private static V2CImageCacheScript vImageCacheScript;

}
