package org.monazilla.v2c;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.net.ssl.HttpsURLConnection;

public class V2CHttpUtilMultiSenbra
{
	// マルチ専ブラ対応
	public static Map <String, String> HMNonaKey = new HashMap <String, String> ();
	public static Map <String, String> HMApiSid = new HashMap <String, String> ();
	public static Map <String, String> HMXRoninSid = new HashMap <String, String> ();
	public static Map <String, Map> HMAddionalApiKeys = new HashMap <String, Map> ();

	public static String getHMKey(String ua){
		if(ua == null){
			return V2CHttpUtil.HMKey;
		}
		if(ua.equals(V2CHttpUtil.UAPost)){
			return V2CHttpUtil.HMKey;
		}
		if(ua.equals(V2CHttpUtil.X2CHUA)){
			return V2CHttpUtil.HMKey;
		}

		return (String) HMAddionalApiKeys.get(getbName(ua)).get("HMKey");
	}

	public static String getAppKey(String ua){
		if(ua == null){
			return V2CHttpUtil.AppKey;
		}
		if(ua.equals(V2CHttpUtil.UAPost)){
			return V2CHttpUtil.AppKey;
		}
		if(ua.equals(V2CHttpUtil.X2CHUA)){
			return V2CHttpUtil.AppKey;
		}

		return (String) HMAddionalApiKeys.get(getbName(ua)).get("AppKey");
	}

	public static String getUAAuth(String ua){
		if(ua == null){
			return V2CHttpUtil.UAAuth;
		}
		if(ua.equals(V2CHttpUtil.UAPost)){
			return V2CHttpUtil.UAAuth;
		}
		if(ua.equals(V2CHttpUtil.UAAuth)){
			return V2CHttpUtil.UAAuth;
		}

		return (String) HMAddionalApiKeys.get(getbName(ua)).get("UAAuth");
	}

	public static String getX2CHUA(String ua){
		if(ua == null){
			return V2CHttpUtil.X2CHUA;
		}
		if(ua.equals(V2CHttpUtil.UAPost)){
			return V2CHttpUtil.X2CHUA;
		}
		if(ua.equals(V2CHttpUtil.X2CHUA)){
			return V2CHttpUtil.X2CHUA;
		}

		return (String) HMAddionalApiKeys.get(getbName(ua)).get("X2CHUA");
	}

	public static void setApiSid(String val, String ua){
		HMApiSid.put(ua, val);
	}

	public static String getApiSid(String sid, String ua){
		if(ua.equals(V2CHttpUtil.UAPost)){
			return sid;
		}else{
			if(!HMApiSid.containsKey(ua)){
				if(!login2ch("", "", null, false, ua)){
					return null;
				}
			}
			return HMApiSid.get(ua);
		}
	}

	public static void setXRoninSid(String val, String ua){
		HMXRoninSid.put(ua, val);
//		V2CProperty apiProperty = V2CHttpUtil.apiProperty;
//		String keys = "";
//		for(Map.Entry<String, String> entry : HMXRoninSid.entrySet()) {
//			keys += (keys.length()==0?"":",") + entry.getKey() + "\t" + entry.getValue();
//		}
//		apiProperty.put("2chAPI.XRoninSidAdditional", keys);
//		apiProperty.doSaveState();
	}

	public static String getXRoninSid(String sid, String ua){
		if(ua.equals(V2CHttpUtil.UAPost)){
			return sid;
		}else{
			if(!HMXRoninSid.containsKey(ua)){
				V2C2chBBS v2chBBS = V2C2chBBS.createInstance("2ch", "2ch");
				V2CProperty v2cproperty = v2chBBS.getProperty();
				V2CPackedPropValue v2cpackedpropvalue = v2cproperty.getPackedValue("2ch.MaruConf:");
				if (v2cpackedpropvalue != null) {
					String as[] = V2CMiscUtil.decodeNullSeparatedBase64Pair(v2cpackedpropvalue.getString('i'));
					if (as != null) {
						if(!login2ch(as[0], as[1], null, false, ua)){
							return null;
						}
					}
				}
			}
			return HMXRoninSid.get(ua);
		}
	}

	public static void setNonaKey(String val, String ua){
		if(ua.equals(V2CHttpUtil.UAPost)){
			V2CHttpUtilOld2New.setNonaKey(val);
		}else{
			HMNonaKey.put(ua, val);
			V2CProperty apiProperty = V2CHttpUtil.apiProperty;
			String keys = "";
			for(Map.Entry<String, String> entry : HMNonaKey.entrySet()) {
				if(V2CHttpUtil.hmSecondaryUA.get("W").containsValue(entry.getKey())){
					keys += (keys.length()==0?"":",") + entry.getKey() + "\t" + entry.getValue();
				}
			}
			apiProperty.put("2chAPI.JavaVenderInfoAdditional", keys);
			apiProperty.doSaveState();
		}
		if(ua == V2CHttpUtilOld2New.MonakeyInit ){
			V2CSwingUtil.showInformationMessage("鍵をクリアしました\n\n"+"UA："+ua);
		}
	}

	public static String getNonaKey(String ua){
		if(ua.equals(V2CHttpUtil.UAPost)){
			return V2CHttpUtilOld2New.getNonaKey();
		}
		if(HMNonaKey.containsKey(ua)){
			return HMNonaKey.get(ua);
		}else{
			HMNonaKey.put(ua, V2CHttpUtilOld2New.MonakeyInit);
			return V2CHttpUtilOld2New.MonakeyInit;
		}
	}

	static boolean login2ch(String userId, String passwd,
			V2CProgressPanel v2cprogresspanel, boolean flag, String ua) {
		boolean LoginAPI = true;
		if(userId != "" && userId != null && passwd != "" && passwd != null){
			V2CHttpUtil.prev_userId = userId;
			V2CHttpUtil.prev_passwd = passwd;
			LoginAPI = false;
		}
		URL url = null;
		if(!LoginAPI){
			url = V2C2chBBS.getLoginServerURL();
		}
		else
		if (V2CHttpUtil.useAPI) {
			if(V2CHttpUtil.Use5chNet){
				url = str2URL("https://api.5ch.net/v1/auth/");
			}else{
				url = str2URL("https://api.2ch.net/v1/auth/");
			}
		} else {
			url = V2C2chBBS.getLoginServerURL();
			if(url != null){
//				String wUrl = url.toString();
//				if(/*wUrl.indexOf(".2ch.net") != -1*/ is2ch.matcher(wUrl).matches()){
//					wUrl = Rep2chTo5ch(wUrl);
//					try {
//						url = new URL(wUrl);
//					} catch (MalformedURLException e) {
//						// TODO 自動生成された catch ブロック
//						e.printStackTrace();
//					}
//				}
			}
		}
		Thread thread = Thread.currentThread();
		PrintWriter printwriter = null;
		BufferedReader bufferedreader = null;
		char[] ac = new char[V2CHttpUtil.nBufLen];
		StringBuffer stringbuffer = new StringBuffer();
		if (!V2CMain.isOnlineMode()) {
			V2CHttpUtil.logNotOnline(userId);
			return false;
		}
		if (null == url) {
			V2CLogger.logError(url, "Error in bbs2ch.getLoginServerURL().");
			V2C2chBBS.maruLoginFailed(flag);
			return false;
		}
		HttpsURLConnection httpsurlconnection;
		try {
			if (v2cprogresspanel != null) {
				v2cprogresspanel.setMessage("opening connection ...");
			}
			httpsurlconnection = (HttpsURLConnection) V2CProxySetting
					.openReadConnection(url);
			if (thread.isInterrupted()) {
				V2CHttpUtil.logInterrupt(url);
				V2C2chBBS.maruLoginFailed(flag);
				return false;
			}
			if (V2CApp.javaVersionLessThan(1, 5)) {
				httpsurlconnection
						.setHostnameVerifier(new V2CHttpUtil.MyHostnameVerifier());
			}
			httpsurlconnection.setRequestMethod("POST");
			httpsurlconnection.setDoOutput(true);
			httpsurlconnection.setUseCaches(false);
			httpsurlconnection.setAllowUserInteraction(false);
			httpsurlconnection.setRequestProperty("Host", url.getHost());
			httpsurlconnection.setRequestProperty("Accept", "*/*");
			httpsurlconnection.setRequestProperty("User-Agent", getUAAuth(ua));
			httpsurlconnection.setRequestProperty("X-2ch-UA", getX2CHUA(ua));
			httpsurlconnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
			if(V2CHttpUtil.SetCookieToAPIModeDat){
				if(V2CHttpUtil.is2ch.matcher(url.toString()).matches()){
					String str2 = V2CCookie.getCookie(url, null);
					if (str2 != null)
					{
						httpsurlconnection.setRequestProperty("Cookie", str2);
					}
				}
			}
//			httpsurlconnection.setRequestProperty("Connection", "Keep-Alive");
//			if(httpsurlconnection.getURL().getHost().equals("api.5ch.net")){
//				String browser = httpsurlconnection.getRequestProperty("X-2ch-UA").replaceAll("/.+$", "");
//				V2CHttpUtilOld2New.getnWo();
//				Map nWoUA = V2CHttpUtilOld2New.getnWoUA(browser);
//				V2CHttpUtilOld2New.setreq(httpsurlconnection, (List) nWoUA.get("req"));
//			}
			V2CLogger.logHTTPHeaderFields(url, "2ch Login Request:",
					httpsurlconnection.getRequestProperties());
			printwriter = new PrintWriter(httpsurlconnection.getOutputStream());
			if (thread.isInterrupted()) {
				V2CHttpUtil.logInterrupt(url);
				V2C2chBBS.maruLoginFailed(flag);
				return false;
			}

			int j;
			if (v2cprogresspanel != null) {
				v2cprogresspanel.setMessage("sending id&pw ...");
			}

			if(!LoginAPI){
				printwriter.print("ID=" + V2CJPConverter.urlEncode(userId, "MS932")
				+ "&PW=" + V2CJPConverter.urlEncode(passwd, "MS932"));
			}
			else
			if (LoginAPI && V2CHttpUtil.useAPI) {
				String CT = String.valueOf(System.currentTimeMillis());
				CT = CT.substring(0,10);
				String message = getAppKey(httpsurlconnection.getRequestProperty("X-2ch-UA")) + CT;
				String HB = V2CHttpUtil.getHash(message, httpsurlconnection.getRequestProperty("X-2ch-UA"));
				printwriter.print("&KY="
						+ V2CJPConverter.urlEncode(getAppKey(httpsurlconnection.getRequestProperty("X-2ch-UA")), "MS932")
						+ "&CT=" + V2CJPConverter.urlEncode(CT, "MS932")
						+ "&HB=" + V2CJPConverter.urlEncode(HB, "MS932"));
			}
			printwriter.close();
			bufferedreader = new BufferedReader(new InputStreamReader(
					httpsurlconnection.getInputStream()));
			if (thread.isInterrupted()) {
				V2CHttpUtil.logInterrupt(url);
				V2C2chBBS.maruLoginFailed(flag);
				return false;
			}
			if (v2cprogresspanel != null) {
				v2cprogresspanel.setMessage("receiving session ID ...");
			}
			while ((j = bufferedreader.read(ac)) >= 0) {
				if (thread.isInterrupted()) {
					V2CHttpUtil.logInterrupt(url);
					V2C2chBBS.maruLoginFailed(flag);
					return false;
				}
				if (j > 0) {
					stringbuffer.append(ac, 0, j);
				}
			}
			Map map = httpsurlconnection.getHeaderFields();
			if (map.containsKey("Set-Cookie")) {
				List list = (List) map.get("Set-Cookie");
				for (int l = 0; l < list.size(); l++)
					V2CCookie.addCookie((String) list.get(l), url);

			}
			V2CHttpUtil.logHTTPResponse(httpsurlconnection, "2ch Login Response: ");
		} catch (IOException ioexception) {
			V2CLogger.logError(url, V2CMiscUtil.getMessage(ioexception),
					ioexception);
			V2C2chBBS.maruLoginFailed(flag);
			return false;
		} finally {
			V2CProxySetting.resetReadProxy();
			V2CLocalFileHandler.closeWriter(printwriter);
			V2CLocalFileHandler.closeReader(bufferedreader);
		}
		for (int i = stringbuffer.length() - 1; i >= 0; i--) {
			char k = stringbuffer.charAt(i);
			if ((k != '\n') && (k != '\r'))
				break;
			stringbuffer.setLength(i);
		}
		String str = stringbuffer.toString();
		if ((!str.startsWith("SESSION-ID="))
				|| (str.regionMatches(11, "ERROR", 0, 5))) {
			V2C2chBBS.maruLoginFailed(flag);
			return false;
		}
		str = str.substring(11);
		int k = str.indexOf(':');
		if (k < 0) {
			V2C2chBBS.maruLoginFailed(flag);
			return false;
		}
		if (LoginAPI && V2CHttpUtil.useAPI) {
			setApiSid(str.substring(k + 1), ua);
		}
		if(!LoginAPI){
			setXRoninSid(str, ua);
		}
		return true;
	}

	private static URL str2URL(String s) {
		try {
			return new URL(s);
		} catch (MalformedURLException malformedurlexception) {
			V2CMiscUtil.printMalformedURLException(malformedurlexception);
		}
		return null;
	}

	public static void setAddionalApiKeys(){
		V2CProperty v2cproperty = V2CMain.getUserProperty();
		File cache = new File(v2cproperty.fParentFolder.getAbsolutePath()
				+ "/2ch_api_AKeySets.txt");
		
		if(cache.exists()){
			BufferedReader br = null;
			try {
				br = new BufferedReader(new FileReader(cache));
		 
				String line;
				while ((line = br.readLine()) != null) {
					if(line.length() > 0){
						String[] k = line.split("\t", 6);
						if(k.length == 6){
							Map <String, String> key = new HashMap <String, String> ();
							key.put("HMKey", k[0]);
							key.put("AppKey", k[1]);
							key.put("X2CHUA", k[2]);
							key.put("UAName", k[3]);
							key.put("UAPost", k[4]);
							key.put("UAAuth", k[5]);
							HMAddionalApiKeys.put(getbName(key.get("UAPost")), key);
						}
					}
				}
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				try {
					br.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	public static String getbName(String ua){
		String[] e = (ua.replaceAll("^Monazilla[^ ]+ ", "")).split("/");
		if(e[0].equals("V2C")){
			e[0] += "-R";
		}
		return e[0];
	}
}
