package org.monazilla.v2c;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class V2CHTMLString implements CharSequence
{

	public V2CHTMLString(boolean flag)
	{
		vlTextSegment = new V2CTextSegment[10];
		bName = flag;
	}

	void breakMessageLines(String s, boolean flag)
	{
		char ac[] = new char[s.length() + 1];
		s.getChars(0, s.length(), ac, 0);
		breakMessageLines(ac, ac.length - 1, flag);
	}

	void breakMessageLines(char ac[], int i, boolean flag)
	{
		i--;
		do {
			if (i < 0)
				break;
			char c = ac[i];
			if (c != ' ')
				break;
			i--;
		} while (true);
		i++;
		int j = 0;
		int k = 0;
		int l = 0;
		int i1 = i - 3;
		for (int j1 = 0; j1 < i1; j1++) {
			if (ac[j1] != '<' || ac[j1 + 1] != 'b' || ac[j1 + 2] != 'r')
				continue;
			char c1 = ac[j1 + 3];
			byte byte0;
			if (c1 == '>') {
				byte0 = 4;
			}
			else {
				if (j1 + 5 >= i || c1 != ' ' || ac[j1 + 4] != '/' || ac[j1 + 5] != '>')
					continue;
				byte0 = 6;
			}
			int k1 = j1 - 1;
			do {
				if (k1 < k)
					break;
				char c2 = ac[k1];
				if (c2 != ' ')
					break;
				k1--;
			} while (true);
			if (k1 >= k) {
				if (k != l)
					System.arraycopy(ac, k, ac, l, (k1 - k) + 1);
				l += (k1 - k) + 1;
			}
			ac[l++] = '\n';
			j++;
			if (j1 + byte0 < i && ac[j1 + byte0] == ' ')
				j1++;
			k = j1 + byte0;
			j1 += byte0 - 1;
		}

		if (k < i) {
			if (k != l)
				System.arraycopy(ac, k, ac, l, i - k);
			l += i - k;
		}
		if (flag)
			ac[l++] = '\n';
		if (ac.length < l) {
			char ac1[] = new char[l];
			System.arraycopy(ac, 0, ac1, 0, l);
			ac = ac1;
		}
		clMsg = ac;
		nMsgLength = l;
	}

	void replaceEscapes()
	{
		char ac[] = clMsg;
		int i = 0;
		do {
			i = indexInMsg("&", i);
			if (i < 0)
				break;
			int j = nMsgLength;
			if (j <= i + 2)
				break;
			int k;
			int l;
			if (ac[i + 1] == '#') {
				if (ac[i + 2] == 'X' || ac[i + 2] == 'x') {
					if (j <= i + 3)
						break;
					int i1 = 0;
					int k1;
					for (k1 = i + 3; k1 < j; k1++) {
						char c = ac[k1];
						if (c >= '0' && c <= '9') {
							i1 = i1 * 16 + (c - 48);
							if (i1 <= 0x10ffff)
								continue;
							i1 = -1;
							break;
						}
						if (c >= 'A' && c <= 'F') {
							i1 = i1 * 16 + ((c - 65) + 10);
							if (i1 <= 0x10ffff)
								continue;
							i1 = -1;
							break;
						}
						if (c >= 'a' && c <= 'f') {
							i1 = i1 * 16 + ((c - 97) + 10);
							if (i1 <= 0x10ffff)
								continue;
							i1 = -1;
							break;
						}
						if (c == ';')
							k1++;
						break;
					}

					if (i1 > 0) {
						l = i1;
						k = k1;
					}
					else {
						i += 3;
						continue;
					}
				}
				else {
					int j1 = 0;
					int l1 = i + 2;
					do {
						if (l1 >= j)
							break;
						char c1 = ac[l1];
						if (c1 >= '0' && c1 <= '9') {
							j1 = j1 * 10 + (c1 - 48);
							if (j1 > 0x10ffff) {
								j1 = -1;
								break;
							}
						}
						else {
							if (c1 == ';')
								l1++;
							break;
						}
						l1++;
					} while (true);
					if (j1 > 0) {
						l = j1;
						k = l1;
					}
					else {
						i += 2;
						continue;
					}
				}
			}
			else {
				String s = lookingAtEntity(i + 1);
				if (s != null) {
					Character character = (Character) hmEntity.get(s);
					if (character != null) {
						k = i + 1 + s.length() + 1;
						l = character.charValue();
					}
					else {
						i += s.length() + 1;
						continue;
					}
				}
				else {
					i++;
					continue;
				}
			}
			boolean flag = l < 0x10000;
			byte byte0 = ((byte) (flag ? 1 : 2));
			int i2 = j - k;
			if (i2 > 0)
				System.arraycopy(ac, k, ac, i + byte0, i2);
			if (flag) {
				ac[i++] = (char) l;
			}
			else {
				l -= 0x10000;
				ac[i++] = (char) ((l >> 10 & 0x3ff) + 55296);
				ac[i++] = (char) ((l & 0x3ff) + 56320);
			}
			nMsgLength -= k - i;
		} while (i < nMsgLength);
	}

	private String lookingAtEntity(int i)
	{
		char ac[] = clMsg;
		int j = Math.min(i + 9, ac.length);
		boolean flag = false;
		int k = 0;
		int l = i;
		do {
			if (l >= j)
				break;
			char c = ac[l];
			boolean flag1 = c >= 'a' && c <= 'z';
			boolean flag2 = c >= 'A' && c <= 'Z';
			boolean flag3 = c >= '0' && c <= '9';
			if (!flag1 && !flag2 && !flag3) {
				flag = c == ';';
				break;
			}
			k++;
			l++;
		} while (true);
		if (!flag || k < 2 || k > 8)
			return null;
		else
			return new String(ac, i, k);
	}

	void processHTMLTags()
	{
		int i = 0;
		do {
			if ((i = indexInMsg("<", i)) < 0 || i >= nMsgLength - 2)
				break;
			switch (toLowerCase(clMsg[i + 1])) {
				case 33: // '!'
					i = startComment(i);
					continue;

				case 97: // 'a'
					i = removeResLink(i);
					continue;

				case 98: // 'b'
					i = startByB(i);
					continue;

				case 102: // 'f'
					i = startFont(i);
					continue;

				case 104: // 'h'
					i = processHR(i);
					continue;

				case 105: // 'i'
					i = startItalic(i);
					continue;

				case 112: // 'p'
					i = startPara(i);
					continue;

				case 117: // 'u'
					i = startUnorderedList(i);
					continue;

				case 47: // '/'
					switch (toLowerCase(clMsg[i + 2])) {
						case 98: // 'b'
							i = endByB(i);
							break;

						case 102: // 'f'
							i = endFont(i);
							break;

						case 105: // 'i'
							i = endItalic(i);
							break;

						case 112: // 'p'
							i = endPara(i);
							break;

						case 117: // 'u'
							i = endUnorderedList(i);
							break;

						default:
							i = skipTag(i);
							break;
					}
					break;

				default:
					i = skipTag(i);
					break;
			}
		} while (true);
	}

	void processHTMLTags2()
	{
		char ac[] = clMsg;
		int i = nMsgLength;
		for (int j = 0; j < i; j++) {
			if (ac[j] != 0)
				continue;
			char c;
			switch (c = ac[j + 1]) {
				case 1: // '\001'
					i = skipMsgChars(j, ac[j + 2]);
					if (!bName) {
						bCommentTag = true;
						V2CTextSegment v2ctextsegment = new V2CTextSegment(j, 0x800000);
						v2ctextsegment.setSubType((short) 1);
						addTextSegment(v2ctextsegment);
					}
					j--;
					break;

				case 2: // '\002'
					ac[j] = '\n';
					ac[j + 1] = '\n';
					V2CTextSegment v2ctextsegment1 = new V2CTextSegment(j + 1, 0x800000);
					v2ctextsegment1.setSubType((short) 8);
					v2ctextsegment1.setNewLineNext(true);
					addTextSegment(v2ctextsegment1);
					break;

				case 3: // '\003'
					i = skipMsgChars(j, 3);
					V2CTextSegment v2ctextsegment2 = new V2CTextSegment(j, 0x800000);
					v2ctextsegment2.setSubType((short) 2);
					addTextSegment(v2ctextsegment2);
					j--;
					break;

				case 4: // '\004'
					i = skipMsgChars(j, 4);
					V2CTextSegment v2ctextsegment3 = new V2CTextSegment(j, 0x800000);
					v2ctextsegment3.setSubType((short) -2);
					if (i > j && ac[j] == '\n')
						v2ctextsegment3.setNewLineNext(true);
					addTextSegment(v2ctextsegment3);
					j--;
					break;

				case 5: // '\005'
					i = skipMsgChars(j, 3);
					V2CTextSegment v2ctextsegment4 = new V2CTextSegment(j, 0x800000);
					v2ctextsegment4.setSubType((short) 3);
					addTextSegment(v2ctextsegment4);
					j--;
					break;

				case 6: // '\006'
					i = skipMsgChars(j, 4);
					V2CTextSegment v2ctextsegment5 = new V2CTextSegment(j, 0x800000);
					v2ctextsegment5.setSubType((short) -3);
					if (i > j && ac[j] == '\n')
						v2ctextsegment5.setNewLineNext(true);
					addTextSegment(v2ctextsegment5);
					j--;
					break;

				case 7: // '\007'
					char c1 = ac[j + 2];
					V2CFontTextSegment v2cfonttextsegment = new V2CFontTextSegment(j, (short) 6, new String(ac, j + 6, c1 - 7));
					i = skipMsgChars(j, c1);
					addTextSegment(v2cfonttextsegment);
					j--;
					break;

				case 8: // '\b'
					i = skipMsgChars(j, 7);
					V2CFontTextSegment v2cfonttextsegment1 = new V2CFontTextSegment(j, (short) 6);
					if (nMsgLength > j && ac[j] == '\n')
						v2cfonttextsegment1.setNewLineNext(true);
					addTextSegment(v2cfonttextsegment1);
					j--;
					break;

				case 9: // '\t'
					j = startUnorderedList2(j);
					i = nMsgLength;
					break;

				case 10: // '\n'
					j = endUnorderedList2(j);
					i = nMsgLength;
					break;

				case 11: // '\013'
				case 12: // '\f'
					boolean flag = c == '\013';
					byte byte0;
					if (j > 0) {
						if (ac[j + 2] == '\002') {
							ac[j] = '\n';
							byte0 = 1;
						}
						else if (ac[j - 1] == '\n') {
							if (j <= 1 || ac[j - 2] == '\n') {
								byte0 = 0;
							}
							else {
								ac[j] = '\n';
								byte0 = 1;
							}
						}
						else {
							ac[j] = '\n';
							ac[j + 1] = '\n';
							byte0 = 2;
						}
					}
					else {
						byte0 = 0;
					}
					j += byte0;
					i = skipMsgChars(j, (flag ? 3 : 12) - byte0);
					V2CTextSegment v2ctextsegment6 = new V2CTextSegment(j, 0x800000);
					v2ctextsegment6.setSubType((short) (flag ? 9 : 10));
					addTextSegment(v2ctextsegment6);
					j--;
					break;

				case 13: // '\r'
				case 14: // '\016'
					boolean flag1 = c == '\r';
					byte byte1;
					if (j > 0 && j + 5 < i) {
						if (ac[j - 1] == '\n') {
							if (j <= 1 || ac[j - 2] == '\n') {
								byte1 = 0;
							}
							else {
								ac[j] = '\n';
								byte1 = 1;
							}
						}
						else {
							ac[j] = '\n';
							ac[j + 1] = '\n';
							byte1 = 2;
						}
					}
					else {
						byte1 = 0;
					}
					j += byte1;
					i = skipMsgChars(j, (flag1 ? 4 : 13) - byte1);
					V2CTextSegment v2ctextsegment7 = new V2CTextSegment(Math.max(j - 2, 0), 0x800000);
					v2ctextsegment7.setSubType((short) (-(flag1 ? 9 : 10)));
					addTextSegment(v2ctextsegment7);
					j--;
					break;

				default:
					ac[j] = ' ';
					ac[j + 1] = ' ';
					break;
			}
		}

	}

	int startComment(int i)
	{
		int j = nMsgLength;
		if (j < i + 8)
			return i + 2;
		char ac[] = clMsg;
		if (ac[i + 2] != '-' || ac[i + 3] != '-' || ac[i + 4] == '-')
			return i + 2;
		int k = indexInMsg("--", i + 5);
		if (k < 0 || j < k + 3)
			return i + 2;
		int l = -1;
		int i1 = k + 2;
		do {
			if (i1 >= j)
				break;
			char c = ac[i1];
			if (c == '>') {
				l = i1 + 1;
				break;
			}
			if (c != ' ')
				break;
			i1++;
		} while (true);
		if (l < 0) {
			return i + 2;
		}
		else {
			ac[i] = '\0';
			ac[i + 1] = '\001';
			ac[i + 2] = (char) (l - i);
			return l;
		}
	}

	int removeResLink(int i)
	{
		int j;
		if ((j = indexInMsg(">", i + 8)) < 0)
			return i + 2;
		int k;
		if ((k = indexInMsg("</a>", j + 1)) < 0)
			return i + 2;
		int l = k - j - 1;
		char ac[] = clMsg;
		int i1 = nMsgLength;
		if (j + 1 > i && l > 0)
			System.arraycopy(ac, j + 1, ac, i, l);
		if (k + 4 > i + l && i1 > k + 4)
			System.arraycopy(ac, k + 4, ac, i + l, i1 - k - 4);
		nMsgLength = i1 - ((j - i) + 5);
		return i + l;
	}

	private int skipTag(int i)
	{
		return i + 2;
	}

	private int startByB(int i)
	{
		switch (toLowerCase(clMsg[i + 2])) {
			case 62: // '>'
				return startBold(i);

			case 108: // 'l'
				return startBQ(i);

			case 114: // 'r'
				return processBR(i);
		}
		return i + 2;
	}

	private int endByB(int i)
	{
		switch (toLowerCase(clMsg[i + 3])) {
			case 62: // '>'
				return endBold(i);

			case 108: // 'l'
				return endBQ(i);
		}
		return i + 3;
	}

	private int startBold(int i)
	{
		char ac[] = clMsg;
		ac[i] = '\0';
		ac[i + 1] = '\003';
		return i + 3;
	}

	private int endBold(int i)
	{
		char ac[] = clMsg;
		ac[i] = '\0';
		ac[i + 1] = '\004';
		return i + 4;
	}

	private int processBR(int i)
	{
		if (nMsgLength < i + 4)
			return i + 2;
		char c = clMsg[i + 3];
		if (c == '>') {
			skipMsgChars(i, 3);
			clMsg[i] = '\n';
			return i + 1;
		}
		if (c == ' ') {
			String s = "clear=all";
			int j = i + 13;
			if (nMsgLength > j && clMsg[j] == '>' && s.equals(new String(clMsg, i + 4, s.length()))) {
				skipMsgChars(i, 13);
				clMsg[i] = '\n';
				return i + 1;
			}
		}
		return i + 2;
	}

	private int startFont(int i)
	{
		char ac[] = clMsg;
		char c;
		if ((c = ac[i + 2]) != 'o' && c != 'O')
			return i + 2;
		if ((c = ac[i + 3]) != 'n' && c != 'N')
			return i + 2;
		if ((c = ac[i + 4]) != 't' && c != 'T')
			return i + 2;
		int j = 0;
		int k = nMsgLength;
		int l = i + 6;
		do {
			if (l >= k)
				break;
			if (ac[l] == '>') {
				j = (l + 1) - i;
				break;
			}
			l++;
		} while (true);
		if (j == 0) {
			return i + 2;
		}
		else {
			ac[i] = '\0';
			ac[i + 1] = '\007';
			ac[i + 2] = (char) j;
			return i + j;
		}
	}

	private int endFont(int i)
	{
		char ac[] = clMsg;
		char c;
		if ((c = ac[i + 3]) != 'o' && c != 'O')
			return i + 2;
		if ((c = ac[i + 4]) != 'n' && c != 'N')
			return i + 2;
		if ((c = ac[i + 5]) != 't' && c != 'T')
			return i + 2;
		if (ac[i + 6] != '>') {
			return i + 2;
		}
		else {
			ac[i] = '\0';
			ac[i + 1] = '\b';
			return i + 7;
		}
	}

	private int processHR(int i)
	{
		char ac[] = clMsg;
		int j = nMsgLength;
		if (j < i + 4 || ac[i + 2] != 'r' && ac[i + 2] != 'R' || ac[i + 3] != '>')
			return i + 2;
		int k;
		for (k = i - 1; k >= 0 && ac[k] == ' '; k--)
			;
		k++;
		ac[k] = '\0';
		ac[k + 1] = '\002';
		System.arraycopy(ac, i + 4, ac, k + 2, j - i - 4);
		nMsgLength = j - ((i - k) + 2);
		return k + 1;
	}

	private int startPara(int i)
	{
		char ac[] = clMsg;
		if (ac[i + 2] != '>')
			return i + 2;
		ac[i] = '\0';
		ac[i + 1] = '\013';
		if (i >= 2 && ac[i - 2] == 0 && ac[i - 1] == '\002')
			ac[i + 2] = '\002';
		return i + 3;
	}

	private int endPara(int i)
	{
		char ac[] = clMsg;
		if (ac[i + 3] != '>') {
			return i + 2;
		}
		else {
			i = skipPrevSP(i);
			ac[i] = '\0';
			ac[i + 1] = '\r';
			return i + 4;
		}
	}

	private int startBQ(int i)
	{
		char ac[] = clMsg;
		if (i + 12 > nMsgLength || !(new String(ac, i + 3, 9)).regionMatches(true, 0, "OCKQUOTE>", 0, 9))
			return i + 3;
		ac[i] = '\0';
		ac[i + 1] = '\f';
		if (i >= 4 && ac[i - 4] == 0 && ac[i - 3] == '\002')
			ac[i + 2] = '\002';
		return i + 12;
	}

	private int skipPrevSP(int i)
	{
		char ac[] = clMsg;
		for (int j = i - 1; j >= 0; j--) {
			char c = ac[j];
			if (c != ' ') {
				int k = i - j - 1;
				if (k <= 0) {
					return i;
				}
				else {
					i -= k;
					skipMsgChars(i, k);
					return i;
				}
			}
		}

		return i;
	}

	private int endBQ(int i)
	{
		char ac[] = clMsg;
		if (i + 13 > nMsgLength || !(new String(ac, i + 4, 9)).regionMatches(true, 0, "OCKQUOTE>", 0, 9)) {
			return i + 4;
		}
		else {
			i = skipPrevSP(i);
			ac[i] = '\0';
			ac[i + 1] = '\016';
			return i + 13;
		}
	}

	private int startItalic(int i)
	{
		char ac[] = clMsg;
		if (ac[i + 2] != '>') {
			return i + 2;
		}
		else {
			ac[i] = '\0';
			ac[i + 1] = '\005';
			return i + 3;
		}
	}

	private int endItalic(int i)
	{
		char ac[] = clMsg;
		if (ac[i + 3] != '>') {
			return i + 2;
		}
		else {
			ac[i] = '\0';
			ac[i + 1] = '\006';
			return i + 4;
		}
	}

	private int startUnorderedList(int i)
	{
		char ac[] = clMsg;
		char c = ac[i + 2];
		if (c != 'l' && c != 'L' || ac[i + 3] != '>') {
			return i + 2;
		}
		else {
			ac[i] = '\0';
			ac[i + 1] = '\t';
			return i + 4;
		}
	}

	private int endUnorderedList(int i)
	{
		char ac[] = clMsg;
		char c = ac[i + 3];
		if (c != 'l' && c != 'L' || ac[i + 4] != '>') {
			return i + 2;
		}
		else {
			ac[i] = '\0';
			ac[i + 1] = '\n';
			return i + 5;
		}
	}

	private int startUnorderedList2(int i)
	{
		int j = 3;
		int k = 0;
		int l = i - 1;
		do {
			if (l < 0)
				break;
			char c = clMsg[l];
			if (c != ' ' && c != '\u3000')
				break;
			k++;
			l--;
		} while (true);
		if (i + 4 < nMsgLength && clMsg[i + 4] == ' ')
			j++;
		i -= k;
		j += k;
		skipMsgChars(i, j);
		clMsg[i] = '\n';
		V2CTextSegment v2ctextsegment = new V2CTextSegment(i, 0x800000);
		v2ctextsegment.setSubType((short) 7);
		v2ctextsegment.setNewLineNext(true);
		addTextSegment(v2ctextsegment);
		return i;
	}

	private int endUnorderedList2(int i)
	{
		int j = 5;
		int k = 0;
		int l = i - 1;
		do {
			if (l < 0)
				break;
			char c = clMsg[l];
			if (c != ' ' && c != '\u3000')
				break;
			k++;
			l--;
		} while (true);
		if (i + 5 < nMsgLength && clMsg[i + 5] == ' ')
			j++;
		i -= k;
		j += k;
		boolean flag = i > 0 && clMsg[i - 1] == '\n';
		boolean flag1 = !flag && i + j < nMsgLength - 1;
		if (flag1)
			j--;
		skipMsgChars(i, j);
		if (flag1)
			clMsg[i] = '\n';
		V2CTextSegment v2ctextsegment = new V2CTextSegment(flag ? i - 1 : i, 0x800000);
		v2ctextsegment.setSubType((short) -7);
		if (flag1)
			v2ctextsegment.setNewLineNext(true);
		addTextSegment(v2ctextsegment);
		return i - 1;
	}

	int indexInMsg(String s)
	{
		return indexInMsg(s, 0);
	}

	int indexInMsg(String s, int i)
	{
		if (s == null || s.length() == 0)
			return -1;
		int j = -1;
		int k = s.length();
		int l = nMsgLength - k;
		char c = s.charAt(0);
		char ac[] = clMsg;
		label0: for (int i1 = i; i1 < l; i1++) {
			if (ac[i1] != c)
				continue;
			int j1;
			for (j1 = 1; j1 < k; j1++)
				if (ac[i1 + j1] != s.charAt(j1))
					continue label0;

			if (j1 != k)
				continue;
			j = i1;
			break;
		}

		return j;
	}

	static char toLowerCase(char c)
	{
		if (c >= 'A' && c <= 'Z')
			return (char) (c + 32);
		else
			return c;
	}

	boolean startsWithInMsg(String s, int i)
	{
		if (s == null || s.length() == 0)
			return false;
		int j = s.length();
		if (nMsgLength < i + j)
			return false;
		char ac[] = clMsg;
		for (int k = 0; k < j; k++)
			if (s.charAt(k) != ac[i + k])
				return false;

		return true;
	}

	int skipMsgChars(int i, int j)
	{
		int k = nMsgLength;
		int l = k - (i + j);
		if (l > 0)
			System.arraycopy(clMsg, i + j, clMsg, i, l);
		k -= j;
		nMsgLength = k;
		return k;
	}

	void createNormalTextSegments(boolean flag)
	{
		sortTextSegments();
		V2CTextSegment av2ctextsegment[] = vlTextSegment;
		int i = nTextSegment;
		V2CTextSegment av2ctextsegment1[] = new V2CTextSegment[10];
		vlTextSegment = av2ctextsegment1;
		nTextSegment = 0;
		char ac[] = clMsg;
		boolean flag1 = true;
		boolean flag2 = false;
		int j = 0;
		for (int k = 0; k <= i; k++) {
			V2CTextSegment v2ctextsegment;
			int l;
			if (k < i) {
				v2ctextsegment = av2ctextsegment[k];
				l = v2ctextsegment.getSegmentStartIndex();
			}
			else {
				v2ctextsegment = null;
				l = nMsgLength;
			}
			int i1 = j;
			int j1 = -1;
			for (int k1 = j; k1 < l; k1++) {
				char c = ac[k1];
				if (c == ' ') {
					if (j1 < 0)
						j1 = k1;
					continue;
				}
				if (c == '\n') {
					V2CTextSegment v2ctextsegment1 = new V2CTextSegment(ac, i1, k1, 1);
					addTextSegment(v2ctextsegment1);
					v2ctextsegment1.setNewLineNext(true);
					flag1 = true;
					flag2 = false;
					i1 = k1 + 1;
					continue;
				}
				if (j1 < 0)
					continue;
				if (j1 == i1 && (flag1 || flag2)) {
					addTextSegment(new V2CTextSegment(ac, i1, k1, 0x80000));
					flag1 = false;
					flag2 = false;
					i1 = k1;
				}
				else if (k1 > j1 + 1) {
					addTextSegment(new V2CTextSegment(ac, i1, j1 + 1, 1));
					addTextSegment(new V2CTextSegment(ac, j1 + 1, k1, 0x80000));
					flag1 = false;
					flag2 = false;
					i1 = k1;
				}
				j1 = -1;
			}

			if (i1 < l) {
				if (j1 >= 0 && j1 == i1) {
					if (flag1 || flag2) {
						addTextSegment(new V2CTextSegment(ac, i1, l, 0x80000));
					}
					else {
						addTextSegment(new V2CTextSegment(ac, i1, i1 + 1, 1));
						if (l > i1 + 1)
							addTextSegment(new V2CTextSegment(ac, i1 + 1, l, 0x80000));
					}
				}
				else {
					addTextSegment(new V2CTextSegment(ac, i1, l, 1));
				}
				flag1 = false;
				flag2 = false;
			}
			if (v2ctextsegment == null)
				continue;
			addTextSegment(v2ctextsegment);
			j = v2ctextsegment.getSegmentEndIndex();
			flag1 = false;
			flag2 = j > l && ac[j - 1] == ' ';
			if (j < nMsgLength && ac[j] == '\n') {
				v2ctextsegment.setNewLineNext(true);
				flag1 = true;
				j++;
			}
		}

		if (flag && nTextSegment > 0)
			vlTextSegment[nTextSegment - 1].setNewLineNext(true);
	}

	private void sortTextSegments()
	{
		V2CTextSegment av2ctextsegment[] = vlTextSegment;
		int i = nTextSegment;
		if (i < 2)
			return;
		label0: for (int j = 1; j < i; j++) {
			V2CTextSegment v2ctextsegment = av2ctextsegment[j];
			int k = v2ctextsegment.getSegmentStartIndex();
			int l = j - 1;
			do {
				if (l < 0)
					continue label0;
				V2CTextSegment v2ctextsegment1 = av2ctextsegment[l];
				int i1 = v2ctextsegment1.getSegmentStartIndex();
				if (k >= i1)
					continue label0;
				V2CTextSegment v2ctextsegment2 = av2ctextsegment[l];
				av2ctextsegment[l] = av2ctextsegment[l + 1];
				av2ctextsegment[l + 1] = v2ctextsegment2;
				l--;
			} while (true);
		}

	}

	void addTextSegment(V2CTextSegment v2ctextsegment)
	{
		V2CTextSegment av2ctextsegment[] = vlTextSegment;
		int i = nTextSegment;
		if (i >= av2ctextsegment.length)
			av2ctextsegment = enlargeTextSegmentArray();
		av2ctextsegment[i] = v2ctextsegment;
		nTextSegment = i + 1;
	}

	V2CTextSegment[] enlargeTextSegmentArray()
	{
		V2CTextSegment av2ctextsegment[] = vlTextSegment;
		V2CTextSegment av2ctextsegment1[] = new V2CTextSegment[av2ctextsegment.length * 2];
		System.arraycopy(av2ctextsegment, 0, av2ctextsegment1, 0, av2ctextsegment.length);
		vlTextSegment = av2ctextsegment1;
		return av2ctextsegment1;
	}

	void checkRedundantNewLineNext()
	{
		int i = nTextSegment;
		if (i == 0)
			return;
		V2CTextSegment av2ctextsegment[] = vlTextSegment;
		V2CTextSegment v2ctextsegment = av2ctextsegment[0];
		boolean flag = v2ctextsegment.newLineNext();
		for (int j = 1; j < i; j++) {
			V2CTextSegment v2ctextsegment1 = av2ctextsegment[j];
			boolean flag1 = v2ctextsegment1.newLineNext();
			if (flag1 && flag && v2ctextsegment.getSegmentEndIndex() == v2ctextsegment1.getSegmentStartIndex())
				v2ctextsegment.setNewLineNext(false);
			v2ctextsegment = v2ctextsegment1;
			flag = flag1;
		}

	}

	V2CTextSegment[] getTextSegments()
	{
		return vlTextSegment;
	}

	int getSegmentCount()
	{
		return nTextSegment;
	}

	ArrayList getKeywordRange()
	{
		return alKeywords;
	}

	int[] getDrawOrder()
	{
		int ai[] = ilDrawOrder;
		if (ai == null)
			return null;
		V2CTextSegment av2ctextsegment[] = vlTextSegment;
		int i = nTextSegment;
		if (ai.length != i)
			ai = new int[i];
		for (int j = 0; j < i; j++)
			ai[j] = j;

		int k = -1;
		int l = -1;
		for (int i1 = 0; i1 < i; i1++) {
			V2CTextSegment v2ctextsegment = av2ctextsegment[i1];
			int j1 = v2ctextsegment.getType();
			if (v2ctextsegment.length() == 0 && !v2ctextsegment.newLineNext() || (j1 & 0x80001) == 0)
				continue;
			if (k < 0) {
				if (v2ctextsegment.isRTL())
					k = l = i1;
				continue;
			}
			if (v2ctextsegment.isRTL()) {
				l = i1;
				continue;
			}
			if (!v2ctextsegment.newLineNext()
					&& (j1 == 1 && v2ctextsegment.length() == 1 && v2ctextsegment.charAt(0) == ' ' || j1 == 0x80000))
				continue;
			int k1 = l - k;
			if (k1 > 1) {
				for (int l1 = 0; l1 <= k1; l1++)
					ai[k + l1] = l - l1;

			}
			k = l = -1;
		}

		return ai;
	}

	boolean createKeywordLinkTextSegment(int i, int j, String s)
	{
		return false;
	}

	boolean insertInlineMsgImg(int i, String s)
	{
		return false;
	}

	void removeAllInlineMsgImgs()
	{
	}

	boolean hasKeywords()
	{
		ArrayList arraylist = alKeywords;
		if (arraylist == null || arraylist.size() == 0)
			return false;
		for (int i = arraylist.size() - 1; i >= 0; i--) {
			V2CHighlightRegion v2chighlightregion = (V2CHighlightRegion) arraylist.get(i);
			if (v2chighlightregion == null)
				continue;
			V2CHighlightItem v2chighlightitem = v2chighlightregion.vHighlightItem;
			if (v2chighlightitem != null && !(v2chighlightitem instanceof V2CTextMarkerItem))
				return true;
		}

		return false;
	}

	void setContainKeyword()
	{
		ArrayList arraylist = alKeywords;
		V2CHighlightRegion v2chighlightregion = (V2CHighlightRegion) arraylist.get(0);
		int i = 1;
		int j = arraylist.size();
		synchronized (oTSLockObject) {
			V2CTextSegment av2ctextsegment[] = vlTextSegment;
			int k = nTextSegment;
			label0: for (int l = 0; l < k; l++) {
				V2CTextSegment v2ctextsegment = av2ctextsegment[l];
				if (v2ctextsegment.length() == 0)
					continue;
				int i1 = v2ctextsegment.getSegmentStartIndex();
				int j1 = v2ctextsegment.getSegmentEndIndex();
				do {
					if (j1 <= v2chighlightregion.iBegin)
						continue label0;
					if (i1 < v2chighlightregion.iEnd) {
						v2ctextsegment.setContainKeyword(true);
						continue label0;
					}
					if (i >= j)
						break label0;
					v2chighlightregion = (V2CHighlightRegion) arraylist.get(i++);
				} while (true);
			}

		}
	}

	final int checkKeywordHighlightWeight(V2CKeywordHighlightItem av2ckeywordhighlightitem[], int i)
	{
		return checkKeywordHighlight(av2ckeywordhighlightitem, i, true, false, null, null);
	}

	final int checkKeywordHighlight(V2CKeywordHighlightItem av2ckeywordhighlightitem[], String as[],
			V2CKeywordHighlightItem av2ckeywordhighlightitem1[])
	{
		return checkKeywordHighlight(av2ckeywordhighlightitem, 0, true, true, as, av2ckeywordhighlightitem1);
	}

	final int applyKeywordHighlight(V2CKeywordHighlightItem av2ckeywordhighlightitem[])
	{
		return checkKeywordHighlight(av2ckeywordhighlightitem, 0, false, bName, null, null);
	}

	private final int checkKeywordHighlight(V2CKeywordHighlightItem av2ckeywordhighlightitem[], int i, boolean flag,
			boolean flag1, String as[], V2CKeywordHighlightItem av2ckeywordhighlightitem1[])
	{
		if (av2ckeywordhighlightitem == null || av2ckeywordhighlightitem.length == 0)
			return 0;
		boolean flag2 = bName;
		if (!flag && !flag2)
			removeAllInlineMsgImgs();
		int j = -1;
		String s = null;
		String s1 = null;
		String s2 = null;
		label0: for (int k = 0; k < av2ckeywordhighlightitem.length; k++) {
			V2CKeywordHighlightItem v2ckeywordhighlightitem = av2ckeywordhighlightitem[k];
			if (v2ckeywordhighlightitem == null || !v2ckeywordhighlightitem.isActive())
				continue;
			boolean flag3;
			boolean flag4;
			if (flag) {
				boolean flag5;
				if (flag2)
					flag5 = ((V2CNameKeywordHighlightItem) v2ckeywordhighlightitem).hasSoundOrAvatarName(flag1);
				else
					flag5 = flag1 && v2ckeywordhighlightitem.hasSoundName();
				flag3 = v2ckeywordhighlightitem.getWeight() > (flag5 ? j : i);
				flag4 = av2ckeywordhighlightitem1 != null && v2ckeywordhighlightitem.isTabImageSet()
						&& av2ckeywordhighlightitem1[k] == null;
				if (!flag3 && !flag4)
					continue;
			}
			else {
				if (!v2ckeywordhighlightitem.isDefined())
					continue;
				flag3 = flag4 = false;
			}
			if (v2ckeywordhighlightitem.isRegEx()) {
				Pattern pattern = v2ckeywordhighlightitem.getPattern();
				if (pattern == null)
					continue;
				Matcher matcher = pattern.matcher(this);
				int i1 = 0;
				do {
					if (!matcher.find(i1))
						continue label0;
					int j1 = matcher.start();
					int l1 = matcher.end();
					if (l1 == j1) {
						i1 = l1 + 1;
						if (i1 >= length() - 1)
							continue label0;
					}
					else {
						if (flag) {
							if (flag3) {
								int j2 = v2ckeywordhighlightitem.getWeight();
								if (flag2) {
									V2CNameKeywordHighlightItem v2cnamekeywordhighlightitem1 = (V2CNameKeywordHighlightItem) v2ckeywordhighlightitem;
									String s13 = v2cnamekeywordhighlightitem1.getSoundOrAvatarName(flag1);
									if (s13 != null) {
										s = s13;
										j = j2;
									}
									if (j2 > i)
										i = j2;
								}
								else if (flag1) {
									String s9 = v2ckeywordhighlightitem.getSoundName();
									if (s9 != null) {
										s = s9;
										j = j2;
									}
									if (j2 > i)
										i = j2;
								}
								else {
									i = j2;
								}
							}
							if (flag4)
								av2ckeywordhighlightitem1[k] = v2ckeywordhighlightitem;
							continue label0;
						}
						try {
							String s6 = v2ckeywordhighlightitem.getHREF();
							if (s6 != null) {
								String s10 = V2CMiscUtil.replaceRegEx(matcher, s6);
								if (s10 != null)
									createKeywordLinkTextSegment(j1, l1, s10);
							}
							String s11 = v2ckeywordhighlightitem.getInlineMessageImage();
							if (s11 != null && s11.length() > 0) {
								s11 = V2CMiscUtil.replaceRegEx(matcher, s11);
								insertInlineMsgImg(v2ckeywordhighlightitem.getIMIRight() ? l1 : j1, s11);
							}
						}
						catch (Exception exception1) {
						}
						if (v2ckeywordhighlightitem.isHighlightDefined())
							addHighlightRegion(v2ckeywordhighlightitem, j1, l1);
						v2ckeywordhighlightitem.setApplied();
						i1 = l1;
					}
				} while (true);
			}
			String s3 = v2ckeywordhighlightitem.getWord();
			if (s3 == null || s3.length() == 0)
				continue;
			int l = s3.length();
			if (s1 == null)
				s1 = toString();
			String s4;
			if (v2ckeywordhighlightitem.isCaseSensitive()) {
				s4 = s1;
			}
			else {
				if (s2 == null)
					s2 = V2CMiscUtil.normalizeCase(s1);
				s4 = s2;
			}
			int k1 = 0;
			do {
				if ((k1 = s4.indexOf(s3, k1)) < 0)
					continue label0;
				if (flag) {
					if (flag3) {
						int i2 = v2ckeywordhighlightitem.getWeight();
						if (flag2) {
							V2CNameKeywordHighlightItem v2cnamekeywordhighlightitem = (V2CNameKeywordHighlightItem) v2ckeywordhighlightitem;
							String s12 = v2cnamekeywordhighlightitem.getSoundOrAvatarName(flag1);
							if (s12 != null) {
								s = s12;
								j = i2;
							}
							if (i2 > i)
								i = i2;
						}
						else if (flag1) {
							String s7 = v2ckeywordhighlightitem.getSoundName();
							if (s7 != null) {
								s = s7;
								j = i2;
							}
							if (i2 > i)
								i = i2;
						}
						else {
							i = i2;
						}
					}
					if (flag4)
						av2ckeywordhighlightitem1[k] = v2ckeywordhighlightitem;
					continue label0;
				}
				try {
					String s5 = v2ckeywordhighlightitem.getHREF();
					if (s5 != null)
						createKeywordLinkTextSegment(k1, k1 + l, s5);
					String s8 = v2ckeywordhighlightitem.getInlineMessageImage();
					if (s8 != null && s8.length() > 0)
						insertInlineMsgImg(v2ckeywordhighlightitem.getIMIRight() ? k1 + l : k1, s8);
				}
				catch (Exception exception) {
				}
				if (v2ckeywordhighlightitem.isHighlightDefined())
					addHighlightRegion(v2ckeywordhighlightitem, k1, k1 + l);
				v2ckeywordhighlightitem.setApplied();
				k1 += l;
			} while (true);
		}

		if (flag)
			if (flag2)
				postCheckKeywordHighlight(s, flag1);
			else if (as != null)
				as[0] = s;

		boolean NameString_flg = false;
		int NameStringlen = 9;
		boolean ID_flg = false;
		boolean Mailsage_flg = false;

		String NameString = getNameString();
		if(NameString != null){
			if(NameString.equals("匿名さん")){
				NameString_flg = true;
			}
			NameStringlen = NameString.length();
		}
		NameString = null;
			
		String ID = getID();
		if(ID != null){
			if(ID.equals("???")){
				ID_flg = true;
			}
		}
		ID = null;
		
		String Mail = getMail();
		if(Mail != null){
			if (Mail.equals("sage") || Mail.equals("↓")){
				Mailsage_flg = true;
			}
		}
		Mail = null;
		
		if(
			(NameString_flg && ID_flg) ||
			(NameStringlen <= 8 && ID_flg && !Mailsage_flg)
		){
			isBakusai = true;
		}

		if(useColorEmoji == 0){
			if (V2CApp.javaVersionEqualOrGreaterThan(1, 7)){
				// Java7 以降
				V2CTextSegmentRedit.OverJava7(vlTextSegment, isBakusai);
			}else{
				// Java6 以前
				V2CTextSegmentRedit.UnderJava6(vlTextSegment, isBakusai);
			}
		}else if(useColorEmoji == 1){ 
		}else if(useColorEmoji == -1){ 
			File v2cDir = V2CLocalFileHandler.v2cDir;
			if((new File(v2cDir, "msgkw.txt")).exists() && (new File(v2cDir, "icon/message")).exists()){
				useColorEmoji = 0;
				System.out.println("B11 Use Color Emoji");
				if (V2CApp.javaVersionEqualOrGreaterThan(1, 7)){
					// Java7 以降
					V2CTextSegmentRedit.OverJava7(vlTextSegment, isBakusai);
				}else{
					// Java6 以前
					V2CTextSegmentRedit.UnderJava6(vlTextSegment, isBakusai);
				}
			}else{
				useColorEmoji = 1;
				System.out.println("B11 Not Use Color Emoji");
			}
		}
		
		return i;
	}
	
	void postCheckKeywordHighlight(String s, boolean flag)
	{
	}

	void addHighlightRegion(V2CHighlightItem v2chighlightitem, int i, int j)
	{
		ArrayList arraylist = alKeywords;
		if (arraylist == null) {
			arraylist = new ArrayList();
			alKeywords = arraylist;
		}
		int k = 0;
		for (int l = 0; l < arraylist.size(); l++) {
			V2CHighlightRegion v2chighlightregion = (V2CHighlightRegion) arraylist.get(l);
			int i1 = v2chighlightregion.iBegin;
			if (k <= i && j <= i1) {
				arraylist.add(l, new V2CHighlightRegion(v2chighlightitem, i, j));
				return;
			}
			k = v2chighlightregion.iEnd;
			if (k <= i)
				continue;
			if (i < i1)
				arraylist.add(l++, new V2CHighlightRegion(v2chighlightitem, i, i1));
			if (j <= k)
				return;
			i = k;
		}

		if (i < j)
			arraylist.add(new V2CHighlightRegion(v2chighlightitem, i, j));
	}

	protected void resetHighlight0()
	{
		bHighlightChecked = false;
		if (alKeywords != null)
			alKeywords.clear();
		V2CTextSegment av2ctextsegment[] = vlTextSegment;
		synchronized (oTSLockObject) {
			removeVirtualTags();
			for (int i = nTextSegment - 1; i >= 0; i--)
				av2ctextsegment[i].setContainKeyword(false);

		}
	}

	private void removeVirtualTags()
	{
		if (!bVirtualTagInserted)
			return;
		int i = nTextSegment;
		V2CTextSegment av2ctextsegment[] = vlTextSegment;
		int j = 0;
		V2CTextSegment v2ctextsegment = null;
		for (int k = 0; k < i; k++) {
			V2CTextSegment v2ctextsegment1 = av2ctextsegment[k];
			int l = v2ctextsegment1.getSubType();
			if (v2ctextsegment1.getType() != 0x800000 || l < 1024 && l > -1024) {
				v2ctextsegment = v2ctextsegment1;
				if (j < k)
					av2ctextsegment[j] = v2ctextsegment1;
				j++;
				continue;
			}
			if (!v2ctextsegment1.newLineNext())
				continue;
			if (v2ctextsegment != null)
				v2ctextsegment.setNewLineNext(true);
			else
				System.out.println("tsp==null: " + k);
		}

		if (j < i) {
			V2CTextSegment av2ctextsegment1[] = new V2CTextSegment[j];
			System.arraycopy(av2ctextsegment, 0, av2ctextsegment1, 0, j);
			vlTextSegment = av2ctextsegment1;
			nTextSegment = j;
		}
		bVirtualTagInserted = false;
	}

	void replaceSegmentString(int i, V2CTextSegment v2ctextsegment, String s)
	{
		V2CTextSegment av2ctextsegment[] = vlTextSegment;
		if (nTextSegment <= i || av2ctextsegment[i] != v2ctextsegment)
			return;
		char ac[] = clMsg;
		int j = nMsgLength;
		boolean flag = false;
		int k = v2ctextsegment.getSegmentStartIndex();
		int l = v2ctextsegment.length();
		int i1 = s.length();
		int j1 = i1 - l;
		if (j1 != 0) {
			if (j + j1 > ac.length) {
				flag = true;
				char ac1[] = new char[j + j1];
				System.arraycopy(ac, 0, ac1, 0, j);
				clMsg = ac = ac1;
			}
			System.arraycopy(ac, k + l, ac, k + i1, j - k - l);
			nMsgLength += j1;
		}
		s.getChars(0, i1, ac, k);
		if (j1 == 0)
			return;
		for (int k1 = nTextSegment - 1; k1 >= 0; k1--) {
			V2CTextSegment v2ctextsegment1 = av2ctextsegment[k1];
			if (flag)
				v2ctextsegment1.setCharArray(ac);
			if (k1 > i)
				v2ctextsegment1.setSegmentStartIndex(v2ctextsegment1.getSegmentStartIndex() + j1);
		}

		v2ctextsegment.forceSetLength(i1);
	}

	public int length()
	{
		return nMsgLength;
	}

	public char charAt(int i)
	{
		return clMsg[i];
	}

	public CharSequence subSequence(int i, int j)
	{
		return new V2CCharSequence(clMsg, i, j);
	}

	public String toString()
	{
		return new String(clMsg, 0, nMsgLength);
	}

	static final int TAG_COMMENT = 1;
	static final int TAG_HR = 2;
	static final int TAG_BOLD = 3;
	static final int TAG_BOLD_END = 4;
	static final int TAG_ITALIC = 5;
	static final int TAG_ITALIC_END = 6;
	static final int TAG_FONT = 7;
	static final int TAG_FONT_END = 8;
	static final int TAG_UNORDEREDLIST = 9;
	static final int TAG_UNORDEREDLIST_END = 10;
	static final int TAG_P = 11;
	static final int TAG_BQ = 12;
	static final int TAG_P_END = 13;
	static final int TAG_BQ_END = 14;
	private static final boolean bHideUnprocessedTags = false;
	static final HashMap hmEntity;
	static final String slEntity[] = { "nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy",
			"ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot",
			"cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde",
			"Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH",
			"Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml",
			"Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave",
			"eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc",
			"otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml", "fnof",
			"Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Iota", "Kappa", "Lambda", "Mu", "Nu", "Xi",
			"Omicron", "Pi", "Rho", "Sigma", "Tau", "Upsilon", "Phi", "Chi", "Psi", "Omega", "alpha", "beta", "gamma", "delta",
			"epsilon", "zeta", "eta", "theta", "iota", "kappa", "lambda", "mu", "nu", "xi", "omicron", "pi", "rho", "sigmaf",
			"sigma", "tau", "upsilon", "phi", "chi", "psi", "omega", "thetasym", "upsih", "piv", "bull", "hellip", "prime",
			"Prime", "oline", "frasl", "weierp", "image", "real", "trade", "alefsym", "larr", "uarr", "rarr", "darr", "harr",
			"crarr", "lArr", "uArr", "rArr", "dArr", "hArr", "forall", "part", "exist", "empty", "nabla", "isin", "notin", "ni",
			"prod", "sum", "minus", "lowast", "radic", "prop", "infin", "ang", "and", "or", "cap", "cup", "int", "there4", "sim",
			"cong", "asymp", "ne", "equiv", "le", "ge", "sub", "sup", "nsub", "sube", "supe", "oplus", "otimes", "perp", "sdot",
			"lceil", "rceil", "lfloor", "rfloor", "lang", "rang", "loz", "spades", "clubs", "hearts", "diams", "quot", "amp",
			"lt", "gt", "OElig", "oelig", "Scaron", "scaron", "Yuml", "circ", "tilde", "ensp", "emsp", "thinsp", "zwnj", "zwj",
			"lrm", "rlm", "ndash", "mdash", "lsquo", "rsquo", "sbquo", "ldquo", "rdquo", "bdquo", "dagger", "Dagger", "permil",
			"lsaquo", "rsaquo", "euro" };
	static final char clEntity[] = { '\240', '\241', '\242', '\243', '\244', '\245', '\246', '\247', '\250', '\251', '\252',
			'\253', '\254', '\255', '\256', '\257', '\260', '\261', '\262', '\263', '\264', '\265', '\266', '\267', '\270',
			'\271', '\272', '\273', '\274', '\275', '\276', '\277', '\300', '\301', '\302', '\303', '\304', '\305', '\306',
			'\307', '\310', '\311', '\312', '\313', '\314', '\315', '\316', '\317', '\320', '\321', '\322', '\323', '\324',
			'\325', '\326', '\327', '\330', '\331', '\332', '\333', '\334', '\335', '\336', '\337', '\340', '\341', '\342',
			'\343', '\344', '\345', '\346', '\347', '\350', '\351', '\352', '\353', '\354', '\355', '\356', '\357', '\360',
			'\361', '\362', '\363', '\364', '\365', '\366', '\367', '\370', '\371', '\372', '\373', '\374', '\375', '\376',
			'\377', '\u0192', '\u0391', '\u0392', '\u0393', '\u0394', '\u0395', '\u0396', '\u0397', '\u0398', '\u0399', '\u039A',
			'\u039B', '\u039C', '\u039D', '\u039E', '\u039F', '\u03A0', '\u03A1', '\u03A3', '\u03A4', '\u03A5', '\u03A6',
			'\u03A7', '\u03A8', '\u03A9', '\u03B1', '\u03B2', '\u03B3', '\u03B4', '\u03B5', '\u03B6', '\u03B7', '\u03B8',
			'\u03B9', '\u03BA', '\u03BB', '\u03BC', '\u03BD', '\u03BE', '\u03BF', '\u03C0', '\u03C1', '\u03C2', '\u03C3',
			'\u03C4', '\u03C5', '\u03C6', '\u03C7', '\u03C8', '\u03C9', '\u03D1', '\u03D2', '\u03D6', '\u2022', '\u2026',
			'\u2032', '\u2033', '\u203E', '\u2044', '\u2118', '\u2111', '\u211C', '\u2122', '\u2135', '\u2190', '\u2191',
			'\u2192', '\u2193', '\u2194', '\u21B5', '\u21D0', '\u21D1', '\u21D2', '\u21D3', '\u21D4', '\u2200', '\u2202',
			'\u2203', '\u2205', '\u2207', '\u2208', '\u2209', '\u220B', '\u220F', '\u2211', '\u2212', '\u2217', '\u221A',
			'\u221D', '\u221E', '\u2220', '\u2227', '\u2228', '\u2229', '\u222A', '\u222B', '\u2234', '\u223C', '\u2245',
			'\u2248', '\u2260', '\u2261', '\u2264', '\u2265', '\u2282', '\u2283', '\u2284', '\u2286', '\u2287', '\u2295',
			'\u2297', '\u22A5', '\u22C5', '\u2308', '\u2309', '\u230A', '\u230B', '\u2329', '\u232A', '\u25CA', '\u2660',
			'\u2663', '\u2665', '\u2666', '"', '&', '<', '>', '\u0152', '\u0153', '\u0160', '\u0161', '\u0178', '\u02C6',
			'\u02DC', '\u2002', '\u2003', '\u2009', '\u200C', '\u200D', '\u200E', '\u200F', '\u2013', '\u2014', '\u2018',
			'\u2019', '\u201A', '\u201C', '\u201D', '\u201E', '\u2020', '\u2021', '\u2030', '\u2039', '\u203A', '\u20AC' };
	final boolean bName;
	V2CTextSegment vlTextSegment[];
	int nTextSegment;
	int ilDrawOrder[];
	final Object oTSLockObject = new byte[0];
	char clMsg[];
	int nMsgLength;
	boolean bCommentTag;
	boolean bVirtualTagInserted;
	ArrayList alKeywords;
	boolean bHighlightChecked;
	static int useColorEmoji = -1;

	static {
		hmEntity = new HashMap();
		int i = slEntity.length;
		if (i != clEntity.length) {
			System.out.println("Error in Entity Array !");
			V2CApp.immediateExit(1);
		}
		for (int j = 0; j < i; j++)
			hmEntity.put(slEntity[j], new Character(clEntity[j]));

	}

	boolean isBakusai = false;
	String getNameString()
	{
		return null;
	}
	String getID()
	{
		return null;
	}
	String getAuxString()
	{
		return null;
	}
	byte getNanasi()
	{
		byte Nanasi = 0;
		return Nanasi;
	}
	String getMail()
	{
		return null;
	}
}
