package org.monazilla.v2c;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

public class V2CGetMovieThumb extends HttpURLConnection
{
	public static String ffmpegCmd = "ffmpeg -i #input# -ss 0 -t 0.1 -f image2 -vcodec mjpeg -qscale 1 -qmin 1 -qmax 1 -r 1 -loglevel quiet -y #output#.jpg";

	protected V2CGetMovieThumb(URL arg0, String paramString1, String paramString2) {
		super(arg0);
		// TODO 自動生成されたコンストラクター・スタブ
		url = arg0;

		String surl = getURL().toString().replaceAll(":[^/][^:]+$", "");

		long ltime = System.currentTimeMillis();
		long r = (int) (Math.random() * 100000);
		String ifn = getURL().getHost() + "_" + r + "_" + ltime;
		String ext = "%d.jpg";
		boolean isJPEG = true;
		if(V2CHttpUtil.CreateMovieThumb_ffmpeg.endsWith(".gif")){
			ext = ".gif";
			isJPEG = false;
		}
		String ofn = getURL().getHost() + "_" + r + "_" + ltime + ".output" + ext;
		File tmpffmpeg = new File(new File(V2CLocalFileHandler.v2cDir, "tmp"), "ffmpeg");
		if(!tmpffmpeg.exists()){
			tmpffmpeg.mkdir();
		}
		File input = new File(tmpffmpeg, ifn);
		File output = new File(tmpffmpeg, ofn);
		sinput = input.getAbsolutePath();
		soutput = output.getAbsolutePath(); 

		URL murl = null;
		HashMap paramHashMap = new HashMap();
		paramHashMap.put("Range", "bytes=0-1258291");
		OutputStream paramOutputStream = null;;
		try {
			murl = new URL(surl);
			paramOutputStream = new FileOutputStream(input);
			boolean b = V2CHttpUtil.getMovieFile(murl, paramString1, paramString2, paramOutputStream, paramHashMap, 3);
		} catch (MalformedURLException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
		} catch (FileNotFoundException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
		} catch (IOException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
		}
		paramHashMap = null;
		try {
			paramOutputStream.close();
		} catch (IOException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
		}
		paramOutputStream = null;
		
		String wcmd = "";
		String addStr = "";
		if(input.length() != 0){
			wcmd = V2CHttpUtil.CreateMovieThumb_ffmpeg
					.replaceAll(" ", "\t")
					.replace("#input#", input.getAbsolutePath())
					.replace("#output#" + (isJPEG?".jpg":".gif"), output.getAbsolutePath());
			V2CHttpUtil.CreateMovieThumb_ffmpeg_path = V2CGetContainerOfAnimTools.ffmpeg();
			if(V2CHttpUtil.CreateMovieThumb_ffmpeg_path.length() != 0 && !V2CHttpUtil.CreateMovieThumb_ffmpeg_path.equals(V2CGetContainerOfAnimTools.sDefaultPathTo)){
				wcmd = V2CHttpUtil.CreateMovieThumb_ffmpeg_path + V2CLocalFileHandler.sFileSeparator + wcmd;
			}
			if(V2CHttpUtil.CreateMovieThumb_ffmpeg_path.equals(V2CGetContainerOfAnimTools.sDefaultPathTo)){
				addStr = V2CHttpUtil.CreateMovieThumb_ffmpeg_path;
			}
			String cmdArray[] = wcmd.split("\t");
			if(V2CApp.isMacintosh() || V2CApp.isLinux()){
				for(int i=0; i<cmdArray.length; i++){
					cmdArray[i] = (""+cmdArray[i]).replaceAll("\"", "");
				}
			}
			
			Runtime runtime = Runtime.getRuntime();
			Process p = null;
			try {
				p = runtime.exec(cmdArray);
			} catch (IOException e) {
				e.printStackTrace();
			}
			try {
				p.waitFor();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			runtime = null;
			cmdArray = null;
			p = null;
			
			output = new File(tmpffmpeg, ofn.replace(".output%d.jpg", ".output1.jpg"));
			if(output.exists()){
				try {
					FileInputStream inputStream = new FileInputStream(output);
					ByteArrayOutputStream baos = new ByteArrayOutputStream();
					byte[] buffer = new byte[2048];
					while(true) {
						int len = inputStream.read(buffer);
						if(len < 0) {
							break;
						}
						baos.write(buffer, 0, len);
					}
					baos.flush();
					byte[] imageInByte = baos.toByteArray();
					setContentLength(imageInByte.length);
					inputStream.close();
					baos.close();
					localInputStream = new ByteArrayInputStream(imageInByte);
					buffer = null;
					inputStream = null;
					baos = null;
					imageInByte = null;
				} catch (IOException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
				}
			}else{
				addStr = "(ffmpeg Convert Error)";
			}
		}else{
			addStr = "(Download Error)";
		}

		if(localInputStream != null){
			setResponseCode(200);
			setResponseMessage("Successful creation of thumbnail of " + url.toString());
		}else{
			setResponseCode(503);
			setResponseMessage("Failed" + addStr + " to create thumbnail of " + url.toString());
			setContentLength(-1);
		}

		setLocation(null);
		setContentType("image/" + (isJPEG?"jpeg":"gif"));
		setContentEncoding(null);
		setRExpiration(0);
		setDate(ltime);
		setLastModified(ltime);
		
		if(V2CHttpUtil.CreateMovieThumbShowCmd){
			System.out.println("ffmpegコマンド(デバッグ用)=\n" + wcmd.replaceAll("\t", " ").replaceAll(" -loglevel quiet", ""));
		}

		new Thread(new Runnable() {
			public void run() {
				try {
					Thread.sleep(3000L);
				} catch (InterruptedException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
				}
				if(!V2CHttpUtil.CreateMovieThumbShowCmd && (new File(sinput)).exists()){
					(new File(sinput)).delete();
				}
				if((new File(soutput)).exists()) (new File(soutput)).delete();
			}
		}).start();
	}

	@Override
	public void disconnect() {
		// TODO 自動生成されたメソッド・スタブ		
	}

	@Override
	public boolean usingProxy() {
		// TODO 自動生成されたメソッド・スタブ
		return false;
	}

	@Override
	public void connect() throws IOException {
		// TODO 自動生成されたメソッド・スタブ		
	}

	public URL getURL(){
		return url;
	}
	
	private void setResponseCode(int i){
		nResponseCode = i;
	}
	public int getResponseCode(){
		return nResponseCode;
	}

	private void setResponseMessage(String s){
		sResponseMessage = s;
	}
	public String getResponseMessage(){
		return sResponseMessage;
	}

	private void setLocation(String s){
		sLocation = s;
	}
	public String getLocation(){
		return sLocation;
	}

	private void setContentLength(int i){
		nContentLength = i;
	}
	public int getContentLength(){
		return nContentLength;
	}

	private void setContentType(String s){
		sContentType = s;
	}
	public String getContentType(){
		return sContentType;
	}

	private void setContentEncoding(String s){
		sContentEncoding = s;
	}
	public String getContentEncoding(){
		return sContentEncoding;
	}

	private void setRExpiration(long l){
		lExpiration = l;
	}
	public long getRExpiration(){
		return lExpiration;
	}

	private void setDate(long l){
		lDate = l;
	}
	public long getDate(){
		return lDate;
	}

	private void setLastModified(long l){
		lLastModified = l;
	}
	public long getLastModified(){
		return lLastModified;
	}

	public InputStream getInputStream(){
		return localInputStream;
		
	}

	URL url;
	int nResponseCode;
	String sResponseMessage;
	String sLocation;
	int nContentLength;
	String sContentType;
	String sContentEncoding;
	long lExpiration;
	long lDate;
	long lLastModified;
	InputStream localInputStream = null;
	
	String sinput = "";
	String soutput = "";
	
}
