package org.monazilla.v2c;

import java.security.AccessControlContext;
import java.security.PrivilegedExceptionAction;

public class V2CGetDatScript extends V2CSystemScript
{

	private static V2CGetDatScript getInstance()
	{
		if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5))
			return null;
		if (!bLoadTried) {
			bLoadTried = true;
			vGetDatScript = (V2CGetDatScript) V2CScriptUtil.createSystemScript("getdat.js");
		}
		return vGetDatScript;
	}

	static void reload()
	{
		if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5))
			return;
		V2CGetDatScript v2cgetdatscript = vGetDatScript;
		if (v2cgetdatscript != null) {
			v2cgetdatscript.stop();
			vGetDatScript = null;
		}
		V2CScriptUtil.printMessage("getdat.jsを読み込んでいます…");
		bLoadTried = false;
		v2cgetdatscript = getInstance();
		V2CScriptUtil.printMessage("getdat.jsを読み込"
				+ (v2cgetdatscript == null ? "めませんでした。"
						: "みました。"));
	}

	static V2CGetDatScript createGetDatScript(String s, V2CScriptClassLoader v2cscriptclassloader,
			AccessControlContext accesscontrolcontext)
	{
		V2CScriptApp v2cscriptapp = new V2CScriptApp("getdat.js");
		String s1 = null;
		PrivilegedExceptionAction privilegedexceptionaction = null;
		try {
			privilegedexceptionaction = V2CJSE6Util.createScriptAction("JavaScript", s, v2cscriptapp, v2cscriptclassloader,
					accesscontrolcontext, false);
		}
		catch (Exception exception) {
			s1 = exception.getMessage();
		}
		if (privilegedexceptionaction == null) {
			V2CScriptUtil
					.setErrorMessage(s1 == null ? "アクションの作成に失敗しました。"
							: s1);
			return null;
		}
		else {
			V2CGetDatScript v2cgetdatscript = new V2CGetDatScript(privilegedexceptionaction, v2cscriptapp, v2cscriptclassloader,
					accesscontrolcontext);
			v2cgetdatscript.exec();
			return v2cgetdatscript;
		}
	}

	static Object getDat(V2CThreadPanel v2cthreadpanel)
	{
		if (v2cthreadpanel == null)
			return null;
		V2CGetDatScript v2cgetdatscript = getInstance();
		if (v2cgetdatscript == null)
			return null;
		else
			return v2cgetdatscript.getDat(V2CScriptThread.createScriptThread(v2cthreadpanel));
	}

	private V2CGetDatScript(PrivilegedExceptionAction privilegedexceptionaction, V2CScriptApp v2cscriptapp,
			V2CScriptClassLoader v2cscriptclassloader, AccessControlContext accesscontrolcontext)
	{
		super(privilegedexceptionaction, v2cscriptapp, v2cscriptclassloader, accesscontrolcontext);
	}

	synchronized Object getDat(V2CScriptThread v2cscriptthread)
	{
		if (bReloading) {
			return null;
		}
		else {
			V2CJSE6Util.setInvokeFunction(vPrivilegedExceptionAction, "getDat", new Object[] { v2cscriptthread });
			return exec();
		}
	}

	static final String sScriptFileName = "getdat.js";
	private static boolean bLoadTried;
	private static V2CGetDatScript vGetDatScript;
}
