package org.monazilla.v2c;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class V2CExtCommandSP extends JPanel {
	static int nLastSelectedIndex;
	JTabbedPane jTabbedPane;
	final V2CMiscExtCommandSP vMiscExtCommandSP;
	final V2CURLCommandSP vURLCommandSP;
	V2CAPISettings apiSettings = new V2CAPISettings();
	V2CAPISettings2 apiSettings2 = new V2CAPISettings2();
	V2CAPISettings3 apiSettings3 = new V2CAPISettings3();
	V2CAPISettings3Plus apiSettings3Plus = new V2CAPISettings3Plus();
	V2CAPISettings4 apiSettings4 = new V2CAPISettings4();
	V2CAPISettings5 apiSettings5 = new V2CAPISettings5();
	V2CAPISettings6 apiSettings6 = new V2CAPISettings6();
	V2CAPISettings7 apiSettings7 = new V2CAPISettings7();
	V2CScriptSP vScriptSP;

	static void setExtCommand() {
		V2CExtCommandSP localV2CExtCommandSP = new V2CExtCommandSP();
		localV2CExtCommandSP.showDialog();
	}

	public V2CExtCommandSP() {
		super(new GridBagLayout());
		GridBagConstraints localGridBagConstraints = V2CSwingUtil
				.createGridBagConstraints();
		localGridBagConstraints.insets = new Insets(1, 1, 1, 1);
		JTabbedPane localJTabbedPane = new JTabbedPane();
		this.jTabbedPane = localJTabbedPane;
		localJTabbedPane.setFocusable(false);
		this.vMiscExtCommandSP = new V2CMiscExtCommandSP();
		localJTabbedPane.addTab("一般", this.vMiscExtCommandSP);
		this.vURLCommandSP = new V2CURLCommandSP();
		localJTabbedPane.addTab("ブラウザ", this.vURLCommandSP);
		if (V2CApp.javaVersionEqualOrGreaterThan(1, 5)) {
			this.vScriptSP = V2CScriptUtil.createScriptSP();
			localJTabbedPane.addTab("スクリプト", this.vScriptSP.getPanel());
		}
		localJTabbedPane.addTab("API設定", this.apiSettings.getPanel());
		localJTabbedPane.addTab("API設定2", this.apiSettings2.getPanel());
		localJTabbedPane.addTab("API設定3", this.apiSettings4.getPanel());
		localJTabbedPane.addTab("API設定4", this.apiSettings3.getPanel());
		localJTabbedPane.addTab("API設定4+", this.apiSettings3Plus.getPanel());
		localJTabbedPane.addTab("API設定5", this.apiSettings5.getPanel());
		localJTabbedPane.addTab("API設定6", this.apiSettings6.getPanel());
		localJTabbedPane.addTab("API設定7", this.apiSettings7.getPanel());
		localJTabbedPane.setSelectedIndex(nLastSelectedIndex);
		localGridBagConstraints.weightx = 1.0D;
		localGridBagConstraints.weighty = 1.0D;
		localGridBagConstraints.fill = 1;
		add(localJTabbedPane, localGridBagConstraints);
	}

	void showDialog() {
		this.vMiscExtCommandSP.beforeConfig();
		try {
			if (!V2CSwingUtil.showOKCancelDialog(this, "外部コマンドの設定"))
				return;
		} finally {
			this.vMiscExtCommandSP.afterConfig();
		}
		this.vMiscExtCommandSP.saveChange();
		this.vURLCommandSP.saveChange();
		if (this.vScriptSP != null)
			this.vScriptSP.postConfig();
		this.apiSettings.saveChanges();
		nLastSelectedIndex = this.jTabbedPane.getSelectedIndex();
	}
	public void beforeConfig() {
		this.vMiscExtCommandSP.beforeConfig();
	}
	public void afterConfig() {
		this.vMiscExtCommandSP.afterConfig();
	}
	void applyChanges() {
		this.vMiscExtCommandSP.saveChange();
		this.vURLCommandSP.saveChange();
		if (this.vScriptSP != null)
			this.vScriptSP.postConfig();
		nLastSelectedIndex = this.jTabbedPane.getSelectedIndex();
		this.apiSettings.saveChanges();
	}
}