package org.monazilla.v2c;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class V2CCookie
{

	static Object getBeLoginMonitor()
	{
		sDMDMValue = sMDMDValue = null;
		return vBeLoginMonitor;
	}

	static boolean hasHAP(boolean paramBoolean)
	{
		ArrayList localArrayList = alCookieList;
		synchronized (localArrayList) {
			for (int i = localArrayList.size() - 1; i >= 0; i--) {
				V2CCookie localV2CCookie = (V2CCookie) localArrayList.get(i);
				String str1 = localV2CCookie.sName;
				if ((str1 != null) && (str1.equals("HAP"))) {
					URL localURL = localV2CCookie.uURL;
					if (localURL != null) {
						String str2 = localURL.getHost().toLowerCase();
						if (str2.endsWith(paramBoolean ? ".bbspink.com" : (V2CHttpUtil.Use5chNet?".5ch.net":".2ch.net"))) {
							return true;
						}
					}
				}
			}
		}
		return false;
	}

	static void discardHAP(boolean flag)
	{
		ArrayList arraylist = alCookieList;
		synchronized (arraylist) {
			boolean flag1 = false;
			for (int i = arraylist.size() - 1; i >= 0; i--) {
				V2CCookie v2ccookie = (V2CCookie) arraylist.get(i);
				String s = v2ccookie.sName;
				if (s == null || !s.equals("HAP"))
					continue;
				URL url = v2ccookie.uURL;
				if (url == null)
					continue;
				String s1 = url.getHost().toLowerCase();
				if (s1.endsWith(flag ? ".bbspink.com" : (V2CHttpUtil.Use5chNet?".5ch.net":".2ch.net"))) {
					flag1 = true;
					arraylist.remove(i);
				}
			}

			if (flag1) {
				bChanged = true;
				saveCookies();
			}
		}
	}

	static void addCookie(String paramString, URL paramURL)
	{
		if(paramURL.toString().equals("https://donguri.5ch.net/auth")){
			if(paramString.indexOf("acorn=") == 0 && paramString.indexOf("Max-Age=") == -1){
				paramString += "; Max-Age=432000; Path=/";
			}
		}
		restoreCookies();
		V2CCookie localV2CCookie = new V2CCookie(paramString, paramURL, null);
		if (!localV2CCookie.isValid()) {
			localV2CCookie.printErrorMessage();
			return;
		}
		if (!localV2CCookie.miscCheck()) {
			return;
		}
		if ((localV2CCookie.sDomain.endsWith((V2CHttpUtil.Use5chNet?".5ch.net":".2ch.net"))) && (localV2CCookie.sPath.equals("/"))) {
			if (localV2CCookie.sName.equals("DMDM")) {
				sDMDMValue = localV2CCookie.sValue;
				return;
			}
			if (localV2CCookie.sName.equals("MDMD")) {
				sMDMDValue = localV2CCookie.sValue;
				return;
			}
		}
		if(localV2CCookie.sName.equals("tako") || localV2CCookie.sName.equals("TAKO")){
			V2CSwingUtil.showWarningMessage("この書き込みに対してcookieで TAKO=ODORI が返されました\nこのcookieは保存しません\n可能ならばBBx規制回避のためIPアドレスを変更して下さい");
			return;
		}
		bChanged = true;
		int i = (localV2CCookie.bMaxAge) && (localV2CCookie.nMaxAge == 0) ? 1 : 0;
		ArrayList localArrayList = alCookieList;
		synchronized (localArrayList) {
			for (int j = 0; j < localArrayList.size(); j++) {
				if (localV2CCookie.matches((V2CCookie) localArrayList.get(j))) {
					if (i != 0) {
						localArrayList.remove(j);
					}
					else {
						localArrayList.set(j, localV2CCookie);
					}
					return;
				}
			}
			if (i == 0) {
				localArrayList.add(localV2CCookie);
			}
		}
	}

	static void removeCookie(String s, String s1, String s2)
	{
		restoreCookies();
		ArrayList arraylist = alCookieList;
		synchronized (arraylist) {
			for (int i = 0; i < arraylist.size(); i++) {
				V2CCookie v2ccookie = (V2CCookie) arraylist.get(i);
				if (v2ccookie.matches(s, (s1==".2ch.net"?(V2CHttpUtil.Use5chNet?".5ch.net":".2ch.net"):s1), s2)) {
					bChanged = true;
					arraylist.remove(i--);
				}
			}

		}
	}

	static String getOneCookieValue(String paramString1, String paramString2, String paramString3)
	{
		restoreCookies();
		ArrayList localArrayList = alCookieList;
		synchronized (localArrayList) {
			for (int i = 0; i < localArrayList.size(); i++) {
				V2CCookie localV2CCookie = (V2CCookie) localArrayList.get(i);
				if (localV2CCookie.matches(paramString1, (paramString2==".2ch.net"?(V2CHttpUtil.Use5chNet?".5ch.net":".2ch.net"):paramString2), paramString3)) {
					return localV2CCookie.sValue;
				}
			}
		}
		return null;
	}

	static String getCookie(URL url)
	{
		return getCookie(url, null);
	}

	static String getCookie(URL url, V2CBeIDListItem v2cbeidlistitem)
	{
		restoreCookies();
		ArrayList arraylist = alCookieList;
		if (arraylist.size() == 0)
			return null;
		ArrayList arraylist1 = new ArrayList();
		synchronized (arraylist) {
			long l = System.currentTimeMillis();
			for (int i1 = 0; i1 < arraylist.size(); i1++) {
				V2CCookie v2ccookie3 = (V2CCookie) arraylist.get(i1);
				if (v2ccookie3.ltExpires > 0L && v2ccookie3.ltExpires < l) {
					bChanged = true;
					arraylist.remove(i1--);
					continue;
				}
				String s = v2ccookie3.sName;
				if (s.equals("DMDM") || s.equals("MDMD") || !v2ccookie3.applicableTo(url))
					continue;
				int j1 = 0;
				do {
					if (j1 >= arraylist1.size())
						break;
					if (v2ccookie3.compareTo((V2CCookie) arraylist1.get(j1)) >= 0) {
						arraylist1.add(j1, v2ccookie3);
						v2ccookie3 = null;
						break;
					}
					j1++;
				} while (true);
				if (v2ccookie3 != null)
					arraylist1.add(v2ccookie3);
			}

		}
		boolean flag = false;
		int i = arraylist1.size() - 1;
		do {
			if (i < 0)
				break;
			V2CCookie v2ccookie = (V2CCookie) arraylist1.get(i);
			if (v2ccookie.isValid() && v2ccookie.sName.equalsIgnoreCase("HAP")
					&& (v2ccookie.sDomain.equalsIgnoreCase((V2CHttpUtil.Use5chNet?".5ch.net":".2ch.net")) || v2ccookie.sDomain.equalsIgnoreCase(".bbspink.com"))
					&& v2ccookie.sPath.equals("/")) {
				flag = true;
				break;
			}
			i--;
		} while (true);
		if (flag) {
			for (int j = arraylist1.size() - 2; j >= 0; j--) {
				V2CCookie v2ccookie1 = (V2CCookie) arraylist1.get(j);
				if (v2ccookie1.isValid()
						&& v2ccookie1.sName.equalsIgnoreCase("HAP")
						&& (v2ccookie1.sDomain.length() > 8 && v2ccookie1.sDomain.endsWith((V2CHttpUtil.Use5chNet?".5ch.net":".2ch.net")) || v2ccookie1.sDomain
								.length() > 12 && v2ccookie1.sDomain.endsWith(".bbspink.com")) && v2ccookie1.sPath.equals("/")) {
					arraylist1.remove(j);
					arraylist1.add(v2ccookie1);
				}
			}

		}
		StringBuffer stringbuffer = new StringBuffer();
		for (int k = 0; k < arraylist1.size(); k++) {
			V2CCookie v2ccookie2 = (V2CCookie) arraylist1.get(k);
			if(v2ccookie2.sValue.length() != 0){
				stringbuffer.append(v2ccookie2.sName + '=' + v2ccookie2.sValue + "; ");
			}
		}

		if (v2cbeidlistitem != null)
			stringbuffer.append("DMDM=" + v2cbeidlistitem.sDMDM + "; " + "MDMD" + '=' + v2cbeidlistitem.sMDMD + "; ");
		return stringbuffer.length() <= 0 ? null : stringbuffer.substring(0, stringbuffer.length() - 2);
	}

	static synchronized void restoreCookies()
	{
		if (bRestored)
			return;
		bRestored = true;
		BufferedReader bufferedreader = V2CLocalFileHandler.getUserSaveFileReader("cookie.txt");
		if (bufferedreader == null)
			return;
		try {
			do {
				String s;
				if ((s = bufferedreader.readLine()) == null)
					break;
				if (s.length() == 0 || s.charAt(0) == '#')
					continue;
				String s1 = null;
				int i = 0;
				char c = s.charAt(0);
				if (c >= '0' && c <= '9') {
					i = s.indexOf('\t');
					if (i < 0)
						continue;
					s1 = s.substring(0, i);
					i++;
				}
				int j = s.indexOf('\t', i);
				if (j < 0)
					continue;
				String s2 = s.substring(j + 1);
				URL url;
				try {
					url = new URL(s.substring(i, j));
				}
				catch (MalformedURLException malformedurlexception) {
					V2CMiscUtil.printMalformedURLException(malformedurlexception);
					continue;
				}
				V2CCookie v2ccookie = new V2CCookie(s2, url, s1);
				if (v2ccookie.sName != null)
					alCookieList.add(v2ccookie);
			} while (true);
			bufferedreader.close();
		}
		catch (IOException ioexception) {
		}
	}

	static void saveCookies()
	{
		ArrayList localArrayList = alCookieList;
		synchronized (localArrayList) {
			if (!bChanged) {
				return;
			}
			bChanged = false;
			V2CSaveFile localV2CSaveFile = new V2CSaveFile("cookie.txt");
			BufferedWriter localBufferedWriter = localV2CSaveFile.getWriter();
			if (localBufferedWriter == null) {
				bChanged = true;
				return;
			}
			long l = System.currentTimeMillis();
			try {
				for (int i = 0; i < localArrayList.size(); i++) {
					V2CCookie localV2CCookie = (V2CCookie) localArrayList.get(i);
					if (localV2CCookie.ltExpires >= l) {
/*
						if (localV2CCookie.bMaxAge) {
							if (localV2CCookie.nMaxAge != 0) {
								localBufferedWriter.write(String.valueOf(localV2CCookie.ltMaxAgeOrigin / 1000L));
								localBufferedWriter.write(9);
							}
						}
						else {
*/
							String str = localV2CCookie.getURLString();
							if ((str != null) && (str.length() > 0)) {
								localBufferedWriter.write(str);
							}
							localBufferedWriter.write(9);
							localBufferedWriter.write(localV2CCookie.sRaw);
							localBufferedWriter.newLine();
/*
						}
*/
					}
				}
				localV2CSaveFile.setOK();
			}
			catch (IOException localIOException) {
				bChanged = true;
			}
			finally {
				V2CLocalFileHandler.closeWriter(localBufferedWriter);
			}
			localV2CSaveFile.replaceTmpFile();
		}
	}

	static long parseHttpDate(String s)
	{
		if (s == null)
			return 0L;
		SimpleDateFormat asimpledateformat[] = lSimpleDateFormat;
		for (int i = 0; i < asimpledateformat.length; i++) {
			ParsePosition parseposition = new ParsePosition(0);
			Date date = asimpledateformat[i].parse(s, parseposition);
			if (date != null)
				return date.getTime();
		}

		return -1L;
	}

	public V2CCookie(String s, URL url, String s1)
	{
		uURL = url;
		bValid = false;
		sRaw = s;
		if (s1 != null)
			ltMaxAgeOrigin = V2CMiscUtil.parseLong(s1) * 1000L;
		parseCookieString(s, url);
	}

	private void printErrorMessage()
	{
		if (bValid)
			return;
		else
			return;
	}

	void parseCookieString(String s, URL url)
	{
		if (s == null || s.length() < 3)
			return;
		String as[] = s.split("\\s*;\\s*");
		if (!parseNameAndValue(as[0]))
			return;
		int i = as.length;
		for (int j = 1; j < i; j++) {
			String s3 = as[j];
			if (!parseFields(s3) && !s3.equalsIgnoreCase("HttpOnly") && !s3.equalsIgnoreCase("secure"))
				return;
		}

		String s1 = sDomain;
		if (s1 != null && s1.length() > 0 && s1.charAt(0) != '.') {
			s1 = '.' + s1;
			sDomain = s1;
		}
		if (url != null) {
			if (sDomain == null)
				sDomain = url.getHost();
			if (sPath == null) {
				String s4 = url.getPath();
				if (s4.length() == 1) {
					sPath = s4;
				}
				else {
					int k = s4.lastIndexOf('/');
					if (k == 0)
						sPath = s4.substring(0, 1);
					else if (k > 0)
						sPath = s4.substring(0, k);
				}
			}
		}
		if (sName == null || sName.length() == 0 || sDomain == null || sDomain.length() == 0 || sPath == null)
			return;
		if (url != null) {
			String s5 = url.getPath();
			if (s5.length() > 0 && !s5.startsWith(sPath))
				return;
			String s2 = sDomain;
			int l = s2.length();
			if (s2.lastIndexOf('.') == 0)
				return;
			String s6 = url.getHost();
			if (s6.length() > 0) {
				char c = s6.charAt(0);
				if (c >= '0' && c <= '9' && s6.matches("(?:\\d+\\.){3}\\d+")) {
					if (!s6.equals(s2))
						return;
				}
				else if (!s2.equals(s6) && (s2.charAt(0) != '.' || !s2.regionMatches(true, 1, s6, 0, s6.length()))) {
					if (s6.indexOf('.') != s6.length() - s2.length())
						return;
					if (!s6.toLowerCase().endsWith(s2.toLowerCase()))
						return;
				}
			}
		}
		bValid = true;
	}

	boolean parseFields(String s)
	{
		int i;
		if ((i = s.indexOf('=')) < 0)
			return false;
		String s1 = s.substring(0, i).toLowerCase();
		String s2 = s.substring(i + 1, s.length());
		if (s1.equals("domain"))
			sDomain = s2;
		else if (s1.equals("path"))
			sPath = s2;
		else if (s1.equals("max-age")) {
			nMaxAge = V2CMiscUtil.parseInt(s2);
			if (nMaxAge < 0)
				return false;
			bMaxAge = true;
			long l = ltMaxAgeOrigin;
			if (l <= 0L) {
				l = System.currentTimeMillis();
				ltMaxAgeOrigin = l;
			}
			ltExpires = (long) nMaxAge * 1000L + l;
		}
		else if (s1.equals("expires")) {
			ltExpires = parseExpiresString(s2);
			if (ltExpires < 0L)
				return false;
		}
		else if (s1.equals("version")) {
			if (!s2.equals("1"))
				return false;
		}
		else if (s1.equals("samesite")){
			sSamesite = s2;
			System.out.println("samesite:URL=" + uURL);
		}
		else if (!s1.equals("comment")) {
			System.out.println("Unknown field: " + s1);
			return false;
		}
		return true;
	}

	long parseExpiresString(String s)
	{
		if (s.length() < 10)
			return -1L;
		if (s.length() == 27 && s.charAt(11) == '-' && s.charAt(14) == ' ')
			s = s.substring(0, 12) + "20" + s.substring(12);
		return parseHttpDate(s);
	}

	boolean parseNameAndValue(String s)
	{
		int i;
		if ((i = s.indexOf('=')) <= 0) {
			return false;
		}
		else {
			sName = s.substring(0, i).trim();
			sValue = s.substring(i + 1, s.length());
			return true;
		}
	}

	public boolean applicableTo(URL url)
	{
		String s = url.getHost();
		String s1 = url.getPath();
		if (s == null || s1 == null)
			return false;
		String s2 = sDomain;
		boolean flag;
		if (s2.startsWith("."))
			flag = s.endsWith(s2) || s.length() == s2.length() - 1 && s.regionMatches(0, s2, 1, s.length());
		else
			flag = s.equals(s2);
		boolean flag1;
		if (sPath.endsWith("/"))
			flag1 = s1.startsWith(sPath);
		else if (s1.length() < sPath.length())
			flag1 = false;
		else if (s1.length() > sPath.length())
			flag1 = s1.startsWith(sPath) && s1.charAt(sPath.length()) == '/';
		else
			flag1 = s1.equals(sPath);
		return flag && flag1;
	}

	boolean miscCheck()
	{
		if (sDomain.indexOf(".yourfilehost.com") >= 0)
			return false;
		if (sDomain.indexOf(".twitter.com") >= 0 && sName.matches("_twitter_sess|twid"))
			return false;
		return sDomain.indexOf(".twitpic.com") < 0;
	}

	public int compareTo(V2CCookie v2ccookie)
	{
		return sPath.length() - v2ccookie.sPath.length();
	}

	public boolean matches(V2CCookie v2ccookie)
	{
		return bValid && v2ccookie.isValid() && sName.equals(v2ccookie.sName) && sDomain.equals(v2ccookie.sDomain)
				&& sPath.equals(v2ccookie.sPath);
	}

	boolean matches(String s, String s1, String s2)
	{
		return bValid && sName.equals(s) && sDomain.equals(s1) && sPath.equals(s2);
	}

	String getURLString()
	{
		return uURL.toString();
	}

	public boolean isValid()
	{
		return bValid;
	}

	public String toString()
	{
		return "name: " + sName + "\nvalue: " + sValue + "\ndomain: " + sDomain + "\npath: " + sPath + "\nexpires: "
				+ new Date(ltExpires) + "\n";
	}

	private static final String sCookieFile = "cookie.txt";
	private static final String sBeMailName = "DMDM";
	private static final String sBeCodeName = "MDMD";
	private static final Object vBeLoginMonitor = new Object();
	static String sDMDMValue;
	static String sMDMDValue;
	private static ArrayList alCookieList = new ArrayList();
	private static boolean bRestored;
	private static boolean bChanged;
	String sRaw;
	String sName;
	String sValue;
	String sDomain;
	String sPath;
	long ltExpires;
	int nMaxAge;
	boolean bMaxAge;
	long ltMaxAgeOrigin;
	boolean bValid;
	URL uURL;
	private static SimpleDateFormat lSimpleDateFormat[] = { new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z"),
			new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z") };

	public static void removeAllCookies(){
		int cnum = alCookieList.size();
		synchronized (alCookieList) {
			alCookieList = new ArrayList();
			File cookieTxt = new File(V2CLocalFileHandler.getV2CDir(), "cookie.txt");
			if(cookieTxt.exists()){
				cookieTxt.delete();
			}
			if(alCookieList.size() == 0){
				V2CSwingUtil.showInformationMessage(cnum + "個のクッキーを全て削除しました");
			}else{
				V2CSwingUtil.showErrorMessage(cnum + "個のクッキーを削除できませんでした");
			}
		}
	}

	public static void removeTargetCookies(){
		removeTargetCookies(".5ch.net,.bbspink.com");
	}

	public static void removeTargetCookies(String sDomains){
		String[] aDomains = sDomains.replaceAll(" ", "").replaceAll(",+", ",").replaceAll("^,|,$", "").split(",");
		int cnum = alCookieList.size();
		int dnum = 0;
		ArrayList localArrayList = (ArrayList) alCookieList;
		synchronized (alCookieList) {
			for(int k=0; k<aDomains.length; k++){
				if(aDomains[k].length() != 0){
					System.out.println("クッキー削除対象ドメイン：" + aDomains[k]);
					for (int j = localArrayList.size()-1; j >= 0; j--) {
						V2CCookie localV2CCookie = (V2CCookie) localArrayList.get(j);
						if(localV2CCookie.sDomain.indexOf(aDomains[k]) != -1){
							if(localV2CCookie.sDMDMValue == null || localV2CCookie.sMDMDValue == null ||
							   localV2CCookie.sDMDMValue == ""   || localV2CCookie.sMDMDValue == ""
							){
								System.out.println("削除したクッキー：" + localV2CCookie.uURL + " " + localV2CCookie.sName + "=" + localV2CCookie.sValue);
								localArrayList.remove(j);
								dnum++;
							}
						}
					}
				}
			}
			if(dnum != 0){
				bChanged = true;
				saveCookies();
			}
			V2CSwingUtil.showInformationMessage("「" + sDomains + "」のクッキーを" + dnum + "個の削除しました");
		}
	}

	public static void UpdateCookie(String sUrl, String sName, String sDomain, String sRaw){
		UpdateCookie(sUrl, sName, sDomain, sRaw, true);
	}

	public static void UpdateCookie(String sUrl, String sName, String sDomain, String sRaw, boolean showDialog){
			int cnum = alCookieList.size();
			int dnum = 0;
			int dnum1 = 0;
			ArrayList localArrayList = (ArrayList) alCookieList;
			synchronized (alCookieList) {
				if(sDomain.length() != 0){
					for (int j = localArrayList.size()-1; j >= 0; j--) {
						V2CCookie localV2CCookie = (V2CCookie) localArrayList.get(j);
						if(localV2CCookie.sDomain.indexOf(sDomain) != -1 && localV2CCookie.sName.equals(sName)){
							System.out.println("削除したクッキー：" + localV2CCookie.uURL + " " + localV2CCookie.sName + "=" + localV2CCookie.sValue);
							localArrayList.remove(j);
							bChanged = true;
							saveCookies();
							dnum++;
							break;
						}
					}
					if(sRaw != null){
						try {
							System.out.println((dnum!=0?"更新":"追加") + "対象：ドメイン：" + sDomain + "、名前：" + sName + "、生Cookie：" + sRaw);
							addCookie(sRaw, new URL(sUrl));
							bChanged = true;
							saveCookies();
							dnum1++;
						} catch (MalformedURLException e) {
							// TODO 自動生成された catch ブロック
							e.printStackTrace();
						}
					}
				}
				if(dnum != 0){
					String label = "削除";
					if(dnum1 != 0){
						label = "更新";
					}
					if(showDialog) V2CSwingUtil.showInformationMessage("「" + sDomain + "」の「" + sName + "」を" + label + "しました");
				}
			}
	}

	String sSamesite;
}
