package org.monazilla.v2c;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MouseInputAdapter;

public final class V2CBePopup extends V2CHTMLPane implements V2CPopupPanel, HyperlinkListener
{
	private class ClickListener extends MouseInputAdapter
	{

		public void mouseDragged(MouseEvent mouseevent)
		{
			bDragged = true;
		}

		public void mousePressed(MouseEvent mouseevent)
		{
			bDragged = false;
		}

		public void mouseClicked(MouseEvent mouseevent)
		{
			if (bDragged || mouseevent.getButton() != 1) {
				return;
			}
			closePopupWindow();
		}

		boolean bDragged;

		ClickListener(V2CBePopup.ClickListener param1)
		{
			this();
		}

		private ClickListener()
		{
		}

	}

	private class GetFlogThread implements Runnable
	{

		public void run()
		{
			V2CHttpUtil.CAndC candc = V2CHttpUtil.getHTTPFile(sFlogURL, null, "EUC-JP", "application/x-javascript", 0L);
			if (Thread.currentThread().isInterrupted())
				return;
			String s = null;
			if (candc != null)
				s = candc.getContents();
			putFlog(sFlogURL, s);
			SwingUtilities.invokeLater(new Runnable() {
				public void run()
				{
					updateFlog();
				}
			});
		}

		String sFlogURL;

		GetFlogThread(String s)
		{
			sFlogURL = s;
		}
	}

	private static class GetProfileThread extends Thread
	{

		public void run()
		{
			String s = V2CHttpUtil.getHTMLFile(sProfileURL, "UTF-8");
			Pattern hostPat = Pattern
					.compile("(https?://[^/]+)/+.");
	        Matcher datMatcher = hostPat.matcher(sProfileURL);
			while (datMatcher.find()) {
				s = s.replaceAll("src=\"/static/", "src=\"" + datMatcher.group(1) + "/static/");
				s = s.replaceAll("href=\"/\"", "href=\"" + datMatcher.group(1) + "/\"");
			}
			if (Thread.currentThread().isInterrupted())
				return;
			if (s == null || s.length() == 0)
				s = "<html><body>ダウンロード失敗</body></html>";
			final String sr0 = V2CBePopup.putProfile(iLocalBeID, s);
			if (vBePopup != null) {
				vBePopup.vtpParent.forceRepaint();
				SwingUtilities.invokeLater(new Runnable() {
					public void run()
					{
						vBePopup.updateText(sr0, true);
					}
				});
			}
			else if (vAbstractThreadPanel != null)
				vAbstractThreadPanel.beProfileUpdated(vPopupKey);
		}

		final Integer iLocalBeID;
		final String sProfileURL;
		final V2CBePopup vBePopup;
		final V2CAbstractThreadPanel vAbstractThreadPanel;
		final Object vPopupKey;

		GetProfileThread(Integer integer, String s, V2CAbstractThreadPanel v2cabstractthreadpanel, Object obj)
		{
			this(integer, s, null, v2cabstractthreadpanel, obj);
		}

		GetProfileThread(String s, V2CBePopup v2cbepopup)
		{
			this(v2cbepopup.iBeID, s, v2cbepopup, null, null);
		}

		GetProfileThread(Integer integer, String s, V2CBePopup v2cbepopup, V2CAbstractThreadPanel v2cabstractthreadpanel,
				Object obj)
		{
			iLocalBeID = integer;
			sProfileURL = s;
			vBePopup = v2cbepopup;
			vAbstractThreadPanel = v2cabstractthreadpanel;
			vPopupKey = obj;
		}
	}

	static boolean hasCache(Integer integer)
	{
		return hmProfiles.containsKey(integer);
	}

	static String getSimpleInfo(Integer integer)
	{
		return (String) hmProfiles.get(integer);
	}

	private static String getBodyTextTagString()
	{
		return "<body bgcolor=\"" + V2CSwingUtil.colorToString(V2CThreadPopup.cPopupBG) + "\" text=\""
				+ V2CSwingUtil.colorToString(V2CThreadStyle.getDefaultForeground()) + "\">";
	}

	public V2CBePopup(V2CAbstractThreadPanel v2cabstractthreadpanel, Point point, Integer integer)
	{
		this(v2cabstractthreadpanel, null, point, integer, false);
	}

	public V2CBePopup(V2CAbstractThreadPanel v2cabstractthreadpanel, String s, Point point, Integer integer)
	{
		this(v2cabstractthreadpanel, s, point, integer, true);
	}

	private V2CBePopup(V2CAbstractThreadPanel v2cabstractthreadpanel, String s, Point point, Integer integer, boolean flag)
	{
		iBeID = integer;
		bRemote = flag;
		setBackground(V2CThreadPopup.cPopupBG);
		vtpParent = v2cabstractthreadpanel;
		pLocation = point;
		ClickListener clicklistener = new ClickListener(null);
		addMouseListener(clicklistener);
		addMouseMotionListener(clicklistener);
		addHyperlinkListener(this);
		jScrollPane = new JScrollPane(this);
		if (V2CApp.isUNIX()) {
			JWindow jwindow = new JWindow(V2CMain.v2cMain);
			jwPopupWindow = jwindow;
			cContainer = jwindow.getContentPane();
		}
		else {
			JDialog jdialog = new JDialog(V2CMain.v2cMain, false);
			jwPopupWindow = jdialog;
			jdialog.setUndecorated(true);
			cContainer = jdialog.getContentPane();
		}
		cContainer.add(jScrollPane, "Center");
		jwPopupWindow.setLocation(point);
		jwPopupWindow.setSize(0, 0);
		jwPopupWindow.setVisible(true);
		String s1;
		if (flag) {
			s1 = "<html>" + getBodyTextTagString() + "プロフィール取得中…</body></html>";
		}
		else {
			s1 = (String) hmProfiles.get(integer);
			if (s1 == null)
				s1 = "<html>" + getBodyTextTagString() + "プロフィール情報がありません。</body></html>";
		}
		updateText(s1, true);
		if (flag) {
			thGetProfile = new Thread(new GetProfileThread(s, this));
			thGetProfile.start();
		}
	}

	public boolean isCloseOnExit()
	{
		return false;
	}

	public void closePopupWindow()
	{
		if (vtpParent != null) {
			V2CAbstractThreadPanel v2cabstractthreadpanel = vtpParent;
			vtpParent = null;
			if (v2cabstractthreadpanel.requestClosePopup(this))
				return;
		}
		if (thGetProfile != null && thGetProfile.isAlive())
			thGetProfile.interrupt();
		if (thGetFlogBookmark != null && thGetFlogBookmark.isAlive())
			thGetFlogBookmark.interrupt();
		jwPopupWindow.dispose();
	}

	private void updateText(String s, boolean flag)
	{
		Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(pLocation);
		Dimension dimension = V2CThreadPopup.getMaxPopupSize();
		Insets insets = jScrollPane.getInsets();
		int i = Math.min(dimension.width, rectangle.width - 2);
		int j = Math.min(dimension.height, rectangle.height - 2);
		s = checkFlog(s, flag);
		createLabelIfNecessary(s);
		s = s.replaceAll("(?s)<script(?: [^>]+)?>.*?</script>", "\n");
		doSetText(s);
		V2CHTMLPane v2chtmlpane = new V2CHTMLPane(s);
		Dimension dimension1 = v2chtmlpane.getPreferredSize();
		int k;
		if (jlURL != null)
			k = jlURL.getPreferredSize().height;
		else
			k = 0;
		int l = Math.min(dimension1.width + insets.left + insets.right + 20, i);
		int i1 = Math.min(dimension1.height + insets.top + insets.bottom, j - k);
		jScrollPane.setPreferredSize(new Dimension(l, i1));
		i1 += k;
		int j1 = (int) pLocation.getX();
		int k1 = (int) pLocation.getY();
		boolean flag1 = false;
		if (j1 + l + 2 > rectangle.x + rectangle.width) {
			flag1 = true;
			j1 = (rectangle.x + rectangle.width) - l - 1;
		}
		if (k1 + i1 + 2 > rectangle.y + rectangle.height) {
			flag1 = true;
			k1 = (rectangle.y + rectangle.height) - i1 - 1;
		}
		if (flag1)
			jwPopupWindow.setLocation(j1, k1);
		jwPopupWindow.pack();
		SwingUtilities.invokeLater(new Runnable() {
			public void run()
			{
				scrollRectToVisible(new Rectangle(0, 0, 1, 1));
			}
		});
	}

	String checkFlog(String s, boolean flag)
	{
		int i = 0;
		do {
			String s1;
			do {
				Matcher matcher = pFlogScript.matcher(s);
				if (!matcher.find(i))
					return s;
				i = matcher.start();
				s = s.substring(0, i) + s.substring(matcher.end());
				s1 = matcher.group(1);
			} while (!s1.endsWith("/sb-euc.js"));
			iFlogIndex = i;
			if (flag && bRemote) {
				thGetFlogBookmark = new Thread(new GetFlogThread(s1));
				thGetFlogBookmark.start();
			}
			else {
				String s2 = (String) hmFlogBookmarks.get(s1);
				if (s2 != null) {
					s = insertFlog(s, s2);
					i += s2.length();
				}
			}
		} while (true);
	}

	private void updateFlog()
	{
		String s = (String) hmProfiles.get(iBeID);
		if (s == null || s.length() < iFlogIndex) {
			return;
		}
		updateText(s, false);
	}

	private String insertFlog(String s, String s1)
	{
		return s.substring(0, iFlogIndex) + s1 + s.substring(iFlogIndex);
	}

	private void createLabelIfNecessary(String s)
	{
		if (jlURL != null || s.indexOf("<a ") < 0 && s.indexOf("<A ") < 0) {
			return;
		}
		jlURL = new JLabel(" ");
		jlURL.setOpaque(true);
		jlURL.setForeground(V2CThreadStyle.getDefaultForeground());
		jlURL.setBackground(V2CThreadPopup.cPopupBG);
		jlURL.setBorder(BorderFactory.createBevelBorder(1));
		cContainer.add(jlURL, "South");
	}

	private static String putProfile(Integer integer, String s)
	{
		for (int i = 0; (i = s.indexOf("<form ", i)) > 0;) {
			int j = s.indexOf("</form>", i + 6);
			if (j > 0)
				s = s.substring(0, i) + s.substring(j + 7);
			else
				i += 6;
		}

		s = s.replaceAll("<p></p>", "");
		s = s.replaceAll("http://be\\.[25]ch\\.net/", "https://be.5ch.net/");
		s = s.replace("<span>" + integer + "</span>", "<span><a href=\"https://be.5ch.net/user/" + integer + "\">" + integer + "</a></span>");
		Matcher matcher = pHTTP.matcher(s);
		s = matcher.replaceAll("$1<a href=\"$2\">$2</a>");
		Matcher matcher1 = pDivContent.matcher(s);
		Matcher matcher2 = pDivLeft.matcher(s);
		Matcher matcher3 = pDivRight.matcher(s);
		if (matcher1.find() && matcher2.find() && matcher3.find()) {
			int k = s.indexOf("</div>", matcher1.end());
			int l = s.indexOf("</div>", matcher2.end());
			int i1 = s.indexOf("</div>", matcher3.end());
			if (k > 0 && l > 0 && i1 > 0) {
				StringBuffer stringbuffer = new StringBuffer();
				stringbuffer.append("<html><body bgcolor=\"");
				stringbuffer.append(V2CSwingUtil.colorToString(V2CThreadPopup.cPopupBG));
				stringbuffer.append("\" text=\"");
				stringbuffer.append(V2CSwingUtil.colorToString(V2CThreadStyle.getDefaultForeground()));
				stringbuffer
						.append("\"><table border=\"1\" rules=\"all\" cellspacing=\"1\" cellpadding=\"5\"><tr><td width=\"170\" valign=\"top\">");
				stringbuffer.append(s.substring(matcher2.end(), l).replaceAll("/>", ">"));
				stringbuffer.append("</font></td><td width=\"400\" valign=\"top\">");
				stringbuffer.append(s.substring(matcher1.end(), k).replaceAll("/>", ">"));
				stringbuffer.append("</font></td><td width=\"150\" valign=\"top\">");
				stringbuffer.append(s.substring(matcher3.end(), i1).replaceAll("/>", ">"));
				stringbuffer.append("</font></td></tr></body></html>");
				s = stringbuffer.toString();
			}
		}
		hmProfiles.put(integer, s);
		return s;
	}

	private String putFlog(String s, String s1)
	{
		String s2 = "flog error !!";
		if (s1 != null) {
			Matcher matcher = Pattern.compile("document.write\\(\"(.+)\"\\);").matcher(s1);
			if (matcher.matches())
				s2 = matcher.group(1);
		}
		hmFlogBookmarks.put(s, s2);
		return s2;
	}

	public void hyperlinkUpdate(HyperlinkEvent hyperlinkevent)
	{
		URL url = hyperlinkevent.getURL();
		if (url == null)
			return;
		String s = url.toString();
		if (hyperlinkevent.getEventType() == javax.swing.event.HyperlinkEvent.EventType.ENTERED) {
			if (jlURL == null)
				return;
			String s1 = V2CMiscUtil.maybeGetURLDecodedString(s);
			if (s1 != null) {
				int i = s1.indexOf('\n');
				if (i >= 0)
					s1 = s1.substring(0, i);
			}
			else {
				s1 = s;
			}
			jlURL.setText(s1);
		}
		else if (hyperlinkevent.getEventType() == javax.swing.event.HyperlinkEvent.EventType.EXITED) {
			if (jlURL != null)
				jlURL.setText(" ");
		}
		else if (hyperlinkevent.getEventType() == javax.swing.event.HyperlinkEvent.EventType.ACTIVATED)
			V2CMiscUtil.openUnknownLink(s, true, false, true);
	}

	static boolean getBeProfileBG(Integer integer, String s, V2CAbstractThreadPanel v2cabstractthreadpanel, Object obj)
	{
		if (!V2CMain.isOnlineMode()) {
			return false;
		}
		else {
			(new Thread(new GetProfileThread(integer, s, v2cabstractthreadpanel, obj))).start();
			return true;
		}
	}

	static final String sBeCondKey = "ThreadView.BePopup";
	static Pattern pHTTP = Pattern.compile("([^=\"])(https?://[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+)");
	static Map hmProfiles = Collections.synchronizedMap(new HashMap());
	static Map hmFlogBookmarks = Collections.synchronizedMap(new HashMap());
	V2CAbstractThreadPanel vtpParent;
	Window jwPopupWindow;
	Container cContainer;
	JScrollPane jScrollPane;
	JLabel jlURL;
	Point pLocation;
	int iFlogIndex;
	final boolean bRemote;
	Thread thGetProfile;
	Thread thGetFlogBookmark;
	Integer iBeID;
	static Pattern pFlogScript = Pattern
			.compile("<script src=\"(http://www.flog.jp/[-_a-zA-Z0-9/]+.js)\" type=\"text/javascript\">");
	private static final Pattern pDivLeft = Pattern.compile("<div\\sid=\"leftside\">");
	private static final Pattern pDivRight = Pattern.compile("<div\\sid=\"rightside\">");
	private static final Pattern pDivContent = Pattern.compile("<div\\sid=\"content\">");

}
