package org.monazilla.v2c;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.*;
import javax.swing.Timer;

public class V2CAutoReloader implements ActionListener
{

	boolean isAutoScrolling()
	{
		return bTmpScrollTimerStopped || tScrollTimer.isRunning();
	}

	void setReloadOnlyAtBottom()
	{
		bReloadOnlyAtBottom = true;
	}

	static boolean getJumpToNewRes()
	{
		return bJumpToNewRes;
	}

	static boolean getStartImmediately()
	{
		return bStartImmediately;
	}

	static boolean getCloseAfterWrite()
	{
		return bCloseAfterWrite;
	}

	static boolean getNextThreadIfAny()
	{
		return bNextThreadIfAny;
	}

	static void restoreState()
	{
		V2CPackedPropValue v2cpackedpropvalue = V2CMain.getUserProperty().getPackedValue("ThreadView.AutoReloadCond");
		if (v2cpackedpropvalue == null)
			return;
		bNextThreadIfAny = v2cpackedpropvalue.getBoolean('a');
		bCloseAfterWrite = v2cpackedpropvalue.getBoolean('c');
		bJumpToNewRes = v2cpackedpropvalue.getBoolean('j');
		bStartImmediately = v2cpackedpropvalue.getBoolean('i');
		bReloadWithoutFocus = v2cpackedpropvalue.getBoolean('f');
		bKeepNormalInterval = v2cpackedpropvalue.getBoolean('k');
		bOneLineMode0 = v2cpackedpropvalue.getBoolean('o');
		bPageScroll0 = v2cpackedpropvalue.getBoolean('p');
		bReloadAfterWrite = v2cpackedpropvalue.getBoolean('r');
		bNoAutoScroll = v2cpackedpropvalue.getBoolean('s');
		bAlwaysOnTop = v2cpackedpropvalue.getBoolean('t');
		bDefExpandResAnchor = v2cpackedpropvalue.getBoolean('x');
		boolean flag = v2cpackedpropvalue.getBoolean('z');
		bNewIntervalMode = flag;
		nMaxZeroCount = v2cpackedpropvalue.getIntInRangeIfExists('z', 10, 1, 100);
		int i = v2cpackedpropvalue.getInt('n');
		if (i > 0)
			fMinLineScrollPerSec = Math.max(1.0F, Math.min((float) i / 10F, 40F));
		int j = v2cpackedpropvalue.getInt('x');
		if (j > 0)
			fMaxLineScrollPerSec = Math.min(j, 40F);
		if (fMaxLineScrollPerSec < fMinLineScrollPerSec)
			fMaxLineScrollPerSec = (float) Math.ceil(fMinLineScrollPerSec);
		int k = v2cpackedpropvalue.getInt('P');
		if (k > 0)
			nMaxPageScrollInterval = V2CMiscUtil.restrictRange(100, k, 10000);
		int l = v2cpackedpropvalue.getInt('p');
		if (l <= 0)
			l = nMinPageScrollInterval;
		nMinPageScrollInterval = V2CMiscUtil.restrictRange(100, l, nMaxPageScrollInterval);
		int i1 = v2cpackedpropvalue.getInt('I');
		if (i1 > 0)
			nInitialInterval = Math.max(i1, 5);
		int j1 = v2cpackedpropvalue.getInt('i');
		if (j1 > 0)
			nIntervalIncrement = j1;
	}

	static void saveState()
	{
		V2CPackedPropValue v2cpackedpropvalue = new V2CPackedPropValue();
		v2cpackedpropvalue.setBoolean('a', bNextThreadIfAny);
		v2cpackedpropvalue.setBoolean('c', bCloseAfterWrite);
		v2cpackedpropvalue.setBoolean('j', bJumpToNewRes);
		v2cpackedpropvalue.setBoolean('i', bStartImmediately);
		v2cpackedpropvalue.setBoolean('f', bReloadWithoutFocus);
		v2cpackedpropvalue.setBoolean('k', bKeepNormalInterval);
		v2cpackedpropvalue.setBoolean('o', bOneLineMode0);
		v2cpackedpropvalue.setBoolean('p', bPageScroll0);
		v2cpackedpropvalue.setBoolean('r', bReloadAfterWrite);
		v2cpackedpropvalue.setBoolean('s', bNoAutoScroll);
		v2cpackedpropvalue.setBoolean('t', bAlwaysOnTop);
		v2cpackedpropvalue.setBoolean('x', bDefExpandResAnchor);
		v2cpackedpropvalue.setBoolean('z', bNewIntervalMode);
		if (nMaxZeroCount != 10)
			v2cpackedpropvalue.setInt('z', nMaxZeroCount);
		if (fMinLineScrollPerSec != 2.0F)
			v2cpackedpropvalue.setInt('n', (int) (fMinLineScrollPerSec * 10F));
		if (fMaxLineScrollPerSec != 10F)
			v2cpackedpropvalue.setInt('x', (int) fMaxLineScrollPerSec);
		if (nMinPageScrollInterval != 500)
			v2cpackedpropvalue.setInt('p', nMinPageScrollInterval);
		if (nMaxPageScrollInterval != 2000)
			v2cpackedpropvalue.setInt('P', nMaxPageScrollInterval);
		if (nInitialInterval != 10)
			v2cpackedpropvalue.setInt('I', nInitialInterval);
		if (nIntervalIncrement != 5)
			v2cpackedpropvalue.setInt('i', nIntervalIncrement);
		V2CMain.getUserProperty().putPackedValue("ThreadView.AutoReloadCond", v2cpackedpropvalue);
	}

	static V2CAutoReloadSP createAutoReloadSP()
	{
		return new V2CAutoReloadSP(fMinLineScrollPerSec, fMaxLineScrollPerSec, nMinPageScrollInterval, nMaxPageScrollInterval);
	}

	static void setAutoReload()
	{
		V2CAutoReloadSP v2cautoreloadsp = createAutoReloadSP();
		v2cautoreloadsp.showDialog();
	}

	static void setParameters(boolean flag, boolean flag1, boolean flag2, boolean flag3, boolean flag4, boolean flag5,
			boolean flag6, boolean flag7, boolean flag8, boolean flag9, boolean flag10, boolean flag11, float f, float f1, int i,
			int j, boolean flag12, int k, int l, int i1)
	{
		bPageScroll0 = flag;
		bOneLineMode0 = flag1;
		bDefExpandResAnchor = flag2;
		bNoAutoScroll = flag3;
		bJumpToNewRes = flag4;
		bReloadWithoutFocus = flag5;
		bStartImmediately = flag6;
		bNextThreadIfAny = flag7;
		bKeepNormalInterval = flag8;
		bAlwaysOnTop = flag9;
		bCloseAfterWrite = flag10;
		bReloadAfterWrite = flag11;
		if (bAlwaysOnTopSet && !flag9) {
			V2CJ2SE5Util.setAlwaysOnTop(V2CMain.v2cMain, false);
			bAlwaysOnTopSet = false;
		}
		bNewIntervalMode = flag12;
		f = Math.max(1.0F, Math.min(f, 40F));
		f1 = Math.max(f, Math.min(f1, 40F));
		j = V2CMiscUtil.restrictRange(100, j, 10000);
		i = V2CMiscUtil.restrictRange(100, i, j);
		fMinLineScrollPerSec = f;
		fMaxLineScrollPerSec = f1;
		nMinPageScrollInterval = i;
		nMaxPageScrollInterval = j;
		nInitialInterval = Math.max(k, 5);
		nIntervalIncrement = Math.max(l, 1);
		nMaxZeroCount = i1;
		saveState();
	}

	static V2CAutoReloader getInstance(V2CThreadPanel v2cthreadpanel)
	{
		if (v2cthreadpanel == null || (v2cthreadpanel instanceof V2CNewThreadPanel))
			return null;
		URL url = v2cthreadpanel.getThreadItem().getURL();
		if (url == null)
			return null;
		String s = url.toString();
		if (s == null)
			return null;
		HashMap hashmap = hmAutoReloaders;
		V2CAutoReloader v2cautoreloader;
		synchronized (hashmap) {
			v2cautoreloader = (V2CAutoReloader) hashmap.get(s);
			if (v2cautoreloader != null) {
				v2cautoreloader.setThreadPanel(v2cthreadpanel);
			}
			else {
				v2cautoreloader = new V2CAutoReloader(v2cthreadpanel, s);
				hashmap.put(s, v2cautoreloader);
			}
		}
		return v2cautoreloader;
	}

	public V2CAutoReloader(V2CThreadPanel v2cthreadpanel, String s)
	{
		sHostKey = s;
		bOneLineMode = bOneLineMode0;
		bPageScroll = bPageScroll0;
		tTimer = new Timer(15000, this);
		tTimer.setRepeats(false);
		tScrollTimer = new Timer(3000, this);
		setThreadPanel(v2cthreadpanel);
	}

	void setThreadPanel(V2CThreadPanel v2cthreadpanel)
	{
		if (vThreadPanel != null && vThreadPanel != v2cthreadpanel)
			vThreadPanel.autoReloadStopped();
		vThreadPanel = v2cthreadpanel;
		if (tTimer.isRunning())
			tTimer.stop();
		if (tScrollTimer.isRunning())
			tScrollTimer.stop();
	}

	void start(boolean flag, boolean flag1)
	{
		bMousePressed = false;
		bPageScroll = flag1;
		bUseInitialInterval = true;
		bPause = false;
		bLastPageBottomDisplayed = false;
		bReloadOnlyAtBottom = false;
		nZeroCount = 0;
		nErrorCount = 0;
		flag = true;
		if (flag) {
			ltEndTime = System.currentTimeMillis() + 0x1b7740L;
		}
		else {
			HashMap hashmap = hmEndTime;
			Object obj;
			synchronized (hashmap) {
				obj = hashmap.get(sHostKey);
			}
			if (obj instanceof Long)
				ltEndTime = ((Long) obj).longValue();
		}
		nLastInterval = 5;
		tTimer.setInitialDelay(100);
		tTimer.start();
		if (bAlwaysOnTop && bAlwaysOnTopSupported && !bAlwaysOnTopSet) {
			bAlwaysOnTopSet = true;
			V2CJ2SE5Util.setAlwaysOnTop(V2CMain.v2cMain, true);
		}
	}

	boolean isPaused()
	{
		return bPause;
	}

	void togglePause(V2CThreadPanel v2cthreadpanel)
	{
		setPause(v2cthreadpanel, !bPause);
	}

	void pause(V2CThreadPanel v2cthreadpanel)
	{
		setPause(v2cthreadpanel, true);
	}

	void setPause(V2CThreadPanel v2cthreadpanel, boolean flag)
	{
		if (vThreadPanel == null || v2cthreadpanel != vThreadPanel)
			return;
		if (flag == bPause) {
			return;
		}
		else {
			bPause = flag;
			vThreadPanel.autoReloadPauseChanged();
			return;
		}
	}

	static void stopAll()
	{
		for (Iterator iterator = hmAutoReloaders.values().iterator(); iterator.hasNext(); ((V2CAutoReloader) iterator.next())
				.stop())
			;
	}

	void stop()
	{
		if (tTimer != null)
			tTimer.stop();
		stopScrollTimer();
	}

	void stop(V2CThreadPanel v2cthreadpanel)
	{
		if (v2cthreadpanel != vThreadPanel) {
			return;
		}
		else {
			doStop();
			return;
		}
	}

	private void doStop()
	{
		if (vThreadPanel == null || tTimer == null)
			return;
		if (tTimer.isRunning())
			tTimer.stop();
		stopScrollTimer();
		vThreadPanel.autoReloadStopped();
		vThreadPanel = null;
		HashMap hashmap = hmAutoReloaders;
		int i;
		synchronized (hashmap) {
			hashmap.remove(sHostKey);
			i = hashmap.size();
		}
		HashMap hashmap2 = hmEndTime;
		synchronized (hashmap2) {
			hashmap2.put(sHostKey, new Long(ltEndTime));
		}
		if (bAlwaysOnTopSet && i == 0) {
			V2CJ2SE5Util.setAlwaysOnTop(V2CMain.v2cMain, false);
			bAlwaysOnTopSet = false;
		}
	}

	boolean continueAfterError()
	{
		return ++nErrorCount < 2;
	}

	void mousePressed(V2CThreadPanel v2cthreadpanel)
	{
		if (!bPageScroll) {
			bMousePressed = true;
			bSetScrollIntervalRequest = true;
		}
	}

	void mouseReleased(V2CThreadPanel v2cthreadpanel)
	{
		if (!bPageScroll) {
			bMousePressed = false;
			bSetScrollIntervalRequest = true;
		}
	}

	void setScrollMode(boolean flag, V2CThreadPanel v2cthreadpanel)
	{
		if (vThreadPanel == null || v2cthreadpanel != vThreadPanel) {
			return;
		}
		else {
			bPageScroll = flag;
			bSetScrollIntervalRequest = true;
			return;
		}
	}

	void setOneLineMode(boolean flag, V2CThreadPanel v2cthreadpanel)
	{
		if (vThreadPanel == null || v2cthreadpanel != vThreadPanel) {
			return;
		}
		else {
			bOneLineMode = flag;
			return;
		}
	}

	int getRemainingTime()
	{
		long l = System.currentTimeMillis();
		if (ltEndTime < l) {
			if (vThreadPanel != null && (bNoAutoScroll || !isAutoScrolling()))
				doStop();
			return 0;
		}
		else {
			return (int) ((ltEndTime - l) / 1000L);
		}
	}

	void resetReloadCount()
	{
		if (bPause) {
			bPause = false;
		}
		else {
			nZeroCount = 0;
			long l = System.currentTimeMillis();
			long l1 = ltEndTime;
			long l2 = Math.max(0x1b7740L, l1 - l);
			ltEndTime = Math.min(l1 + l2, l + 0x5265c00L);
		}
	}

	void requestNextReload(V2CThreadPanel v2cthreadpanel, final int nnr, final int ndl)
	{
		if (vThreadPanel == null)
			return;
		if (v2cthreadpanel != vThreadPanel) {
			v2cthreadpanel.autoReloadStopped();
			return;
		}
		nDisplayLines = Math.max(ndl, 10);
		try {
			EventQueue.invokeAndWait(new Runnable() {

				public void run()
				{
					requestNextReload0(nnr, ndl);
				}
			});
		}
		catch (Exception exception) {
		}
	}

	private void requestNextReload0(int i, int j)
	{
		long l = System.currentTimeMillis();
		if (l < ltEndTime) {
			boolean flag = tTimer.isRunning();
			if (flag)
				tTimer.stop();
			else if (i > 0)
				nZeroCount = 0;
			else
				nZeroCount++;
			if (nZeroCount >= nMaxZeroCount) {
				vThreadPanel.autoReloadStopped();
				return;
			}
			j = Math.max(10, Math.min(j, 20));
			int k;
			if (bNewIntervalMode) {
				if (bUseInitialInterval) {
					bUseInitialInterval = false;
					k = nInitialInterval;
					nZeroCount = 0;
				}
				else {
					k = nInitialInterval + nZeroCount * nIntervalIncrement;
				}
			}
			else {
				int i1 = 3 * i;
				if (bUseInitialInterval) {
					bUseInitialInterval = false;
					k = 5;
					nZeroCount = 0;
				}
				else if (nZeroCount < 2) {
					if (flag)
						k = 5;
					else if (i1 <= 0)
						k = 15;
					else
						k = Math.min(Math.max((j * nLastInterval) / i1, 5), 15);
				}
				else {
					k = Math.max(30, Math.min(nLastInterval + 10, 60));
				}
			}
			nLastInterval = k;
			tTimer.setInitialDelay(k * 1000);
			tTimer.start();
		}
		bReloadOnlyAtBottom = false;
		if (tScrollTimer.isRunning())
			tScrollTimer.stop();
		ltScrollTimerStart = l;
		if (!bNoAutoScroll) {
			bScrollSpeedCalculated = false;
			char c = bJumpToNewRes ? 'Ɛ' : 'd';
			tScrollTimer.setDelay(c);
			tScrollTimer.setInitialDelay(c);
			startScrollTimer(System.currentTimeMillis());
		}
		vThreadPanel.updateReloadCount();
	}

	private void startScrollTimer(long l)
	{
		tScrollTimer.start();
	}

	private void stopScrollTimer()
	{
		if (tScrollTimer != null && tScrollTimer.isRunning())
			tScrollTimer.stop();
	}

	private boolean checkPageBottomDisplayed()
	{
		boolean flag = vThreadPanel.hasPageBottomDisplayed();
		if (flag && !bLastPageBottomDisplayed)
			ltPageBottomDisplayed = System.currentTimeMillis();
		bLastPageBottomDisplayed = flag;
		return flag;
	}

	private boolean isScrollable()
	{
		if (bPause)
			return false;
		if (!V2CMain.getDisplayPane().isSelected(vThreadPanel))
			return false;
		return vThreadPanel.isNormalMode() && !vThreadPanel.hasChild();
	}

	private boolean isReloadable()
	{
		if (bPause)
			return false;
		if (!V2CMain.getDisplayPane().isSelected(vThreadPanel))
			return false;
		if (!checkPageBottomDisplayed() || !vThreadPanel.isNormalMode() || vThreadPanel.hasChild())
			return false;
		if (bReloadOnlyAtBottom && !vThreadPanel.isAtPageBottom())
			return false;
		else
			return bReloadWithoutFocus || V2CMain.hasFocusInApplication();
	}

	private boolean shouldReloadForKeepInterval(long l)
	{
		if (bPause)
			return false;
		boolean flag = ltScrollTimerStart > 0L && l > ltScrollTimerStart + 15000L;
		if (flag)
			ltScrollTimerStart = 0L;
		if (!bKeepNormalInterval)
			return false;
		if (!V2CMain.getDisplayPane().isSelected(vThreadPanel))
			return false;
		else
			return flag && (bReloadWithoutFocus || V2CMain.hasFocusInApplication());
	}

	public void actionPerformed(ActionEvent actionevent)
	{
		if (vThreadPanel == null)
			return;
		Object obj = actionevent.getSource();
		long l = System.currentTimeMillis();
		if (obj == tTimer) {
			if (ltEndTime <= l) {
				if (bNoAutoScroll || !isAutoScrolling())
					doStop();
				return;
			}
			int i;
			if (isReloadable()) {
				if (bJumpToNewRes) {
					long l1 = (ltPageBottomDisplayed + 1000L) - l;
					if (l1 <= 100L) {
						vThreadPanel.autoUpdateThread();
						return;
					}
					i = Math.min((int) l1, 1000);
				}
				else {
					vThreadPanel.autoUpdateThread();
					return;
				}
			}
			else {
				if (shouldReloadForKeepInterval(l)) {
					vThreadPanel.autoUpdateThread();
					return;
				}
				i = bJumpToNewRes ? 1000 : 500;
			}
			tTimer.setInitialDelay(i);
			tTimer.start();
		}
		else if (obj == tScrollTimer) {
			bTmpScrollTimerStopped = true;
			tScrollTimer.stop();
			if (checkPageBottomDisplayed()) {
				if (bSearchNext)
					vThreadPanel.searchNextThreadAndStartAR();
				bTmpScrollTimerStopped = false;
				if (l >= ltEndTime)
					vThreadPanel.autoReloadStopped();
				return;
			}
			if (bNoAutoScroll)
				return;
			boolean flag = bScrollSpeedCalculated;
			if (!flag) {
				float f = vThreadPanel.getLinesToPageBottom();
				fLineScrollSpeed = Math.max(fMinLineScrollPerSec,
						Math.min(f <= 0.0F ? fLineScrollSpeed * 1000F : f / (float) (nLastInterval - 1), fMaxLineScrollPerSec)) / 1000F;
				fLineScrollFraction = 0.0F;
				float f1 = f / (float) nDisplayLines + 1.0F;
				nPageScrollInterval = Math.max(nMinPageScrollInterval, Math.min(f <= 0.0F ? nPageScrollInterval
						: (int) ((1000F * (float) nLastInterval) / f1), nMaxPageScrollInterval));
				ltLastScroll = l;
				bSetScrollIntervalRequest = true;
				bScrollSpeedCalculated = true;
			}
			if (isScrollable())
				if (bPageScroll) {
					if (flag)
						vThreadPanel.pageDown();
				}
				else {
					fLineScrollFraction = vThreadPanel.verticalScrollByLine(
							Math.max((float) (l - ltLastScroll) * fLineScrollSpeed, 0.01F), fLineScrollFraction);
				}
			ltLastScroll = l;
			if (bSetScrollIntervalRequest) {
				bSetScrollIntervalRequest = false;
				int j = bPageScroll ? nPageScrollInterval : ((int) (bMousePressed ? 60 : 10));
				tScrollTimer.setDelay(j);
				tScrollTimer.setInitialDelay(j);
			}
			if (V2CApp.isUNIX())
				Toolkit.getDefaultToolkit().sync();
			startScrollTimer(l);
			bTmpScrollTimerStopped = false;
		}
	}

	private static final String sCondKey = "ThreadView.AutoReloadCond";
	private static final int nReloadTimeUnit = 0x1b7740;
	private static final int nReloadTimeLimit = 0x5265c00;
	private static final int MINSPEEDSAVEFACTOR = 10;
	private static final int nSlowInterval = 30;
	private static final int nNormalInterval = 15;
	private static final int nMinimumInterval = 5;
	static boolean bNewIntervalMode;
	private static final int nInitialInterval0 = 10;
	private static final int nIntervalIncrement0 = 5;
	static int nInitialInterval = 10;
	static int nIntervalIncrement = 5;
	static final int nMaxMaxZeroCount = 100;
	static final int nDefMaxZeroCount = 10;
	static int nMaxZeroCount = 10;
	V2CThreadPanel vThreadPanel;
	final String sHostKey;
	int nErrorCount;
	long ltEndTime;
	int nZeroCount;
	int nLastInterval;
	boolean bPause;
	static boolean bJumpToNewRes;
	static boolean bReloadWithoutFocus;
	static boolean bStartImmediately;
	static boolean bSearchNext = true;
	boolean bUseInitialInterval;
	static boolean bPageScroll0;
	static boolean bOneLineMode0;
	boolean bPageScroll;
	boolean bOneLineMode;
	boolean bLastPageBottomDisplayed;
	boolean bReloadOnlyAtBottom;
	static boolean bNextThreadIfAny;
	static boolean bCloseAfterWrite;
	static boolean bReloadAfterWrite;
	static boolean bKeepNormalInterval;
	static boolean bAlwaysOnTop;
	static boolean bAlwaysOnTopSet;
	static final boolean bAlwaysOnTopSupported = V2CSwingUtil.isAlwaysOnTopSupported();
	static boolean bNoAutoScroll;
	static boolean bDefExpandResAnchor;
	boolean bMousePressed;
	int nDisplayLines;
	long ltLastScroll;
	long ltScrollTimerStart;
	long ltPageBottomDisplayed;
	float fLineScrollSpeed;
	private static final float fDefaultMinLineScrollPerSec = 2F;
	private static final float fDefaultMaxLineScrollPerSec = 10F;
	private static final int nDefaultMinPageScrollInterval = 500;
	private static final int nDefaultMaxPageScrollInterval = 2000;
	static final float fMinLineScrollPerSecLimit = 1F;
	static final float fMaxLineScrollPerSecLimit = 40F;
	static final int nMinPageScrollIntervalLimit = 100;
	static final int nMaxPageScrollIntervalLimit = 10000;
	static float fMinLineScrollPerSec = 2.0F;
	static float fMaxLineScrollPerSec = 10F;
	static int nMinPageScrollInterval = 500;
	static int nMaxPageScrollInterval = 2000;
	static final HashMap hmAutoReloaders = new HashMap();
	static final HashMap hmEndTime = new HashMap();
	float fLineScrollFraction;
	int nPageScrollInterval;
	boolean bScrollSpeedCalculated;
	boolean bSetScrollIntervalRequest;
	Timer tTimer;
	Timer tScrollTimer;
	boolean bTmpScrollTimerStopped;

	static {
		restoreState();
		V2CMain.autoReloaderLoaded();
	}

}
