package org.monazilla.v2c;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;

public class V2CAddressBar extends JPanel implements V2CEditOperation, ActionListener, V2CKeyPopupMenu, FocusListener
{
	private static final Pattern patternInputhttpsUrl = Pattern
			.compile("(https://)([^\\.]*)(\\.[25]ch\\.net/|\\.bbspink\\.com/)");
	private static final Pattern patternInput5chUrl = Pattern
			.compile("(http://)([^\\.]*)(\\.5ch\\.net/)");
	private static final Pattern patternInputjbbshttpsUrl = Pattern
			.compile("(https://)(jbbs\\.shitaraba\\.net)");
	private static final Pattern patternInputjbbsKakoLogUrl = Pattern
			.compile("(https?://)(jbbs\\.shitaraba\\.net/bbs/read_archive\\.cgi/)");
	private static final Pattern LockUrl = Pattern
			.compile("https?://[^\\.]*(?:\\.[25]ch\\.net/|\\.bbspink\\.com/).+?#(lock|unlock)$");
	private static final Pattern patternReadCGI = Pattern
			.compile("https?://([^\\.]*)(\\.[25]ch\\.net|\\.bbspink\\.com)/test/read\\.cgi/([^/]*)/([0-9]*).*");
	private static final Pattern patternInputmachibbshttpsUrl = Pattern
			.compile("(https?://)([^.]+\\.)?(machi\\.to)");
	private static final Pattern patternInputmachibbshttpsUrlThread = Pattern
			.compile("https?://machi\\.to/bbs/read\\.cgi/([^/]+)/[0-9]+");
	private static final Pattern patternInputmachibbshttpsUrlThreadList = Pattern
			.compile("https?://machi\\.to/([^/]+)");
	private static final Pattern patternInputtalkjpUrl = Pattern
			.compile("https?://talk\\.jp/boards/([^/]+)/(\\d+)/?");

	private class PopupListener extends V2CPopupListener
	{

		void setupAction(MouseEvent mouseevent)
		{
			V2CAction.setEnabled("OpenLinkInside", V2CWebBrowserUtil.checkJDIC());
			JTextField jtextfield = jtfAddress;
			String s = jtextfield.getText();
			boolean flag = false;
			V2CParseLinkResult v2cparselinkresult = new V2CParseLinkResult(s);
			if (v2cparselinkresult.parse(true)) {
				V2CThreadItem v2cthreaditem = v2cparselinkresult.getThreadItem();
				if (v2cthreaditem != null && v2cthreaditem.is2ch() && V2C2chBBS.isMoritapoLoggedIn())
					flag = true;
			}
			V2CAction.setEnabled("GetThreadWithMoritapo", flag);
			if (mouseevent == null)
				return;
			if (V2CAddressBar.bWinSelection)
				return;
			Caret caret = jtextfield.getCaret();
			int i = jtextfield.getSelectionStart();
			int j = jtextfield.getSelectionEnd();
			boolean flag1 = V2CApp.isWinType() ? caret.isSelectionVisible() : caret.isVisible();
			if (flag1 && i < j) {
				int k = mouseevent.getPoint().x;
				try {
					Rectangle rectangle = jtextfield.modelToView(i);
					if (rectangle != null && k > rectangle.x) {
						Rectangle rectangle1 = jtextfield.modelToView(j);
						if (rectangle1 != null && k < rectangle1.x)
							return;
					}
				}
				catch (BadLocationException badlocationexception) {
				}
			}
			if (!flag1 || i > 0 || j < s.length()) {
				jtextfield.requestFocusInWindow();
				jtextfield.selectAll();
			}
		}

		PopupListener()
		{
			super("AddressBar", V2CAddressBar.this);
		}
	}

	static V2CAddressBar getInstance()
	{
		if (vAddresBar == null)
			vAddresBar = new V2CAddressBar();
		return vAddresBar;
	}

	static void openLocation()
	{
		String as[];
		if (V2CWebBrowserUtil.checkJDIC())
			as = (new String[] { "開く", "外部ブラウザ", "内部ブラウザ",
					"キャンセル" });
		else
			as = (new String[] { "開く", "外部ブラウザ", "キャンセル" });
		int i = as.length - 1;
		V2CInputDialog v2cinputdialog = new V2CInputDialog(null, "URL：", null, null, 40, "URLを開く");
		int j = v2cinputdialog.showDialog(as, 0);
		if (j < 0 || j >= i)
			return;
		String s = v2cinputdialog.getInputString();
		if (s.length() == 0)
			return;
		if (j == 0)
			openLocation(s, true, false);
		else if (j == 1)
			V2CMiscUtil.openLinkWithWebBrowser(s, true, false, true, false);
		else if (j == 2)
			V2CMiscUtil.openLinkWithWebBrowser(s, true, true, false, false);
	}

	static void openLocation(String s, boolean flag, boolean flag1)
	{
		if (s == null || s.length() == 0)
			return;
		if (s.startsWith(V2CApp.getV2CBaseURLString())) {
			Pattern pattern = Pattern.compile("/iconimg\\.(?:gif|png|jpg|tiff)$");
			Matcher matcher = pattern.matcher(s);
			if (matcher.find()) {
				java.io.File file = V2CLocalFileHandler.getUserConfigFile("iconimg");
				if (V2CMiscUtil2.getContentWithDialog(s, file, null, "iconimg")) {
					V2CMain.clearV2CIcon();
					String as[] = { "OK" };
					JOptionPane.showOptionDialog(V2CMain.v2cMain,
							"アイコンが設定されました。", "icon set", 0, -1,
							V2CMain.getV2CIcon(true), as, as[0]);
				}
				else {
					V2CSwingUtil
							.showErrorMessage("iconimgのダウンロードに失敗しました。");
				}
			}
			else if (s.endsWith("/toolbar.zip")) {
				java.io.File file1 = V2CLocalFileHandler.getTempFile("tmp.zip");
				if (V2CMiscUtil2.getContentWithDialog(s, null, file1, "ツールバーアイコン")) {
					if (V2CLocalFileHandler.extractToolBarIcons(file1))
						V2CSwingUtil
								.showInformationMessage("ツールバーアイコンが設定されました。\n再起動後に変更が反映されます。");
					else
						V2CSwingUtil
								.showErrorMessage("ツールバーアイコンの解凍に失敗しました。");
				}
				else {
					V2CSwingUtil
							.showErrorMessage("ツールバーアイコンのダウンロードに失敗しました。");
				}
			}
			else if (s.endsWith("/item.zip")) {
				java.io.File file2 = V2CLocalFileHandler.getTempFile("tmp.zip");
				if (V2CMiscUtil2.getContentWithDialog(s, null, file2, "アイテム用アイコン")) {
					if (V2CLocalFileHandler.extractItemIcons(file2))
						V2CSwingUtil
								.showInformationMessage("アイテム用アイコンが設定されました。\n再起動後に変更が反映されます。");
					else
						V2CSwingUtil
								.showErrorMessage("アイテム用アイコンの解凍に失敗しました。");
				}
				else {
					V2CSwingUtil
							.showErrorMessage("アイテム用アイコンのダウンロードに失敗しました。");
				}
			}
			else if (V2CApp.isMacintosh() && V2CLauncher.startedByLauncher() && s.endsWith("/V2C.icns"))
				V2CLauncher.getMacIcnsFile(s);
			return;
		}
		else {
			V2CMiscUtil.openUnknownLink(s, flag, true, flag1, flag1, true);
			return;
		}
	}

	static void setComponentSize()
	{
		if (vAddresBar == null)
			return;
		boolean flag = nFixedWidth > 0;
		V2CToolBarComponentSettingPanel v2ctoolbarcomponentsettingpanel = new V2CToolBarComponentSettingPanel(flag,
				vAddresBar.getWidth());
		if (!v2ctoolbarcomponentsettingpanel.showDialog())
			return;
		V2CProperty v2cproperty = V2CMain.getUserProperty();
		int i = v2ctoolbarcomponentsettingpanel.getFixedWidth();
		if (i == nFixedWidth)
			return;
		nFixedWidth = i;
		if (i > 0)
			v2cproperty.putInt("AddressBar.Width", i);
		else
			v2cproperty.remove("AddressBar.Width");
		vAddresBar.invalidate();
		V2CToolBar v2ctoolbar = (V2CToolBar) SwingUtilities.getAncestorOfClass(org.monazilla.v2c.V2CToolBar.class, vAddresBar);
		if (v2ctoolbar != null) {
			v2ctoolbar.revalidate();
			v2ctoolbar.repaint();
		}
	}

	static void resetFont()
	{
		if (vAddresBar != null)
			vAddresBar.jtfAddress.setFont(null);
	}

	public static void setAddressText(String s)
	{
		if (vAddresBar == null) {
			return;
		}
		else {
			vAddresBar.setText(s);
			return;
		}
	}

	public V2CAddressBar()
	{
		super(new GridBagLayout());
		setOpaque(false);
		GridBagConstraints gridbagconstraints = V2CSwingUtil.createGridBagConstraints();
		Insets insets = gridbagconstraints.insets;
		JTextField jtextfield = V2CSwingUtil.createTextField();
		jtfAddress = jtextfield;
		jtextfield.enableInputMethods(true);
		if (V2CApp.isMacintosh() && V2CMacQuaquaSupport.needsGeometryTweak())
			V2CMacQuaquaSupport.resetVisualMargin(jtextfield);
		jtextfield.addActionListener(this);
		vPopupListener = new PopupListener();
		jtextfield.addMouseListener(vPopupListener);
		if (bWinSelection)
			jtextfield.addFocusListener(this);
		gridbagconstraints.weightx = 1.0D;
		gridbagconstraints.fill = 2;
		if (V2CSwingUtil.isSynthLaF())
			gridbagconstraints.insets = new Insets(0, 0, 1, 0);
		add(jtextfield, gridbagconstraints);
		gridbagconstraints.gridx++;
		gridbagconstraints.fill = 0;
		gridbagconstraints.weightx = 0.0D;
		JButton jbutton = V2CToolBar.createButtonForToolBar("gotoaddr");
		jbGo = jbutton;
		jbutton.addActionListener(this);
		jbutton.setFocusable(false);
		gridbagconstraints.insets = insets;
		add(jbutton, gridbagconstraints);
		V2CInputMap.interceptNormalKeyForTextComponent(this);
	}

	public void cut(String s)
	{
		jtfAddress.cut();
	}

	public void copy(String s)
	{
		jtfAddress.copy();
	}

	public void paste(String s)
	{
		jtfAddress.paste();
	}

	public void selectAll(String s)
	{
		jtfAddress.selectAll();
	}

	private void setText(String s)
	{
		if (s != null && !s.equals(jtfAddress.getText()))
			jtfAddress.setText(s);
	}

	void openLinkOutside()
	{
		String s = jtfAddress.getText();
		if (s != null && s.length() > 0)
			V2CMiscUtil.openLinkWithWebBrowser(s, true, false, true, false);
	}

	void openLinkInside()
	{
		String s = jtfAddress.getText();
		if (s != null && s.length() > 0)
			V2CMiscUtil.openLinkWithWebBrowser(s, true, true, false, false);
	}

	void getThreadWithMoritapo()
	{
		V2CParseLinkResult v2cparselinkresult = new V2CParseLinkResult(jtfAddress.getText());
		if (v2cparselinkresult.parse(true))
			V2CThreadPanel.getThreadWithMoritapo(v2cparselinkresult.getThreadItem());
	}

	void pasteAndGo(ActionEvent actionevent)
	{
		jtfAddress.selectAll();
		jtfAddress.paste();
		actionPerformed(actionevent);
	}

	void openWithCurrentTab()
	{
		openLocation(jtfAddress.getText(), false, false);
	}

	void openLinkAsBoard()
	{
		String s = V2CBBS.trimForBoardURL(jtfAddress.getText());
		if (s == null) {
			V2CMain.setErrorMessage("板のURLではありません。");
			return;
		}
		V2CBoardItem v2cboarditem = V2CBBS.getAnyBoardIfPossible(s, true);
		if (v2cboarditem == null) {
			V2CMain.setErrorMessage("板のURLではありません。");
			return;
		}
		else {
			v2cboarditem.open(true, true);
			return;
		}
	}

	public void actionPerformed(ActionEvent actionevent)
	{
		String s = jtfAddress.getText();
		Matcher lu = LockUrl.matcher(s);
		while (lu.find()) {
			s = s.replace("#"+lu.group(1), "");
			jtfAddress.setText(s);
			dolock0(lu.group(1), s);
			return;
		}
		Matcher m = patternInputhttpsUrl.matcher(s);
		while (m.find()) {
			s = s.replace(m.group(0), "http://" + m.group(2) + m.group(3));
		}
		if(V2CHttpUtil.Use5chNet){
			m = patternInput5chUrl.matcher(s);
			while (m.find()) {
				s = s.replace(m.group(0), m.group(1) + m.group(2) + ".2ch.net/");
			}
		}
		m = patternInputjbbshttpsUrl.matcher(s);
		while (m.find()) {
			s = s.replace("https://", "http://");
		}
		m = patternInputjbbsKakoLogUrl.matcher(s);
		while (m.find()) {
			s = s.replace("/read_archive.cgi/", "/read.cgi/");
		}
		m = patternInputmachibbshttpsUrl.matcher(s);
		while (m.find()) {
			s = s.replace("https://", "http://");
			s = machiBBS2legacyUrl(s);
		}
		m = patternInputtalkjpUrl.matcher(s);
		while (m.find()) {
			s = "https://classic.talk-platform.com/test/read.cgi/" + m.group(1) + "/" + m.group(2) + "/";
		}
		s = V2CInsteadOfThreadldJs.resolveUrl(s);
		jtfAddress.setText(s);
		openLocation(jtfAddress.getText(), (actionevent.getModifiers() & 1) == 0, false);
	}

	public Dimension getMaximumSize()
	{
		Dimension dimension = super.getPreferredSize();
		if (dimension != null) {
			if (nFixedWidth > 0)
				return new Dimension(nFixedWidth, dimension.height);
			else
				return new Dimension(0x7fffffff, dimension.height);
		}
		else {
			return super.getMaximumSize();
		}
	}

	public Dimension getPreferredSize()
	{
		Dimension dimension = super.getPreferredSize();
		if (nFixedWidth > 0)
			return new Dimension(nFixedWidth, dimension.height);
		else
			return dimension;
	}

	public Dimension getMinimumSize()
	{
		Dimension dimension = super.getMinimumSize();
		if (nFixedWidth > 0)
			return new Dimension(nFixedWidth, dimension.height);
		else
			return dimension;
	}

	public void focusGained(FocusEvent focusevent)
	{
		if (bTempFocusLost) {
			return;
		}
		else {
			jtfAddress.selectAll();
			return;
		}
	}

	public void focusLost(FocusEvent focusevent)
	{
		bTempFocusLost = focusevent.isTemporary();
		if (bTempFocusLost) {
			return;
		}
		else {
			Caret caret = jtfAddress.getCaret();
			int i = caret.getDot();
			jtfAddress.setSelectionStart(i);
			jtfAddress.setSelectionEnd(i);
			return;
		}
	}

	public void showPopupMenuByKB(ActionEvent actionevent)
	{
		vPopupListener.showPopup(jtfAddress);
	}

	private static final String sWidthKey = "AddressBar.Width";
	private static final boolean bWinSelection = V2CApp.isWinType();
	private static V2CAddressBar vAddresBar;
	static int nFixedWidth = V2CMain.getUserProperty().getInt("AddressBar.Width");
	JTextField jtfAddress;
	PopupListener vPopupListener;
	JButton jbGo;
	private boolean bTempFocusLost;

	public void doLock(V2CThreadPanel v2cthreadpanel, String lock)
	{
		String s = v2cthreadpanel.getThreadItem().getFormalURLString();
		Matcher lu = patternReadCGI.matcher(s);
		while (lu.find()) {
			dolock0(lock, s);
			return;
		}
		V2CSwingUtil.showWarningMessage("スレの" + (lock.equals("lock")?"ロック":"ロック解除") + "は、5ちゃん(V2C上では2ちゃん表記)とBBSPINKでのみ有効です");
	}
	
	private void dolock0(String lock, String s){
		V2CLockedThreadList v2ckockedthreadlist = new V2CLockedThreadList();
		if(lock.equals("lock")){
			v2ckockedthreadlist.update(null, s, null);
		}else if(lock.equals("unlock")){
			v2ckockedthreadlist.update(null, null, s);
		}
		v2ckockedthreadlist = null;
		String sLabel = s;
		Matcher matcher = patternReadCGI.matcher(s);
		if (matcher.matches()) {
			V2CBoardItem v2cboarditem = V2C2chBBS.getBoardItem(s);
			if(v2cboarditem != null){
				if(v2cboarditem.is2ch()){
					V2CThreadItem v2cthreaditem = v2cboarditem.getThreadItem(matcher.group(4) + ".dat");
					sLabel = v2cthreaditem.getTabTitle();
				}else{
					V2CSwingUtil.showWarningMessage("スレの" + (lock.equals("lock")?"ロック":"ロック解除") + "は、5ちゃん(V2C上では2ちゃん表記)とBBSPINKでのみ有効です");
					return;
				}
			}
		}
		V2CSwingUtil.showInformationMessage("「" + sLabel + "」 " + (lock.equals("lock")?"をロックしました":"のロックを解除しました"));
		return;
	}
	
	public static String machiBBS2legacyUrl(String s){
		Matcher m = patternInputmachibbshttpsUrlThread.matcher(s);
		boolean bm = false;
		String board = "";
		while (m.find()) {
			bm = true;
			board = m.group(1);
		}
		if(!bm){
			m = patternInputmachibbshttpsUrlThreadList.matcher(s);
			while (m.find()) {
				board = m.group(1);
			}
		}
		if(board != ""){
			return s.replaceAll("https?://machi\\.to/", "http://" + getSubHost(board) + ".machi.to/");
		}else{
			return s;
		}
	}
	public static String getSubHost(String s){
		if(s.equals("hokkaidou")) return "hokkaido";
		if(s.equals("touhoku")) return "tohoku";
		if(s.equals("kousinetu")) return "kousinetu";
		if(s.equals("kanto")) return "kanto";
		if(s.equals("tokyo")) return "tokyo";
		if(s.equals("tama")) return "kanto";
		if(s.equals("kana")) return "kanto";
		if(s.equals("toukai")) return "tokai";
		if(s.equals("kinki")) return "kinki";
		if(s.equals("osaka")) return "kinki";
		if(s.equals("cyugoku")) return "chugoku";
		if(s.equals("sikoku")) return "sikoku";
		if(s.equals("kyusyu")) return "kyusyu";
		if(s.equals("okinawa")) return "okinawa";
		if(s.equals("tawara")) return "www";
		return "";
	}
}
