package org.monazilla.v2c;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class V2CAPISettings7 extends JPanel {

	JPanel jPanel;
	
	private static final String useUPLIFT_Key = "2chAPI.useUPLIFT";
	private static final String Not_UPLIFT_AutoLogin_Key = "2chAPI.Not_UPLIFT_AutoLogin";
	private static final String RomSenBoard_Key = "2chAPI.RomSenBoard";
	static JCheckBox useUPLIFT = new JCheckBox("UPLIFTで5chにログインする", V2CHttpUtil.apiProperty.getBoolean(useUPLIFT_Key));
	static JCheckBox Not_UPLIFT_AutoLogin = new JCheckBox("UPLIFTに自動ログインしない", V2CHttpUtil.apiProperty.getBoolean(Not_UPLIFT_AutoLogin_Key));
	static JTextField[] config2 = new JTextField[1];

	public V2CAPISettings7() {
		this.jPanel = new JPanel(new GridBagLayout());

		GridBagConstraints constraints = V2CSwingUtil
				.createGridBagConstraints();

		constraints = V2CSwingUtil.createGridBagConstraints();
		JPanel UPLIFTandDonguriPanel = new JPanel(new GridBagLayout());
		UPLIFTandDonguriPanel.setBorder(new TitledBorder("UPLIFT と どんぐり"));
		constraints.insets = new Insets(2, 7, 2, 7);

		constraints.gridx = 0;
		constraints.gridy = 0;
		UPLIFTandDonguriPanel.add(useUPLIFT, constraints);

		constraints.gridx = 0;
		constraints.gridy++;
		UPLIFTandDonguriPanel.add(Not_UPLIFT_AutoLogin, constraints);

		constraints = V2CSwingUtil.createGridBagConstraints();
		JPanel RomSenBoardPanel = new JPanel(new GridBagLayout());
		RomSenBoardPanel.setBorder(new TitledBorder("ロム専にする板(複数ある場合は半角カンマで区切る)"));
		constraints.insets = new Insets(2, 7, 2, 7);
		constraints.gridx = 0;
		constraints.gridy = 0;
		RomSenBoardPanel.add(new JLabel("キーワード(例：.2ch.net/software) :"),
				constraints);
		config2[0] = new JTextField(V2CHttpUtil.RomSenBoard, 35);
		constraints.gridx = 1;
		RomSenBoardPanel.add(config2[0], constraints);

		constraints = V2CSwingUtil.createGridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 0;
		this.jPanel.add(UPLIFTandDonguriPanel, constraints);
		constraints.gridy++;
		this.jPanel.add(RomSenBoardPanel, constraints);
	}

	JPanel getPanel() {
		return this.jPanel;
	}

	public static V2CProperty saveChanges(V2CProperty apiProperty) {
		apiProperty.putBoolean(useUPLIFT_Key, useUPLIFT.isSelected());
		apiProperty.putBoolean(Not_UPLIFT_AutoLogin_Key, Not_UPLIFT_AutoLogin.isSelected());
		apiProperty.put(RomSenBoard_Key, config2[0].getText().replaceAll(" ", ""));
		V2CHttpUtil.useUPLIFT = useUPLIFT.isSelected();
		V2CHttpUtil.Not_UPLIFT_AutoLogin = Not_UPLIFT_AutoLogin.isSelected();
		V2CHttpUtil.RomSenBoard = config2[0].getText().replaceAll(" ", "");
		V2CHttpUtil.RomSenBoardArrayList = V2CHttpUtil.StringToArrayList("ROM専の板", V2CHttpUtil.RomSenBoard);
		return apiProperty;
	}
}
