package org.monazilla.v2c;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class V2CAPISettings extends JPanel {

	public static final String SubVersion = ".32.2.4 For Java5 on MacOSX";
	public static final String exp = ".js";

	private static final long serialVersionUID = 1L;
	private static final String HMKey_Key = "2chAPI.HMKey";
	private static final String AppKey_Key = "2chAPI.AppKey";
	private static final String UAName_Key = "2chAPI.UAName";
	private static final String UAPost_Key = "2chAPI.UAPost";
	private static final String UAAuth_Key = "2chAPI.UAAuth";
	private static final String XUAName_Key = "2chAPI.X2chUA";
	private static final String UseAPI_Key = "2chAPI.UseAPI";
//	private static final String UseHYBRID_Key = "2chAPI.UseHYBRID";
	public static final String UseSC_Key = "2chAPI.UseSC";
	private static final String UseHTML_Key = "2chAPI.UseHTML";
//	private static final String UseSSL_Key = "2chAPI.UseSSL";
	private static final String UAPostCGI_Key = "2chAPI.UAPostCGI";
	private static final String UAPostCGIPost_Key = "2chAPI.UAPostCGIPost";
	private static final String reloadJS_Key = "2chAPI.reloadJS";
	public static final String exclusionSC_Key = "2chAPI.exclusionSC";
	public static final String MacAppPath_Key = "2chAPI.MacAppPath";
	public static final String OperationErrorResponseCode_Key = "2chAPI.OperationErrorResponseCode";
	public static final String OperationErrorDat_Key = "2chAPI.OperationErrorDat";
	public static final String NoBouncyCastleHosts_Key = "2chAPI.NoBouncyCastleHosts";
	public static final String BadgeHttps_Key = "2chAPI.BadgeHttps";
	public static final String Badge5ch_Key = "2chAPI.Badge5ch";
	public static final String UATwitter_Key = "2chAPI.UATwitter";
	public static final String CreateMovieThumb_ffmpeg_Key = "2chAPI.CreateMovieThumb_ffmpeg";
	public static final String Append_1_toURL_Key = "2chAPI.Append_1_toURL";

	JPanel jPanel;
	JTextField[] config = new JTextField[8];
	static JTextField[] config2 = new JTextField[1];

	JCheckBox useAPI = new JCheckBox(/*"2ch APIを使用する"*/ "datを取得する", V2CHttpUtil.apiProperty.getBoolean(UseAPI_Key));
//	JCheckBox useHYBRID = new JCheckBox("1式HYBRIDを使用する(APIモードでの書き込みにread.cgi 書き込み用UAを使用する)", V2CHttpUtil.apiProperty.getBoolean(UseHYBRID_Key));
	JCheckBox useHTML = new JCheckBox("read.cgiを使用する", V2CHttpUtil.apiProperty.getBoolean(UseHTML_Key, true));
//	JCheckBox useSSL = new JCheckBox("read.cgi使用時、常にhttps://で受信する", V2CHttpUtil.apiProperty.getBoolean(UseSSL_Key));
//	JCheckBox useSC = new JCheckBox("2ch.scを使用する", V2CHttpUtil.apiProperty.getBoolean(UseSC_Key));
	JCheckBox reloadJS = new JCheckBox("readcgi" + exp + "のデバッグを行う(受信したhtmlと変換後のdatをコンソールログに出力します)", V2CHttpUtil.apiProperty.getBoolean(reloadJS_Key));
//	JCheckBox exclusionSC = new JCheckBox("SCのスレで常にSCからのレスを除外する(通常はチェックしない)", V2CHttpUtil.apiProperty.getBoolean(exclusionSC_Key));

	public V2CAPISettings() {
		this.jPanel = new JPanel(new GridBagLayout());

		GridBagConstraints constraints = V2CSwingUtil
				.createGridBagConstraints();
		JPanel keyConfigPanel = new JPanel(new GridBagLayout());
		keyConfigPanel.setBorder(new TitledBorder("鍵設定"));
		constraints.insets = new Insets(2, 7, 2, 7);

		keyConfigPanel.add(new JLabel("API共通鍵（HMKey）："),
				constraints);
		constraints.gridx += 1;
		config[0] = new JTextField(V2CHttpUtil.getHMKey(null), 35);
		keyConfigPanel.add(config[0], constraints);
		constraints.gridx = 0;
		constraints.gridy += 1;
		keyConfigPanel
				.add(new JLabel("API鍵（AppKey）："), constraints);
		constraints.gridx += 1;
		config[1] = new JTextField(V2CHttpUtil.getAppKey(null), 35);
		keyConfigPanel.add(config[1], constraints);

		JPanel uaConfigPanel = new JPanel(new GridBagLayout());
		uaConfigPanel.setBorder(new TitledBorder("UA設定 (読み込めない/書き込めない場合は、最初にUAを新しい物に変えてみてください)"));
		constraints.insets = new Insets(2, 7, 2, 7);
		constraints.gridx = 0;
		constraints.gridy = 0;
		uaConfigPanel.add(new JLabel("API 認証用UA (X-2ch-UA) :"),
				constraints);
		config[2] = new JTextField(V2CHttpUtil.X2CHUA, 35);
		constraints.gridx = 1;
		uaConfigPanel.add(config[2], constraints);
		constraints.gridx = 0;
		constraints.gridy += 1;
		uaConfigPanel.add(new JLabel("ユーザーエージェント(専ブラ dat取得) :"),
				constraints);
		config[3] = new JTextField(V2CHttpUtil.UAName, 35);
		constraints.gridx = 1;
		uaConfigPanel.add(config[3], constraints);

                constraints.gridx = 0;
		constraints.gridy += 1;
		uaConfigPanel.add(new JLabel("ユーザーエージェント(専ブラ 書き込み) :"),
				constraints);
		config[4] = new JTextField(V2CHttpUtil.UAPost, 35);
		constraints.gridx = 1;
		uaConfigPanel.add(config[4], constraints);

		constraints.gridx = 0;
		constraints.gridy += 1;
		uaConfigPanel.add(new JLabel("ユーザーエージェント(API 認証) :"),
				constraints);
		config[5] = new JTextField(V2CHttpUtil.UAAuth, 35);
		constraints.gridx = 1;
		uaConfigPanel.add(config[5], constraints);

		constraints.gridx = 0;
		constraints.gridy += 1;
		uaConfigPanel.add(new JLabel("ユーザーエージェント(read.cgi ページ取得) :"),
				constraints);
		config[6] = new JTextField(V2CHttpUtil.UAPostCGI, 35);
		constraints.gridx = 1;
		uaConfigPanel.add(config[6], constraints);

		constraints.gridx = 0;
		constraints.gridy += 1;
		uaConfigPanel.add(new JLabel("ユーザーエージェント(read.cgi 書き込み) :"),
				constraints);
		config[7] = new JTextField(V2CHttpUtil.UAPostCGIPost, 35);
		constraints.gridx = 1;
		uaConfigPanel.add(config[7], constraints);

		JPanel removeCookiesPane = new JPanel(new GridBagLayout());
		removeCookiesPane.setBorder(new TitledBorder("クッキー削除 & 調査支援設定"));
		constraints.insets = new Insets(2, 7, 2, 7);

		constraints.gridx = 0;
		constraints.gridy = 0;
		JButton button0 = new JButton("鍵をクリアする");
		button0 = V2CHttpUtilOld2New.setEnableStatus(button0);
		button0.addActionListener(new clearMonaKey());
		removeCookiesPane.add(button0, constraints);

		constraints.gridx = 1;
		constraints.gridy = 0;
		JButton button2 = new JButton("5ch/BBSPINKのクッキーを削除する");
		button2.addActionListener(new remove5chCookies());
		removeCookiesPane.add(button2, constraints);

		constraints.gridx = 2;
		constraints.gridy = 0;
		JButton button1 = new JButton("クッキーを全て削除する");
		button1.addActionListener(new removeCookies());
		removeCookiesPane.add(button1, constraints);

//		constraints.gridx = 2;
//		constraints.gridy = 0;
//		JButton button2 = new JButton("共通UA設定" + getAPISettingDefaultLastModified());
//		button2.addActionListener(new SurveySupport());
//		if(useAPI.isSelected()){
//			button2.setEnabled(false);
//		}
//		removeCookiesPane.add(button2, constraints);

        constraints.gridx = 0;
		constraints.gridy = 0;
		this.jPanel.add(useAPI, constraints);
		constraints.gridy++;		
//		constraints.insets = new Insets(2, 27, 2, 7);
//		this.jPanel.add(useHYBRID, constraints);
		constraints.insets = new Insets(2, 7, 2, 7);
		constraints.gridy++;		
		this.jPanel.add(useHTML, constraints);
//		constraints.gridy++;		
//		this.jPanel.add(useSSL, constraints);
//		constraints.gridy++;
//		if (!V2CHttpUtil.apiProperty.getBoolean("I.hate.Tarako")){
//			this.jPanel.add(useSC, constraints);
//			constraints.gridy++;
//		}

		GridBagConstraints constraints1 = V2CSwingUtil
				.createGridBagConstraints();
		JPanel Append_1_Panel = new JPanel(new GridBagLayout());
		constraints1 = V2CSwingUtil.createGridBagConstraints();
		constraints1.insets = new Insets(0, 0, 0, 0);
		constraints1.gridx = 0;
		constraints1.gridy = 0;
		Append_1_Panel.add(new JLabel("⇒ urlに「1-」を追加する鯖/板(半角カンマで区切る)："),
				constraints1);
		config2[0] = new JTextField(V2CHttpUtil.Append_1_toURL, 35);
		constraints1.gridx = 1;
		Append_1_Panel.add(config2[0], constraints1);
		constraints.insets = new Insets(2, 27, 2, 7);
		constraints.gridy++;
		this.jPanel.add(Append_1_Panel, constraints);

		constraints.insets = new Insets(2, 7, 2, 7);
		constraints.gridy++;		
		this.jPanel.add(reloadJS, constraints);
//		constraints.gridy++;		
//		this.jPanel.add(exclusionSC, constraints);
		constraints.gridy++;		
		this.jPanel.add(keyConfigPanel, constraints);
		constraints.gridy++;
		this.jPanel.add(uaConfigPanel, constraints);
		constraints.gridy++;
		this.jPanel.add(removeCookiesPane, constraints);
		JLabel l = new JLabel("V2C API Patch - B11" + SubVersion);
		constraints.gridy++;
		constraints.gridwidth = 300;
		this.jPanel.add(l, constraints);
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
		JLabel l1 = new JLabel("readcgi" + exp + " - " + sdf.format(new File(V2CLauncher.getJarDir(), "readcgi" + exp).lastModified()) + "、" +
							   "readcgi_aux" + exp + " - " + sdf.format(new File(V2CLauncher.getJarDir(), "readcgi_aux" + exp).lastModified()));
		constraints.gridy++;
		this.jPanel.add(l1, constraints);
//		JLabel l2 = new JLabel("readcgi_aux" + exp + " - " + sdf.format(new File(V2CLauncher.getJarDir(), "readcgi_aux" + exp).lastModified()));
//		constraints.gridy++;
//		this.jPanel.add(l2, constraints);
/*
		File file0 = new File(V2CLauncher.getJarDir(), "ReplaceStr_B11_Dev.txt");
		if(!file0.exists()){
			file0 = new File(V2CLauncher.getJarDir(), "ReplaceStr_B11.txt");
		}
		JLabel l3 = (file0.exists()?new JLabel(file0.getName() + " - " + sdf.format(file0.lastModified())):new JLabel("B11用 ReplaceStr.txt - 未使用"));
		constraints.gridy++;
		this.jPanel.add(l3, constraints);
*/
	}

	JPanel getPanel() {
		return this.jPanel;
	}

	public void saveChanges() {
		V2CProperty apiProperty = V2CHttpUtil.apiProperty;
		apiProperty.put(HMKey_Key, config[0].getText().trim());
		apiProperty.put(AppKey_Key, config[1].getText().trim());
		apiProperty.put(XUAName_Key, config[2].getText().trim());
		apiProperty.put(UAName_Key, config[3].getText().trim());
		apiProperty.put(UAPost_Key, config[4].getText().trim());
		apiProperty.put(UAAuth_Key, config[5].getText().trim());
		apiProperty.putBoolean(UseAPI_Key, useAPI.isSelected());
//		apiProperty.putBoolean(UseHYBRID_Key, useHYBRID.isSelected());
		apiProperty.putBoolean(UseSC_Key, V2CAPISettings4.useSC.isSelected());
		apiProperty.putBoolean(UseHTML_Key, useHTML.isSelected());
//		apiProperty.putBoolean(UseSSL_Key, useSSL.isSelected());
		apiProperty.put(UAPostCGI_Key, config[6].getText().trim());
		apiProperty.put(UAPostCGIPost_Key, config[7].getText().trim());
		apiProperty.putBoolean(reloadJS_Key, reloadJS.isSelected());
		apiProperty.putBoolean(exclusionSC_Key, V2CAPISettings4.exclusionSC.isSelected());
		apiProperty.put(Append_1_toURL_Key, config2[0].getText().replaceAll(" ", ""));
		if(useAPI.isSelected()){
			if(
				!V2CHttpUtil.HMKey.equals(config[0].getText().trim()) ||
				!V2CHttpUtil.AppKey.equals(config[1].getText().trim()) ||
				!V2CHttpUtil.X2CHUA.equals(config[2].getText().trim()) ||
				!V2CHttpUtil.UAName.equals(config[3].getText().trim()) ||
				!V2CHttpUtil.UAPost.equals(config[4].getText().trim()) ||
				!V2CHttpUtil.UAAuth.equals(config[5].getText().trim())
			){
				V2CHttpUtilOld2New.clearNonaKey();
			}
		}
		V2CHttpUtil.HMKey = config[0].getText().trim();
		V2CHttpUtil.AppKey = config[1].getText().trim();
		V2CHttpUtil.X2CHUA = config[2].getText().trim();
		V2CHttpUtil.UAName = config[3].getText().trim();
		V2CHttpUtil.UAPost = config[4].getText().trim();
		V2CHttpUtil.UAAuth= config[5].getText().trim();
		V2CHttpUtil.useAPI = useAPI.isSelected();
//		V2CHttpUtil.useHYBRID = useHYBRID.isSelected();
		V2CHttpUtil.useSC = V2CAPISettings4.useSC.isSelected();
		V2CHttpUtil.useHTML = useHTML.isSelected();
//		V2CHttpUtil.useSSL = useSSL.isSelected();
		if(V2CHttpUtil.SID_updater != null) V2CHttpUtil.SID_updater.interrupt();
		V2CHttpUtil.reloadJS = reloadJS.isSelected();
		V2CHttpUtil.UAPostCGI = config[6].getText().trim();
		V2CHttpUtil.UAPostCGIPost = config[7].getText().trim();
		V2CHttpUtil.exclusionSC = V2CAPISettings4.exclusionSC.isSelected();
		V2CHttpUtil.Append_1_toURL = config2[0].getText().replaceAll(" ", "");
		V2CHttpUtil.Append_1_toURLArrayList = V2CHttpUtil.StringToArrayList("read.cgiモード読み込みurlに「1-」を追加する板", V2CHttpUtil.Append_1_toURL.replace("\\,", "%comma%"));
		apiProperty = V2CAPISettings2.saveChanges(apiProperty);
		apiProperty = V2CAPISettings3.saveChanges2(apiProperty);
		apiProperty = V2CAPISettings4.saveChanges(apiProperty);
		apiProperty = V2CAPISettings6.saveChanges(apiProperty);
		apiProperty = V2CAPISettings7.saveChanges(apiProperty);
		apiProperty.doSaveState();
		V2CAPISettings3.saveChanges();
		V2CAPISettings3Plus.saveChanges();
		V2CAPISettings5.saveChanges();
		V2CHttpUtilMultiSenbra.setAddionalApiKeys();
	}

	private class removeCookies implements ActionListener{
		public void actionPerformed(ActionEvent e){
			V2CCookie.removeAllCookies();
		}
	}

	private class remove5chCookies implements ActionListener{
		public void actionPerformed(ActionEvent e){
			V2CCookie.removeTargetCookies();
		}
	}

	private class SurveySupport implements ActionListener{
		public void actionPerformed(ActionEvent e){
			V2CProperty localv2cproperty = V2CMain.getUserProperty();
			File localApiFile = new File(localv2cproperty.fParentFolder.getAbsolutePath()
					+ "/2ch_api_SurveySupport.txt");
			V2CHttpUtil.CAndC candc = V2CHttpUtil.getRawTextFile("http://www7b.biglobe.ne.jp/~hashlay/SurveySupport/2ch_api.txt", 0);
			if (candc != null) {
				byte abyte0[] = candc.getRawContents();
				if (abyte0 != null) {
					if (!V2CLocalFileHandler.saveToFile(localApiFile, abyte0)) {
					}
				}
			}

			File localApiFileSecondaryUA = new File(localv2cproperty.fParentFolder.getAbsolutePath()
					+ "/2ch_api_SecondaryUA_SurveySupport.txt");
			candc = V2CHttpUtil.getRawTextFile("http://www7b.biglobe.ne.jp/~hashlay/SurveySupport/2ch_api_SecondaryUA.txt", 0);
			if (candc != null) {
				byte abyte0[] = candc.getRawContents();
				if (abyte0 != null) {
					if (!V2CLocalFileHandler.saveToFile(localApiFileSecondaryUA, abyte0)) {
					}
				}
			}

			if (localApiFile.exists() && localApiFileSecondaryUA.exists()) {
				FileCopy(localv2cproperty, "2ch_api.txt");
				FileCopy(localv2cproperty, "2ch_api_SecondaryUA.txt");
				
				V2CProperty localApiProperty = new V2CProperty(localApiFile);
//				useAPI.setSelected(localApiProperty.getBoolean("2chAPI.UseAPI"));
//				if(useAPI.isSelected()){
//					useHYBRID.setSelected(true);
//				}
//				useHTML.setSelected(localApiProperty.getBoolean("2chAPI.UseHTML"));
//				reloadJS.setSelected(localApiProperty.getBoolean("2chAPI.reloadJS"));

//				config[0].setText(localApiProperty.get("2chAPI.HMKey"));
//				config[1].setText(localApiProperty.get("2chAPI.AppKey"));

				String Value;
//				Value = localApiProperty.get("2chAPI.X2chUA");
//		        if (null == Value){
//		        	Value = "DOLIB/1.00";
//		        }
//				config[2].setText(Value);

//				Value = localApiProperty.get("2chAPI.UAName");
//				if (null == Value) {
//                	Value = V2CHttpUtil.DEFAULT_UA;
//				}
//				config[3].setText(Value);

//				Value = localApiProperty.get("2chAPI.UAPost");
//				if (null == Value) {
//                	Value = V2CHttpUtil.DEFAULT_UA;
//				}
//				config[4].setText(Value);

//				Value = localApiProperty.get("2chAPI.UAAuth");
//				if (null == Value) {
//                	Value = config[3].getText();
//				}
//				config[5].setText(Value);

				Value = localApiProperty.get("2chAPI.UAPostCGI");
		        if (null == Value || "" == Value) {
		        	Value = V2CHttpUtil.IE_UA;
		        }
				config[6].setText(Value);

				Value = localApiProperty.get("2chAPI.UAPostCGIPost");
		        if (null == Value || "" == Value) {
		        	Value = config[6].getText();
		        }
				config[7].setText(Value);

//				Value = localApiProperty.get("2chAPI.PostAcceptUseChrome");
//		        if (null == Value || "" == Value) {
//		        	Value = "";
//		        }
//		        V2CAPISettings3.config2[0].setText(Value);

		        Value = localApiProperty.get("2chAPI.Use_guidON_ToPost");
		        if (null == Value || "" == Value) {
		        	Value = "";
		        }
		        V2CAPISettings3.config2[1].setText(Value);

		        Value = localApiProperty.get("2chAPI.Use_READJS_ToPost");
		        if (null == Value || "" == Value) {
		        	Value = "";
		        }
		        V2CAPISettings3.config2[4].setText(Value);

		        Value = localApiProperty.get("2chAPI.PostAccept_FF");
		        if (null == Value || "" == Value) {
		        	Value = "";
		        }
		        V2CAPISettings3.config2[2].setText(Value);
		        V2CAPISettings3.config2[2].setColumns(54);

		        Value = localApiProperty.get("2chAPI.PostAccept_Chrome");
		        if (null == Value || "" == Value) {
		        	Value = "";
		        }
		        V2CAPISettings3.config2[3].setText(Value);
		        V2CAPISettings3.config2[3].setColumns(54);

				localApiProperty = null;

				String[] sUA = new String[3];
				V2CHttpUtil_SecondaryUA SecondaryUA = new V2CHttpUtil_SecondaryUA();
				sUA = SecondaryUA.getSecondaryUA("_SurveySupport");
				SecondaryUA = null;

				int[] Rows = {2, 2, 3};
				for(int i=0; i<3; i++){
					V2CAPISettings3.config[i].setText(sUA[i]);
					V2CAPISettings3.config[i].setRows(Rows[i]);
					V2CAPISettings3.config[i].setColumns(60);
				}
				
				localApiFile.delete();
				localApiFileSecondaryUA.delete();
			}else{
				V2CSwingUtil.showErrorMessage("調査支援用API設定ファイルがありません");
			}
			localv2cproperty = null;
		}
	}
	
	private void FileCopy(V2CProperty localv2cproperty, String fn){
		File inFile  = new File(localv2cproperty.fParentFolder.getAbsolutePath() + "/" + fn);
		SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
		long lastModified = inFile.lastModified();
		File outFile = new File(localv2cproperty.fParentFolder.getAbsolutePath() + "/" + fn.replaceAll("\\.txt", "_" + sdf.format(lastModified) + ".txt"));
		V2CLocalFileHandler.copyFile(inFile, outFile, true);
        outFile.setLastModified(lastModified);
	}
	
	private String getAPISettingDefaultLastModified(){
		V2CHttpUtil.CAndC candc = V2CHttpUtil.getRawTextFile("http://www7b.biglobe.ne.jp/~hashlay/SurveySupport/LastModified.txt", 0);
		if (candc != null) {
			byte abyte0[] = candc.getRawContents();
			if (abyte0 != null) {
				return " (" + (new String(abyte0)).replaceAll("\\n", "") + "更新)";
			}
		}
		return "";
	}


	private class clearMonaKey implements ActionListener{
		public void actionPerformed(ActionEvent e){
			V2CHttpUtilOld2New.clearNonaKey();
		}
	}
}
