import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.monazilla.v2c.V2CAddressBar;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CDarkMode;

public class V2C
{

	private static final Pattern MajorVersion = Pattern
			.compile("^([\\d]+).*");
	private static final Pattern patternArg = Pattern
			.compile("https?://([^\\.]*)(\\.[25]ch\\.net)/");
	private static final Pattern patternArg2 = Pattern
			.compile("https?://jbbs\\.shitaraba\\.(net|com)/");
	private static final Pattern patternArg3 = Pattern
			.compile("https?://([^.]+\\.)?machi\\.to/");

	public V2C()
	{
	}

	public static void main(String args[])
	{
		Matcher m1 = MajorVersion.matcher(System.getProperty("java.runtime.version"));
		if (m1.matches()){
			int MajorVersion = Integer.parseInt(m1.group(1));
			if(MajorVersion >= 9){
			   	System.setProperty("v2c.java.version", String.valueOf(MajorVersion) +".0");
			}
			String v2cjsv = System.getProperty("java.specification.version");
			if(v2cjsv != null){
				if(v2cjsv.equals("1.5") || v2cjsv.equals("1.6") || v2cjsv.equals("1.7")){
					String jarPath = System.getProperty("java.class.path");
					String dirPath = jarPath.substring(0, jarPath.lastIndexOf(File.separator)+1);
					(new File(dirPath + "rhino.jar")).delete();
					(new File(dirPath + "js-engine.jar")).delete();
				}
			}
		}

		String jarPath = System.getProperty("java.class.path");
		String dirPath = jarPath.substring(0, jarPath.lastIndexOf(File.separator)+1);
		File v2cargs_B11 = (new File(dirPath + "v2cargs_B11.txt"));
		if(v2cargs_B11.exists()){
			BufferedReader br = null;
			String s = null;
			try {
				br = new BufferedReader(new FileReader(v2cargs_B11));
				while ((s = br.readLine()) != null) {
					break;
				}
			} catch (IOException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			} finally {
				if (br != null) {
					try {
						br.close();
					} catch (IOException e) {
						// TODO 自動生成された catch ブロック
						e.printStackTrace();
					}
				}
			}
			String[] opts = s.trim().replaceAll(" +", " ").split(" ");
			for(int i=0; i<opts.length; i++){
				if(opts[i].startsWith("-D")){
					String[] kv = opts[i].replaceAll("^-D", "").split("=");
					if(kv.length == 2){
						System.setProperty(kv[0], kv[1]);
					}
				}
			}
		}
		
		V2CDarkMode.setcolorkeys();

		for(int i=0; i<args.length; i++){
			Matcher m = patternArg.matcher(args[i]);
			while (m.find()) {
				args[i] = args[i].replace(m.group(0), "http://" + m.group(1) + ".2ch.net/");
			}
			m = patternArg2.matcher(args[i]);
			while (m.find()) {
				args[i] = args[i].replace(m.group(0), "http://jbbs.shitaraba.net/");
			}
			m = patternArg3.matcher(args[i]);
			while (m.find()) {
				args[i] = args[i].replace("https://", "http://");
				args[i] = V2CAddressBar.machiBBS2legacyUrl(args[i]);
			}
		}

		File v2crelativefolder = new File(getApplicationDir("launcher"), "v2cfolder.txt");		
		if(v2crelativefolder.exists()){
			String s = null;
			boolean isAbsolute = false;
			File f = getApplicationDir("");
			BufferedReader br = null;
			try {
				br = new BufferedReader(new FileReader(v2crelativefolder));
				while ((s = br.readLine()) != null) {
					if(s.substring(0, 2).equals("##")){
						s = null;
						continue;
					}
					isAbsolute = (new File(s)).isAbsolute();
					break;
				}
			} catch (IOException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			} finally {
				if (br != null) {
					try {
						br.close();
					} catch (IOException e) {
						// TODO 自動生成された catch ブロック
						e.printStackTrace();
					}
				}
			}
			if(s != null){
				System.setProperty("v2c.directory", (!isAbsolute
														?(new File(f.getAbsolutePath(), s)).getAbsolutePath()
														:(new File(                     s)).getAbsolutePath()
													)
				);
			}
		}
		V2CApp.startApp(args);
	}

	private static File getApplicationDir(String fldr)
	{
		URL url = (org.monazilla.v2c.V2CLauncher.class).getClassLoader().getResource("V2C.class");
		if (url == null)
			return null;
		String s = url.getPath();
		try {
			s = URLDecoder.decode(s, "UTF-8");
		}
		catch (UnsupportedEncodingException unsupportedencodingexception) {
			return null;
		}
		if (s == null || !s.startsWith("file:"))
			return null;
		int i = s.lastIndexOf(".jar!");
		if (i < 0)
			return null;
		String s1 = s.substring(5, i + 4);
		File file = new File(s1);
		if (!file.exists())
			return null;
		if (!file.isAbsolute()) {
			file = file.getAbsoluteFile();
			if (file == null || !file.exists())
				return null;
		}
		File fJarDir = file.getParentFile();
		if (!fJarDir.getName().equals("launcher")) {
			return null;
		}
		if(fldr.equals("launcher")){
			return fJarDir;
		}
		return fJarDir.getParentFile();
	}
}
