//【登録場所】 "V2C\script\system\readcgi_aux.js"

//【内容】.netスレのdat存在判定(.net→.scへの自動切替判定)
//【引数】oBody  : HTMLデータ
//【戻り値】datが存在しない場合は"KakoLog"、それ以外は""
function checkDotNetDatExists(oBody){

//	//スレのタイトルを取得
//	var title = oBody.match(/<title.*?>(.*?)\n?<\/title>/mi); //read.cgi 06対応
//
//	if((title+'').indexOf('ちゃんねるdatが存在しません。削除されたかURL間違ってますよ。') != -1){
//		return "KakoLog";
//	}
	return "";

}

//【内容】API+read.cgiモード時に、取得したDATの過去ログ判定を行う(read.cgiモードへの自動切替判定)
//【引数】rescode  : HTMLレスポンスコード
//　　　　rescount : 総レス数(thから取得できるレス数は正しくないのでこちらを使用してください)
//　　　　res      : レス配列
//【戻り値】過去ログの場合は"KakoLog"、それ以外は""
function checkKakologAPO(rescode, rescount, res){

	// レスポンスが正常、且つ総レス数2のスレだった場合
	if (rescode == 200 && rescount == 2) {
		var message = getMessage(res[1]);
		var idx = message.indexOf("このスレッドは過去ログです。");
		// 2レス目に該当レスが存在する場合はTrue
		if(idx != -1) {
			return "KakoLog";
		}
	}

	// 配信仕様変更メッセージが出たスレも一応read.cgiで取りに行ってみる
	if (rescode == 200 && rescount == 1) {
		var message = getMessage(res[0]);
		var idx = message.indexOf("ちゃんねるの配信仕様が変更されました。");
		// 2レス目に該当レスが存在する場合はTrue
		if(idx != -1) {
			return "KakoLog";
		}
	}

	// APIアクセス時にエラーコードが返ってくるスレがあるがread.cgiだと取得できることもあるのでこの場合もTrueを返す
	if (rescode >= 400 && rescode <= 499){
		return "KakoLog";
	}

	// 全ての判定条件に当てはまらなかった場合は過去ログではない
	return "";
}

function getMessage(msg){
	var str = (msg+"").split("<>");
	return (str.length>=4?str[3]+"":"");
}

//【内容】今後接続すべき鯖をSSLとすべきかnonSSLとすべきか判定する
//【引数】host     : host
//　　　　html     : html
//【戻り値】SSL接続とすべき場合は"true"、そうでない場合は"false"
function checkUseSSLSrever(host, html){

	var ret = "false";

	if(html.match(/<base href="https:\/\//)){
		ret = "true";
	}

	return ret;
}

function JSONToDat(url, lastResNum, htmltext){

	//文字化け解消テーブル読み込み
	var bodyTab  = {
		'%22' : 'quot',
		'%3C' : 'lt',
		'%3E' : 'gt',
		'%A0' : 'nbsp',
		'%A1' : 'iexcl',
		'%A2' : 'cent',
		'%A3' : 'pound',
		'%A4' : 'curren',
		'%A5' : 'yen',
		'%A6' : 'brvbar',
		'%A7' : 'sect',
		'%A8' : 'uml',
		'%A9' : 'copy',
		'%AA' : 'ordf',
		'%AB' : 'laquo',
		'%AC' : 'not',
		'%AC' : 'shy',
		'%AE' : 'reg',
		'%AF' : 'macr',
		'%B0' : 'deg',
		'%B1' : 'plusmn',
		'%B2' : 'sup2',
		'%B3' : 'sup3',
		'%B4' : 'acute',
		'%B5' : 'micro',
		'%B6' : 'para',
		'%B7' : 'middot',
		'%B8' : 'cedil',
		'%B9' : 'sup1',
		'%BA' : 'ordm',
		'%BB' : 'raquo',
		'%BC' : 'frac14',
		'%BD' : 'frac12',
		'%BE' : 'frac34',
		'%BF' : 'iquest',
		'%C0' : 'Agrave',
		'%C1' : 'Aacute',
		'%C2' : 'Acirc',
		'%C3' : 'Atilde',
		'%C4' : 'Auml',
		'%C5' : 'Aring',
		'%C6' : 'AElig',
		'%C7' : 'Ccedil',
		'%C8' : 'Egrave',
		'%C9' : 'Eacute',
		'%CA' : 'Ecirc',
		'%CB' : 'Euml',
		'%CC' : 'Igrave',
		'%CD' : 'Iacute',
		'%CE' : 'Icirc',
		'%CF' : 'Iuml',
		'%D0' : 'ETH',
		'%D1' : 'Ntilde',
		'%D2' : 'Ograve',
		'%D3' : 'Oacute',
		'%D4' : 'Ocirc',
		'%D5' : 'Otilde',
		'%D6' : 'Ouml',
		'%D7' : 'times',
		'%D8' : 'Oslash',
		'%D9' : 'Ugrave',
		'%DA' : 'Uacute',
		'%DB' : 'Ucirc',
		'%DC' : 'Uuml',
		'%DD' : 'Yacute',
		'%DE' : 'THORN',
		'%DF' : 'szlig',
		'%E0' : 'agrave',
		'%E1' : 'aacute',
		'%E2' : 'acirc',
		'%E3' : 'atilde',
		'%E4' : 'auml',
		'%E5' : 'aring',
		'%E6' : 'aelig',
		'%E7' : 'ccedil',
		'%E8' : 'egrave',
		'%E9' : 'eacute',
		'%EA' : 'ecirc',
		'%EB' : 'euml',
		'%EC' : 'igrave',
		'%ED' : 'iacute',
		'%EE' : 'icirc',
		'%EF' : 'iuml',
		'%F0' : 'eth',
		'%F1' : 'ntilde',
		'%F2' : 'ograve',
		'%F3' : 'oacute',
		'%F4' : 'ocirc',
		'%F5' : 'otilde',
		'%F6' : 'ouml',
		'%F7' : 'divide',
		'%F8' : 'oslash',
		'%F9' : 'ugrave',
		'%FA' : 'uacute',
		'%FB' : 'ucirc',
		'%FC' : 'uuml',
		'%FD' : 'yacute',
		'%FE' : 'thorn',
		'%FF' : 'yuml',
	};

/*
	var u = url;
	if((''+u).match(/https?:\/\/([^\.]+)\.[25]ch\.net\/([^\/]+)\/dat\/([^\.]+)\.dat/)){
		u ='http://itest.5ch.net/public/newapi/client.php?subdomain=' + RegExp.$1 + '&board=' + RegExp.$2 + '&dat=' + RegExp.$3;
	}
	if((''+u).match(/https?:\/\/([^\.]+)\.bbspink\.com\/([^\/]+)\/dat\/([^\.]+)\.dat/)){
		u ='http://itest.bbspink.com/public/newapi/client.php?subdomain=' + RegExp.$1 + '&board=' + RegExp.$2 + '&dat=' + RegExp.$3;
	}
	if((''+u).match(/https?:\/\/api\.[25]ch\.net\/v1\/([^\/]+)\/([^\/]+)\/([^\/]+)/)){
		u ='http://itest.5ch.net/public/newapi/client.php?subdomain=' + RegExp.$1 + '&board=' + RegExp.$2 + '&dat=' + RegExp.$3;
	}
	var htmltext = ''+getHTML(u, '', '');
*/
	if(htmltext == '' || htmltext == null || htmltext.length == 0){
		return '¥a¥b¥n¥r¥f¥t¥v¥a¥b¥n¥r¥f¥t¥v';
	}
	var json = eval('(' + htmltext + ')');
	if(json['comments'] == null){
		return '¥a¥b¥n¥r¥f¥t¥v¥a¥b¥n¥r¥f¥t¥v';
	}

	var dat = ''
	for(var i=lastResNum; i<json['comments'].length; i++){
		var title = '';
		if(i == 0){
			title = cnvtCharacterReference1((''+json['thread'][5]).replace(/^\s+|\s+$/g, ''), bodyTab);
		}

		json['comments'][i][3] = (''+json['comments'][i][3]).replace(/^\s+|\s+$/g, '');
		json['comments'][i][4] = (''+json['comments'][i][4]).replace(/^\s+|\s+$/g, '');
		json['comments'][i][5] = (''+json['comments'][i][5]).replace(/^\s+|\s+$/g, '');

//		var pubDate = edit2chFormatDate(new Date(parseInt(json['comments'][i][3])*1000));
		var pubDate = json['comments'][i][3];

		var id = '';
		if(json['comments'][i][4] != '0' && json['comments'][i][4] != ''){
			id = 'ID:' + json['comments'][i][4];
		}else{
			id = json['comments'][i][4];
		}
		var be = '';
		if(json['comments'][i][5] != ''){
			be = ' BE:'+json['comments'][i][5];
		}

		dat += '' + 
		json['comments'][i][1] + '<>' + 
		json['comments'][i][2] + '<>' + 
		pubDate + ' ' + id + be + '<>' + 
		cnvtCharacterReference1(json['comments'][i][6].replace(/<\/?br>/g, '\n'), bodyTab).replace(/[\n\r]/gi, '<br>') + '<>' + 
		title + '\n';
	}
	if(dat == ''){
		dat = '¥a¥b¥n¥r¥f¥t¥v¥a¥b¥n¥r¥f¥t¥v';
	}
	else{
		dat = dat.replace(/〜/g, '～');
	}
	return dat;
}

/*
function getHTML(u, d, ref){
	var html = '';

	var urlConnection  = new java.net.URL((''+u).replace('http://', 'https://'));
	var con = urlConnection.openConnection();
	if(ref != ''){
		con.setRequestProperty('Referer', (''+ref).replace('http://', 'https://'));
	}
	con.setRequestProperty('User-Agent', 'Mozilla/5.0 (iPhone; CPU iPhone OS 6_0 like Mac OS X) AppleWebKit/536.26 (KHTML, like Gecko) Version/6.0 Mobile/10A5376e Safari/8536.25');
	con.setConnectTimeout(5000)
	if(d == ''){
		con.setRequestMethod('GET');
	}else{
		con.setDoOutput(true);
		con.setRequestMethod('POST');
		con.setRequestProperty('Content-Type', 'application/x-www-form-urlencoded');
		var out = new java.io.OutputStreamWriter(con.getOutputStream());
		out.write(d);
		out.close();
	}
	con.connect();

	if(con.getResponseCode() == 200){
		// 通信に成功した
		// テキストを取得する
		var inp = con.getInputStream();
		var encoding = con.getContentEncoding();
		if(null == encoding){
			encoding = 'UTF-8';
		}
		var inReader = new java.io.InputStreamReader(inp, encoding);
		var bufReader = new java.io.BufferedReader(inReader);
	
		// テキストを読み込む
		var line = '';
		while((line=bufReader.readLine()) != null){
			html += line;
		}
		html = (''+html).replace(/\\u301c/gi, '\uff5e').replace(/\\u2212/gi, '\uff0d').replace(/\\u2016/gi, '\u2225');
	
		bufReader.close();
		inReader.close();
		inp.close();
	}

	return html;
}
*/

function edit2chFormatDate(wkDate){
	var yobi = ['日','月','火','水','木','金','土'];
	return [wkDate.getFullYear(),
			((wkDate.getMonth() + 1)<10?'0'+(wkDate.getMonth() + 1):(wkDate.getMonth() + 1)),
			( wkDate.getDate()	  <10?'0'+ wkDate.getDate()	  : wkDate.getDate())
		   ].join( '/' ) + '(' + yobi[wkDate.getDay()] +') ' +
			[(wkDate.getHours()  <10?'0'+wkDate.getHours()  :wkDate.getHours()),
			(wkDate.getMinutes()<10?'0'+wkDate.getMinutes():wkDate.getMinutes()),
			(wkDate.getSeconds()<10?'0'+wkDate.getSeconds():wkDate.getSeconds())
		   ].join( ':' )
}

function cnvtCharacterReference1(str, bodyTab){
	return str;
}

function _cnvtCharacterReference(str, bodyTab){
	var i=0;
	var uD83C = '';
	var uD83D = '';

	while(i<=str.length){
		if(escape(str.substr(i, 1)) in bodyTab){
			var r = new RegExp(str.substr(i, 1), 'gi');
			str = str.replace(r, '&'+bodyTab[escape(str.substr(i, 1))]+';');
		}else{
			switch(escape(str.substr(i, 1)).substr(0,4)){
				case '%uDC':
				case '%uDD':
				case '%uDE':
				case '%uDF':
					var base = 128000;
					switch(escape(str.substr(i-1, 1))){
						case '%uD83C':
						   //先行文字が%uD83Cの場合
						   base = 127000 - 24;
						   uD83C = str.substr(i-1, 1);
						   break;
						case '%uD83D':
						   //先行文字が%uD83Dの場合
						   base = 128000;
						   uD83D = str.substr(i-1, 1);
						   break;
					}

					var tag = '#' + (base + parseInt(escape(str.substr(i, 1)).replace(/%u?/gi, ''),16) - parseInt('DC00',16));
					var r = new RegExp(str.substr(i, 1), 'gi');
					str = str.replace(r, '&'+tag+';');
					break;
				default:
					if(escape(str.substr(i, 1)).substr(0,2) == '%u'){
						//16進4桁の場合のみ
						switch(escape(str.substr(i, 1)).substr(0,3)){
							case '%uD':
								if(escape(str.substr(i, 1)) == '%uD83C' || escape(str.substr(i, 1)) == '%uD83D'){
									break;
								}
							default:
								var tag = '#' + parseInt(escape(str.substr(i, 1)).replace(/%u?/gi, ''),16);
								var r = new RegExp(str.substr(i, 1), 'gi');
								str = str.replace(r, '&'+tag+';');
							   break;
						}
					}
			}
		}
		i++;
	}

	if(uD83C != ''){
		var r = new RegExp(uD83C, 'gi');
		str = str.replace(r, '');
	}
	if(uD83D != ''){
		var r = new RegExp(uD83D, 'gi');
		str = str.replace(r, '');
	}

	return str;
}

function getRequestParams(url){
	var ua = 'Mozilla/5.0 (iPhone; CPU iPhone OS 6_0 like Mac OS X) AppleWebKit/536.26 (KHTML, like Gecko) Version/6.0 Mobile/10A5376e Safari/8536.25';

	var u  = url;
	if((''+u).match(/https?:\/\/([^\.]+)\.[25]ch\.net\/([^\/]+)\/dat\/([^\.]+)\.dat/)){
		u ='http://itest.5ch.net/public/newapi/client.php?subdomain=' + RegExp.$1 + '&board=' + RegExp.$2 + '&dat=' + RegExp.$3;
	}
	if((''+u).match(/https?:\/\/([^\.]+)\.bbspink\.com\/([^\/]+)\/dat\/([^\.]+)\.dat/)){
		u ='http://itest.bbspink.com/public/newapi/client.php?subdomain=' + RegExp.$1 + '&board=' + RegExp.$2 + '&dat=' + RegExp.$3;
	}
	if((''+u).match(/https?:\/\/api\.[25]ch\.net\/v1\/([^\/]+)\/([^\/]+)\/([^\/]+)/)){
		u ='http://itest.5ch.net/public/newapi/client.php?subdomain=' + RegExp.$1 + '&board=' + RegExp.$2 + '&dat=' + RegExp.$3;
	}

	return 'url#' + (''+u).replace('http://', 'https://') + '\n' + 'User-Agent#' + ua;
}
