/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;

public class V2CWindowConfig {
    private static final String sConfSetKey = "Main.ConfSet";
    static final HashMap hmConfigs = new HashMap();
    final String sName;
    Rectangle rBounds;
    Rectangle rTreeBounds;
    int nState;
    int[] nlDividerLocations;
    boolean bShowTreePane;
    boolean b2PaneMode;
    boolean bTablePaneShown;
    boolean bRightVerticalSplit;
    boolean bMainToolBar;
    boolean bStatusBar;
    boolean bTreeToolBar;
    boolean bTableToolBar;
    boolean bDisplayToolBar;
    boolean bTablePaneHSpan;
    boolean bTreePaneRight;
    boolean bTablePaneBottom;
    int[] ilThreadListColumns;

    private static void restoreConfig() {
        V2CPackedPropValue[] v2CPackedPropValueArray = V2CApp.getUserProperty().getPackedValueArray(sConfSetKey);
        if (v2CPackedPropValueArray == null) {
            return;
        }
        for (int i = 0; i < v2CPackedPropValueArray.length; ++i) {
            V2CWindowConfig v2CWindowConfig = new V2CWindowConfig(v2CPackedPropValueArray[i]);
            String string = v2CWindowConfig.sName;
            if (string == null || string.length() <= 0) continue;
            hmConfigs.put(string, v2CWindowConfig);
        }
    }

    private static void saveConfig() {
        ArrayList<V2CPackedPropValue> arrayList = new ArrayList<V2CPackedPropValue>();
        Iterator iterator = hmConfigs.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(((V2CWindowConfig)iterator.next()).createSaveValue());
        }
        V2CPackedPropValue[] v2CPackedPropValueArray = new V2CPackedPropValue[arrayList.size()];
        v2CPackedPropValueArray = arrayList.toArray(v2CPackedPropValueArray);
        V2CApp.getUserProperty().putPackedValueArray(sConfSetKey, v2CPackedPropValueArray);
    }

    static boolean containsName(String string) {
        return hmConfigs.containsKey(string);
    }

    static void add(V2CWindowConfig v2CWindowConfig) {
        String string = v2CWindowConfig.sName;
        if (string != null && string.length() > 0) {
            hmConfigs.put(string, v2CWindowConfig);
            V2CWindowConfig.saveConfig();
        }
    }

    static void remove(V2CWindowConfig v2CWindowConfig) {
        String string = v2CWindowConfig.sName;
        if (string != null && string.length() > 0 && hmConfigs.containsKey(string)) {
            hmConfigs.remove(string);
            V2CWindowConfig.saveConfig();
        }
    }

    static V2CWindowConfig[] getConfigArray() {
        V2CWindowConfig[] v2CWindowConfigArray = hmConfigs.values().toArray(new V2CWindowConfig[hmConfigs.size()]);
        Arrays.sort(v2CWindowConfigArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((V2CWindowConfig)object).sName.compareTo(((V2CWindowConfig)object2).sName);
            }
        });
        return v2CWindowConfigArray;
    }

    public V2CWindowConfig(V2CPackedPropValue v2CPackedPropValue) {
        if (v2CPackedPropValue == null) {
            this.sName = null;
            return;
        }
        this.sName = v2CPackedPropValue.getString('N');
        this.rBounds = v2CPackedPropValue.getRectangle('W');
        this.rTreeBounds = v2CPackedPropValue.getRectangle('T');
        this.nState = v2CPackedPropValue.getInt('S');
        this.nlDividerLocations = v2CPackedPropValue.getIntArrayUpTo('D', 10);
        this.bShowTreePane = v2CPackedPropValue.getBoolean('T');
        this.b2PaneMode = v2CPackedPropValue.getBoolean('2');
        this.bTablePaneShown = v2CPackedPropValue.getBoolean('L');
        this.bRightVerticalSplit = v2CPackedPropValue.getBoolean('V');
        this.bMainToolBar = v2CPackedPropValue.getBoolean('m');
        this.bStatusBar = v2CPackedPropValue.getBoolean('s');
        this.bTreeToolBar = v2CPackedPropValue.getBoolean('t');
        this.bTableToolBar = v2CPackedPropValue.getBoolean('l');
        this.bDisplayToolBar = v2CPackedPropValue.getBoolean('d');
        this.bTablePaneHSpan = v2CPackedPropValue.getBoolean('H');
        this.bTreePaneRight = v2CPackedPropValue.getBoolean('R');
        this.bTablePaneBottom = v2CPackedPropValue.getBoolean('B');
        this.ilThreadListColumns = v2CPackedPropValue.getIntArrayUpTo('C', 50);
    }

    public V2CWindowConfig(String string) {
        this.sName = V2CMiscUtil.replaceTab2SP(string);
    }

    V2CPackedPropValue createSaveValue() {
        V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
        v2CPackedPropValue.setString('N', this.sName);
        v2CPackedPropValue.setRectangle('W', this.rBounds);
        v2CPackedPropValue.setRectangle('T', this.rTreeBounds);
        v2CPackedPropValue.setInt('S', this.nState);
        v2CPackedPropValue.setIntArray('D', this.nlDividerLocations);
        v2CPackedPropValue.setBoolean('T', this.bShowTreePane);
        v2CPackedPropValue.setBoolean('2', this.b2PaneMode);
        v2CPackedPropValue.setBoolean('L', this.bTablePaneShown);
        v2CPackedPropValue.setBoolean('V', this.bRightVerticalSplit);
        v2CPackedPropValue.setBoolean('m', this.bMainToolBar);
        v2CPackedPropValue.setBoolean('s', this.bStatusBar);
        v2CPackedPropValue.setBoolean('t', this.bTreeToolBar);
        v2CPackedPropValue.setBoolean('l', this.bTableToolBar);
        v2CPackedPropValue.setBoolean('d', this.bDisplayToolBar);
        v2CPackedPropValue.setBoolean('H', this.bTablePaneHSpan);
        v2CPackedPropValue.setBoolean('R', this.bTreePaneRight);
        v2CPackedPropValue.setBoolean('B', this.bTablePaneBottom);
        v2CPackedPropValue.setIntArray('C', this.ilThreadListColumns);
        return v2CPackedPropValue;
    }

    public String toString() {
        return this.sName;
    }

    static {
        V2CWindowConfig.restoreConfig();
    }
}

