/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTablePopupListener;
import org.monazilla.v2c.V2CTextField;
import org.monazilla.v2c.V2CWebSearchEntry;

public class V2CWebSearchSP
extends JPanel
implements ActionListener {
    MyTableModel tmTableModel;
    JTable jTable;
    JButton jbUp;
    JButton jbDown;
    JTextField jtfLabel;
    JTextField jtfCommand;
    JComboBox jcbKeywords;
    JComboBox jcbLinkEx;
    JButton jbAdd;
    JButton jbInsert;
    JButton jbInsertEx;

    public V2CWebSearchSP(ArrayList arraylist) {
        super(new GridBagLayout());
        JTable jtable;
        GridBagConstraints gridbagconstraints = V2CSwingUtil.createGridBagConstraints();
        gridbagconstraints.insets = new Insets(1, 1, 1, 1);
        this.tmTableModel = new MyTableModel(arraylist);
        this.jTable = jtable = new JTable(this.tmTableModel);
        TableColumnModel tablecolumnmodel = jtable.getColumnModel();
        tablecolumnmodel.getColumn(0).setPreferredWidth(100);
        tablecolumnmodel.getColumn(1).setPreferredWidth(300);
        jtable.addMouseListener(new V2CTablePopupListener("EditAndDeleteEntry", this, jtable));
        JScrollPane jscrollpane = V2CSwingUtil.createScrollPaneForTable(jtable, 200);
        gridbagconstraints.weightx = 1.0;
        gridbagconstraints.weighty = 1.0;
        gridbagconstraints.fill = 1;
        gridbagconstraints.gridwidth = 2;
        this.add((Component)jscrollpane, gridbagconstraints);
        gridbagconstraints.weightx = 0.0;
        gridbagconstraints.weighty = 0.0;
        gridbagconstraints.fill = 0;
        gridbagconstraints.gridwidth = 1;
        Box box = new Box(1);
        this.jbUp = new JButton("\u2191");
        this.jbUp.setFocusable(false);
        this.jbUp.addActionListener(this);
        box.add(this.jbUp);
        this.jbDown = new JButton("\u2193");
        this.jbDown.setFocusable(false);
        this.jbDown.addActionListener(this);
        box.add(this.jbDown);
        gridbagconstraints.gridx = 2;
        this.add((Component)box, gridbagconstraints);
        gridbagconstraints.gridx = 0;
        ++gridbagconstraints.gridy;
        this.add((Component)new JLabel("\u30e9\u30d9\u30eb\uff1a "), gridbagconstraints);
        ++gridbagconstraints.gridx;
        this.jtfLabel = new V2CTextField();
        gridbagconstraints.fill = 2;
        this.add((Component)this.jtfLabel, gridbagconstraints);
        gridbagconstraints.fill = 0;
        ++gridbagconstraints.gridx;
        this.jbAdd = new JButton("\u8ffd\u52a0");
        this.jbAdd.setFocusable(false);
        this.jbAdd.addActionListener(this);
        gridbagconstraints.fill = 2;
        this.add((Component)this.jbAdd, gridbagconstraints);
        gridbagconstraints.fill = 0;
        gridbagconstraints.gridx = 0;
        ++gridbagconstraints.gridy;
        this.add((Component)new JLabel("\u691c\u7d22URL\uff1a "), gridbagconstraints);
        ++gridbagconstraints.gridx;
        this.jtfCommand = new V2CTextField();
        gridbagconstraints.fill = 2;
        gridbagconstraints.gridwidth = 2;
        this.add((Component)this.jtfCommand, gridbagconstraints);
        gridbagconstraints.fill = 0;
        gridbagconstraints.gridwidth = 1;
        gridbagconstraints.gridx = 0;
        ++gridbagconstraints.gridy;
        this.add((Component)new JLabel("\u30ad\u30fc\u30ef\u30fc\u30c9: "), gridbagconstraints);
        ++gridbagconstraints.gridx;
        KeywordEntry[] akeywordentry = new KeywordEntry[]{new KeywordEntry("$INPTEXTU", "URL\u30a8\u30f3\u30b3\u30fc\u30c9\u3057\u305f\u5165\u529b\u30c6\u30ad\u30b9\u30c8\uff08UTF-8\uff09"), new KeywordEntry("$INPTEXTE", "URL\u30a8\u30f3\u30b3\u30fc\u30c9\u3057\u305f\u5165\u529b\u30c6\u30ad\u30b9\u30c8\uff08EUC-JP\uff09"), new KeywordEntry("$INPTEXTS", "URL\u30a8\u30f3\u30b3\u30fc\u30c9\u3057\u305f\u5165\u529b\u30c6\u30ad\u30b9\u30c8\uff08MS932\u3001\u30b7\u30d5\u30c8JIS\uff09")};
        this.jcbKeywords = new JComboBox<KeywordEntry>(akeywordentry);
        this.jcbKeywords.setFocusable(false);
        gridbagconstraints.fill = 2;
        this.add((Component)this.jcbKeywords, gridbagconstraints);
        gridbagconstraints.fill = 0;
        ++gridbagconstraints.gridx;
        this.jbInsert = new JButton("\u633f\u5165");
        this.jbInsert.setFocusable(false);
        this.jbInsert.addActionListener(this);
        gridbagconstraints.fill = 2;
        this.add((Component)this.jbInsert, gridbagconstraints);
        gridbagconstraints.fill = 0;
        ++gridbagconstraints.gridy;
        gridbagconstraints.gridx = 0;
        this.add((Component)new JLabel("\u4f8b: "), gridbagconstraints);
        ++gridbagconstraints.gridx;
        ExampleEntry[] aexampleentry = new ExampleEntry[]{new ExampleEntry("\uff12\u3061\u3083\u3093\u306d\u308b\u691c\u7d22(dig.2ch.net)", "http://dig.2ch.net/?keywords=$INPTEXTU"), new ExampleEntry("domo2", "http://www.domo2.net/search/search.cgi?word=$INPTEXTE&tnum=50&bbs=all"), new ExampleEntry("ttsearch", "http://ttsearch.net/s.cgi?k=$INPTEXTS&N=50"), new ExampleEntry("Google [site:.2ch.net]", "http://www.google.co.jp/search?as_q=$INPTEXTU+site:.2ch.net&num=50"), new ExampleEntry("2NN+", "http://www.2nn.jp/")};
        this.jcbLinkEx = new JComboBox<ExampleEntry>(aexampleentry);
        this.jcbLinkEx.setFocusable(false);
        gridbagconstraints.fill = 2;
        this.add((Component)this.jcbLinkEx, gridbagconstraints);
        gridbagconstraints.fill = 0;
        ++gridbagconstraints.gridx;
        this.jbInsertEx = new JButton("\u5165\u529b");
        this.jbInsertEx.setFocusable(false);
        this.jbInsertEx.addActionListener(this);
        gridbagconstraints.fill = 2;
        this.add((Component)this.jbInsertEx, gridbagconstraints);
        gridbagconstraints.fill = 0;
    }

    boolean showDialog() {
        V2CSwingUtil.showDialogWithClose(this, this.jtfCommand, "Web\u30b9\u30ec\u30c3\u30c9\u691c\u7d22\u306e\u8a2d\u5b9a");
        return this.checkEditing();
    }

    boolean checkEditing() {
        V2CSwingUtil.checkEditing(this.jTable);
        return this.tmTableModel.bChange;
    }

    void deleteSelectedEntry() {
        int[] ai = this.jTable.getSelectedRows();
        if (ai == null) {
            return;
        }
        this.tmTableModel.delete(ai);
    }

    void editSelectedEntry() {
        int i = this.jTable.getSelectedRow();
        if (i < 0) {
            return;
        }
        V2CWebSearchEntry v2cwebsearchentry = this.tmTableModel.getSearchEntry(i);
        if (v2cwebsearchentry == null) {
            return;
        }
        String s = v2cwebsearchentry.getLabel();
        if (s != null) {
            this.jtfLabel.setText(s);
        } else {
            this.jtfLabel.setText("");
        }
        String s1 = v2cwebsearchentry.getRawURL();
        if (s1 != null) {
            this.jtfCommand.setText(s1);
        } else {
            this.jtfCommand.setText("");
        }
    }

    void insertCommandString(String s) {
        int i = Math.max(this.jtfCommand.getCaretPosition(), 0);
        try {
            this.jtfCommand.getDocument().insertString(i, s, null);
        }
        catch (BadLocationException badlocationexception) {
            return;
        }
        this.jtfCommand.setCaretPosition(i + s.length());
    }

    @Override
    public void actionPerformed(ActionEvent actionevent) {
        JTable jtable = this.jTable;
        Object obj = actionevent.getSource();
        if (obj == this.jbAdd) {
            String s = this.jtfCommand.getText();
            if (!V2CWebSearchEntry.checkURL(s)) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            V2CSwingUtil.checkEditing(jtable);
            this.tmTableModel.add(this.jtfLabel.getText(), s);
        } else if (obj == this.jbInsert) {
            Object obj1 = this.jcbKeywords.getSelectedItem();
            if (obj1 instanceof KeywordEntry) {
                this.insertCommandString(((KeywordEntry)obj1).sKeyword);
            }
        } else if (obj == this.jbInsertEx) {
            Object obj2 = this.jcbLinkEx.getSelectedItem();
            if (obj2 instanceof ExampleEntry) {
                ExampleEntry exampleentry = (ExampleEntry)obj2;
                this.jtfLabel.setText(exampleentry.sLabel);
                this.jtfCommand.setText(exampleentry.sCommand);
            }
        } else if (obj == this.jbUp) {
            int i = jtable.getSelectedRow();
            if (i < 0) {
                return;
            }
            V2CSwingUtil.checkEditing(jtable);
            if (this.tmTableModel.moveEntry(i, true)) {
                jtable.changeSelection(i - 1, 0, false, false);
            }
        } else if (obj == this.jbDown) {
            int j = jtable.getSelectedRow();
            if (j < 0) {
                return;
            }
            V2CSwingUtil.checkEditing(jtable);
            if (this.tmTableModel.moveEntry(j, false)) {
                jtable.changeSelection(j + 1, 0, false, false);
            }
        }
    }

    private static class ExampleEntry {
        String sLabel;
        String sCommand;

        public String toString() {
            return this.sLabel;
        }

        ExampleEntry(String s, String s1) {
            this.sLabel = s;
            this.sCommand = s1;
        }
    }

    private static class KeywordEntry {
        final String sKeyword;
        final String sLabel;

        public String toString() {
            return this.sLabel;
        }

        KeywordEntry(String s, String s1) {
            this.sKeyword = s;
            this.sLabel = String.valueOf(s) + "\uff1a  " + s1;
        }
    }

    private static class MyTableModel
    extends AbstractTableModel {
        static final int LABEL = 0;
        static final int COMMAND = 1;
        static final String[] slColNames = new String[]{"\u30e9\u30d9\u30eb", "\u691c\u7d22URL"};
        final ArrayList alEntries;
        boolean bChange;

        void add(String s, String s1) {
            this.bChange = true;
            V2CWebSearchEntry.addEntry(s, s1);
            int i = this.alEntries.size() - 1;
            this.fireTableRowsInserted(i, i);
        }

        void delete(int[] ai) {
            this.bChange = true;
            if (ai.length > 1) {
                Arrays.sort(ai);
            }
            int i = ai.length - 1;
            while (i >= 0) {
                int j = ai[i];
                this.alEntries.remove(j);
                this.fireTableRowsDeleted(j, j);
                --i;
            }
        }

        boolean moveEntry(int i, boolean flag) {
            if (flag && i == 0 || !flag && i == this.getRowCount() - 1) {
                return false;
            }
            this.bChange = true;
            Object obj = this.alEntries.get(i);
            int j = flag ? i - 1 : i + 1;
            this.alEntries.set(i, this.alEntries.get(j));
            this.alEntries.set(j, obj);
            if (flag) {
                this.fireTableRowsUpdated(i - 1, i);
            } else {
                this.fireTableRowsUpdated(i, i + 1);
            }
            return true;
        }

        public Class getColumnClass(int i) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int i, int j) {
            return true;
        }

        @Override
        public int getRowCount() {
            return this.alEntries.size();
        }

        @Override
        public int getColumnCount() {
            return slColNames.length;
        }

        @Override
        public String getColumnName(int i) {
            return slColNames[i];
        }

        @Override
        public void setValueAt(Object obj, int i, int j) {
            this.bChange = true;
            String s = (String)obj;
            V2CWebSearchEntry v2cwebsearchentry = this.getSearchEntry(i);
            String s1 = v2cwebsearchentry.getLabel();
            String s2 = v2cwebsearchentry.getRawURL();
            switch (j) {
                case 0: {
                    s1 = s;
                    break;
                }
                case 1: {
                    if (s.length() > 0) {
                        s2 = s;
                        break;
                    }
                    this.alEntries.remove(i);
                    this.fireTableRowsDeleted(i, i);
                    return;
                }
            }
            if (!V2CWebSearchEntry.setEntryAt(i, s1, s2)) {
                this.fireTableRowsUpdated(i, i);
            }
        }

        V2CWebSearchEntry getSearchEntry(int i) {
            return (V2CWebSearchEntry)this.alEntries.get(i);
        }

        @Override
        public Object getValueAt(int i, int j) {
            V2CWebSearchEntry v2cwebsearchentry = this.getSearchEntry(i);
            if (v2cwebsearchentry == null) {
                return null;
            }
            switch (j) {
                case 0: {
                    return v2cwebsearchentry.getLabel();
                }
                case 1: {
                    return v2cwebsearchentry.getRawURL();
                }
            }
            return null;
        }

        MyTableModel(ArrayList arraylist) {
            this.alEntries = arraylist;
        }
    }
}

