/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CJPConverter;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CWebSearchMenu;
import org.monazilla.v2c.V2CWebSearchSP;

public final class V2CWebSearchEntry {
    private static final String sWebSearchEntryKey = "WebSearch.Entry";
    private static final int UNCHECKED = 0;
    private static final int NO_INPUT = 1;
    private static final int NEED_INPUT = 2;
    private static final ArrayList<V2CWebSearchEntry> alEntries = new ArrayList();
    String sURL;
    String sLabel;
    int nNeedsInput;

    static {
        V2CWebSearchEntry.restoreEntries();
    }

    static void restoreEntries() {
        V2CPackedPropValue[] av2cpackedpropvalue = V2CApp.getUserProperty().getPackedValueArray(sWebSearchEntryKey);
        if (av2cpackedpropvalue != null) {
            int i = 0;
            while (i < av2cpackedpropvalue.length) {
                V2CPackedPropValue v2cpackedpropvalue = av2cpackedpropvalue[i];
                String s = v2cpackedpropvalue.getString('L');
                String s1 = v2cpackedpropvalue.getString('U');
                if (s != null && s.length() > 0 && V2CWebSearchEntry.checkURL(s1)) {
                    V2CWebSearchEntry.addEntry(s, s1);
                }
                ++i;
            }
        }
        if (alEntries.size() == 0) {
            V2CWebSearchEntry.addEntry("\uff12\u3061\u3083\u3093\u306d\u308b\u691c\u7d22(dig.2ch.net)", "http://dig.2ch.net/?keywords=$INPTEXTU");
        }
    }

    static void saveEntries() {
        ArrayList<V2CPackedPropValue> arraylist = new ArrayList<V2CPackedPropValue>();
        int i = 0;
        while (i < alEntries.size()) {
            V2CWebSearchEntry v2cwebsearchentry = alEntries.get(i);
            V2CPackedPropValue v2cpackedpropvalue = new V2CPackedPropValue();
            v2cpackedpropvalue.setString('L', v2cwebsearchentry.sLabel);
            v2cpackedpropvalue.setString('U', v2cwebsearchentry.sURL);
            arraylist.add(v2cpackedpropvalue);
            ++i;
        }
        V2CProperty v2cproperty = V2CApp.getUserProperty();
        int j = arraylist.size();
        if (j > 0) {
            v2cproperty.putPackedValueArray(sWebSearchEntryKey, arraylist.toArray(new V2CPackedPropValue[j]));
        } else {
            v2cproperty.remove(sWebSearchEntryKey);
        }
    }

    static void setWebSearchEntry() {
        V2CWebSearchSP v2cwebsearchsp = new V2CWebSearchSP(alEntries);
        if (v2cwebsearchsp.showDialog()) {
            V2CWebSearchEntry.applyChanges();
        }
    }

    static void applyChanges() {
        V2CWebSearchEntry.saveEntries();
        V2CWebSearchMenu.updateConfigTime();
    }

    public static JPanel getConfPanel() {
        V2CWebSearchSP v2cwebsearchsp = new V2CWebSearchSP(alEntries);
        return v2cwebsearchsp;
    }

    static ArrayList<V2CWebSearchEntry> getEntries() {
        return alEntries;
    }

    static boolean checkURL(String s) {
        if (s == null) {
            return false;
        }
        if (!s.startsWith("http")) {
            return false;
        }
        return Pattern.matches("[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+", s);
    }

    static void addEntry(String s, String s1) {
        alEntries.add(new V2CWebSearchEntry(s, s1));
    }

    static boolean setEntryAt(int i, String s, String s1) {
        if (!V2CWebSearchEntry.checkURL(s1)) {
            return false;
        }
        V2CWebSearchEntry v2cwebsearchentry = alEntries.get(i);
        v2cwebsearchentry.sLabel = s;
        v2cwebsearchentry.sURL = s1;
        return true;
    }

    public V2CWebSearchEntry(String s, String s1) {
        this.sLabel = V2CMiscUtil.replaceTab2SP(s);
        this.sURL = s1;
    }

    String getRawURL() {
        return this.sURL;
    }

    String getSearchURL(String s) {
        HashMap<String, String> hashmap = new HashMap<String, String>();
        hashmap.put("$INPTEXTU", V2CJPConverter.urlEncode(s, "UTF-8"));
        hashmap.put("$INPTEXTE", V2CJPConverter.urlEncode(s, "EUC-JP"));
        hashmap.put("$INPTEXTS", V2CJPConverter.urlEncode(s, "MS932"));
        return V2CMiscUtil.replaceKeywords(this.sURL, hashmap);
    }

    boolean needsSearchWord() {
        if (this.nNeedsInput == 0) {
            HashMap<String, String> hashmap = new HashMap<String, String>();
            hashmap.put("$INPTEXTU", "");
            hashmap.put("$INPTEXTE", "");
            hashmap.put("$INPTEXTS", "");
            String s = V2CMiscUtil.replaceKeywords(this.sURL, hashmap);
            int n = this.nNeedsInput = this.sURL.equals(s) ? 1 : 2;
        }
        return this.nNeedsInput == 2;
    }

    String getLabel() {
        return this.sLabel;
    }

    public int hashCode() {
        return this.sURL.hashCode() + this.sLabel.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V2CWebSearchEntry)) {
            return false;
        }
        V2CWebSearchEntry v2cwebsearchentry = (V2CWebSearchEntry)obj;
        return this.sURL.equals(v2cwebsearchentry.sURL) && this.sLabel.equals(v2cwebsearchentry.sLabel);
    }

    public String toString() {
        return this.sLabel;
    }
}

