/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.HttpURLConnection;
import javax.swing.Timer;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CHttpUtil;
import org.monazilla.v2c.V2CLauncher;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CReleaseInfo;
import org.monazilla.v2c.V2CUpdateSP;
import org.monazilla.v2c.V2CUpdaterConstants;

public class V2CUpdater
implements V2CUpdaterConstants {
    private static final String sKeyPrefix = "Updater.";
    private static final String sAutoCheckKey = "Updater.AutoCheck";
    private static final String sLastCheckTimeKey = "Updater.LastCheckTime";
    private static final String sLastModifiedKey = "Updater.LastModified";
    private static final String sCheckCountKey = "Updater.CheckCount";
    private static final String sCheckTestVersionKey = "Updater.CheckTestVersion";
    private static boolean bChecked;
    private static volatile boolean bChecking;
    private static volatile V2CProperty vProperty;

    static void startAutoCheck() {
        boolean bool = true;
        if (!V2CUpdater.getAutoCheck() || (bool = V2CUpdater.getLocalRelInfoFile().isFile()) && V2CUpdater.getLastCheckTime() / 86400000L == System.currentTimeMillis() / 86400000L) {
            return;
        }
        Timer localTimer = new Timer(10000, new AutoChecker(!bool));
        localTimer.setRepeats(false);
        localTimer.start();
    }

    static boolean getAutoCheck() {
        return V2CApp.getBooleanUserProperty(sAutoCheckKey);
    }

    static boolean getCheckTestVersion() {
        return V2CApp.getBooleanUserProperty(sCheckTestVersionKey);
    }

    static void setCond(boolean paramBoolean1, boolean paramBoolean2) {
        V2CApp.setBooleanUserProperty(sAutoCheckKey, paramBoolean1, false);
        if (V2CApp.setBooleanUserProperty(sCheckTestVersionKey, paramBoolean2, false)) {
            vProperty = null;
            V2CMain.updateNotificationMenu();
        }
    }

    static long getLastCheckTime() {
        return V2CMain.getUserProperty().getLong(sLastCheckTimeKey);
    }

    static boolean isChecking() {
        return bChecking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void startCheck(boolean paramBoolean1, boolean paramBoolean2) {
        Class<V2CUpdater> clazz = V2CUpdater.class;
        synchronized (V2CUpdater.class) {
            if (!paramBoolean1 && bChecked || bChecking) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            bChecking = true;
            bChecked = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            V2CUpdateSP.updateStatus();
            Thread thread = new Thread(new CheckThread(paramBoolean1, paramBoolean2));
            thread.start();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkUpdateAndDownload(boolean paramBoolean1, boolean paramBoolean2) {
        block12: {
            try {
                if (V2CUpdater.checkUpdate(paramBoolean1, paramBoolean2)) break block12;
                Class<V2CUpdater> clazz = V2CUpdater.class;
            }
            catch (Throwable throwable) {
                Class<V2CUpdater> clazz = V2CUpdater.class;
                synchronized (V2CUpdater.class) {
                    bChecking = false;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    V2CUpdateSP.updateStatus();
                    throw throwable;
                }
            }
            synchronized (V2CUpdater.class) {
                bChecking = false;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                V2CUpdateSP.updateStatus();
                return;
            }
        }
        V2CLauncher.downloadNewVersion(V2CUpdater.getProperty(), paramBoolean2);
        V2CMain.updateNotificationMenu();
        Class<V2CUpdater> clazz = V2CUpdater.class;
        synchronized (V2CUpdater.class) {
            bChecking = false;
            // ** MonitorExit[var3_4] (shouldn't be in output)
            V2CUpdateSP.updateStatus();
            return;
        }
    }

    static boolean checkUpdate(boolean paramBoolean1, boolean paramBoolean2) {
        V2CHttpUtil.CAndC localCAndC;
        V2CProperty localV2CProperty = V2CMain.getUserProperty();
        localV2CProperty.putLong(sLastCheckTimeKey, System.currentTimeMillis());
        int i = localV2CProperty.getInt(sCheckCountKey);
        long l = paramBoolean1 || i >= 10 ? 0L : localV2CProperty.getLong(sLastModifiedKey);
        i = l > 0L ? i + 1 : 0;
        localV2CProperty.putInt(sCheckCountKey, i);
        boolean checkTestVersionEnabled = V2CUpdater.getCheckTestVersion();
        String str = "http://v2cr.neopj.net/jars/" + V2CReleaseInfo.getRelInfFileName(checkTestVersionEnabled);
        if (paramBoolean2) {
            System.out.println("URL: " + str);
            System.out.println("LastModified: " + l);
        }
        if ((localCAndC = V2CHttpUtil.getRawTextFile(str, l)) == null) {
            if (paramBoolean2) {
                V2CUpdater.showErrorMessage("\u66f4\u65b0\u60c5\u5831\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u306e\u30ed\u30b0\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002", true);
            }
            return false;
        }
        byte[] arrayOfByte = localCAndC.getRawContents();
        if (arrayOfByte == null) {
            if (paramBoolean2) {
                V2CUpdater.showErrorMessage("\u66f4\u65b0\u60c5\u5831\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u306e\u30ed\u30b0\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002", true);
            }
            return false;
        }
        if (!V2CLocalFileHandler.saveToFile(V2CUpdater.getLocalRelInfoFile(), arrayOfByte)) {
            if (paramBoolean2) {
                V2CUpdater.showErrorMessage(V2CUpdater.getLocalRelInfoFile() + " \u3078\u306e\u60c5\u5831\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", true);
            }
            return false;
        }
        vProperty = null;
        HttpURLConnection localHttpURLConnection = localCAndC.getConnection();
        if (localHttpURLConnection != null) {
            l = localHttpURLConnection.getLastModified();
            if (l > 0L) {
                localV2CProperty.putLong(sLastModifiedKey, l);
            } else {
                localV2CProperty.remove(sLastModifiedKey);
            }
        }
        if (checkTestVersionEnabled && V2CUpdater.getProperty().getInt("TestSequenceNumber") == 0 && !V2CLocalFileHandler.copyFile(V2CUpdater.getLocalRelInfoFile(), V2CUpdater.getLocalRelInfoFile(false), true) && paramBoolean2) {
            V2CUpdater.showErrorMessage(V2CUpdater.getLocalRelInfoFile(false) + " \u3078\u306e\u60c5\u5831\u306e\u30b3\u30d4\u30fc\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", false);
        }
        return true;
    }

    static void showErrorMessage(String paramString, boolean paramBoolean) {
        System.out.println(paramString);
        if (paramBoolean) {
            V2CMain.setErrorMessage(paramString);
        } else {
            V2CMain.setMessage(paramString);
        }
    }

    static boolean isNewVersionAvailable() {
        if (V2CLauncher.shouldDownloadNewVersion()) {
            return V2CLauncher.isNewVersionAvailable();
        }
        V2CProperty localV2CProperty = V2CUpdater.getProperty();
        return V2CReleaseInfo.isNewer(localV2CProperty.getInt("SequenceNumber"), localV2CProperty.getInt("SubSequenceNumber"), localV2CProperty.getInt("TestSequenceNumber"));
    }

    static String getStatusString() {
        if (bChecking) {
            return "\u66f4\u65b0\u3092\u30c1\u30a7\u30c3\u30af\u4e2d\u2026";
        }
        if (V2CUpdater.isNewVersionAvailable()) {
            V2CProperty localV2CProperty = V2CUpdater.getProperty();
            String str = localV2CProperty.get("Version");
            str = str != null && str.length() > 0 ? "Ver." + str : localV2CProperty.get("Name");
            return "\u65b0\u3057\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u5229\u7528\u53ef\u80fd\u3067\u3059 - " + str;
        }
        return "\u65b0\u3057\u3044\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u60c5\u5831\u306f\u3042\u308a\u307e\u305b\u3093\u3002";
    }

    static String getComment() {
        V2CProperty localV2CProperty = V2CUpdater.getProperty();
        return V2CMiscUtil.restoreNewLine(localV2CProperty.get("Comment"));
    }

    static File getLocalRelInfoFile() {
        return V2CUpdater.getLocalRelInfoFile(V2CUpdater.getCheckTestVersion());
    }

    private static File getLocalRelInfoFile(boolean paramBoolean) {
        return V2CLocalFileHandler.getUserConfigFile(V2CReleaseInfo.getRelInfFileName(paramBoolean));
    }

    static V2CProperty getProperty() {
        if (vProperty == null) {
            File localFile = V2CUpdater.getLocalRelInfoFile();
            if (localFile.exists()) {
                vProperty = new V2CProperty(localFile, null, null);
                vProperty.setReadOnly(true);
            } else {
                vProperty = new V2CProperty(true);
            }
        }
        return vProperty;
    }

    private static class AutoChecker
    implements ActionListener {
        final boolean bForceCheck;

        AutoChecker(boolean paramBoolean) {
            this.bForceCheck = paramBoolean;
        }

        @Override
        public void actionPerformed(ActionEvent paramActionEvent) {
            if (V2CUpdater.getAutoCheck()) {
                V2CUpdater.startCheck(this.bForceCheck, false);
            }
        }
    }

    private static class CheckThread
    implements Runnable {
        final boolean bForce;
        final boolean bManual;

        CheckThread(boolean paramBoolean1, boolean paramBoolean2) {
            this.bForce = paramBoolean1;
            this.bManual = paramBoolean2;
        }

        @Override
        public void run() {
            V2CUpdater.checkUpdateAndDownload(this.bForce, this.bManual);
        }
    }
}

