/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.io.BufferedReader;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CTwitterBBS;
import org.monazilla.v2c.V2CTwitterConstants;
import org.monazilla.v2c.V2CTwitterThreadRes;

public class V2CTwitterListItem
implements Comparable,
V2CTwitterConstants {
    private static final HashMap vListMember = new HashMap();
    final boolean bOwnList;
    long nListID;
    String sListName;
    long nListOwnerID;
    String sListOwnerName;
    String sLabel;
    String sDescription;
    boolean bPrivate;

    static V2CTwitterListItem createItem(V2CThreadItem v2CThreadItem) {
        if (v2CThreadItem == null || !v2CThreadItem.isTwitter()) {
            return null;
        }
        return V2CTwitterListItem.createItem(v2CThreadItem.getProperty().getPackedValue("Thread.TwitterConf:"));
    }

    static V2CTwitterListItem createItem(V2CPackedPropValue v2CPackedPropValue) {
        boolean bl;
        if (v2CPackedPropValue == null) {
            return null;
        }
        String string = v2CPackedPropValue.getString('T');
        if (string == null || string.length() != 1) {
            return null;
        }
        char c = string.charAt(0);
        if (c == 'L') {
            bl = true;
        } else if (c == 'K') {
            bl = false;
        } else {
            return null;
        }
        long l = v2CPackedPropValue.getLong('K');
        String string2 = v2CPackedPropValue.getString('L');
        if (string2 == null) {
            return null;
        }
        if (bl) {
            return new V2CTwitterListItem(l, string2);
        }
        long l2 = v2CPackedPropValue.getLong('J');
        String string3 = v2CPackedPropValue.getString('O');
        if (l <= 0L || string2 == null) {
            return null;
        }
        return new V2CTwitterListItem(l, string2, l2, string3);
    }

    static V2CTwitterListItem createItem(Map map, boolean bl) {
        long l = V2CTwitterThreadRes.getIDFromMap(map);
        String string = V2CTwitterThreadRes.getStringFromMap(map, "name");
        if (l <= 0L || string == null) {
            return null;
        }
        String string2 = V2CTwitterThreadRes.getStringFromMap(map, "description");
        boolean bl2 = V2CMiscUtil.isEqual(V2CTwitterThreadRes.getStringFromMap(map, "mode"), "private");
        if (bl) {
            return new V2CTwitterListItem(l, string, string2, bl2);
        }
        Object v = map.get("user");
        if (v == null) {
            return null;
        }
        long l2 = V2CTwitterThreadRes.getIDFromMap(v);
        String string3 = V2CTwitterThreadRes.getStringFromMap(v, "screen_name");
        if (l2 <= 0L || string3 == null) {
            return null;
        }
        return new V2CTwitterListItem(l, string, l2, string3);
    }

    public V2CTwitterListItem(long l, String string) {
        this(l, string, null, false);
    }

    public V2CTwitterListItem(long l, String string, String string2, boolean bl) {
        this.bOwnList = true;
        this.nListID = l;
        this.sListName = string != null ? string : "";
        this.sDescription = string2;
        this.bPrivate = bl;
    }

    public V2CTwitterListItem(long l, String string, long l2, String string2) {
        this.bOwnList = false;
        this.nListID = l;
        this.sListName = string != null ? string : "";
        this.nListOwnerID = l2;
        this.sListOwnerName = string2 != null ? string2 : "";
    }

    long getID() {
        return this.nListID;
    }

    String getName() {
        return this.sListName;
    }

    String getDescription() {
        return this.sDescription;
    }

    boolean isPrivate() {
        return this.bPrivate;
    }

    V2CPackedPropValue createPackedValue() {
        V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
        this.setValue(v2CPackedPropValue);
        return v2CPackedPropValue;
    }

    void setValue(V2CPackedPropValue v2CPackedPropValue) {
        v2CPackedPropValue.setLong('K', this.nListID);
        v2CPackedPropValue.setString('L', this.sListName);
        v2CPackedPropValue.setLong('J', this.nListOwnerID);
        v2CPackedPropValue.setString('O', this.sListOwnerName);
    }

    String createThreadTitle(String string) {
        return '@' + (this.bOwnList ? string : this.sListOwnerName) + '/' + this.sListName;
    }

    int getIndexFrom(ArrayList arrayList) {
        if (arrayList != null) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                if (!this.isSameAs((V2CTwitterListItem)arrayList.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    static File getMemberFile(long l) {
        return new File(V2CTwitterBBS.fLocalListMembersRoot, l + ".txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setMembers(Object object) {
        Object object2;
        if (!(object instanceof ArrayList)) {
            return false;
        }
        ArrayList arrayList = (ArrayList)object;
        int n = arrayList.size();
        if (arrayList.size() == 0) {
            return false;
        }
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(n * 1000);
        for (int i = 0; i < n; ++i) {
            object2 = V2CTwitterThreadRes.getArrayFromMap(arrayList.get(i), "users");
            if (object2 == null) continue;
            for (int j = 0; j < object2.size(); ++j) {
                Object e = object2.get(j);
                if (!(e instanceof Map)) continue;
                Map map = (Map)e;
                long l = V2CTwitterThreadRes.getIDFromMap(map);
                String string = V2CTwitterThreadRes.getStringFromMap(map, "screen_name");
                if (l <= 0L || string == null) continue;
                String string2 = V2CTwitterThreadRes.getStringFromMap(map, "name");
                stringBuffer.append(l);
                stringBuffer.append('\t');
                if (V2CTwitterThreadRes.getBooleanFromMap(map, "protected")) {
                    stringBuffer.append('p');
                }
                stringBuffer.append('\t');
                stringBuffer.append(string);
                stringBuffer.append('\t');
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
                stringBuffer.append('\n');
                ++n2;
            }
        }
        File file = V2CTwitterListItem.getMemberFile(this.nListID);
        object2 = V2CTwitterListItem.class;
        synchronized (object2) {
            V2CLocalFileHandler.saveToFile(file, ":n" + n2 + "\n" + stringBuffer.toString(), "UTF-8");
        }
        Object object3 = object2 = vListMember;
        synchronized (object3) {
            ((HashMap)object2).put(new Long(this.nListID), null);
        }
        return true;
    }

    long getMemberFileDate() {
        File file = V2CTwitterListItem.getMemberFile(this.nListID);
        return file.isFile() && file.length() > 0L ? file.lastModified() : -1L;
    }

    long[] getMemberArray() {
        return V2CTwitterListItem.getMemberArray(this.nListID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static long[] getMemberArray(long l) {
        Object object;
        Object object2;
        long[] lArray;
        Cloneable cloneable;
        HashMap hashMap;
        block22: {
            hashMap = vListMember;
            cloneable = hashMap;
            // MONITORENTER : cloneable
            lArray = (long[])hashMap.get(new Long(l));
            // MONITOREXIT : cloneable
            if (lArray != null) {
                return lArray;
            }
            cloneable = new HashSet();
            File file = V2CTwitterListItem.getMemberFile(l);
            Class clazz = V2CTwitterListItem.class;
            // MONITORENTER : clazz
            if (file.length() == 0L) {
                // MONITOREXIT : clazz
                return null;
            }
            BufferedReader bufferedReader = V2CLocalFileHandler.getBufferedReader(file, "UTF-8");
            if (bufferedReader == null) {
                // MONITOREXIT : clazz
                return null;
            }
            try {
                object2 = bufferedReader.readLine();
                if (object2 == null) {
                    long[] lArray2 = null;
                    Object var16_13 = null;
                    V2CLocalFileHandler.closeReader(bufferedReader);
                    // MONITOREXIT : clazz
                    return lArray2;
                }
                object = new V2CPackedPropValue((String)object2);
                if (((V2CPackedPropValue)object).getInt('v') != 0) {
                    long[] lArray3 = null;
                    Object var16_14 = null;
                    V2CLocalFileHandler.closeReader(bufferedReader);
                    // MONITOREXIT : clazz
                    return lArray3;
                }
                int n = ((V2CPackedPropValue)object).getInt('n', -1);
                if (n < 0) {
                    long[] lArray4 = null;
                    Object var16_15 = null;
                    V2CLocalFileHandler.closeReader(bufferedReader);
                    // MONITOREXIT : clazz
                    return lArray4;
                }
                while ((object2 = bufferedReader.readLine()) != null) {
                    long l2;
                    int n2 = ((String)object2).indexOf(9);
                    if (n2 < 0 || ((String)object2).length() <= n2 + 1 || (l2 = V2CMiscUtil.parseLong((String)object2, 0, n2, 0L)) <= 0L) continue;
                    Long l3 = new Long(l2);
                    if (((String)object2).charAt(n2 + 1) == '-') {
                        ((HashSet)cloneable).remove(l3);
                        continue;
                    }
                    ((HashSet)cloneable).add(l3);
                }
                Object var16_16 = null;
                V2CLocalFileHandler.closeReader(bufferedReader);
                break block22;
                catch (Exception exception) {
                    exception.printStackTrace();
                    var16_16 = null;
                    V2CLocalFileHandler.closeReader(bufferedReader);
                }
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                V2CLocalFileHandler.closeReader(bufferedReader);
                throw throwable;
            }
        }
        // MONITOREXIT : clazz
        int n = ((HashSet)cloneable).size();
        lArray = new long[n];
        int n3 = 0;
        object2 = ((HashSet)cloneable).iterator();
        while (true) {
            if (!object2.hasNext()) {
                Arrays.sort(lArray);
                object = hashMap;
                // MONITORENTER : object
                hashMap.put(new Long(l), lArray);
                // MONITOREXIT : object
                return lArray;
            }
            lArray[n3++] = (Long)object2.next();
        }
    }

    void getMembers(HashSet hashSet) {
        long[] lArray = this.getMemberArray();
        if (lArray == null) {
            return;
        }
        for (int i = lArray.length - 1; i >= 0; --i) {
            hashSet.add(new Long(lArray[i]));
            if (hashSet.size() >= 5000) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromMember(long l) {
        HashMap hashMap;
        if (l <= 0L) {
            return;
        }
        long[] lArray = this.getMemberArray();
        if (lArray == null) {
            return;
        }
        int n = lArray.length;
        int n2 = -1;
        for (int i = n - 1; i >= 0; --i) {
            if (lArray[i] != l) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            return;
        }
        long[] lArray2 = new long[n - 1];
        if (n2 > 0) {
            System.arraycopy(lArray, 0, lArray2, 0, n2);
        }
        if (n2 < n - 1) {
            System.arraycopy(lArray, n2 + 1, lArray2, n2, n - n2 - 1);
        }
        Serializable serializable = hashMap = vListMember;
        synchronized (serializable) {
            hashMap.put(new Long(this.nListID), lArray2);
        }
        serializable = V2CTwitterListItem.getMemberFile(this.nListID);
        Class clazz = V2CTwitterListItem.class;
        synchronized (clazz) {
            V2CLocalFileHandler.appendToFile((File)serializable, l + "\t-\n", "UTF-8");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addToMember(long l, String string) {
        int n;
        if (l <= 0L) {
            return false;
        }
        long[] lArray = this.getMemberArray();
        if (lArray == null) {
            return false;
        }
        int n2 = n = lArray.length;
        for (int i = n - 1; i >= 0; --i) {
            long l2 = lArray[i];
            if (l2 == l) {
                return false;
            }
            if (l2 <= l) continue;
            n2 = i;
            break;
        }
        long[] lArray2 = new long[n + 1];
        if (n2 > 0) {
            System.arraycopy(lArray, 0, lArray2, 0, n2);
        }
        lArray2[n2] = l;
        if (n2 < n) {
            System.arraycopy(lArray, n2, lArray2, n2 + 1, n - n2);
        }
        HashMap hashMap = vListMember;
        Serializable serializable = hashMap;
        synchronized (serializable) {
            hashMap.put(new Long(this.nListID), lArray2);
        }
        serializable = new StringBuffer();
        ((StringBuffer)serializable).append(l);
        ((StringBuffer)serializable).append('\t');
        ((StringBuffer)serializable).append('\t');
        ((StringBuffer)serializable).append(string);
        ((StringBuffer)serializable).append('\t');
        ((StringBuffer)serializable).append('\n');
        File file = V2CTwitterListItem.getMemberFile(this.nListID);
        Class clazz = V2CTwitterListItem.class;
        synchronized (clazz) {
            V2CLocalFileHandler.appendToFile(file, ((StringBuffer)serializable).toString(), "UTF-8");
        }
        return true;
    }

    public int compareTo(Object object) {
        V2CTwitterListItem v2CTwitterListItem = (V2CTwitterListItem)object;
        if (this.bOwnList != v2CTwitterListItem.bOwnList) {
            return this.bOwnList ? -1 : 1;
        }
        return this.sListName.compareTo(v2CTwitterListItem.sListName);
    }

    boolean isEqual(V2CTwitterListItem v2CTwitterListItem) {
        return this.bOwnList == v2CTwitterListItem.bOwnList && this.nListID == v2CTwitterListItem.nListID && this.sListName.equalsIgnoreCase(v2CTwitterListItem.sListName) && (this.bOwnList || this.nListOwnerID == v2CTwitterListItem.nListOwnerID && this.sListOwnerName.equalsIgnoreCase(v2CTwitterListItem.sListOwnerName));
    }

    boolean isSameAs(V2CTwitterListItem v2CTwitterListItem) {
        if (this.bOwnList != v2CTwitterListItem.bOwnList) {
            return false;
        }
        if (this.nListID > 0L && v2CTwitterListItem.nListID > 0L ? this.nListID != v2CTwitterListItem.nListID : !this.sListName.equalsIgnoreCase(v2CTwitterListItem.sListName)) {
            return false;
        }
        if (this.bOwnList) {
            return true;
        }
        return this.nListOwnerID == v2CTwitterListItem.nListOwnerID;
    }

    public String toString() {
        String string = this.sLabel;
        if (string == null) {
            string = this.sListName;
            if (!this.bOwnList) {
                string = '@' + this.sListOwnerName + '/' + string;
            }
            this.sLabel = string;
        }
        return string;
    }
}

