/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.util.HashMap;
import org.monazilla.v2c.V2CAbstractAction;
import org.monazilla.v2c.V2CAction;

public class V2CToolBarComponent
implements Cloneable {
    static final int TYPE_UNDEFINED = 0;
    static final int TYPE_BUTTON = 1;
    static final int TYPE_COMPONENT = 2;
    static final int TYPE_SEPARATOR = 3;
    static final int TYPE_SPACER = 4;
    static final int TYPE_GLUE = 5;
    static final int TYPE_NEWLINE = 6;
    static final String[] slNames = new String[]{"", "Button", "Component", "Separator", "Spacer", "Glue", "NewLine"};
    static V2CToolBarComponent vtbcSeparator;
    static V2CToolBarComponent vtbcGlue;
    static V2CToolBarComponent vtbcSpacer;
    static V2CToolBarComponent vtbcNewLine;
    final int nType;
    final V2CAbstractAction vAction;
    String sComponentName;
    int nWidth;
    static HashMap hmLabels;

    static V2CToolBarComponent getSeparator() {
        if (vtbcSeparator == null) {
            vtbcSeparator = new V2CToolBarComponent(3);
        }
        return vtbcSeparator;
    }

    static V2CToolBarComponent getSpacer() {
        if (vtbcSpacer == null) {
            vtbcSpacer = new V2CToolBarComponent(4);
        }
        return vtbcSpacer;
    }

    static V2CToolBarComponent getGlue() {
        if (vtbcGlue == null) {
            vtbcGlue = new V2CToolBarComponent(5);
        }
        return vtbcGlue;
    }

    static V2CToolBarComponent getNewLine() {
        if (vtbcNewLine == null) {
            vtbcNewLine = new V2CToolBarComponent(6);
        }
        return vtbcNewLine;
    }

    static V2CAbstractAction getJButtonAction(String[] stringArray) {
        int n = stringArray.length;
        if (n < 2) {
            return null;
        }
        V2CAbstractAction v2CAbstractAction = V2CAction.getAction(stringArray[1]);
        if (v2CAbstractAction == null) {
            System.out.println("unknown action: " + stringArray[1]);
            return null;
        }
        switch (v2CAbstractAction.getType()) {
            case 0: 
            case 2: {
                return v2CAbstractAction;
            }
        }
        return null;
    }

    static V2CToolBarComponent createToolBarComponent(String[] stringArray) {
        String string = stringArray[0];
        if (string.equals(slNames[1])) {
            V2CAbstractAction v2CAbstractAction = V2CToolBarComponent.getJButtonAction(stringArray);
            if (v2CAbstractAction != null) {
                return new V2CToolBarComponent(1, v2CAbstractAction);
            }
        } else if (string.equals(slNames[2])) {
            if (stringArray.length >= 2) {
                return new V2CToolBarComponent(2, stringArray);
            }
        } else {
            if (string.equals(slNames[3])) {
                return new V2CToolBarComponent(3);
            }
            if (string.equals(slNames[4])) {
                return new V2CToolBarComponent(4, stringArray);
            }
            if (string.equals(slNames[5])) {
                return new V2CToolBarComponent(5);
            }
            if (string.equals(slNames[6])) {
                return new V2CToolBarComponent(6);
            }
            System.out.println("unknown element: " + string);
        }
        return null;
    }

    public V2CToolBarComponent(int n, V2CAbstractAction v2CAbstractAction) {
        this(n, v2CAbstractAction, null);
    }

    public V2CToolBarComponent(int n, String[] stringArray) {
        this(n, null, stringArray);
    }

    public V2CToolBarComponent(int n) {
        this(n, null, null);
    }

    public V2CToolBarComponent(int n, V2CAbstractAction v2CAbstractAction, String[] stringArray) {
        this.nType = n;
        this.vAction = v2CAbstractAction;
        this.parseOption(stringArray);
        if (this.nType == 4 && this.nWidth <= 0) {
            this.nWidth = 50;
        }
    }

    void parseOption(String[] stringArray) {
        if (stringArray == null || stringArray.length <= 1) {
            return;
        }
        if (this.nType == 2) {
            this.sComponentName = stringArray[1];
        } else if (this.nType == 4) {
            String string = stringArray[1];
            int n = 0;
            if (string.startsWith("w:")) {
                try {
                    n = Integer.parseInt(string.substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.nWidth = Math.max(n, 1);
        }
    }

    int getType() {
        return this.nType;
    }

    V2CAbstractAction getAction() {
        return this.vAction;
    }

    String getComponentName() {
        return this.sComponentName;
    }

    int getWidth() {
        return this.nWidth;
    }

    void setWidth(int n) {
        this.nWidth = Math.max(n, 1);
    }

    boolean isWidthConfigurable() {
        return this.nType == 4;
    }

    boolean isDuplicatable() {
        return this.nType != 1 && this.nType != 2;
    }

    boolean isUnique() {
        return this.nType == 2 && this.sComponentName != null && !this.sComponentName.equals("ButtonPanel");
    }

    boolean isUniqueInWritePanel() {
        return this.nType == 1 || this.nType == 2;
    }

    String getSaveString() {
        String string = slNames[this.nType];
        int n = this.nType;
        if (n == 3 || n == 5 || n == 6) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(',');
        if (n == 1) {
            String string2 = null;
            if (this.vAction == null || (string2 = this.vAction.getName()) == null) {
                return null;
            }
            stringBuffer.append(string2);
        } else if (n == 2) {
            if (this.sComponentName == null || this.sComponentName.length() == 0) {
                return null;
            }
            stringBuffer.append(this.sComponentName);
        } else if (n == 4) {
            stringBuffer.append("w:");
            stringBuffer.append(String.valueOf(Math.max(this.nWidth, 1)));
        }
        return stringBuffer.toString();
    }

    V2CToolBarComponent doClone() {
        try {
            return (V2CToolBarComponent)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof V2CToolBarComponent)) {
            return false;
        }
        V2CToolBarComponent v2CToolBarComponent = (V2CToolBarComponent)object;
        if (this.nType != v2CToolBarComponent.nType) {
            return false;
        }
        if (this.nType == 1) {
            return this.vAction == v2CToolBarComponent.vAction;
        }
        if (this.nType == 2) {
            return this.sComponentName.equals(v2CToolBarComponent.sComponentName);
        }
        return true;
    }

    public int hashCode() {
        int n = this.nType;
        if (this.vAction != null) {
            n += this.vAction.hashCode();
        }
        if (this.sComponentName != null) {
            n += this.sComponentName.hashCode();
        }
        return n;
    }

    static void setLabelHashMap(HashMap hashMap) {
        hmLabels = hashMap;
    }

    public String toString() {
        String string = null;
        switch (this.nType) {
            case 1: {
                return this.vAction.toString();
            }
            case 2: {
                string = this.sComponentName;
                break;
            }
            case 3: {
                string = "Separator";
                break;
            }
            case 4: {
                string = "Spacer";
                break;
            }
            case 5: {
                string = "Glue";
                break;
            }
            case 6: {
                string = "NewLine";
            }
        }
        if (string != null) {
            String string2 = null;
            HashMap hashMap = hmLabels;
            if (hashMap != null) {
                string2 = (String)hashMap.get(string);
            }
            return string2 != null ? string2 : string;
        }
        return super.toString();
    }
}

