/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import javax.swing.CellRendererPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CBBS;
import org.monazilla.v2c.V2CGraphController;
import org.monazilla.v2c.V2CGraphSP;
import org.monazilla.v2c.V2CGraphSavePanel;
import org.monazilla.v2c.V2CHighlightTableCellRenderer;
import org.monazilla.v2c.V2CJStr;
import org.monazilla.v2c.V2CLink;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CNameRankingPanel;
import org.monazilla.v2c.V2CPackedPropValue;
import org.monazilla.v2c.V2CProgressPanel;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CResItem;
import org.monazilla.v2c.V2CResLabel;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadPanel;
import org.monazilla.v2c.V2CThreadRes;
import org.monazilla.v2c.V2CThreadStyle;

public class V2CThreadGraph {
    static final int ANCHOR_NORTH = 11;
    static final int ANCHOR_NORTHEAST = 12;
    static final int ANCHOR_EAST = 13;
    static final int ANCHOR_SOUTHEAST = 14;
    static final int ANCHOR_SOUTH = 15;
    static final int ANCHOR_SOUTHWEST = 16;
    static final int ANCHOR_WEST = 17;
    static final int ANCHOR_NORTHWEST = 18;
    static final String sKeyPrefix = "ThreadGraph.";
    private static final String sCondKey = "ThreadGraph.Cond";
    private static final String sGraphNewMarkColorKey0 = "ThreadView.GraphNewMarkColor";
    private static final String sGraphCursorColorKey0 = "ThreadView.GraphCursorColor";
    private static final String sNumRefResMarkersKey = "ThreadGraph.NumRefResMarkers";
    private static final String sNumRefResNumbersKey = "ThreadGraph.NumRefResNumbers";
    private static final String sDrawCapMarkersKey = "ThreadGraph.DrawCapMarkers";
    private static final String sDrawThreadInfoKey = "ThreadGraph.DrawThreadInfo";
    private static final String sDrawSpeedKey = "ThreadGraph.DrawSpeed";
    private static final String sHighRenderingQualityKey = "ThreadGraph.HighRenderingQuality";
    private static final String sNoSelection = "\u9078\u629e\u306a\u3057";
    static BasicStroke bsGraphGrid = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{4.0f}, 0.0f);
    static SimpleDateFormat dfTRes1 = new SimpleDateFormat("HH:mm");
    static SimpleDateFormat dfTRes1s = new SimpleDateFormat("HH:mm:ss");
    static SimpleDateFormat dfTRes1sw = new SimpleDateFormat("HH:mm:ss (E)", Locale.JAPANESE);
    static SimpleDateFormat dfTRes1p = new SimpleDateFormat("HH:mm (E)", Locale.JAPANESE);
    static SimpleDateFormat dfTRes2 = new SimpleDateFormat("yy/MM/dd");
    static SimpleDateFormat dfTRes3 = new SimpleDateFormat("yyyy/MM");
    static int[][] ilTimeTicks = new int[][]{{30, 15, 10, 5, 3, 2, 1}, {1800, 900, 600, 300, 180, 120, 60}, {43200, 21600, 10800, 7200, 3600}, {1296000, 864000, 432000, 259200, 172800, 86400}, {15778800, 7889400, 5259600, 2629800}, {157788000, 94672800, 63115200, 31557600}};
    private static Color cDefaultCap = new Color(3715294);
    private static Color cHiroyukiCap = new Color(16737095);
    private static Color cFOXCap = new Color(3050327);
    private static Color cRootCap = new Color(4251856);
    private static int nRefResMarkers;
    private static int nRefResNumbers;
    static final int nCapMarkSize = 8;
    private static final int nRefResInTickSize = 5;
    private static boolean bHighRenderingQuality;
    private static boolean bDrawCapMarkers;
    private static boolean bDrawCapNames;
    private static boolean bDrawThreadInfo;
    private static boolean bDrawSpeed;
    private static boolean bDrawResLabel;
    static final BasicStroke bsCapStar;
    static GeneralPath gpStar;
    private static final int nCursorTickLength = 10;
    private static final BasicStroke bsMarker;
    static Color cBGIn;
    static Color cBGOut;
    static Color cFrame;
    static Color cGrid;
    static Color cCursor;
    static Color cCursorLetter;
    static Color cLine;
    static Color cNewMark;
    static Color cReference;
    static Color cSpeed;
    private static final Color cMarker;
    V2CThreadPanel vThreadPanel;
    int nXGRight;
    int nXGLeft;
    int nYGBottom;
    int nYGTop;
    int nXCursor = -1;
    int nYCursor = -1;
    double dXScale;
    double dYScale;
    long[] llTime;
    int[] nlXGArray;
    int[] nlRefMarkers;
    short[] nlRefMarkerRadius;
    boolean bGraphDrawn;
    Rectangle2D r2dNRes;
    Rectangle2D r2dTRes;
    int nGResNum;
    boolean bInFrame;
    boolean bWheel;
    String sSelectedCap;
    String sSelectedTrip;
    String sSelectedName;
    String sSelectedID;
    char cSelectedPostDevice;
    int iSelectedBE;
    String sSelectedAux;
    Font fGraphFont;
    Font fGraphCursorFont;
    Font fMarkerLabelFont;
    private static String[] slOmitHTMLTags;
    private static final int NP = 5;

    static void setHighRenderingQuality(boolean bl) {
        bHighRenderingQuality = bl;
    }

    static void setDrawCapMarkers(boolean bl, boolean bl2) {
        bDrawCapMarkers = bl;
        bDrawCapNames = bl2;
    }

    static void setDrawThreadInfo(boolean bl) {
        bDrawThreadInfo = bl;
    }

    static void setDrawResLabel(boolean bl) {
        bDrawResLabel = bl;
    }

    static void setDrawSpeed(boolean bl) {
        bDrawSpeed = bl;
    }

    static void saveColor() {
        V2CPackedPropValue v2CPackedPropValue = new V2CPackedPropValue();
        v2CPackedPropValue.setColor('B', cBGOut);
        v2CPackedPropValue.setColor('C', cCursor);
        v2CPackedPropValue.setColor('F', cFrame);
        v2CPackedPropValue.setColor('G', cGrid);
        v2CPackedPropValue.setColor('I', cBGIn);
        v2CPackedPropValue.setColor('L', cLine);
        v2CPackedPropValue.setColor('N', cNewMark);
        v2CPackedPropValue.setColor('R', cReference);
        v2CPackedPropValue.setColor('S', cSpeed);
        v2CPackedPropValue.setColor('T', cCursorLetter);
        if (bDrawResLabel) {
            v2CPackedPropValue.setBoolean('L', true);
        }
        V2CApp.getUserProperty().putPackedValue(sCondKey, v2CPackedPropValue);
    }

    static void saveStates() {
        V2CProperty v2CProperty = V2CApp.getUserProperty();
        if (nRefResMarkers != 10) {
            v2CProperty.putInt(sNumRefResMarkersKey, nRefResMarkers);
        } else {
            v2CProperty.remove(sNumRefResMarkersKey);
        }
        if (nRefResNumbers > 0) {
            v2CProperty.putInt(sNumRefResNumbersKey, nRefResNumbers);
        } else {
            v2CProperty.remove(sNumRefResNumbersKey);
        }
        if (bHighRenderingQuality) {
            v2CProperty.putBoolean(sHighRenderingQualityKey, true);
        } else {
            v2CProperty.remove(sHighRenderingQualityKey);
        }
        if (bDrawCapMarkers) {
            v2CProperty.put(sDrawCapMarkersKey, bDrawCapNames ? "F" : "M");
        } else {
            v2CProperty.remove(sDrawCapMarkersKey);
        }
        if (bDrawThreadInfo) {
            v2CProperty.putBoolean(sDrawThreadInfoKey, true);
        } else {
            v2CProperty.remove(sDrawThreadInfoKey);
        }
        if (bDrawSpeed) {
            v2CProperty.putBoolean(sDrawSpeedKey, true);
        } else {
            v2CProperty.remove(sDrawSpeedKey);
        }
        V2CThreadGraph.saveColor();
    }

    private static Rectangle2D getStringBounds(Graphics2D graphics2D, Font font, String string) {
        return font.getStringBounds(string, graphics2D.getFontRenderContext());
    }

    private static Rectangle2D drawString(Graphics2D graphics2D, Font font, Color color, boolean bl, String string, int n, int n2, int n3) {
        Rectangle2D rectangle2D = V2CThreadGraph.getStringBounds(graphics2D, font, string);
        switch (n3) {
            case 13: {
                n -= (int)rectangle2D.getWidth();
                n2 -= (int)rectangle2D.getY() / 2;
                break;
            }
            case 17: {
                n2 -= (int)rectangle2D.getY() / 2;
                break;
            }
            case 11: {
                n -= (int)rectangle2D.getWidth() / 2;
                n2 += (int)rectangle2D.getHeight();
                break;
            }
            case 18: {
                n2 += (int)rectangle2D.getHeight();
                break;
            }
            case 16: {
                break;
            }
            case 14: {
                n -= (int)rectangle2D.getWidth();
            }
        }
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.drawString(string, n, n2);
        if (!bHighRenderingQuality && bl) {
            graphics2D.drawString(string, n + 1, n2);
        }
        rectangle2D.setFrame(n, (double)n2 + rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        return rectangle2D;
    }

    private static GeneralPath createStar(int n) {
        float f = (float)Math.cos(0.6283185307179586);
        float f2 = (float)Math.cos(1.2566370614359172);
        float f3 = (float)Math.sin(1.2566370614359172);
        float f4 = (float)Math.cos(2.5132741228718345);
        float f5 = (float)Math.sin(2.5132741228718345);
        float f6 = -n;
        float f7 = f3 * f6;
        float f8 = f2 * f6;
        float f9 = f5 * f6;
        float f10 = f4 * f6;
        float f11 = (float)n / f / 2.0f * 0.7f;
        float f12 = -f3 * f11;
        float f13 = f2 * f11;
        float f14 = -f5 * f11;
        float f15 = f4 * f11;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, f6);
        generalPath.lineTo(-f14, f15);
        generalPath.lineTo(-f7, f8);
        generalPath.lineTo(-f12, f13);
        generalPath.lineTo(-f9, f10);
        generalPath.lineTo(0.0f, f11);
        generalPath.lineTo(f9, f10);
        generalPath.lineTo(f12, f13);
        generalPath.lineTo(f7, f8);
        generalPath.lineTo(f14, f15);
        generalPath.closePath();
        return generalPath;
    }

    public V2CThreadGraph(V2CThreadPanel v2CThreadPanel) {
        Font font;
        this.vThreadPanel = v2CThreadPanel;
        this.fGraphCursorFont = font = v2CThreadPanel.vDefResStyle.getMessageFont()[0].getAwtFont();
        this.fMarkerLabelFont = this.fGraphFont = font.deriveFont((float)font.getSize() * 0.9f);
        this.nGResNum = -1;
    }

    void clear() {
        this.llTime = null;
        this.nlXGArray = null;
    }

    private static boolean selectedStringChanged(String string, String string2) {
        return string != null ? !string.equals(string2) : string2 != null;
    }

    void requestRedraw(V2CGraphController v2CGraphController, V2CNameRankingPanel v2CNameRankingPanel, boolean bl) {
        int n;
        boolean bl2 = bl;
        String string = v2CNameRankingPanel.getSelectedName();
        if (!bl2) {
            bl2 = V2CThreadGraph.selectedStringChanged(string, this.sSelectedName);
        }
        this.sSelectedName = string;
        String string2 = v2CNameRankingPanel.getSelectedCap();
        if (!bl2) {
            bl2 = V2CThreadGraph.selectedStringChanged(string2, this.sSelectedCap);
        }
        this.sSelectedCap = string2;
        String string3 = v2CNameRankingPanel.getSelectedTrip();
        if (!bl2) {
            bl2 = V2CThreadGraph.selectedStringChanged(string3, this.sSelectedTrip);
        }
        this.sSelectedTrip = string3;
        String string4 = v2CNameRankingPanel.getSelectedID();
        if (!bl2) {
            bl2 = V2CThreadGraph.selectedStringChanged(string4, this.sSelectedID);
        }
        this.sSelectedID = string4;
        char c = v2CNameRankingPanel.getSelectedPostDevice();
        if (!bl2) {
            bl2 = c != this.cSelectedPostDevice;
        }
        this.cSelectedPostDevice = c;
        int n2 = v2CNameRankingPanel.getSelectedBE();
        if (!bl2) {
            bl2 = n2 > 0;
        }
        this.iSelectedBE = n2;
        String string5 = v2CNameRankingPanel.getSelectedAux();
        if (!bl2) {
            bl2 = V2CThreadGraph.selectedStringChanged(string5, this.sSelectedAux);
        }
        this.sSelectedAux = string5;
        int n3 = v2CGraphController.getReferredNums();
        if (n3 != nRefResMarkers) {
            nRefResMarkers = n3;
            bl2 = true;
        }
        if ((n = v2CGraphController.getReferredNumNums()) != nRefResNumbers) {
            nRefResNumbers = n;
            bl2 = true;
        }
        if (bl2) {
            this.vThreadPanel.repaint();
        }
    }

    static V2CGraphSP createGraphSP() {
        return new V2CGraphSP(nRefResMarkers, nRefResNumbers, bDrawCapMarkers, bDrawCapNames, bDrawThreadInfo, bDrawResLabel, bDrawSpeed, bHighRenderingQuality);
    }

    static int postConfig(V2CGraphSP v2CGraphSP) {
        int n;
        int n2;
        boolean bl = false;
        boolean bl2 = v2CGraphSP.jcbDrawCapMarkers.isSelected();
        if (bl2 != bDrawCapMarkers) {
            bDrawCapMarkers = bl2;
            bl = true;
        }
        if ((bl2 = v2CGraphSP.jcbDrawCapNames.isSelected()) != bDrawCapNames) {
            bDrawCapNames = bl2;
            bl = true;
        }
        if ((bl2 = v2CGraphSP.jcbDrawThreadInfo.isSelected()) != bDrawThreadInfo) {
            bDrawThreadInfo = bl2;
            bl = true;
        }
        if ((bl2 = v2CGraphSP.jcbDrawResLabel.isSelected()) != bDrawResLabel) {
            bDrawResLabel = bl2;
            bl = true;
        }
        if ((bl2 = v2CGraphSP.jcbDrawSpeed.isSelected()) != bDrawSpeed) {
            bDrawSpeed = bl2;
            bl = true;
        }
        if ((bl2 = v2CGraphSP.jcbHighRenderingQuality.isSelected()) != bHighRenderingQuality) {
            bHighRenderingQuality = bl2;
            bl = true;
        }
        if ((n2 = v2CGraphSP.getReferredNums()) != nRefResMarkers) {
            nRefResMarkers = n2;
            bl = true;
        }
        if ((n = v2CGraphSP.getReferredNumNums()) != nRefResNumbers) {
            nRefResNumbers = n;
            bl = true;
        }
        if (bl) {
            V2CThreadGraph.saveStates();
        }
        return bl ? 1 : 0;
    }

    void showController() {
        V2CGraphController v2CGraphController = new V2CGraphController(this, this.vThreadPanel.getThreadRes(), nRefResMarkers, nRefResNumbers, bDrawCapMarkers, bDrawCapNames, bDrawThreadInfo, bDrawResLabel, bDrawSpeed, bHighRenderingQuality);
        V2CNameRankingPanel v2CNameRankingPanel = v2CGraphController.getRankingPanel();
        if (this.sSelectedName != null) {
            v2CNameRankingPanel.setSelectedName(this.sSelectedName, false);
        } else if (this.sSelectedCap != null) {
            v2CNameRankingPanel.setSelectedCap(this.sSelectedCap);
        } else if (this.sSelectedTrip != null) {
            v2CNameRankingPanel.setSelectedTrip(this.sSelectedTrip);
        } else if (this.sSelectedID != null) {
            v2CNameRankingPanel.setSelectedID(this.sSelectedID);
        } else if (this.cSelectedPostDevice > '\u0000') {
            v2CNameRankingPanel.setSelectedPostDevice(this.cSelectedPostDevice);
        } else if (this.iSelectedBE > 0) {
            v2CNameRankingPanel.setSelectedBE(this.iSelectedBE);
        } else if (this.sSelectedAux != null) {
            v2CNameRankingPanel.setSelectedAux(this.sSelectedAux);
        }
        v2CGraphController.showDialog();
    }

    String createSaveFileName() {
        String string;
        V2CThreadItem v2CThreadItem = this.vThreadPanel.getThreadItem();
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append("graph");
        String string2 = v2CThreadItem.getBoardString();
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append('_');
            stringBuffer.append(string2);
        }
        if ((string = v2CThreadItem.getThreadKey()) != null && string.length() > 0) {
            stringBuffer.append('_');
            stringBuffer.append(string);
        }
        stringBuffer.append(".png");
        return stringBuffer.toString();
    }

    void saveGraph() {
        Object object;
        int n;
        int n2;
        File file = V2CLink.getImageSaveDir(this.vThreadPanel.getThreadItem());
        V2CGraphSavePanel v2CGraphSavePanel = new V2CGraphSavePanel();
        JFileChooser jFileChooser = V2CSwingUtil.createFileChooser(file);
        jFileChooser.setAccessory(v2CGraphSavePanel);
        jFileChooser.setSelectedFile(new File(file, this.createSaveFileName()));
        int n3 = jFileChooser.showSaveDialog(V2CMain.v2cMain);
        if (n3 != 0) {
            return;
        }
        File file2 = jFileChooser.getSelectedFile();
        V2CLink.saveLastImageSaveDir(file2, true);
        v2CGraphSavePanel.saveCondition();
        if (file2.exists()) {
            if (!file2.canWrite()) {
                V2CSwingUtil.showErrorMessage("\u5bfe\u8c61\u30d5\u30a1\u30a4\u30eb\u306b\u66f8\u304d\u8fbc\u3081\u307e\u305b\u3093");
                return;
            }
            n3 = JOptionPane.showConfirmDialog(V2CMain.v2cMain, V2CJStr.getFileExistsMessage(file2), "Warning", 2, 2);
            if (n3 != 0) {
                return;
            }
        }
        if (v2CGraphSavePanel.useCustomeSize()) {
            n2 = v2CGraphSavePanel.getGraphWidth();
            n = v2CGraphSavePanel.getGraphHeight();
        } else {
            object = this.vThreadPanel.getRealDrawingRect();
            n2 = ((Rectangle)object).width;
            n = ((Rectangle)object).height;
        }
        object = new V2CProgressPanel("\u63cf\u753b\u4e2d\u2026", "\u30b0\u30e9\u30d5\u63cf\u753b");
        GraphSaver graphSaver = new GraphSaver(file2, n2, n, (V2CProgressPanel)object);
        graphSaver.start();
        if (!((V2CProgressPanel)object).showPanel()) {
            graphSaver.interrupt();
            return;
        }
    }

    int getResNumToPopup(Point point) {
        int[] nArray;
        this.setInFrame(point);
        if (this.bInFrame && (nArray = this.nlRefMarkers) != null) {
            int n = point.x;
            int n2 = point.y;
            short[] sArray = this.nlRefMarkerRadius;
            int[] nArray2 = this.nlXGArray;
            float f = Float.MAX_VALUE;
            int n3 = -1;
            for (int i = 0; i < nArray.length; ++i) {
                int n4 = nArray[i];
                int n5 = this.nlXGArray[n4];
                int n6 = this.nYGBottom - (int)(this.dYScale * (double)n4);
                float f2 = (float)Math.sqrt(Math.pow(n5 - n, 2.0) + Math.pow(n6 - n2, 2.0));
                if ((int)f2 > sArray[i] || !(f2 < f)) continue;
                n3 = n4;
                f = f2;
            }
            if (n3 >= 0) {
                return n3;
            }
        }
        return this.nGResNum;
    }

    void setResNumToGo(int n) {
        this.nGResNum = n;
        this.bWheel = true;
    }

    int getResNumToGo(boolean bl) {
        return bl && this.bInFrame || this.bWheel ? this.nGResNum : -1;
    }

    void setRenderingQuality(Graphics2D graphics2D, boolean bl) {
        boolean bl2 = bHighRenderingQuality;
        if (bl) {
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, bl2 ? RenderingHints.VALUE_RENDER_QUALITY : RenderingHints.VALUE_RENDER_SPEED);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl2 ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, bl2 ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    void clearGraphCursor(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        int n4;
        Image image = this.vThreadPanel.getImageBuffer();
        if (this.nXCursor >= 0) {
            graphics2D.drawImage(image, this.nXCursor, this.nYGBottom + 1, this.nXCursor + 1, this.nYGTop, this.nXCursor, this.nYGBottom + 1, this.nXCursor + 1, this.nYGTop, null);
        }
        if (this.nYCursor >= 0) {
            graphics2D.drawImage(image, this.nXGLeft, this.nYCursor, this.nXGRight + 1, this.nYCursor + 1, this.nXGLeft, this.nYCursor, this.nXGRight + 1, this.nYCursor + 1, null);
        }
        if (this.nXCursor >= 0 && this.nYCursor >= 0) {
            graphics2D.drawImage(image, this.nXCursor - 10, this.nYCursor - 10, this.nXCursor + 10 + 1, this.nYCursor + 10 + 1, this.nXCursor - 10, this.nYCursor - 10, this.nXCursor + 10 + 1, this.nYCursor + 10 + 1, null);
        }
        if (this.r2dNRes != null) {
            n4 = (int)this.r2dNRes.getMinX();
            n3 = (int)this.r2dNRes.getMaxX() + 1;
            n2 = (int)this.r2dNRes.getMinY();
            n = (int)this.r2dNRes.getMaxY() + 1;
            graphics2D.drawImage(image, n4, n2, n3, n, n4, n2, n3, n, null);
            this.r2dNRes = null;
        }
        if (this.r2dTRes != null) {
            n4 = (int)this.r2dTRes.getMinX();
            n3 = (int)this.r2dTRes.getMaxX() + 1;
            n2 = (int)this.r2dTRes.getMinY();
            n = (int)this.r2dTRes.getMaxY() + 1;
            graphics2D.drawImage(image, n4, n2, n3, n, n4, n2, n3, n, null);
            this.r2dTRes = null;
        }
    }

    void drawGraphCursor(Graphics2D graphics2D, int n) {
        long l;
        int n2;
        this.nGResNum = n;
        this.nXCursor = this.nlXGArray[n];
        this.nYCursor = this.nYGBottom - (int)(this.dYScale * (double)n);
        graphics2D.setColor(cCursor);
        if (this.nXCursor > this.nXGLeft + 10) {
            n2 = this.nXCursor - 10;
            graphics2D.drawLine(this.nXGLeft, this.nYCursor, n2, this.nYCursor);
            graphics2D.drawLine(n2, this.nYCursor - 2, n2, this.nYCursor + 2);
        }
        if (this.nXCursor < this.nXGRight - 10) {
            n2 = this.nXCursor + 10;
            graphics2D.drawLine(n2, this.nYCursor, this.nXGRight, this.nYCursor);
            graphics2D.drawLine(n2, this.nYCursor - 2, n2, this.nYCursor + 2);
        }
        if (this.nYCursor > this.nYGTop + 10) {
            n2 = this.nYCursor - 10;
            graphics2D.drawLine(this.nXCursor, this.nYGTop, this.nXCursor, n2);
            graphics2D.drawLine(this.nXCursor - 2, n2, this.nXCursor + 2, n2);
        }
        if (this.nYCursor < this.nYGBottom - 10) {
            n2 = this.nYCursor + 10;
            graphics2D.drawLine(this.nXCursor, n2, this.nXCursor, this.nYGBottom);
            graphics2D.drawLine(this.nXCursor - 2, n2, this.nXCursor + 2, n2);
        }
        this.r2dNRes = V2CThreadGraph.drawString(graphics2D, this.fGraphCursorFont, cCursorLetter, true, String.valueOf(n + 1), this.nXCursor - 5, this.nYCursor - 5, 14);
        V2CThreadRes v2CThreadRes = this.vThreadPanel.getThreadRes();
        V2CResItem v2CResItem = null;
        for (int i = n; i < v2CThreadRes.getNRes() && (v2CResItem = v2CThreadRes.getResItem(i)) == null; ++i) {
        }
        long l2 = l = v2CResItem != null ? v2CResItem.getTime() : 0L;
        if (l > 0L) {
            Date date = new Date(l);
            int n3 = this.nYCursor + 5;
            graphics2D.setColor(cCursorLetter);
            Rectangle2D rectangle2D = V2CThreadGraph.drawString(graphics2D, this.fGraphCursorFont, cCursorLetter, true, (v2CResItem.hasSecond() ? dfTRes1sw : dfTRes1p).format(date), this.nXCursor + 5, n3, 18);
            Rectangle2D rectangle2D2 = V2CThreadGraph.drawString(graphics2D, this.fGraphCursorFont, cCursorLetter, true, dfTRes2.format(date), this.nXCursor + 5, n3 += (int)rectangle2D.getHeight() + 1, 18);
            this.r2dTRes = rectangle2D.createUnion(rectangle2D2);
        }
    }

    void updateGraphCursor(Point point) {
        if (!this.bGraphDrawn) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.vThreadPanel.getGraphics();
        graphics2D.setClip(this.vThreadPanel.getRealDrawingRect());
        this.setRenderingQuality(graphics2D, false);
        if (point == null) {
            this.clearGraphCursor(graphics2D);
            return;
        }
        int n = this.vThreadPanel.getWidth();
        int n2 = this.vThreadPanel.getDrawingHeight(true);
        int n3 = (int)point.getX();
        int n4 = (int)point.getY();
        this.setInFrame(point);
        if (this.bInFrame || !this.bWheel) {
            this.clearGraphCursor(graphics2D);
        }
        if (this.bInFrame) {
            this.bWheel = false;
            int n5 = (int)((double)(this.nYGBottom - n4) / this.dYScale);
            if (n4 < this.nYGBottom - (int)(this.dYScale * (double)(2 * n5 + 1) / 2.0)) {
                ++n5;
            }
            if (n5 > this.llTime.length - 1) {
                n5 = this.llTime.length - 1;
            } else if (n5 < 0) {
                n5 = 0;
            }
            if (n3 >= this.nlXGArray[n5]) {
                int n6;
                for (n6 = 0; n6 < this.nlXGArray.length && n3 > this.nlXGArray[n6]; ++n6) {
                }
                if (n6 == this.nlXGArray.length || n6 > 0 && n3 < (this.nlXGArray[n6 - 1] + this.nlXGArray[n6]) / 2) {
                    --n6;
                }
                n5 = n6;
            }
            this.drawGraphCursor(graphics2D, n5);
        } else if (!this.bWheel) {
            this.nYCursor = -1;
            this.nXCursor = -1;
        }
    }

    void unitMove(boolean bl) {
        if (this.bInFrame) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.vThreadPanel.getGraphics();
        graphics2D.setClip(this.vThreadPanel.getRealDrawingRect());
        this.setRenderingQuality(graphics2D, false);
        this.clearGraphCursor(graphics2D);
        int[] nArray = this.nlRefMarkers;
        if (nArray == null || nArray.length == 0) {
            return;
        }
        this.bWheel = true;
        int n = -1;
        if (this.nGResNum >= 0) {
            if (bl) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] <= this.nGResNum) continue;
                    n = nArray[i];
                    break;
                }
            } else {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    if (nArray[i] >= this.nGResNum) continue;
                    n = nArray[i];
                    break;
                }
            }
        }
        if (n < 0) {
            n = nArray[bl ? 0 : nArray.length - 1];
        }
        this.drawGraphCursor(graphics2D, n);
    }

    void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.unitMove(mouseWheelEvent.getUnitsToScroll() < 0);
    }

    void drawGraph(Graphics2D graphics2D, Rectangle rectangle, boolean bl) {
        int n;
        this.bInFrame = false;
        this.bWheel = false;
        V2CThreadRes v2CThreadRes = this.vThreadPanel.getThreadRes();
        int n2 = rectangle.height;
        int n3 = rectangle.width;
        this.setRenderingQuality(graphics2D, true);
        graphics2D.setColor(cBGOut);
        graphics2D.fillRect(rectangle.x, rectangle.y, n3, n2);
        this.nXGLeft = rectangle.x + (int)((double)n3 * 0.1);
        this.nXGRight = rectangle.x + (int)((double)n3 * 0.92);
        this.nYGTop = rectangle.y + (int)((double)n2 * 0.08);
        this.nYGBottom = rectangle.y + (int)((double)n2 * 0.9);
        int n4 = this.nXGRight - this.nXGLeft;
        int n5 = this.nYGBottom - this.nYGTop;
        int n6 = v2CThreadRes.getNRes();
        if (n6 < 2) {
            return;
        }
        long l = v2CThreadRes.getResItem(0).getTime();
        long[] lArray = new long[n6];
        this.llTime = lArray;
        for (int i = 0; i < n6; ++i) {
            long l2;
            V2CResItem v2CResItem = v2CThreadRes.getResItem(i);
            long l3 = l2 = v2CResItem != null ? v2CResItem.getTime() : 0L;
            if (l2 == 0L && i > 0) {
                l2 = lArray[i - 1];
            }
            lArray[i] = l2;
        }
        long l4 = 0L;
        for (int i = n6 - 1; i >= 0; --i) {
            long l5 = lArray[i];
            if (l5 <= 0L) continue;
            l4 = l5;
            break;
        }
        long l6 = l4 - l;
        if (l == 0L || l4 == 0L || l6 == 0L) {
            return;
        }
        graphics2D.setColor(cBGIn);
        graphics2D.fillRect(this.nXGLeft - 1, this.nYGTop - 1, this.nXGRight - this.nXGLeft + 2, this.nYGBottom - this.nYGTop + 2);
        this.dXScale = (double)n4 / (double)l6;
        this.dYScale = (double)n5 / (double)(n6 - 1);
        this.nlXGArray = new int[n6];
        int[] nArray = new int[n6];
        for (n = n6 - 1; n >= 0; --n) {
            long l7 = lArray[n];
            this.nlXGArray[n] = this.nXGLeft + (int)(this.dXScale * (double)(l7 - l));
            nArray[n] = this.nYGBottom - (int)(this.dYScale * (double)n);
        }
        this.drawSpeed(graphics2D);
        if (bDrawThreadInfo) {
            V2CThreadItem v2CThreadItem = this.vThreadPanel.getThreadItem();
            int n7 = this.nXGRight - 10;
            int n8 = this.nYGBottom - 10;
            Rectangle2D rectangle2D = V2CThreadGraph.drawString(graphics2D, this.fGraphFont, cFrame, true, v2CThreadItem.getFormalURLString(), n7, n8, 14);
            V2CThreadGraph.drawString(graphics2D, this.fGraphFont, cFrame, true, v2CThreadItem.getTitle(), n7, n8 - (int)rectangle2D.getHeight(), 14);
        }
        this.drawNumLabels(graphics2D, v2CThreadRes);
        this.drawTimeLabels(graphics2D, l, l4);
        n = v2CThreadRes.getNewMarkPos();
        if (!bl && n > 0 && n < n6) {
            int n9 = this.nYGBottom - (int)(this.dYScale * (double)n);
            graphics2D.setColor(cNewMark);
            graphics2D.drawLine(this.nXGLeft, n9, this.nXGRight, n9);
        }
        graphics2D.setColor(cLine);
        graphics2D.drawPolyline(this.nlXGArray, nArray, n6);
        int n10 = 0;
        while (n10 < n6) {
            int n11 = n10++;
            this.nlXGArray[n11] = this.nlXGArray[n11] + 1;
        }
        graphics2D.drawPolyline(this.nlXGArray, nArray, n6);
        n10 = 0;
        while (n10 < n6) {
            int n12 = n10;
            this.nlXGArray[n12] = this.nlXGArray[n12] - 1;
            int n13 = n10++;
            nArray[n13] = nArray[n13] - 1;
        }
        graphics2D.drawPolyline(this.nlXGArray, nArray, n6);
        n10 = 0;
        while (n10 < n6) {
            int n14 = n10++;
            nArray[n14] = nArray[n14] + 1;
        }
        graphics2D.setColor(cFrame);
        graphics2D.drawRect(this.nXGLeft - 1, this.nYGTop - 1, this.nXGRight - this.nXGLeft + 2, this.nYGBottom - this.nYGTop + 2);
        graphics2D.drawRect(this.nXGLeft - 2, this.nYGTop - 2, this.nXGRight - this.nXGLeft + 4, this.nYGBottom - this.nYGTop + 4);
        this.drawResLabels(graphics2D, this.nlXGArray, nArray, n6);
        this.drawMarkers(graphics2D, this.nlXGArray, nArray, n6);
        this.bGraphDrawn = true;
        if (!bl) {
            this.setInFrame(V2CSwingUtil.getMouseLocation(this.vThreadPanel));
        }
    }

    void setInFrame(Point point) {
        this.bInFrame = point != null && point.x >= this.nXGLeft && point.x <= this.nXGRight && point.y >= this.nYGTop && point.y <= this.nYGBottom;
    }

    void drawNumLabels(Graphics2D graphics2D, V2CThreadRes v2CThreadRes) {
        int n;
        int n2;
        int n3;
        block8: {
            n3 = v2CThreadRes.getNRes();
            int n4 = (int)Math.pow(10.0, (int)(Math.log(n3) / Math.log(10.0)));
            do {
                if (n3 / (n4 * 5) >= 3) {
                    n2 = n4 * 5;
                    n = n4;
                } else if (n3 / (n4 * 2) >= 3) {
                    n2 = n4 * 2;
                    n = n4 / 2;
                } else {
                    if (n3 / n4 < 3) continue;
                    n2 = n4;
                    n = n4 / 5;
                }
                break block8;
            } while ((n4 /= 10) != 0);
            return;
        }
        if (n == 0) {
            n = n2;
        }
        V2CThreadGraph.drawString(graphics2D, this.fGraphFont, cFrame, true, "1", this.nXGLeft - 5, this.nYGBottom, 13);
        Stroke stroke = graphics2D.getStroke();
        for (int i = n - 1; i < n3; i += n) {
            int n5 = this.nYGBottom - (int)(this.dYScale * (double)i);
            int n6 = 5;
            if ((i + 1) % n2 == 0) {
                graphics2D.setColor(cGrid);
                graphics2D.setStroke(bsGraphGrid);
                graphics2D.drawLine(this.nXGLeft, n5, this.nXGRight, n5);
                V2CThreadGraph.drawString(graphics2D, this.fGraphFont, cFrame, true, String.valueOf(i + 1), this.nXGLeft - 5, n5, 13);
                n6 = 8;
            }
            graphics2D.setColor(cFrame);
            graphics2D.setStroke(stroke);
            graphics2D.drawLine(this.nXGLeft, n5, this.nXGLeft + n6, n5);
            graphics2D.drawLine(this.nXGRight - n6, n5, this.nXGRight, n5);
        }
        graphics2D.setStroke(stroke);
    }

    void drawTimeLabels(Graphics2D graphics2D, long l, long l2) {
        int n = (int)((l2 - l) / 1000L);
        int n2 = 0;
        block0: for (int i = 0; i < ilTimeTicks.length; ++i) {
            int[] nArray = ilTimeTicks[i];
            for (int j = 0; j < nArray.length; ++j) {
                if (n / nArray[j] < 3) continue;
                n2 = nArray[j];
                continue block0;
            }
        }
        if (n2 == 0) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        int n3 = 1;
        if (n2 > 86400) {
            calendar.set(5, 1);
            if (n2 > 2629800) {
                calendar.set(2, 0);
                n3 = n2 > 31557600 ? (int)Math.round((double)n2 / 3.15576E7) : (int)Math.round((double)n2 / 2629800.0);
            } else {
                n3 = (int)Math.round((double)n2 / 86400.0);
            }
        }
        long l3 = calendar.getTimeInMillis();
        long l4 = (long)n2 * 1000L;
        long l5 = n2 > 86400 ? l3 : l3 + ((l - l3) / l4 + 1L) * l4;
        Stroke stroke = graphics2D.getStroke();
        String string = null;
        while (l5 < l2) {
            if (l5 >= l) {
                String string2;
                Cloneable cloneable;
                int n4 = this.nXGLeft + (int)(this.dXScale * (double)(l5 - l));
                graphics2D.setColor(cGrid);
                graphics2D.setStroke(bsGraphGrid);
                graphics2D.drawLine(n4, this.nYGBottom, n4, this.nYGTop);
                Date date = new Date(l5);
                int n5 = this.nYGBottom + 5;
                if (n2 < 86400) {
                    cloneable = V2CThreadGraph.drawString(graphics2D, this.fGraphFont, cFrame, true, (n2 < 60 ? dfTRes1s : dfTRes1).format(date), n4, n5, 11);
                    n5 += (int)((RectangularShape)cloneable).getHeight();
                }
                if (!(string2 = ((DateFormat)(cloneable = n2 > 2629800 ? dfTRes3 : dfTRes2)).format(date)).equals(string)) {
                    V2CThreadGraph.drawString(graphics2D, this.fGraphFont, cFrame, true, string2, n4, n5, 11);
                }
                string = string2;
                graphics2D.setColor(cFrame);
                graphics2D.setStroke(stroke);
                graphics2D.drawLine(n4, this.nYGBottom, n4, this.nYGBottom - 8);
                graphics2D.drawLine(n4, this.nYGTop + 8, n4, this.nYGTop);
            }
            if (n2 > 86400) {
                if (n2 > 31557600) {
                    calendar.add(1, n3);
                } else if (n2 > 2629800) {
                    calendar.add(2, n3);
                } else {
                    calendar.add(5, n3);
                }
                l5 = calendar.getTimeInMillis();
                continue;
            }
            l5 += l4;
        }
        graphics2D.setStroke(stroke);
    }

    void drawResLabels(Graphics2D graphics2D, int[] nArray, int[] nArray2, int n) {
        if (!bDrawResLabel || n == 0) {
            return;
        }
        V2CThreadRes v2CThreadRes = this.vThreadPanel.getThreadRes();
        V2CHighlightTableCellRenderer v2CHighlightTableCellRenderer = null;
        CellRendererPane cellRendererPane = null;
        int[] nArray3 = null;
        int[] nArray4 = null;
        for (int i = 0; i < n; ++i) {
            V2CResLabel v2CResLabel = v2CThreadRes.getResLabel(i);
            if (v2CResLabel == null) continue;
            if (v2CHighlightTableCellRenderer == null) {
                v2CHighlightTableCellRenderer = new V2CHighlightTableCellRenderer(V2CThreadStyle.getDefaultColor(1));
                cellRendererPane = new CellRendererPane();
                nArray3 = new int[3];
                nArray4 = new int[3];
            }
            v2CHighlightTableCellRenderer.setText(V2CMiscUtil.stringValueOf(i + 1));
            Dimension dimension = v2CHighlightTableCellRenderer.getPreferredSize();
            v2CHighlightTableCellRenderer.setHighlightStyle(v2CResLabel.getStyle());
            int n2 = nArray[i] + 3;
            int n3 = nArray2[i] + 3;
            cellRendererPane.paintComponent(graphics2D, v2CHighlightTableCellRenderer, this.vThreadPanel, n2, n3, dimension.width, dimension.height);
            graphics2D.setColor(cReference);
            nArray3[0] = nArray3[2] = --n2;
            nArray3[1] = n2 + 5;
            nArray4[0] = nArray4[1] = --n3;
            nArray4[2] = n3 + 5;
            graphics2D.fillPolygon(nArray3, nArray4, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawMarkers(Graphics2D graphics2D, int[] nArray, int[] nArray2, int n) {
        Object object;
        Object object2;
        int n2;
        Object object3;
        if (n == 0) {
            return;
        }
        V2CThreadRes v2CThreadRes = this.vThreadPanel.getThreadRes();
        Stroke stroke = graphics2D.getStroke();
        AffineTransform affineTransform = graphics2D.getTransform();
        this.nlRefMarkers = null;
        if (nRefResMarkers > 0) {
            int[] nArray3 = v2CThreadRes.createRefCountArray();
            int[] nArray4 = V2CThreadGraph.sortMostReferredRes(nArray3);
            object3 = new short[nArray4.length];
            if (nArray4.length > 0) {
                int n3;
                int n4;
                int n5;
                int n6 = 0;
                n2 = 0;
                boolean bl = nRefResNumbers > 0;
                for (int i = nArray4.length - 1; i >= 0 && (n5 = nArray3[i]) < nArray.length; --i) {
                    int n7;
                    int n8 = nArray4[i];
                    if (n6 >= nRefResMarkers && n8 < n2) break;
                    if (bl && n6 >= nRefResNumbers && n8 < n2) {
                        bl = false;
                    }
                    ++n6;
                    n2 = n8;
                    n4 = nArray[n5];
                    n3 = nArray2[n5];
                    int n9 = (int)(Math.log(n8) * 10.0);
                    object3[i] = (short)n9;
                    graphics2D.setColor(cReference);
                    graphics2D.setStroke(new BasicStroke((float)n9 * 0.2f));
                    graphics2D.drawOval(n4 - n9, n3 - n9, n9 * 2 + 1, n9 * 2 + 1);
                    if (n9 > 5) {
                        graphics2D.setStroke(stroke);
                        n7 = Math.max(5, n9 - 5);
                        graphics2D.drawLine(n4 - n9, n3, n4 - n7, n3);
                        graphics2D.drawLine(n4 + n7, n3, n4 + n9, n3);
                        graphics2D.drawLine(n4, n3 - n9, n4, n3 - n7);
                        graphics2D.drawLine(n4, n3 + n7, n4, n3 + n9);
                    }
                    if (!bl) continue;
                    n7 = nArray[n5] - 8;
                    int n10 = nArray2[n5] - 8;
                    String string = String.valueOf(n5 + 1);
                    V2CThreadGraph.drawString(graphics2D, this.fMarkerLabelFont, cBGIn, false, string, n7 + 1, n10 + 1, 14);
                    V2CThreadGraph.drawString(graphics2D, this.fMarkerLabelFont, cReference, false, string, n7, n10, 14);
                }
                object2 = new int[n6];
                object = new short[n6];
                this.nlRefMarkers = object2;
                this.nlRefMarkerRadius = object;
                if (n6 > 0) {
                    long[] lArray = new long[n6];
                    for (n4 = 0; n4 < n6; ++n4) {
                        n3 = nArray4.length - n4 - 1;
                        lArray[n4] = ((long)nArray3[n3] << 32) + (long)object3[n3];
                    }
                    Arrays.sort(lArray);
                    for (n4 = 0; n4 < n6; ++n4) {
                        object2[n4] = (int)(lArray[n4] >>> 32);
                        object[n4] = (short)(lArray[n4] & 0xFFFFL);
                    }
                }
            }
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            object3 = v2CThreadRes.getResItem(i);
            if (object3 == null) continue;
            String string = ((V2CResItem)object3).getNameString();
            if (string != null && string.length() > 0) {
                if (this.sSelectedCap != null && string.indexOf(this.sSelectedCap) >= 0) {
                    V2CThreadGraph.drawNormalMarker(graphics2D, nArray[i], nArray2[i]);
                } else if (this.sSelectedTrip != null && string.indexOf(this.sSelectedTrip) >= 0) {
                    V2CThreadGraph.drawNormalMarker(graphics2D, nArray[i], nArray2[i]);
                } else if (string.equals(this.sSelectedName)) {
                    V2CThreadGraph.drawNormalMarker(graphics2D, nArray[i], nArray2[i]);
                }
                if (!(!bDrawCapMarkers || (n2 = string.indexOf(9733)) <= 0 || string.equals("\u30c8\u30e9\u30c3\u30af\u30d0\u30c3\u30af \u2605") || n2 >= 4 && string.regionMatches(n2 - 4, "\uff20\u682a\u4e3b \u2605", 0, 5))) {
                    Object var24_30;
                    Color color = string.indexOf("root\u25b2\u25b2 \u2605") >= 0 || string.indexOf("root\u25b2 \u2605") >= 0 || string.indexOf("root \u2605") >= 0 ? cRootCap : (string.indexOf("FOX \u2605") >= 0 || string.indexOf("FAX \u2605") >= 0 || string.indexOf("\u305f\u306b\u3057 \u2605") >= 0 || string.indexOf("\u3061\u3087\u308d \u2605") >= 0 || string.indexOf("\u3076\u305f\u3055\u3093 \u2605") >= 0 || string.indexOf("\u756a\u72ac \u2605") >= 0 || string.indexOf("\u3056\u308b \u2605") >= 0 || string.indexOf("\u9df2\u9d28 \u2605") >= 0 || string.indexOf("\u3064\u308b\u3063\u3074 \u2605") >= 0 || string.indexOf("\u305b\u3057\u308a\u3042 \u2605") >= 0 || string.indexOf("\u8efd\u5feb\u3046\u306d\u3063\u3053 \u2605") >= 0 || string.indexOf("\u3061\u304d\u3061\u30fc\u305f \u2605") >= 0 ? cFOXCap : (string.indexOf("\u3072\u308d\u3086\u304d\uff20\u3069\u3046\u3084\u3089\u7ba1\u7406\u4eba \u2605") >= 0 || string.indexOf("\u3069\u3046\u3084\u3089\u7ba1\u7406\u4eba \u2605") >= 0 ? cHiroyukiCap : cDefaultCap));
                    graphics2D.setColor(color);
                    graphics2D.setStroke(bsCapStar);
                    try {
                        graphics2D.translate(nArray[i], nArray2[i]);
                        graphics2D.draw(gpStar);
                        var24_30 = null;
                        graphics2D.setTransform(affineTransform);
                    }
                    catch (Throwable throwable) {
                        var24_30 = null;
                        graphics2D.setTransform(affineTransform);
                        throw throwable;
                    }
                    if (bDrawCapNames) {
                        object2 = V2CThreadGraph.omitHTMLTags(string);
                        if (!bl && nArray[i] > (this.nXGLeft + this.nXGRight) / 2 && (double)(nArray[i] + 8) + ((RectangularShape)(object = (Object)V2CThreadGraph.getStringBounds(graphics2D, this.fMarkerLabelFont, (String)object2))).getWidth() > (double)this.nXGRight) {
                            bl = true;
                        }
                        V2CThreadGraph.drawString(graphics2D, this.fMarkerLabelFont, color, false, (String)object2, nArray[i] + (bl ? -8 : 8), nArray2[i], bl ? 13 : 17);
                    }
                }
            }
            if (this.sSelectedID != null && this.sSelectedID.equals(((V2CResItem)object3).getID())) {
                V2CThreadGraph.drawNormalMarker(graphics2D, nArray[i], nArray2[i]);
            }
            if (this.cSelectedPostDevice > '\u0000' && this.cSelectedPostDevice == ((V2CResItem)object3).getPostDevice()) {
                V2CThreadGraph.drawNormalMarker(graphics2D, nArray[i], nArray2[i]);
            }
            if (this.iSelectedBE > 0 && this.iSelectedBE == ((V2CResItem)object3).getBeID0()) {
                V2CThreadGraph.drawNormalMarker(graphics2D, nArray[i], nArray2[i]);
            }
            if (this.sSelectedAux == null || !this.sSelectedAux.equals(((V2CResItem)object3).getAuxString())) continue;
            V2CThreadGraph.drawNormalMarker(graphics2D, nArray[i], nArray2[i]);
        }
        graphics2D.setStroke(stroke);
    }

    private static String omitHTMLTags(String string) {
        if (string.indexOf(60) < 0) {
            return string;
        }
        int n = 0;
        while ((n = string.indexOf(60, n)) >= 0) {
            int n2;
            boolean bl = false;
            for (n2 = 0; n2 < slOmitHTMLTags.length; ++n2) {
                String string2 = slOmitHTMLTags[n2];
                if (!string.regionMatches(true, n + 1, string2, 0, string2.length())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                ++n;
                continue;
            }
            n2 = string.indexOf(62, n + 1);
            if (n2 < 0) break;
            string = string.substring(0, n) + string.substring(n2 + 1);
        }
        return string;
    }

    private static void drawNormalMarker(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setColor(cMarker);
        graphics2D.fillOval(n - 4, n2 - 4, 9, 9);
    }

    private static int[] sortMostReferredRes(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 1) continue;
            nArray[n++] = nArray[i] << 16 | i;
        }
        if (n == 0) {
            return new int[0];
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        Arrays.sort(nArray2);
        for (int i = 0; i < nArray2.length; ++i) {
            int n2 = nArray2[i];
            nArray[i] = n2 & 0xFFFF;
            nArray2[i] = n2 >> 16;
        }
        return nArray2;
    }

    private void drawSpeed(Graphics2D graphics2D) {
        int n;
        if (!bDrawSpeed) {
            return;
        }
        long[] lArray = this.llTime;
        int n2 = lArray.length;
        if (n2 < 20) {
            return;
        }
        int[] nArray = new int[n2];
        float[] fArray = new float[n2];
        int n3 = 0;
        float f = Float.NEGATIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        for (int i = 5; i < n2 - 5; ++i) {
            float f3;
            long l = lArray[i];
            if (l == 0L) continue;
            n = i - 5;
            int n4 = i + 5;
            int n5 = 0;
            int n6 = 0;
            for (int j = n; j < n4; ++j) {
                long l2;
                if (j == i || (l2 = lArray[j]) == 0L) continue;
                int n7 = (int)(l2 - l);
                if (n7 < 0) {
                    n7 = -n7;
                }
                n5 += n7;
                ++n6;
            }
            if (n6 == 0) continue;
            double d = (double)n5 / (double)n6;
            d *= d;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            n6 = 0;
            for (int j = n; j < n4; ++j) {
                long l3 = lArray[j];
                int n8 = (int)(l3 - l);
                float f9 = (float)n8 * (float)n8;
                float f10 = (float)Math.exp((double)(-f9) / d);
                if (l3 == 0L) continue;
                f4 += f10 * f9;
                f5 += f10 * (float)n8;
                f6 += f10;
                int n9 = j - i;
                f7 += f10 * (float)n8 * (float)n9;
                f8 += f10 * (float)n9;
                ++n6;
            }
            float f11 = f4 * f6 - f5 * f5;
            if (f11 == 0.0f || (f3 = (f6 * f7 - f5 * f8) / f11) <= 0.0f) continue;
            if ((f3 = (float)Math.log(f3)) > f) {
                f = f3;
            }
            if (f3 < f2) {
                f2 = f3;
            }
            fArray[n3] = f3;
            nArray[n3] = this.nlXGArray[i];
            ++n3;
        }
        if (n3 <= 1 || f <= f2) {
            return;
        }
        float f12 = (float)(this.nYGBottom - this.nYGTop) / (f - f2) * 0.7f;
        int n10 = this.nYGBottom;
        int[] nArray2 = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray2[n] = n10 - Math.max((int)(f12 * (fArray[n] - f2)), 0);
        }
        graphics2D.setColor(cSpeed);
        graphics2D.drawPolyline(nArray, nArray2, n3);
        n = 0;
        while (n < n3) {
            int n11 = n++;
            nArray[n11] = nArray[n11] + 1;
        }
        graphics2D.drawPolyline(nArray, nArray2, n3);
        n = 0;
        while (n < n3) {
            int n12 = n;
            nArray[n12] = nArray[n12] - 1;
            int n13 = n++;
            nArray2[n13] = nArray2[n13] - 1;
        }
        graphics2D.drawPolyline(nArray, nArray2, n3);
    }

    static {
        bsCapStar = new BasicStroke(2.0f, 1, 1);
        bsMarker = new BasicStroke(2.0f);
        cMarker = new Color(0x90EE90);
        TimeZone timeZone = V2CBBS.tzWritePreview;
        dfTRes1.setTimeZone(timeZone);
        dfTRes1s.setTimeZone(timeZone);
        dfTRes1sw.setTimeZone(timeZone);
        dfTRes1p.setTimeZone(timeZone);
        dfTRes2.setTimeZone(timeZone);
        dfTRes3.setTimeZone(timeZone);
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        if (v2CProperty.containsKey(sGraphNewMarkColorKey0)) {
            v2CProperty.remove(sGraphNewMarkColorKey0);
        }
        if (v2CProperty.containsKey(sGraphCursorColorKey0)) {
            v2CProperty.remove(sGraphCursorColorKey0);
        }
        nRefResMarkers = v2CProperty.getInt(sNumRefResMarkersKey, 10);
        nRefResNumbers = v2CProperty.getInt(sNumRefResNumbersKey);
        bHighRenderingQuality = v2CProperty.getBoolean(sHighRenderingQualityKey);
        String string = v2CProperty.get(sDrawCapMarkersKey);
        if (string != null) {
            bDrawCapMarkers = true;
            bDrawCapNames = string.equals("F");
        }
        bDrawThreadInfo = v2CProperty.getBoolean(sDrawThreadInfoKey);
        bDrawSpeed = v2CProperty.getBoolean(sDrawSpeedKey);
        V2CPackedPropValue v2CPackedPropValue = v2CProperty.getPackedValue(sCondKey);
        if (v2CPackedPropValue != null) {
            cBGOut = v2CPackedPropValue.getColor('B');
            cCursor = v2CPackedPropValue.getColor('C');
            cFrame = v2CPackedPropValue.getColor('F');
            cGrid = v2CPackedPropValue.getColor('G');
            cBGIn = v2CPackedPropValue.getColor('I');
            cLine = v2CPackedPropValue.getColor('L');
            cNewMark = v2CPackedPropValue.getColor('N');
            cReference = v2CPackedPropValue.getColor('R');
            cSpeed = v2CPackedPropValue.getColor('S');
            cCursorLetter = v2CPackedPropValue.getColor('T');
            bDrawResLabel = v2CPackedPropValue.getBoolean('L');
        }
        if (cBGOut == null) {
            cBGOut = Color.WHITE;
        }
        if (cCursor == null) {
            cCursor = new Color(0x2222AA);
        }
        if (cFrame == null) {
            cFrame = Color.BLACK;
        }
        if (cGrid == null) {
            cGrid = Color.GRAY;
        }
        if (cBGIn == null) {
            cBGIn = new Color(0.97f, 0.97f, 0.97f);
        }
        if (cLine == null) {
            cLine = Color.RED;
        }
        if (cNewMark == null) {
            cNewMark = new Color(0x66DD00);
        }
        if (cReference == null) {
            cReference = Color.GRAY;
        }
        if (cCursorLetter == null) {
            cCursorLetter = Color.BLUE;
        }
        if (cSpeed == null) {
            cSpeed = new Color(192, 192, 255);
        }
        gpStar = V2CThreadGraph.createStar(8);
        V2CMain.threadGraphLoaded();
        slOmitHTMLTags = new String[]{"b>", "/b>", "font ", "/font>"};
    }

    private class GraphSaver
    extends Thread {
        File fSaveFile;
        int nWidth;
        int nHeight;
        V2CProgressPanel vProgressPanel;
        BufferedImage biImage;

        GraphSaver(File file, int n, int n2, V2CProgressPanel v2CProgressPanel) {
            this.fSaveFile = file;
            this.nWidth = n;
            this.nHeight = n2;
            this.vProgressPanel = v2CProgressPanel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = false;
            try {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            GraphSaver.this.biImage = (BufferedImage)((GraphSaver)GraphSaver.this).V2CThreadGraph.this.vThreadPanel.createImage(GraphSaver.this.nWidth, GraphSaver.this.nHeight);
                            Graphics2D graphics2D = GraphSaver.this.biImage.createGraphics();
                            boolean bl = bHighRenderingQuality;
                            bHighRenderingQuality = true;
                            try {
                                V2CThreadGraph.this.drawGraph(graphics2D, new Rectangle(GraphSaver.this.nWidth, GraphSaver.this.nHeight), true);
                                Object var4_3 = null;
                            }
                            catch (Throwable throwable) {
                                Object var4_4 = null;
                                bHighRenderingQuality = bl;
                                graphics2D.dispose();
                                throw throwable;
                            }
                            bHighRenderingQuality = bl;
                            graphics2D.dispose();
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                    Object var4_5 = null;
                    this.vProgressPanel.hidePanel();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    Object var4_6 = null;
                    this.vProgressPanel.hidePanel();
                    return;
                }
                this.vProgressPanel.setMessage("\u4fdd\u5b58\u4e2d\u2026");
                try {
                    bl = ImageIO.write((RenderedImage)this.biImage, "png", this.fSaveFile);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                Object var4_7 = null;
                this.vProgressPanel.hidePanel();
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                this.vProgressPanel.hidePanel();
                throw throwable;
            }
            if (!bl && !Thread.currentThread().isInterrupted()) {
                V2CSwingUtil.showMessageLater("\u30b0\u30e9\u30d5\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", "error", 0);
            }
        }
    }
}

