/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMemoryGauge;
import org.monazilla.v2c.V2CMessageField;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CStatusBarComponent
extends JPanel {
    static final String sForegroundKey = "StatusBar.Foreground";
    static final int nExtraHInset = 2;
    static int nHeight;
    static int nYDrawString;
    static Color cForeground;
    static boolean bForceRecalc;
    static int nFadeFactor;
    static final Color cMacBG;
    static final boolean bMacSpecial;

    static void checkFadeFactor(Graphics2D graphics2D) {
        int n = nFadeFactor;
        if (n >= 0 && n < 10) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)n / 10.0f));
        }
    }

    static void setForceRecalcHeight() {
        bForceRecalc = true;
    }

    static void updateColor(Color color) {
        if (color.equals(cForeground)) {
            return;
        }
        cForeground = color;
        V2CMain.getUserProperty().putColor(sForegroundKey, color);
        V2CMessageField.update();
        V2CMemoryGauge.update();
    }

    static void drawString(Graphics graphics, String string, int n) {
        if (bMacSpecial && V2CApp.isMacintosh(5)) {
            graphics.setColor(V2CSwingUtil.cMacTextShadow);
            graphics.drawString(string, n, nYDrawString + 1);
        }
        graphics.setColor(cForeground);
        graphics.drawString(string, n, nYDrawString);
    }

    public V2CStatusBarComponent(LayoutManager layoutManager, Border border) {
        super(layoutManager);
        if (bMacSpecial) {
            this.setOpaque(false);
        }
        if (border == null) {
            if (bMacSpecial) {
                Border border2 = BorderFactory.createEmptyBorder(0, 1, 0, 1);
                Border border3 = BorderFactory.createLineBorder(cMacBG, 2);
                border = BorderFactory.createCompoundBorder(border2, border3);
            } else {
                border = BorderFactory.createBevelBorder(1);
            }
        }
        this.setBorder(border);
        if (nHeight == 0) {
            this.recalcHeight();
        }
    }

    void recalcHeight() {
        int n;
        int n2;
        Insets insets = this.getInsets();
        Font font = UIManager.getFont("Panel.font");
        if (font != null) {
            LineMetrics lineMetrics = font.getLineMetrics("Ag", new FontRenderContext(null, false, false));
            n2 = (int)lineMetrics.getAscent();
            n = (int)lineMetrics.getDescent();
        } else {
            n2 = 15;
            n = 3;
        }
        n = Math.min(n2 / 4, n);
        nHeight = n2 + n + insets.top + insets.bottom + (n2 + n >= 15 ? 1 : 2);
        nYDrawString = insets.top + n2 + 1;
    }

    public void updateUI() {
        super.updateUI();
        if (bForceRecalc) {
            bForceRecalc = false;
            if (nHeight > 0) {
                this.recalcHeight();
            }
        }
    }

    static {
        cMacBG = new Color(0, true);
        bMacSpecial = V2CApp.isMacintosh(5) || V2CApp.isBrushMetalLook();
        Color color = UIManager.getColor("Panel.foreground");
        if (color == null) {
            color = Color.BLACK;
        }
        cForeground = V2CMain.getUserProperty().getColor(sForegroundKey, color);
    }
}

