/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CSplitPane
extends JSplitPane {
    int nDividerLocationRequest;

    public V2CSplitPane() {
        this.setFocusable(false);
        this.disableRightDrag();
    }

    public V2CSplitPane(int n) {
        super(n);
        this.setFocusable(false);
        this.disableRightDrag();
    }

    private void disableRightDrag() {
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            final Component component = this.getComponent(i);
            if (!(component instanceof BasicSplitPaneDivider)) continue;
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

                public void mousePressed(final MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 1 && V2CSwingUtil.isSimpleClick(mouseEvent, 3)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                component.dispatchEvent(new MouseEvent(component, 502, mouseEvent.getWhen(), 256, mouseEvent.getX(), mouseEvent.getY(), 1, false, mouseEvent.getButton()));
                            }
                        });
                    }
                }
            };
            component.addMouseListener(mouseInputAdapter);
        }
    }

    boolean requestDividerLocation(int n) {
        boolean bl;
        int n2;
        this.nDividerLocationRequest = n;
        int n3 = n2 = this.getOrientation() == 1 ? this.getWidth() : this.getHeight();
        if (this.getResizeWeight() < 0.5) {
            bl = true;
        } else {
            n = n2 - this.getDividerSize() - n;
            boolean bl2 = bl = n > 0;
        }
        if (bl) {
            this.setDividerLocation(n);
        } else {
            this.invalidate();
        }
        return bl;
    }

    public void doLayout() {
        int n;
        int n2;
        super.doLayout();
        final int n3 = this.nDividerLocationRequest;
        if (n3 <= 0) {
            return;
        }
        int n4 = this.getDividerLocation();
        int n5 = n2 = this.getOrientation() == 1 ? this.getWidth() : this.getHeight();
        if (this.getResizeWeight() < 0.5) {
            n = n3;
            if (n3 >= n2) {
                return;
            }
        } else {
            n = n2 - this.getDividerSize() - n3;
            if (n <= 0) {
                return;
            }
        }
        if (n4 != n) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    int n = V2CSplitPane.this.getResizeWeight() < 0.5 ? n3 : (V2CSplitPane.this.getOrientation() == 1 ? V2CSplitPane.this.getWidth() : V2CSplitPane.this.getHeight()) - V2CSplitPane.this.getDividerSize() - n3;
                    V2CSplitPane.this.setDividerLocation(n);
                }
            });
        } else {
            this.nDividerLocationRequest = -1;
        }
    }
}

