/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.monazilla.v2c.V2CAbstractThreadPanel;
import org.monazilla.v2c.V2CBoardItem;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CNewThreadItem;
import org.monazilla.v2c.V2CPanel;
import org.monazilla.v2c.V2CParseLinkResult;
import org.monazilla.v2c.V2CResCheckScript;
import org.monazilla.v2c.V2CResLabel;
import org.monazilla.v2c.V2CRuntimePermission;
import org.monazilla.v2c.V2CScriptApp;
import org.monazilla.v2c.V2CScriptBBS;
import org.monazilla.v2c.V2CScriptBoard;
import org.monazilla.v2c.V2CScriptRes;
import org.monazilla.v2c.V2CScriptResCheckContext;
import org.monazilla.v2c.V2CScriptResLabel;
import org.monazilla.v2c.V2CScriptWritePanel;
import org.monazilla.v2c.V2CSingleTabbedPane;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadList;
import org.monazilla.v2c.V2CThreadOpenRequest;
import org.monazilla.v2c.V2CThreadPanel;
import org.monazilla.v2c.V2CThreadRes;
import org.monazilla.v2c.V2CThreadStyle;
import org.monazilla.v2c.V2CThreadViewPane;

public final class V2CScriptThread {
    private V2CResCheckScript vResCheckScript;
    private final V2CThreadItem vThreadItem;
    private V2CThreadRes vThreadRes;
    private final boolean bNewThread;
    private int nCheckType;
    private V2CScriptResCheckContext vScriptResCheckContext;
    private volatile boolean bSleeping;
    private static final int ACTION_CLOSE = 1;
    private static final int ACTION_LOCK = 2;
    private static final int ACTION_UNLOCK = 3;
    private static final int ACTION_SETNEWMARK = 4;
    private static final int ACTION_RESETNEWMARK = 5;
    private static final int ACTION_SAVEVIEWPOS = 6;
    private static final int ACTION_GETVIEWPOS = 7;
    private static final int ACTION_SETVIEWPOS = 8;
    private static final int ACTION_COLUMNINDEX = 9;
    private static final int ACTION_MOVE = 10;
    private static final int ACTION_GETAUTORESLABEL = 11;
    private static final int ACTION_RESTORELABELS = 12;

    static V2CScriptThread createCheckScriptThread(V2CThreadItem v2cthreaditem, V2CThreadRes v2cthreadres) {
        V2CResCheckScript v2crescheckscript = V2CResCheckScript.getInstance();
        if (v2crescheckscript == null || !v2crescheckscript.checkFunctionDefined()) {
            return null;
        }
        V2CScriptThread v2cscriptthread = V2CScriptThread.createScriptThread(v2cthreaditem, v2cthreadres);
        try {
            v2crescheckscript.beginCheckThread(v2cscriptthread);
        }
        catch (InterruptedException interruptedexception) {
            interruptedexception.printStackTrace();
        }
        V2CScriptResCheckContext v2cscriptrescheckcontext = v2cscriptthread.vScriptResCheckContext;
        if (!v2cscriptrescheckcontext.shouldCheckAny()) {
            try {
                v2crescheckscript.endCheckThread(v2cscriptthread);
            }
            catch (InterruptedException interruptedexception1) {
                interruptedexception1.printStackTrace();
            }
            return null;
        }
        v2cscriptthread.vResCheckScript = v2crescheckscript;
        return v2cscriptthread;
    }

    static V2CScriptThread createScriptThread(V2CAbstractThreadPanel v2cabstractthreadpanel) {
        return v2cabstractthreadpanel == null ? null : new V2CScriptThread(v2cabstractthreadpanel.getThreadItem(), v2cabstractthreadpanel.getThreadRes());
    }

    static V2CScriptThread createInstance(V2CThreadItem v2cthreaditem) {
        return v2cthreaditem == null ? null : new V2CScriptThread(v2cthreaditem, null);
    }

    static V2CScriptThread createScriptThread(V2CThreadItem v2cthreaditem, V2CThreadRes v2cthreadres) {
        return v2cthreaditem == null || v2cthreadres == null ? null : new V2CScriptThread(v2cthreaditem, v2cthreadres);
    }

    static V2CScriptThread createScriptThread(final String su, final String st, final int nr) {
        return (V2CScriptThread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                V2CThreadPanel v2cthreadpanel;
                V2CThreadItem v2cthreaditem;
                V2CParseLinkResult v2cparselinkresult = new V2CParseLinkResult(su);
                if (!v2cparselinkresult.parse(false) || (v2cthreaditem = v2cparselinkresult.getThreadItem()) == null) {
                    return null;
                }
                if (st != null && st.length() > 0 && v2cthreaditem.getTitle() == null) {
                    v2cthreaditem.setTitle(st);
                }
                if (nr > 0 && nr > v2cthreaditem.getNRes()) {
                    v2cthreaditem.setNRes(nr);
                }
                V2CThreadRes v2cthreadres = (v2cthreadpanel = V2CThreadPanel.loadThreadIfNotLoaded(v2cthreaditem)) == null ? null : v2cthreadpanel.getThreadRes();
                return new V2CScriptThread(v2cthreaditem, v2cthreadres);
            }
        });
    }

    static V2CScriptThread createScriptThread(final V2CBoardItem bi, final String sk, final String sb, final String st, final int nr) {
        if (bi == null || sk == null) {
            return null;
        }
        return (V2CScriptThread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                V2CThreadPanel v2cthreadpanel;
                Object obj = bi.checkSubjectTxtLoaded();
                V2CThreadItem v2cthreaditem = bi.getThreadItemK(sk);
                if (v2cthreaditem == null && sb != null) {
                    v2cthreaditem = V2CThreadItem.createThreadItemOfName(sk, bi, sb);
                }
                bi.releaseSubjectHoldKey(obj);
                if (v2cthreaditem == null) {
                    return null;
                }
                if (st != null && st.length() > 0 && v2cthreaditem.getTitle() == null) {
                    v2cthreaditem.setTitle(st);
                }
                if (nr > 0 && nr > v2cthreaditem.getNRes()) {
                    v2cthreaditem.setNRes(nr);
                }
                V2CThreadRes v2cthreadres = (v2cthreadpanel = V2CThreadPanel.loadThreadIfNotLoaded(v2cthreaditem)) == null ? null : v2cthreadpanel.getThreadRes();
                return new V2CScriptThread(v2cthreaditem, v2cthreadres);
            }
        });
    }

    V2CScriptThread(V2CThreadItem v2cthreaditem, V2CThreadRes v2cthreadres) {
        this.vThreadItem = v2cthreaditem;
        this.vThreadRes = v2cthreadres;
        this.bNewThread = v2cthreaditem instanceof V2CNewThreadItem;
    }

    V2CResCheckScript getResCheckScript() {
        return this.vResCheckScript;
    }

    void beginCheck(boolean flag, boolean flag1, boolean flag2) {
        this.nCheckType = 1;
        this.vScriptResCheckContext = new V2CScriptResCheckContext(flag, flag1, flag2);
    }

    void endCheck() {
        this.nCheckType = 6;
    }

    public int _getCheckType() {
        return this.nCheckType;
    }

    public V2CScriptResCheckContext _getResCheckContext() {
        return this.vScriptResCheckContext;
    }

    void releaseRCCAndSS() {
        this.vScriptResCheckContext = null;
        this.vResCheckScript = null;
    }

    boolean isChecking() {
        return this.vResCheckScript != null;
    }

    V2CThreadItem getThreadItem() {
        return this.vThreadItem;
    }

    V2CThreadRes getThreadRes() {
        return this.vThreadRes;
    }

    public V2CScriptBBS getBbs() {
        return new V2CScriptBBS(this.vThreadItem.getBBS());
    }

    boolean isNewThread() {
        return this.bNewThread;
    }

    public boolean isLocal() {
        return this.vThreadItem.isLocalThread();
    }

    public String getTitle() {
        return this.vThreadItem.getTitle();
    }

    public String getTabTitle() {
        return this.vThreadItem.getTabTitle();
    }

    public void setTabTitle(String s) {
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("\u30bf\u30d6\u30bf\u30a4\u30c8\u30eb\u306b\u7a7a\u306e\u6587\u5b57\u5217\u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        V2CThreadViewPane tvp = V2CMain.getDisplayPane();
        int i = 0;
        while (i < tvp.getPanelCount()) {
            int ci;
            V2CThreadItem ti;
            V2CPanel p = tvp.getPanelAt(i);
            if (p instanceof V2CThreadPanel && (ti = ((V2CThreadPanel)p).getThreadItem()) == this.vThreadItem && (ci = tvp.getColumnIndexOfPanel(p)) != -1) {
                ti.setTabTitle(s);
                V2CSingleTabbedPane stp = tvp.getSinglePaneAt(ci);
                stp.titleChanged(p);
                break;
            }
            ++i;
        }
    }

    private V2CThreadRes getAttachedThreadRes() {
        V2CThreadRes v2cthreadres = this.vThreadRes;
        if (v2cthreadres != null) {
            return v2cthreadres;
        }
        V2CThreadPanel v2cthreadpanel = this.getAttachedPanel();
        return v2cthreadpanel == null ? null : v2cthreadpanel.getThreadRes();
    }

    private V2CThreadRes loadThreadRes() {
        V2CThreadRes v2cthreadres = this.vThreadRes;
        if (v2cthreadres == null && !this.bNewThread) {
            this.vThreadRes = v2cthreadres = (V2CThreadRes)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    V2CThreadPanel v2cthreadpanel = V2CThreadPanel.loadThreadIfNotLoaded(V2CScriptThread.this.vThreadItem);
                    return v2cthreadpanel == null ? null : v2cthreadpanel.getThreadRes();
                }
            });
        }
        return v2cthreadres;
    }

    public V2CScriptRes getRes(int i) {
        V2CThreadRes v2cthreadres = this.loadThreadRes();
        return v2cthreadres == null ? null : V2CScriptRes.createScriptRes(v2cthreadres.getResItem(i), this);
    }

    public V2CScriptBoard getBoard() {
        return new V2CScriptBoard(this.vThreadItem.getBoardItem());
    }

    public URL getUrl() {
        return this.getURL();
    }

    public URL getURL() {
        try {
            return new URL(this.vThreadItem.getFormalURLString());
        }
        catch (MalformedURLException malformedurlexception) {
            return null;
        }
    }

    public String getKey() {
        return this.bNewThread ? null : this.vThreadItem.getThreadKey();
    }

    public File getLocalFile() {
        return this.bNewThread ? null : this.vThreadItem.getLocalFile();
    }

    public File getStyleDir() {
        return V2CThreadStyle.getStyleFolder(this.vThreadItem);
    }

    public File getStyleFile() {
        return V2CThreadStyle.getStyleFile(this.vThreadItem);
    }

    public int getResCount() {
        return this.bNewThread ? 1 : this.vThreadItem.getNRes();
    }

    public int getLocalResCount() {
        return this.bNewThread ? 0 : this.vThreadItem.getNResGet();
    }

    public int getNewResCount() {
        if (this.bNewThread) {
            return 0;
        }
        V2CThreadRes v2cthreadres = this.loadThreadRes();
        return v2cthreadres == null ? 0 : v2cthreadres.getNumNewRes();
    }

    public int getNewMarkResCount() {
        int i = this.getLocalResCount();
        if (i <= 0) {
            return 0;
        }
        return Math.max(i - this.getNewMarkResIndex(), 0);
    }

    public int getNewMarkResIndex() {
        if (this.bNewThread) {
            return 0;
        }
        V2CThreadRes v2cthreadres = this.getAttachedThreadRes();
        if (v2cthreadres != null) {
            return v2cthreadres.getNewMarkPos();
        }
        int i = this.vThreadItem.getNewThreshold();
        return i < 0 ? this.getLocalResCount() : i;
    }

    public void setNewMarkResIndex(int i) {
        if (this.bNewThread) {
            System.out.println("bNewThread");
            return;
        }
        if (this.doPanelAction(4, i, 0) == null) {
            V2CThreadItem v2cthreaditem = this.vThreadItem;
            v2cthreaditem.setNewThreshold(i);
            v2cthreaditem.updateLocalThreadStatusLater();
            v2cthreaditem.threadStatusChanged();
        }
    }

    public int getViewResIndex() {
        if (this.bNewThread) {
            return 0;
        }
        this.doPanelAction(6);
        int[] ai = (int[])AccessController.doPrivileged(new PEDTAction(7, null, 0, 0));
        if (ai == null) {
            return 0;
        }
        int i = ai[0];
        if (i > 0 && ai[1] > 0) {
            --i;
        }
        return i;
    }

    public void setViewResIndex(int i) {
        if (this.bNewThread) {
            System.out.println("bNewThread");
            return;
        }
        V2CThreadPanel v2cthreadpanel = this.getAttachedPanel();
        if (v2cthreadpanel != null) {
            v2cthreadpanel.goToResNumberLater(i, 0);
        } else {
            AccessController.doPrivileged(new PEDTAction(8, null, i, 0));
        }
    }

    public V2CScriptResLabel getPostResLabel() {
        V2CResLabel v2creslabel = (V2CResLabel)AccessController.doPrivileged(new PEDTAction(11, null, 0, 0));
        return v2creslabel == null ? null : V2CScriptResLabel.get(v2creslabel);
    }

    public int[] getPostResIndex() {
        V2CResLabel[] av2creslabel;
        ArrayList<Integer> arraylist = new ArrayList<Integer>();
        V2CResLabel v2creslabel = (V2CResLabel)AccessController.doPrivileged(new PEDTAction(11, null, 0, 0));
        if (v2creslabel != null && (av2creslabel = (V2CResLabel[])AccessController.doPrivileged(new PEDTAction(12, null, 0, 0))) != null) {
            int j = av2creslabel.length;
            int k = 0;
            while (k < j) {
                if (av2creslabel[k] == v2creslabel) {
                    arraylist.add(new Integer(k));
                }
                ++k;
            }
        }
        int i = arraylist.size();
        int[] ai = new int[i];
        int l = i - 1;
        while (l >= 0) {
            ai[l] = (Integer)arraylist.get(l);
            --l;
        }
        return ai;
    }

    public boolean setPostResIndex(int i) {
        if (this.bNewThread) {
            return false;
        }
        V2CScriptResLabel v2cscriptreslabel = this.getPostResLabel();
        if (v2cscriptreslabel == null) {
            return false;
        }
        V2CThreadRes v2cthreadres = this.getAttachedThreadRes();
        if (v2cthreadres != null) {
            V2CScriptRes v2cscriptres = this.getRes(i);
            if (v2cscriptres == null) {
                return false;
            }
            v2cscriptres.setResLabel(v2cscriptreslabel);
        } else {
            V2CResLabel.setResLabel(i, v2cscriptreslabel.getResLabel(), null, this.vThreadItem, true);
        }
        return true;
    }

    public float getSpeed() {
        return this.bNewThread ? 0.0f : this.vThreadItem.getSpeed() * 86400.0f;
    }

    public boolean getLive() {
        return !this.bNewThread && !this.vThreadItem.isTwitter() ? this.vThreadItem.isActiveScr() : true;
    }

    public boolean getUnread() {
        return this.bNewThread ? false : this.vThreadItem.getUnread();
    }

    public void resetUnread() {
        if (this.bNewThread) {
            return;
        }
        this.vThreadItem.resetNewThreshold();
        this.vThreadItem.updateLocalThreadStatusLater();
    }

    public void clearNewMark() {
        if (this.bNewThread) {
            return;
        }
        if (this.doPanelAction(5) == null) {
            this.resetUnread();
        }
    }

    public void open() {
        this.open(true, true, false, null);
    }

    public void open(boolean flag) {
        this.open(flag, true, false, null);
    }

    public void open(boolean flag, boolean flag1) {
        this.open(flag, flag1, false, null);
    }

    public void open(boolean flag, boolean flag1, boolean flag2) {
        this.open(flag, flag1, flag2, null);
    }

    public void open(boolean flag, boolean flag1, boolean flag2, V2CThreadOpenRequest v2cthreadopenrequest) {
        if (this.bNewThread) {
            return;
        }
        V2CScriptApp.open(this.vThreadItem, flag, flag1, flag2, v2cthreadopenrequest);
    }

    public boolean update() {
        return this.update(false);
    }

    public boolean updateAndWait() {
        return this.update(true);
    }

    private boolean update(boolean flag) {
        if (this.bNewThread || !V2CThreadList.checkRoundCount()) {
            return false;
        }
        V2CThreadItem v2cthreaditem = this.vThreadItem;
        if (!flag) {
            return V2CScriptApp.open(v2cthreaditem, true, true, false, -1);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            return false;
        }
        Long long1 = V2CScriptApp.getLastThreadUpdateTime(v2cthreaditem);
        V2CThreadOpenRequest v2cthreadopenrequest = this.doUpdateAndWait();
        if (v2cthreadopenrequest == null) {
            return false;
        }
        if (v2cthreadopenrequest.getSetUpdSucc()) {
            return true;
        }
        V2CScriptApp.setLastThreadUpdateTime(v2cthreaditem, long1);
        V2CThreadPanel v2cthreadpanel = V2CThreadPanel.getAttachedPanel(this.vThreadItem);
        if (v2cthreadpanel == null) {
            return true;
        }
        Object obj = v2cthreadpanel.getUpdLockObj();
        if (v2cthreadopenrequest.getWasUpdating()) {
            V2CScriptThread.waitUpdateFinish(v2cthreadpanel, obj);
            return true;
        }
        int i = 0;
        while (i < 2) {
            if (!V2CScriptThread.waitUpdateFinish(v2cthreadpanel, obj)) {
                return true;
            }
            Long long2 = V2CScriptApp.getLastThreadUpdateTime(v2cthreaditem);
            V2CThreadOpenRequest v2cthreadopenrequest1 = this.doUpdateAndWait();
            if (v2cthreadopenrequest1 == null) {
                return false;
            }
            if (v2cthreadopenrequest1.getSetUpdSucc()) {
                return true;
            }
            V2CScriptApp.setLastThreadUpdateTime(v2cthreaditem, long2);
            if (v2cthreadopenrequest1.getWasUpdating()) {
                V2CScriptThread.waitUpdateFinish(v2cthreadpanel, obj);
                return true;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean waitUpdateFinish(V2CThreadPanel v2cthreadpanel, Object obj) {
        Object object = obj;
        synchronized (object) {
            while (v2cthreadpanel.isUpdating()) {
                try {
                    obj.wait();
                }
                catch (InterruptedException interruptedexception) {
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V2CThreadOpenRequest doUpdateAndWait() {
        V2CThreadOpenRequest v2cthreadopenrequest = new V2CThreadOpenRequest();
        v2cthreadopenrequest.setWaitObject(v2cthreadopenrequest);
        v2cthreadopenrequest.setOpenLater(true);
        V2CThreadOpenRequest v2CThreadOpenRequest = v2cthreadopenrequest;
        synchronized (v2CThreadOpenRequest) {
            block6: {
                if (V2CScriptApp.open(this.vThreadItem, true, true, false, v2cthreadopenrequest)) break block6;
                return null;
            }
            try {
                v2cthreadopenrequest.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return v2cthreadopenrequest;
    }

    public V2CScriptWritePanel openWritePanel() {
        V2CThreadRes v2cthreadres = this.loadThreadRes();
        if (v2cthreadres == null) {
            return null;
        }
        return V2CScriptWritePanel.createScriptWritePanel(v2cthreadres.vtpThreadPanel, true);
    }

    public V2CScriptWritePanel mayOpenWritePanel() {
        V2CThreadRes v2cthreadres = this.loadThreadRes();
        if (v2cthreadres == null) {
            return null;
        }
        return V2CScriptWritePanel.createScriptWritePanel(v2cthreadres.vtpThreadPanel, false);
    }

    V2CThreadPanel getOpenPanel() {
        return V2CThreadPanel.getOpenPanel(this.vThreadItem);
    }

    private V2CThreadPanel getAttachedPanel() {
        return V2CThreadPanel.getAttachedPanel(this.vThreadItem);
    }

    private Object doPanelAction(int i) {
        return this.doPanelAction(i, 0, 0);
    }

    private Object doPanelAction(int i, int j, int k) {
        V2CThreadPanel v2cthreadpanel = this.getAttachedPanel();
        if (v2cthreadpanel != null) {
            return V2CScriptApp.performPrivilegedEDTAction(new PEDTAction(i, v2cthreadpanel, j, k));
        }
        return null;
    }

    public int getColumnIndex() {
        Object obj = this.doPanelAction(9);
        return obj instanceof Integer ? (Integer)obj : -1;
    }

    public void movePanelTo(int i, int j) {
        this.doPanelAction(10, i, j);
    }

    public void close() {
        this.doPanelAction(1);
    }

    public boolean getLock() {
        V2CThreadPanel v2cthreadpanel = this.getAttachedPanel();
        return v2cthreadpanel == null ? false : v2cthreadpanel.isLocked();
    }

    public void setLock(boolean flag) {
        this.doPanelAction(flag ? 2 : 3);
    }

    public boolean importDatFile(String s) {
        return this.importDatFile(s, null, true);
    }

    public boolean importDatFile(String s, String s1) {
        return this.importDatFile(s, s1, true);
    }

    public boolean importDatFile(String s, String s1, boolean flag) {
        if (this.bNewThread) {
            return false;
        }
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("\u30a4\u30f3\u30dd\u30fc\u30c8\u3059\u308bdat\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u7a7a\u3067\u3059\u3002");
        }
        return this.importDat(new File(s), null, s1, flag);
    }

    public boolean importDatBytes(byte[] abyte0) {
        return this.importDat(null, abyte0, null, true);
    }

    public boolean importDatBytes(byte[] abyte0, String s) {
        return this.importDat(null, abyte0, s, true);
    }

    public boolean importDatBytes(byte[] abyte0, String s, boolean flag) {
        return this.importDat(null, abyte0, s, flag);
    }

    private boolean importDat(final File fd0, final byte[] bl, final String st, final boolean bo) {
        Boolean boolean1;
        if (this.bNewThread) {
            return false;
        }
        if (fd0 == null && (bl == null || bl.length == 0)) {
            throw new IllegalArgumentException("\u30a4\u30f3\u30dd\u30fc\u30c8\u3059\u308bdat\u304c\u7a7a\u3067\u3059\u3002");
        }
        SecurityManager securitymanager = System.getSecurityManager();
        if (securitymanager != null) {
            String s = V2CLocalFileHandler.getV2CDir().getPath();
            securitymanager.checkWrite(s);
        }
        return (boolean1 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                V2CThreadPanel v2cthreadpanel1;
                File file;
                boolean flag;
                boolean bl2 = flag = fd0 != null;
                if (flag) {
                    file = fd0;
                } else {
                    file = V2CLocalFileHandler.getTempFile();
                    V2CLocalFileHandler.saveToFile(file, bl);
                }
                V2CThreadItem v2cthreaditem = V2CScriptThread.this.vThreadItem;
                try {
                    String s1 = v2cthreaditem.getThreadKey();
                    V2CThreadItem.copyDatFile(v2cthreaditem, file, s1, s1, st, v2cthreaditem.getBoardItem(), null, bo);
                }
                finally {
                    if (!flag && file.exists()) {
                        file.delete();
                    }
                }
                boolean flag1 = v2cthreaditem.getNResGet() > 0;
                V2CThreadPanel v2cthreadpanel = V2CThreadPanel.getOpenPanel(v2cthreaditem);
                if (v2cthreadpanel != null) {
                    v2cthreadpanel.setTabText();
                }
                if (flag1 && bo && V2CScriptThread.this.vThreadRes == null && (v2cthreadpanel1 = V2CThreadPanel.loadThreadIfNotLoaded(v2cthreaditem)) != null) {
                    V2CScriptThread.this.vThreadRes = v2cthreadpanel1.getThreadRes();
                }
                return flag1;
            }
        })) == null ? false : boolean1;
    }

    public void importPropertyFrom(final V2CScriptThread st) {
        if (this.isNewThread() || st == null || st.isNewThread()) {
            return;
        }
        SecurityManager securitymanager = System.getSecurityManager();
        if (securitymanager != null) {
            securitymanager.checkPermission(new V2CRuntimePermission("changeProperty"));
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                V2CScriptThread.this.vThreadItem.importThreadPropertyFrom(st.vThreadItem);
                return null;
            }
        });
    }

    private class PEDTAction
    implements PrivilegedAction {
        final int iAction;
        final V2CThreadPanel vTargetPanel;
        int iResPaneComumn;
        int iTabIndex;

        public Object run() {
            V2CThreadViewPane v2cthreadviewpane = V2CMain.getDisplayPane();
            switch (this.iAction) {
                case 1: {
                    v2cthreadviewpane.removePanel(this.vTargetPanel);
                    break;
                }
                case 2: {
                    v2cthreadviewpane.setTabLock(this.vTargetPanel, true);
                    break;
                }
                case 3: {
                    v2cthreadviewpane.setTabLock(this.vTargetPanel, false);
                    break;
                }
                case 4: {
                    this.vTargetPanel.setNewThreshold(this.iResPaneComumn);
                    return Boolean.TRUE;
                }
                case 5: {
                    this.vTargetPanel.resetNewThreshold();
                    return Boolean.TRUE;
                }
                case 6: {
                    this.vTargetPanel.saveViewPosition();
                    return Boolean.TRUE;
                }
                case 7: {
                    return V2CScriptThread.this.vThreadItem.getViewPos();
                }
                case 8: {
                    V2CScriptThread.this.vThreadItem.setViewPos(this.iResPaneComumn, this.iTabIndex);
                    break;
                }
                case 9: {
                    return new Integer(V2CMain.getDisplayPane().getColumnIndexOfPanel(this.vTargetPanel));
                }
                case 10: {
                    V2CMain.getDisplayPane().movePanel(this.vTargetPanel, this.iResPaneComumn, this.iTabIndex);
                    break;
                }
                case 11: {
                    return V2CScriptThread.this.vThreadItem.getAutoPostResLabel();
                }
                case 12: {
                    return V2CResLabel.restoreLabels(V2CScriptThread.this.vThreadItem);
                }
            }
            return null;
        }

        PEDTAction(int i, V2CThreadPanel v2cthreadpanel, int j, int k) {
            this.iAction = i;
            this.vTargetPanel = v2cthreadpanel;
            this.iResPaneComumn = j;
            this.iTabIndex = k;
        }
    }
}

