/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class V2CSHA1Value {
    final MessageDigest mdSHA1;
    int iHV;
    long lMV;
    long lLV;
    private static final int[] ilHC2I = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};
    private static final int[] ilB32HC2I = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};

    static V2CSHA1Value createInstance() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        return new V2CSHA1Value(messageDigest);
    }

    public V2CSHA1Value() {
        this((MessageDigest)null);
    }

    public V2CSHA1Value(V2CSHA1Value v2CSHA1Value) {
        this(v2CSHA1Value.iHV, v2CSHA1Value.lMV, v2CSHA1Value.lLV);
    }

    public V2CSHA1Value(int n, long l, long l2) {
        this((MessageDigest)null);
        this.iHV = n;
        this.lMV = l;
        this.lLV = l2;
    }

    private V2CSHA1Value(MessageDigest messageDigest) {
        this.mdSHA1 = messageDigest;
    }

    void reset() {
        this.mdSHA1.reset();
    }

    void update(byte[] byArray, int n, int n2) {
        this.mdSHA1.update(byArray, n, n2);
    }

    void digest() {
        byte[] byArray = this.mdSHA1.digest();
        this.iHV = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        int n = (byArray[4] & 0xFF) << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        int n2 = (byArray[8] & 0xFF) << 24 | (byArray[9] & 0xFF) << 16 | (byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF;
        this.lMV = (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
        int n3 = (byArray[12] & 0xFF) << 24 | (byArray[13] & 0xFF) << 16 | (byArray[14] & 0xFF) << 8 | byArray[15] & 0xFF;
        int n4 = (byArray[16] & 0xFF) << 24 | (byArray[17] & 0xFF) << 16 | (byArray[18] & 0xFF) << 8 | byArray[19] & 0xFF;
        this.lLV = (long)n3 << 32 | (long)n4 & 0xFFFFFFFFL;
    }

    private static int hexCharToInt(char c) {
        return c >= '0' && c <= 'f' ? ilHC2I[c - 48] : -1;
    }

    private static int b32HCharToInt(char c) {
        return c >= '0' && c <= 'V' ? ilB32HC2I[c - 48] : -1;
    }

    boolean parseB32H(String string) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < 6; ++n3) {
            n2 = V2CSHA1Value.b32HCharToInt(string.charAt(n3));
            if (n2 < 0) {
                return false;
            }
            n4 = n4 << 5 | n2;
        }
        n2 = V2CSHA1Value.b32HCharToInt(string.charAt(6));
        if (n2 < 0) {
            return false;
        }
        this.iHV = n4 << 2 | n2 >>> 3;
        n4 = n2 & 7;
        for (n3 = 7; n3 < 12; ++n3) {
            n2 = V2CSHA1Value.b32HCharToInt(string.charAt(n3));
            if (n2 < 0) {
                return false;
            }
            n4 = n4 << 5 | n2;
        }
        n2 = V2CSHA1Value.b32HCharToInt(string.charAt(12));
        if (n2 < 0) {
            return false;
        }
        n3 = n4 << 4 | n2 >>> 1;
        n4 = n2 & 1;
        for (n = 13; n < 19; ++n) {
            n2 = V2CSHA1Value.b32HCharToInt(string.charAt(n));
            if (n2 < 0) {
                return false;
            }
            n4 = n4 << 5 | n2;
        }
        n2 = V2CSHA1Value.b32HCharToInt(string.charAt(19));
        if (n2 < 0) {
            return false;
        }
        this.lMV = (long)n3 << 32 | (long)n4 << 1 | (long)(n2 >>> 4);
        n4 = n2 & 0xF;
        for (n = 20; n < 25; ++n) {
            n2 = V2CSHA1Value.b32HCharToInt(string.charAt(n));
            if (n2 < 0) {
                return false;
            }
            n4 = n4 << 5 | n2;
        }
        n2 = V2CSHA1Value.b32HCharToInt(string.charAt(25));
        if (n2 < 0) {
            return false;
        }
        n = n4 << 3 | n2 >>> 2;
        n4 = n2 & 3;
        for (int i = 26; i < 32; ++i) {
            n2 = V2CSHA1Value.b32HCharToInt(string.charAt(i));
            if (n2 < 0) {
                return false;
            }
            n4 = n4 << 5 | n2;
        }
        this.lLV = (long)n << 32 | (long)n4 & 0xFFFFFFFFL;
        return true;
    }

    boolean parse(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (string == null || string.length() < 40) {
            return false;
        }
        int n6 = 0;
        for (n5 = 0; n5 < 8; ++n5) {
            n4 = V2CSHA1Value.hexCharToInt(string.charAt(n5));
            if (n4 < 0) {
                return false;
            }
            n6 = n6 << 4 | n4;
        }
        this.iHV = n6;
        n4 = 0;
        while (n5 < 16) {
            n3 = V2CSHA1Value.hexCharToInt(string.charAt(n5));
            if (n3 < 0) {
                return false;
            }
            n4 = n4 << 4 | n3;
            ++n5;
        }
        n3 = 0;
        while (n5 < 24) {
            n2 = V2CSHA1Value.hexCharToInt(string.charAt(n5));
            if (n2 < 0) {
                return false;
            }
            n3 = n3 << 4 | n2;
            ++n5;
        }
        this.lMV = (long)n4 << 32 | (long)n3 & 0xFFFFFFFFL;
        n2 = 0;
        while (n5 < 32) {
            n = V2CSHA1Value.hexCharToInt(string.charAt(n5));
            if (n < 0) {
                return false;
            }
            n2 = n2 << 4 | n;
            ++n5;
        }
        n = 0;
        while (n5 < 40) {
            int n7 = V2CSHA1Value.hexCharToInt(string.charAt(n5));
            if (n7 < 0) {
                return false;
            }
            n = n << 4 | n7;
            ++n5;
        }
        this.lLV = (long)n2 << 32 | (long)n & 0xFFFFFFFFL;
        return true;
    }

    int compareTo(Object object) {
        V2CSHA1Value v2CSHA1Value = (V2CSHA1Value)object;
        int n = this.iHV;
        int n2 = v2CSHA1Value.iHV;
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        long l = this.lMV;
        long l2 = v2CSHA1Value.lMV;
        if (l > l2) {
            return 1;
        }
        if (l < l2) {
            return -1;
        }
        long l3 = this.lLV;
        long l4 = v2CSHA1Value.lLV;
        if (l3 > l4) {
            return 1;
        }
        if (l3 < l4) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return (int)this.lMV;
    }

    public boolean equals(Object object) {
        if (!(object instanceof V2CSHA1Value)) {
            return false;
        }
        V2CSHA1Value v2CSHA1Value = (V2CSHA1Value)object;
        return this.iHV == v2CSHA1Value.iHV && this.lMV == v2CSHA1Value.lMV && this.lLV == v2CSHA1Value.lLV;
    }

    static String toString(int n, long l, long l2) {
        int n2;
        int n3;
        char[] cArray = new char[40];
        for (n3 = 0; n3 < 8; ++n3) {
            n2 = n & 0xF;
            cArray[7 - n3] = n2 < 10 ? (char)(n2 + 48) : (char)(n2 + 87);
            n >>>= 4;
        }
        for (n3 = 0; n3 < 16; ++n3) {
            n2 = (int)(l & 0xFL);
            cArray[23 - n3] = n2 < 10 ? (char)(n2 + 48) : (char)(n2 + 87);
            l >>>= 4;
        }
        for (n3 = 0; n3 < 16; ++n3) {
            n2 = (int)(l2 & 0xFL);
            cArray[39 - n3] = n2 < 10 ? (char)(n2 + 48) : (char)(n2 + 87);
            l2 >>>= 4;
        }
        return new String(cArray);
    }

    public String toString() {
        return V2CSHA1Value.toString(this.iHV, this.lMV, this.lLV);
    }

    static String toB32HString(int n, long l, long l2) {
        char[] cArray = new char[32];
        V2CSHA1Value.fillB32HChars(n, l, l2, cArray);
        return new String(cArray);
    }

    static void fillB32HChars(int n, long l, long l2, char[] cArray) {
        int n2 = V2CSHA1Value.appendB32HByte(cArray, (int)l2, 0, 0);
        n2 = V2CSHA1Value.appendB32HByte(cArray, (int)(l2 >>> 32), n2, 1);
        n2 = V2CSHA1Value.appendB32HByte(cArray, (int)l, n2, 2);
        n2 = V2CSHA1Value.appendB32HByte(cArray, (int)(l >>> 32), n2, 3);
        V2CSHA1Value.appendB32HByte(cArray, n, n2, 4);
    }

    static int appendB32HByte(char[] cArray, int n, int n2, int n3) {
        int n4 = 31 - (n3 *= 32) / 5;
        int n5 = n3 % 5;
        if (n5 > 0) {
            cArray[n4--] = V2CSHA1Value.toB32HChar(n << n5 | n2);
            n5 = 5 - n5;
            n >>>= n5;
            n5 = 32 - n5;
        } else {
            n5 = 32;
        }
        while (n5 >= 5) {
            cArray[n4--] = V2CSHA1Value.toB32HChar(n);
            n >>>= 5;
            n5 -= 5;
        }
        return n;
    }

    static char toB32HChar(int n) {
        if ((n &= 0x1F) < 10) {
            return (char)(48 + n);
        }
        return (char)(n + 55);
    }
}

