/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.monazilla.v2c.V2CGestureMap;
import org.monazilla.v2c.V2CListTable;
import org.monazilla.v2c.V2CListTableModel;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMemoryGauge;
import org.monazilla.v2c.V2CMouseClickManager;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CProgressBar;
import org.monazilla.v2c.V2CProgressState;
import org.monazilla.v2c.V2CResNote;
import org.monazilla.v2c.V2CResNoteItem;
import org.monazilla.v2c.V2CResNoteStyle;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadListHistory;
import org.monazilla.v2c.V2CThreadListPane;
import org.monazilla.v2c.V2CThreadOpenRequest;
import org.monazilla.v2c.V2CThreadStyle;

public class V2CResNoteList
extends V2CListTable {
    static final String[][] slColumnLabel = new String[][]{{"\u4f5c\u6210\u6642\u523b", "CTIME"}, {"\u7de8\u96c6\u6642\u523b", "MTIME"}, {"\u30b9\u30bf\u30a4\u30eb", "STYLE"}, {"\u30ad\u30fc\u30ef\u30fc\u30c9", "KEYWORD"}, {"\u30ec\u30b9\u756a\u53f7", "RESNUM"}, {"\u30bf\u30a4\u30c8\u30eb", "TITLE"}, {"\u677f", "BOARD"}};
    static final int CTIME = 0;
    static final int MTIME = 1;
    static final int STYLE = 2;
    static final int KEYWORD = 3;
    static final int RESNUM = 4;
    static final int TITLE = 5;
    static final int BOARD = 6;
    static final int RESNOTEITEM = 7;
    static final int THREADITEM = 8;
    static final int ARRAYSIZE = 9;
    static int[] nlColWidth = new int[slColumnLabel.length];
    static Reference refResNoteList;
    static Icon icDefault;
    static final Object oHistoryKey;
    ResNoteTableModel icTableModel = new ResNoteTableModel();
    volatile boolean bUpdating;

    static V2CResNoteList getResNoteList(boolean bl) {
        V2CResNoteList v2CResNoteList = refResNoteList != null ? (V2CResNoteList)refResNoteList.get() : null;
        if (v2CResNoteList == null && bl) {
            v2CResNoteList = new V2CResNoteList();
            refResNoteList = new SoftReference<V2CResNoteList>(v2CResNoteList);
        }
        return v2CResNoteList;
    }

    static void fontSizeChanged(Font font, int n) {
        V2CResNoteList v2CResNoteList = V2CResNoteList.getResNoteList(false);
        if (v2CResNoteList != null) {
            v2CResNoteList.setFont(font);
            v2CResNoteList.setRowHeight(n);
        }
    }

    static void setBGColor() {
        V2CResNoteList v2CResNoteList = V2CResNoteList.getResNoteList(false);
        if (v2CResNoteList == null) {
            return;
        }
        v2CResNoteList.setBackground(cOddBG);
    }

    static void listResNotes(boolean bl) {
        V2CResNoteList v2CResNoteList = V2CResNoteList.getResNoteList(true);
        v2CResNoteList.openResNoteList(bl);
    }

    public V2CResNoteList() {
        this.setModel(this.icTableModel);
        this.dTCRenderer = new ListRenderer();
        this.setColumnState();
        this.vGestureMap = V2CGestureMap.getGestureMap("Other");
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        TableHeaderListener tableHeaderListener = new TableHeaderListener();
        jTableHeader.addMouseListener(tableHeaderListener);
        jTableHeader.addMouseMotionListener(tableHeaderListener);
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
        this.addMouseMotionListener(popupListener);
        this.addMouseWheelListener(this);
    }

    public String getTitleString() {
        return "\u4ed8\u7b8b\u4e00\u89a7";
    }

    public Icon getIcon() {
        return icDefault;
    }

    public void detouch() {
        this.close();
    }

    public boolean close() {
        return true;
    }

    public V2CProgressState getProgressState() {
        return this.psProgState;
    }

    public Icon getDefaultIcon() {
        return icDefault;
    }

    Object getItem() {
        return oHistoryKey;
    }

    void setColumnWidths() {
        this.setColumnState(false);
    }

    void setColumnState() {
        this.setColumnState(true);
    }

    void setColumnState(boolean bl) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int n2 = nlColWidth[i];
            tableColumnModel.getColumn(i).setPreferredWidth(n2);
            if (!bl) continue;
            tableColumnModel.getColumn(i).setCellRenderer(this.dTCRenderer);
        }
    }

    synchronized boolean setUpdating(boolean bl) {
        if (bl && this.bUpdating) {
            return false;
        }
        this.bUpdating = bl;
        this.psProgState.setInProgress(this.bUpdating);
        if (this.bUpdating) {
            V2CProgressBar.setState(this, this.psProgState);
        }
        return this.bUpdating;
    }

    void openResNoteList(boolean bl) {
        V2CThreadListPane v2CThreadListPane = V2CMain.getTablePane();
        int n = v2CThreadListPane.indexOfPanel(this);
        if (n < 0) {
            if (bl || v2CThreadListPane.getPanelCount() == 0) {
                n = v2CThreadListPane.addPanel(this);
            } else {
                n = Math.max(v2CThreadListPane.getSelectedIndex(), 0);
                v2CThreadListPane.setPanelAt(n, this);
            }
        }
        v2CThreadListPane.setSelectedIndex(n);
        V2CThreadListHistory.moveToHistoryTop(oHistoryKey);
        V2CMain.showTablePane(false);
        this.openList(false);
    }

    void openList(final boolean bl) {
        if (!this.setUpdating(true)) {
            System.out.println("already updating !");
            return;
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                V2CResNoteList.this.psProgState.setThread();
                try {
                    V2CResNoteList.this.displayList(bl);
                    V2CSwingUtil.armRequestFocus(V2CResNoteList.this);
                    Object var2_1 = null;
                    V2CResNoteList.this.setUpdating(false);
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    V2CResNoteList.this.setUpdating(false);
                    throw throwable;
                }
                V2CMemoryGauge.update();
            }
        };
        thread.start();
    }

    boolean displayList(boolean bl) {
        final ArrayList arrayList = V2CResNote.createResNoteList();
        if (SwingUtilities.isEventDispatchThread()) {
            this.icTableModel.setNewList(arrayList);
            this.scrollToRow(0);
            this.indicateSortColumn(-1);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    V2CResNoteList.this.icTableModel.setNewList(arrayList);
                    V2CResNoteList.this.scrollToRow(0);
                    V2CResNoteList.this.indicateSortColumn(-1);
                }
            });
        }
        return true;
    }

    void performResNoteAction(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("Edit")) {
            this.editSelectedResNote();
        } else if (string.equals("Delete")) {
            this.deleteSelectedResNotes();
        }
    }

    int[] getActiveRowIndices() {
        int[] nArray = this.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (!this.icTableModel.getResNoteItem(n2).isValid()) continue;
            if (n < i) {
                nArray[n] = n2;
            }
            ++n;
        }
        if (n == 0) {
            return null;
        }
        if (n == nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    void editSelectedResNote() {
        int[] nArray = this.getActiveRowIndices();
        if (nArray != null) {
            if (nArray.length == 1) {
                V2CResNoteItem v2CResNoteItem;
                int n = nArray[0];
                V2CThreadItem v2CThreadItem = this.icTableModel.getThreadItem(n);
                if (V2CResNote.editResNote(v2CThreadItem, v2CResNoteItem = this.icTableModel.getResNoteItem(n))) {
                    this.icTableModel.resNoteItemUpdated(n);
                }
            } else {
                V2CSwingUtil.showErrorMessage("\u4e00\u5ea6\u306b\u8907\u6570\u306e\u4ed8\u7b8b\u3092\u5909\u66f4\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
            }
        }
    }

    void deleteSelectedResNotes() {
        int[] nArray = this.getActiveRowIndices();
        if (nArray != null && (nArray.length <= 1 || V2CSwingUtil.showOKCancelDialog(nArray.length + "\u500b\u306e\u4ed8\u7b8b\u3092\u524a\u9664\u3057\u307e\u3059\u3002", "\u4ed8\u7b8b\u306e\u524a\u9664", 2))) {
            for (int i = 0; i < nArray.length; ++i) {
                V2CResNoteItem v2CResNoteItem;
                int n = nArray[i];
                V2CThreadItem v2CThreadItem = this.icTableModel.getThreadItem(n);
                if (!V2CResNote.deleteResNote(v2CThreadItem, v2CResNoteItem = this.icTableModel.getResNoteItem(n))) continue;
                this.icTableModel.resNoteItemDeleted(n);
            }
        }
    }

    void doSortColumn(int n) {
        this.icTableModel.sort(n);
    }

    String getRowURLString(int n) {
        return null;
    }

    String getPanelURLString() {
        return null;
    }

    void showPopup(MouseEvent mouseEvent, Point point) {
        JPopupMenu jPopupMenu;
        int n = this.rowAtPoint(point);
        if (n < 0) {
            return;
        }
        if (mouseEvent != null) {
            mouseEvent.consume();
        }
        if (!this.isRowSelected(n)) {
            this.changeSelection(n, 0, false, false);
        }
        if ((jPopupMenu = V2CMain.getPopupMenu("ResNote")) == null) {
            return;
        }
        V2CPopupListener.showPopup(jPopupMenu, mouseEvent, this, point.x, point.y);
    }

    int getTitleColumnIndex() {
        return 3;
    }

    V2CListTableModel getListTableModel() {
        return this.icTableModel;
    }

    static {
        oHistoryKey = new byte[0];
        V2CResNoteList.nlColWidth[0] = 100;
        V2CResNoteList.nlColWidth[1] = 100;
        V2CResNoteList.nlColWidth[2] = 100;
        V2CResNoteList.nlColWidth[3] = 120;
        V2CResNoteList.nlColWidth[4] = 50;
        V2CResNoteList.nlColWidth[5] = 250;
        V2CResNoteList.nlColWidth[6] = 100;
        icDefault = V2CSwingUtil.getItemIcon("Tag");
    }

    private class ListRenderer
    extends V2CListTable.ListItemRenderer {
        private ListRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setHorizontalAlignment(n2 == 0 || n2 == 1 || n2 == 4 ? 4 : 2);
            if (n2 == 2) {
                object2 = V2CResNoteList.this.icTableModel.getResNoteStyle(n);
                this.setBackground(((V2CResNoteStyle)object2).getBackground());
                Color color = ((V2CResNoteStyle)object2).getForeground();
                this.setForeground(color != null ? color : V2CThreadStyle.getDefaultForeground());
                this.setText(((V2CResNoteStyle)object2).toString());
            } else if (!bl) {
                this.setForeground(V2CListTable.cTextFG);
                this.setBackground(n % 2 == 0 ? V2CListTable.cOddBG : V2CListTable.cEvenBG);
            }
            object2 = V2CResNoteList.this.icTableModel.getResNoteItem(n);
            if (!((V2CResNoteItem)object2).isValid()) {
                this.setForeground(Color.GRAY);
            }
            return this;
        }
    }

    private static class ResNoteTableModel
    extends V2CListTableModel {
        private ResNoteTableModel() {
        }

        String getTitle(int n) {
            return (String)this.getValueAt(n, 3);
        }

        public int getColumnCount() {
            return slColumnLabel.length;
        }

        String getRealColumnName(int n) {
            return slColumnLabel[n][0];
        }

        public Object getValueAt(int n, int n2) {
            if (this.olTemp == null) {
                return null;
            }
            Object[] objectArray = (Object[])this.olTemp[n];
            if (objectArray == null) {
                return null;
            }
            return objectArray[n2];
        }

        void resNoteItemUpdated(int n) {
            V2CResNoteItem v2CResNoteItem = this.getResNoteItem(n);
            Object[] objectArray = (Object[])this.olTemp[n];
            objectArray[1] = new SimpleDateFormat("yy/MM/dd HH:mm").format(new Date(v2CResNoteItem.getModificationTime()));
            objectArray[2] = new Integer(v2CResNoteItem.getStyleIndex());
            objectArray[3] = v2CResNoteItem.getKeyword();
            this.fireTableRowsUpdated(n, n);
        }

        void resNoteItemDeleted(int n) {
            this.getResNoteItem(n).invalidate();
        }

        V2CResNoteStyle getResNoteStyle(int n) {
            return V2CResNoteStyle.get((Integer)this.getValueAt(n, 2));
        }

        V2CResNoteItem getResNoteItem(int n) {
            return (V2CResNoteItem)this.getValueAt(n, 7);
        }

        V2CThreadItem getThreadItem(int n) {
            return (V2CThreadItem)this.getValueAt(n, 8);
        }

        void sort(int n) {
            this.bAscending = n == this.nColSort ? !this.bAscending : false;
            this.nColSort = n;
            Arrays.sort(this.olTemp, 0, this.getRowCount(), this);
            this.fireTableDataChanged();
        }

        public int compare(Object object, Object object2) {
            int n;
            V2CResNoteItem v2CResNoteItem = (V2CResNoteItem)((Object[])object)[7];
            V2CResNoteItem v2CResNoteItem2 = (V2CResNoteItem)((Object[])object2)[7];
            if (this.nColSort == 0) {
                long l = v2CResNoteItem2.getCreationTime() - v2CResNoteItem.getCreationTime();
                n = l < 0L ? -1 : (l > 0L ? 1 : 0);
            } else if (this.nColSort == 1) {
                long l = v2CResNoteItem2.getModificationTime() - v2CResNoteItem.getModificationTime();
                n = l < 0L ? -1 : (l > 0L ? 1 : 0);
            } else if (this.nColSort == 2) {
                n = v2CResNoteItem.getStyleIndex() - v2CResNoteItem2.getStyleIndex();
            } else if (this.nColSort == 4) {
                n = v2CResNoteItem.getResIndex() - v2CResNoteItem2.getResIndex();
            } else {
                String string = (String)((Object[])object)[this.nColSort];
                String string2 = (String)((Object[])object2)[this.nColSort];
                n = string == null ? (string2 == null ? 0 : -1) : (string2 == null ? 1 : string.compareTo(string2));
            }
            return this.bAscending ? n : -n;
        }
    }

    private class PopupListener
    extends V2CListTable.TitlePopupListener {
        private PopupListener() {
        }

        boolean isActiveColumn(int n) {
            return true;
        }

        void doClickAction(MouseEvent mouseEvent, int n, int n2) {
            V2CThreadItem v2CThreadItem = V2CResNoteList.this.icTableModel.getThreadItem(n);
            int n3 = V2CResNoteList.this.icTableModel.getResNoteItem((int)n).iRes;
            V2CThreadOpenRequest v2CThreadOpenRequest = new V2CThreadOpenRequest();
            v2CThreadOpenRequest.setResNumToGo(n3);
            String string = V2CMouseClickManager.checkClickAction("G", mouseEvent);
            if (string != null) {
                v2CThreadItem.open(false, string.equals("ON"), v2CThreadOpenRequest);
            }
        }
    }

    private class TableHeaderListener
    extends MouseInputAdapter {
        int nDragCount;

        private TableHeaderListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ++this.nDragCount;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.nDragCount = 0;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 1 && this.nDragCount < 2 && mouseEvent.getButton() == 1) {
                V2CResNoteList.this.sortColumn(V2CResNoteList.this.getColumnModel().getColumnIndexAtX(mouseEvent.getX()));
            }
        }
    }
}

