/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.monazilla.v2c.V2CUpdaterConstants;

public class V2CReleaseInfo
implements V2CUpdaterConstants {
    private static final String sDigestAlgorithm = "MD5";
    private static final int nReleaseSequenceNumber = 104;
    private static final int nReleaseSubSequenceNumber = 5;
    private static final String sNormalReleaseName = "A20180407";
    private static final int nOldestCompatibleRelSeqNum = 55;
    private static final int nCompatRelSeqNum = 98;
    private static final int nCompatRelSubSeqNum = 1;
    private static final int nCompatTestRelSeqNum = 0;
    private static final String sVersion;
    private static final String sReleaseName;
    private static final String sTestReleaseName;
    private static final int nTestReleaseSequenceNumber = 2;
    private static final boolean devMode = false;
    private static final String sRelInfFileName = "relinf.txt";
    private static final String sTestRelInfFileName = "relinft.txt";
    private static final String sIDFileName = "id";

    static {
        sTestReleaseName = null;
        sReleaseName = sNormalReleaseName;
        StringBuffer localStringBuffer = new StringBuffer();
        localStringBuffer.append(3);
        localStringBuffer.append('.');
        localStringBuffer.append(4);
        localStringBuffer.append('.');
        localStringBuffer.append(2);
        sVersion = localStringBuffer.toString();
    }

    static String checkVersionExpiration() {
        return null;
    }

    static boolean isEqual(int paramInt1, int paramInt2, int paramInt3) {
        return V2CReleaseInfo.isEqual(paramInt1, paramInt2, paramInt3, 104, 5, 2);
    }

    static boolean isNewer(int paramInt1, int paramInt2, int paramInt3) {
        return V2CReleaseInfo.isNewer(paramInt1, paramInt2, paramInt3, 104, 5, 2);
    }

    static boolean isEqual(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6) {
        return paramInt1 == paramInt4 && paramInt2 == paramInt5 && paramInt3 == paramInt6;
    }

    static boolean isNewer(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6) {
        return paramInt1 > paramInt4 || paramInt1 == paramInt4 && (paramInt2 > paramInt5 || paramInt2 == paramInt5 && paramInt3 > paramInt6);
    }

    static int[] getRelSeqNums() {
        int[] nArray = new int[6];
        nArray[0] = 104;
        nArray[1] = 2;
        nArray[2] = 5;
        nArray[3] = 1;
        nArray[4] = 2;
        return nArray;
    }

    static int getOldestCompatibleRelSeqNum() {
        return 55;
    }

    static int createRelSeqNum(int paramInt1, int paramInt2) {
        return (paramInt1 & 0xFF) - 100 << 8 | paramInt2 & 0xFF;
    }

    static int createUniqueRelSeqNum(int paramInt1, int paramInt2, int paramInt3) {
        return (paramInt1 & 0xFF) - 100 << 16 | (paramInt2 & 0xFF) << 8 | paramInt3 & 0xFF;
    }

    static int getReleaseSequenceNumber() {
        return V2CReleaseInfo.createRelSeqNum(104, 5);
    }

    static int getUniqueReleaseSequenceNumber() {
        return V2CReleaseInfo.createUniqueRelSeqNum(104, 5, 2);
    }

    static int getReleaseSubSequenceNumber() {
        return 5;
    }

    static String getDisplayName() {
        return String.valueOf(sVersion) + " [" + sReleaseName + ']';
    }

    static String getVersionOrName() {
        return sVersion;
    }

    static String getVersion() {
        return sVersion;
    }

    static String getReleaseName() {
        return sReleaseName;
    }

    static String getRelInfFileName(boolean paramBoolean) {
        return paramBoolean ? sTestRelInfFileName : sRelInfFileName;
    }

    static String calcMD5Digest(File paramFile) {
        return V2CReleaseInfo.calcMessageDigest(paramFile, sDigestAlgorithm);
    }

    static String calcMessageDigest(File paramFile, String paramString) {
        MessageDigest localMessageDigest = null;
        try {
            localMessageDigest = MessageDigest.getInstance(paramString);
        }
        catch (NoSuchAlgorithmException localNoSuchAlgorithmException) {
            return null;
        }
        BufferedInputStream localBufferedInputStream = null;
        try {
            String str2;
            int i;
            localBufferedInputStream = new BufferedInputStream(new FileInputStream(paramFile));
            byte[] arrayOfByte1 = new byte[1024];
            while ((i = localBufferedInputStream.read(arrayOfByte1)) >= 0) {
                if (i <= 0) continue;
                localMessageDigest.update(arrayOfByte1, 0, i);
            }
            byte[] arrayOfByte2 = localMessageDigest.digest();
            StringBuffer localStringBuffer = new StringBuffer();
            int j = 0;
            while (j < arrayOfByte2.length) {
                String str3 = Integer.toHexString(arrayOfByte2[j] & 0xFF);
                if (str3.length() == 1) {
                    localStringBuffer.append("0");
                }
                localStringBuffer.append(str3);
                ++j;
            }
            String string = str2 = localStringBuffer.toString();
            return string;
        }
        catch (IOException localIOException1) {
            String str1;
            String string = str1 = null;
            return string;
        }
        finally {
            try {
                if (localBufferedInputStream != null) {
                    localBufferedInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void createReleaseInfoFileWithoutPack(String paramString) {
        block14: {
            File localFile1 = new File(paramString);
            if (!localFile1.exists()) {
                return;
            }
            String str1 = V2CReleaseInfo.calcMD5Digest(localFile1);
            if (str1 == null || str1.length() == 0) {
                return;
            }
            BufferedWriter localBufferedWriter = null;
            try {
                try {
                    localBufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(sRelInfFileName), "UTF-8"));
                    localBufferedWriter.write("Version");
                    localBufferedWriter.write("=");
                    localBufferedWriter.write(sVersion);
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("Name");
                    localBufferedWriter.write("=");
                    localBufferedWriter.write(sReleaseName);
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("PackPath");
                    localBufferedWriter.write("=V2C_");
                    localBufferedWriter.write(sReleaseName);
                    localBufferedWriter.write(".pack.gz");
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("Path");
                    localBufferedWriter.write("=V2C_");
                    localBufferedWriter.write(sReleaseName);
                    localBufferedWriter.write(".jar");
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("SequenceNumber");
                    localBufferedWriter.write("=");
                    localBufferedWriter.write(String.valueOf(104));
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("SubSequenceNumber");
                    localBufferedWriter.write("=");
                    localBufferedWriter.write(String.valueOf(5));
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("TestSequenceNumber");
                    localBufferedWriter.write("=");
                    localBufferedWriter.write(String.valueOf(2));
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("Length");
                    localBufferedWriter.write("=");
                    localBufferedWriter.write(String.valueOf(localFile1.length()));
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("DigestAlgorithm");
                    localBufferedWriter.write("=");
                    localBufferedWriter.write(sDigestAlgorithm);
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("HashValue");
                    localBufferedWriter.write("=");
                    localBufferedWriter.write(str1);
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("Comment");
                    localBufferedWriter.write("=");
                }
                catch (IOException iOException) {
                    if (localBufferedWriter == null) break block14;
                    try {
                        localBufferedWriter.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (localBufferedWriter != null) {
                    try {
                        localBufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static void createReleaseInfoFile(String paramString) {
        block15: {
            File localFile1 = new File(paramString);
            File localFile2 = new File(String.valueOf(paramString.substring(0, paramString.length() - 3)) + "pack.gz");
            if (!localFile1.exists() || !localFile2.exists()) {
                return;
            }
            String str1 = V2CReleaseInfo.calcMD5Digest(localFile1);
            if (str1 == null || str1.length() == 0) {
                return;
            }
            String str2 = V2CReleaseInfo.calcMD5Digest(localFile2);
            if (str2 == null || str2.length() == 0) {
                return;
            }
            BufferedWriter localBufferedWriter = null;
            try {
                try {
                    localBufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(sRelInfFileName), "UTF-8"));
                    localBufferedWriter.write("Version");
                    localBufferedWriter.write("=");
                    localBufferedWriter.write(sVersion);
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("Name");
                    localBufferedWriter.write("=");
                    localBufferedWriter.write(sReleaseName);
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("PackPath");
                    localBufferedWriter.write("=V2C_");
                    localBufferedWriter.write(sReleaseName);
                    localBufferedWriter.write(".pack.gz");
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("Path");
                    localBufferedWriter.write("=V2C_");
                    localBufferedWriter.write(sReleaseName);
                    localBufferedWriter.write(".jar");
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("SequenceNumber");
                    localBufferedWriter.write("=");
                    localBufferedWriter.write(String.valueOf(104));
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("SubSequenceNumber");
                    localBufferedWriter.write("=");
                    localBufferedWriter.write(String.valueOf(5));
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("TestSequenceNumber");
                    localBufferedWriter.write("=");
                    localBufferedWriter.write(String.valueOf(2));
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("PackLength");
                    localBufferedWriter.write("=");
                    localBufferedWriter.write(String.valueOf(localFile2.length()));
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("Length");
                    localBufferedWriter.write("=");
                    localBufferedWriter.write(String.valueOf(localFile1.length()));
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("DigestAlgorithm");
                    localBufferedWriter.write("=");
                    localBufferedWriter.write(sDigestAlgorithm);
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("PackHashValue");
                    localBufferedWriter.write("=");
                    localBufferedWriter.write(str2);
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("HashValue");
                    localBufferedWriter.write("=");
                    localBufferedWriter.write(str1);
                    localBufferedWriter.newLine();
                    localBufferedWriter.write("Comment");
                    localBufferedWriter.write("=");
                }
                catch (IOException iOException) {
                    if (localBufferedWriter == null) break block15;
                    try {
                        localBufferedWriter.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (localBufferedWriter != null) {
                    try {
                        localBufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static void checkNumbers() {
        char i = sReleaseName.charAt(0);
        boolean j = false;
        boolean bl = j = i == 'R';
        if (!j) {
            System.out.println("SequenceNumber error !");
            System.exit(1);
        }
    }

    private static void createIDFile() {
        block13: {
            File localFile = new File(sIDFileName);
            if (localFile.exists() && !localFile.delete()) {
                System.exit(1);
            }
            byte[] arrayOfByte = new byte[]{0, 104, 5, 2};
            FilterOutputStream localBufferedOutputStream = null;
            try {
                try {
                    localBufferedOutputStream = new BufferedOutputStream(new FileOutputStream(localFile));
                    localBufferedOutputStream.write(arrayOfByte);
                    localBufferedOutputStream.write(sReleaseName.getBytes());
                }
                catch (IOException localIOException1) {
                    localIOException1.printStackTrace();
                    if (localBufferedOutputStream == null) break block13;
                    try {
                        localBufferedOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (localBufferedOutputStream != null) {
                    try {
                        localBufferedOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void main(String[] paramArrayOfString) {
        if (paramArrayOfString.length == 0) {
            System.out.print(sReleaseName);
        } else if (paramArrayOfString.length == 1) {
            String str = paramArrayOfString[0];
            if (str.endsWith(".jarwithoupack")) {
                V2CReleaseInfo.createReleaseInfoFileWithoutPack(str.substring(0, str.length() - 10));
            } else if (str.endsWith(".jar")) {
                V2CReleaseInfo.createReleaseInfoFile(str);
            } else if (str.equals("c")) {
                V2CReleaseInfo.checkNumbers();
            } else if (str.equals("i")) {
                V2CReleaseInfo.createIDFile();
            } else if (str.equals("v")) {
                System.out.print(sVersion);
            }
        }
    }
}

