/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CProgressPanel {
    JPanel jPanel;
    JLabel jlStatus;
    String sDialogTitle;
    JProgressBar jProgressBar;
    JTextArea jtaResult;
    volatile boolean bFinished;
    Thread vThread;

    public V2CProgressPanel(String string, int n) {
        this(string, n, null, false);
    }

    public V2CProgressPanel(String string, String string2) {
        this(string, 0, string2, false);
    }

    public V2CProgressPanel(String string, int n, String string2) {
        this(string, n, string2, false);
    }

    public V2CProgressPanel(String string, String string2, boolean bl) {
        this(string, 0, string2, bl);
    }

    private V2CProgressPanel(String string, int n, String string2, boolean bl) {
        JProgressBar jProgressBar;
        JPanel jPanel = new JPanel(){

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                V2CProgressPanel.this.startThread();
            }
        };
        jPanel.setLayout(new GridBagLayout());
        this.jPanel = jPanel;
        this.sDialogTitle = string2 != null ? string2 : "Progress";
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jlStatus = new JLabel(string);
        jPanel.add((Component)this.jlStatus, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.jProgressBar = jProgressBar = new JProgressBar(0, 100);
        if (n > 0) {
            jProgressBar.setMaximum(n);
            jProgressBar.setValue(0);
        } else {
            jProgressBar.setIndeterminate(true);
        }
        if (bl) {
            gridBagConstraints.fill = 2;
        }
        jPanel.add((Component)jProgressBar, gridBagConstraints);
        ++gridBagConstraints.gridy;
        if (bl) {
            JTextArea jTextArea;
            this.jtaResult = jTextArea = new JTextArea();
            jTextArea.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jScrollPane.setPreferredSize(new Dimension(400, 150));
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            jPanel.add((Component)jScrollPane, gridBagConstraints);
        }
    }

    void setMaximum(int n) {
        if (n > 0) {
            this.jProgressBar.setIndeterminate(false);
            this.jProgressBar.setMaximum(n);
            this.jProgressBar.setValue(0);
        } else {
            this.jProgressBar.setIndeterminate(true);
        }
    }

    void setMessage(String string) {
        if (EventQueue.isDispatchThread()) {
            this.jlStatus.setText(string);
        } else {
            final String string2 = string;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    V2CProgressPanel.this.jlStatus.setText(string2);
                }
            });
        }
    }

    void addResult(final String string) {
        final JTextArea jTextArea = this.jtaResult;
        if (jTextArea == null) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            jTextArea.append(string);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    jTextArea.append(string);
                }
            });
        }
    }

    String getResult() {
        return this.jtaResult.getText();
    }

    void setValue(final int n) {
        if (EventQueue.isDispatchThread()) {
            this.jProgressBar.setValue(n);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        V2CProgressPanel.this.jProgressBar.setValue(n);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    boolean showPanel() {
        return this.showPanel(null);
    }

    boolean showPanel(Thread thread) {
        if (this.bFinished) {
            return true;
        }
        this.bFinished = false;
        this.vThread = thread;
        Window window = SwingUtilities.getWindowAncestor(V2CMain.getTreePane());
        if (window instanceof JFrame && window.isVisible()) {
            V2CSwingUtil.showDialogWithClose((JFrame)window, this.jPanel, null, this.sDialogTitle, "\u4e2d\u6b62");
        } else {
            V2CSwingUtil.showDialogWithClose((JComponent)this.jPanel, null, this.sDialogTitle, "\u4e2d\u6b62");
        }
        return this.bFinished;
    }

    void hidePanel() {
        this.bFinished = true;
        Window window = SwingUtilities.getWindowAncestor(this.jPanel);
        if (!(window instanceof JDialog)) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            ((JDialog)window).setVisible(false);
        } else {
            final JDialog jDialog = (JDialog)window;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    jDialog.setVisible(false);
                }
            });
        }
    }

    private void startThread() {
        if (this.vThread != null) {
            this.vThread.start();
            this.vThread = null;
        }
    }
}

