/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMemoryGauge;
import org.monazilla.v2c.V2CPanel;
import org.monazilla.v2c.V2CProgressState;
import org.monazilla.v2c.V2CStatusBarComponent;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CProgressBar
extends V2CStatusBarComponent
implements Runnable,
ActionListener {
    static V2CProgressBar vProgressBar;
    static V2CPanel vpOwner;
    static Icon icStop;
    static Icon icOnline;
    static Icon icOffline;
    V2CProgressState psProgState;
    JProgressBar jProgressBar;
    JLabel jStopLabel;
    JLabel jTargetLabel;
    int nMin;
    int nMax;
    int nValue;
    boolean bInProgress;
    boolean bIndetMode;
    boolean bIndetModeChanged;
    boolean bBoundChanged;
    boolean bValueChanged;
    Timer tTimer;
    Timer tFadeTimer;

    static V2CProgressBar getInstance() {
        V2CProgressBar v2CProgressBar = vProgressBar;
        if (v2CProgressBar == null) {
            vProgressBar = v2CProgressBar = new V2CProgressBar();
        }
        return v2CProgressBar;
    }

    static void stopProgress() {
        V2CProgressBar.getInstance().stopProgressIfPossible();
    }

    public static void setState(V2CPanel v2CPanel, V2CProgressState v2CProgressState) {
        if (v2CPanel == null || v2CProgressState == null) {
            return;
        }
        V2CProgressBar.getInstance().setProgState(v2CPanel, v2CProgressState);
    }

    static void notifyOnlineStateChange() {
        V2CProgressBar.getInstance().onlineStateChanged();
    }

    public V2CProgressBar() {
        super((LayoutManager)new GridBagLayout(), null);
        Insets insets;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = insets = new Insets(0, 2, 0, 1);
        gridBagConstraints.fill = 3;
        this.jTargetLabel = new JLabel();
        this.setIdleIcon();
        this.add((Component)this.jTargetLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.jProgressBar = new JProgressBar(0, 100);
        this.jProgressBar.setPreferredSize(new Dimension(100, 8));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jProgressBar, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = insets;
        ++gridBagConstraints.gridx;
        this.jStopLabel = new JLabel(icStop);
        this.jStopLabel.addMouseListener(new StopButtonListener());
        this.jStopLabel.setEnabled(false);
        this.add((Component)this.jStopLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.tTimer = new Timer(200, this);
        this.tFadeTimer = new Timer(100, this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(130, nHeight);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    void onlineStateChanged() {
        Icon icon = this.jTargetLabel.getIcon();
        if (icon != icOnline && icon != icOffline) {
            return;
        }
        this.setIdleIcon();
    }

    void setIdleIcon() {
        Icon icon = V2CMain.isOnlineMode() ? icOnline : icOffline;
        this.setIcon(icon);
    }

    void setIcon(Icon icon) {
        if (this.jTargetLabel.getIcon() != icon) {
            this.jTargetLabel.setIcon(icon);
        }
    }

    synchronized void setProgState(V2CPanel v2CPanel, V2CProgressState v2CProgressState) {
        this.psProgState = v2CProgressState != null && v2CProgressState.isInProgress() ? v2CProgressState : null;
        this.setOwnerIcon(v2CPanel);
        if (EventQueue.isDispatchThread()) {
            this.updateProgressBar();
        } else {
            EventQueue.invokeLater(this);
        }
    }

    void setOwnerIcon(V2CPanel v2CPanel) {
        Icon icon = null;
        if (v2CPanel != null) {
            icon = v2CPanel.getDefaultIcon();
        }
        if (this.psProgState != null && this.psProgState.isInProgress() && icon != null) {
            this.setIcon(icon);
        } else {
            this.setIdleIcon();
        }
    }

    boolean setIndeterminateMode(boolean bl) {
        if (bl != this.bIndetMode) {
            this.bIndetModeChanged = true;
            this.bIndetMode = bl;
        }
        return bl;
    }

    void setProgressBound(int n, int n2) {
        if (this.nMin != n) {
            this.bBoundChanged = true;
            this.nMin = n;
        }
        if (this.nMax != n2) {
            this.bBoundChanged = true;
            this.nMax = n2;
        }
    }

    void setProgressValue(int n) {
        if (this.nValue != n) {
            this.bValueChanged = true;
            this.nValue = n;
        }
    }

    boolean checkInProgress() {
        boolean bl = this.psProgState != null && this.psProgState.isInProgress();
        boolean bl2 = false;
        if (bl) {
            if (!this.bInProgress) {
                this.bInProgress = true;
                this.tTimer.start();
                bl2 = true;
            }
        } else if (this.bInProgress) {
            this.tTimer.stop();
            this.bInProgress = false;
            bl2 = true;
        }
        if (bl2) {
            this.doStartStopProgress(this.bInProgress);
        }
        return bl;
    }

    void doStartStopProgress(boolean bl) {
        this.jProgressBar.setStringPainted(bl);
        if (!bl) {
            this.jProgressBar.setValue(0);
            this.setIdleIcon();
            this.enableStopLabel(false);
            this.bIndetMode = false;
            this.jProgressBar.setIndeterminate(false);
        } else {
            this.bIndetModeChanged = true;
            this.bBoundChanged = true;
            this.bValueChanged = true;
        }
    }

    boolean setProgState() {
        if (!this.checkInProgress()) {
            return false;
        }
        this.enableStopLabel(this.psProgState.isStoppable());
        if (this.setIndeterminateMode(this.psProgState.isIndetMode())) {
            return true;
        }
        if (!this.psProgState.isIndetMode()) {
            this.setProgressBound(this.psProgState.nMin, this.psProgState.nMax);
            this.setProgressValue(this.psProgState.nValue);
        }
        return true;
    }

    public void run() {
        this.updateProgressBar();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.tTimer) {
            this.updateProgressBar();
        } else if (object == this.tFadeTimer) {
            int n = nFadeFactor - 1;
            if (n <= 0) {
                this.tFadeTimer.stop();
            }
            if (n >= 0) {
                nFadeFactor = n;
                this.repaint();
                V2CMemoryGauge.getInstance().repaint();
            }
        }
    }

    synchronized void updateProgressBar() {
        if (!this.setProgState()) {
            return;
        }
        if (this.bIndetModeChanged) {
            this.jProgressBar.setIndeterminate(this.bIndetMode);
            this.jProgressBar.setStringPainted(!this.bIndetMode);
            this.bIndetModeChanged = false;
        }
        if (this.bBoundChanged) {
            this.jProgressBar.setMinimum(this.nMin);
            this.jProgressBar.setMaximum(this.nMax);
            this.bBoundChanged = false;
        }
        if (this.bValueChanged) {
            this.jProgressBar.setValue(this.nValue);
            this.bValueChanged = false;
        }
    }

    void enableStopLabel(boolean bl) {
        boolean bl2 = this.jStopLabel.isEnabled();
        this.jStopLabel.setEnabled(bl);
        if (bMacSpecial && bl != bl2) {
            Timer timer = this.tFadeTimer;
            if (bl) {
                if (timer.isRunning()) {
                    timer.stop();
                }
                nFadeFactor = -1;
                this.repaint();
                V2CMemoryGauge.getInstance().repaint();
            } else {
                nFadeFactor = 10;
                if (!timer.isRunning()) {
                    timer.start();
                }
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        if (bMacSpecial) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            V2CProgressBar.checkFadeFactor(graphics2D);
            Insets insets = this.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            int n3 = this.getWidth() - n - insets.right;
            int n4 = this.getHeight() - n2 - insets.bottom;
            graphics.setColor(cMacBG);
            graphics.fillRect(n, n2, n3, n4);
        }
        super.paintComponent(graphics);
    }

    void stopProgressIfPossible() {
        if (!this.jStopLabel.isEnabled()) {
            return;
        }
        V2CProgressState v2CProgressState = this.psProgState;
        if (v2CProgressState != null) {
            v2CProgressState.stop();
            this.enableStopLabel(false);
        }
    }

    static {
        icStop = V2CSwingUtil.getItemIcon("Stop");
        icOnline = V2CSwingUtil.getItemIcon("Online");
        icOffline = V2CSwingUtil.getItemIcon("Offline");
    }

    class StopButtonListener
    extends MouseAdapter {
        StopButtonListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (V2CProgressBar.this.psProgState == null) {
                return;
            }
            V2CProgressBar.this.psProgState.stop();
            V2CProgressBar.this.enableStopLabel(false);
        }
    }
}

