/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.monazilla.v2c.V2CBeIDItem;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CResItem;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadRes;

public class V2CNameRankingPanel
extends JPanel
implements Comparator {
    JComboBox jcbCaps;
    JComboBox jcbTrips;
    JComboBox jcbNames;
    JComboBox jcbIDs;
    JComboBox jcbPostDevices;
    JComboBox jcbBEs;
    JComboBox jcbAuxs;
    RankingEntry[] elCaps;
    RankingEntry[] elTrips;
    RankingEntry[] elNames;
    RankingEntry[] elIDs;
    RankingEntry[] elPostDevices;
    RankingEntry[] elBEs;
    RankingEntry[] elAuxs;
    boolean bChanging;

    public V2CNameRankingPanel(V2CThreadRes v2CThreadRes, ActionListener actionListener) {
        super(new GridBagLayout());
        this.generateStatistics(v2CThreadRes);
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        int n = Math.max((int)(0.75 * (double)rectangle.width), 400);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jcbNames = this.createComboBox("\u540d\u524d\uff1a", this.elNames, actionListener, false, gridBagConstraints, n);
        this.jcbCaps = this.createComboBox(" \u2605\u30ad\u30e3\u30c3\u30d7\uff1a", this.elCaps, actionListener, true, gridBagConstraints, n);
        this.jcbTrips = this.createComboBox(" \u25c6\u30c8\u30ea\u30c3\u30d7\uff1a", this.elTrips, actionListener, true, gridBagConstraints, n);
        this.jcbIDs = this.createComboBox("ID\uff1a", this.elIDs, actionListener, false, gridBagConstraints, n);
        this.jcbPostDevices = this.createComboBox("\u6295\u7a3f\u7aef\u672b\uff1a", this.elPostDevices, actionListener, true, gridBagConstraints, n);
        this.jcbBEs = this.createComboBox("Be\uff1a", this.elBEs, actionListener, false, gridBagConstraints, n);
        this.jcbAuxs = this.createComboBox("Aux\uff1a", this.elAuxs, actionListener, false, gridBagConstraints, n);
    }

    private JComboBox createComboBox(String string, RankingEntry[] rankingEntryArray, ActionListener actionListener, boolean bl, GridBagConstraints gridBagConstraints, int n) {
        gridBagConstraints.gridx = bl ? 1 : 0;
        gridBagConstraints.insets = new Insets(5, 2, 2, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)new JLabel(string), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridx;
        JComboBox jComboBox = V2CSwingUtil.createComboBox(rankingEntryArray);
        jComboBox.setFocusable(false);
        if (rankingEntryArray.length > 1) {
            if (actionListener != null) {
                jComboBox.addActionListener(actionListener);
            }
        } else {
            jComboBox.setEnabled(false);
        }
        if (!bl) {
            gridBagConstraints.gridwidth = 0;
        }
        this.add((Component)jComboBox, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        Dimension dimension = jComboBox.getPreferredSize();
        if (dimension.width > n) {
            jComboBox.setPreferredSize(new Dimension(n, dimension.height));
        }
        return jComboBox;
    }

    boolean showDialog() {
        String[] stringArray = new String[]{"\u62bd\u51fa", "\u30b3\u30d4\u30fc", "\u9589\u3058\u308b"};
        Object[] objectArray = V2CSwingUtil.createJButtonForOptionPane(stringArray);
        int n = JOptionPane.showOptionDialog(V2CMain.v2cMain, this, "\u540d\u524d\u30fbID\u30fbBE\u306e\u51fa\u73fe\u56de\u6570", -1, -1, null, objectArray, objectArray[2]);
        if (n == 1) {
            ArrayList arrayList = new ArrayList();
            this.addCopyEntry(this.elNames, "\u540d\u524d", arrayList);
            this.addCopyEntry(this.elCaps, "\u30ad\u30e3\u30c3\u30d7", arrayList);
            this.addCopyEntry(this.elTrips, "\u30c8\u30ea\u30c3\u30d7", arrayList);
            this.addCopyEntry(this.elIDs, "ID", arrayList);
            this.addCopyEntry(this.elPostDevices, "\u6295\u7a3f\u7aef\u672b", arrayList);
            this.addCopyEntry(this.elBEs, "Be", arrayList);
            this.addCopyEntry(this.elAuxs, "\u88dc\u52a9\u60c5\u5831", arrayList);
            if (arrayList.size() > 0) {
                Object[] objectArray2 = arrayList.toArray();
                Object object = JOptionPane.showInputDialog(V2CMain.v2cMain, V2CSwingUtil.wrapString("\u30b3\u30d4\u30fc\u3059\u308b\u51fa\u73fe\u983b\u5ea6\u60c5\u5831\uff1a"), "\u30b3\u30d4\u30fc", -1, null, objectArray2, objectArray2[0]);
                if (object instanceof CopyEntry) {
                    StringBuffer stringBuffer = new StringBuffer();
                    RankingEntry[] rankingEntryArray = ((CopyEntry)object).elRankingEntry;
                    for (int i = 1; i < rankingEntryArray.length; ++i) {
                        RankingEntry rankingEntry = rankingEntryArray[i];
                        stringBuffer.append(rankingEntry.nFrequency);
                        stringBuffer.append(" \u2026 ");
                        stringBuffer.append(rankingEntry.sName);
                        stringBuffer.append('\n');
                    }
                    V2CMain.copyString(stringBuffer.toString());
                }
            } else {
                V2CSwingUtil.showErrorMessage("\u30b3\u30d4\u30fc\u3067\u304d\u308b\u60c5\u5831\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
            }
        }
        return n == 0;
    }

    void addCopyEntry(RankingEntry[] rankingEntryArray, String string, ArrayList arrayList) {
        if (rankingEntryArray.length > 1) {
            arrayList.add(new CopyEntry(rankingEntryArray, string));
        }
    }

    public int compare(Object object, Object object2) {
        if (object instanceof RankingEntry && object2 instanceof RankingEntry) {
            return ((RankingEntry)object2).nFrequency - ((RankingEntry)object).nFrequency;
        }
        return 0;
    }

    private void generateStatistics(V2CThreadRes v2CThreadRes) {
        boolean bl = v2CThreadRes.isTwitter();
        int n = v2CThreadRes.getNRes();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        HashMap<Object, RankingEntry> hashMap5 = new HashMap<Object, RankingEntry>();
        HashMap<Object, RankingEntry> hashMap6 = new HashMap<Object, RankingEntry>();
        HashMap hashMap7 = new HashMap();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3;
            char c;
            String string;
            String string2;
            V2CResItem v2CResItem = v2CThreadRes.getResItem(i);
            if (v2CResItem == null) continue;
            String string3 = string2 = bl ? v2CResItem.getUserName() : v2CResItem.getNameString();
            if (string2 != null && string2.length() > 0) {
                V2CNameRankingPanel.addEntry(hashMap3, string2, true);
                if (string2.indexOf(9733) >= 0) {
                    V2CNameRankingPanel.addEntry(hashMap, string2, true);
                }
                if ((string = V2CNameRankingPanel.extractTrip(string2)) != null) {
                    V2CNameRankingPanel.addEntry(hashMap2, string, true);
                }
            }
            if ((string = v2CResItem.getID()) != null && string.length() > 1 && string.charAt(0) != '?') {
                V2CNameRankingPanel.addEntry(hashMap4, string, false);
            }
            if ((c = v2CResItem.getPostDevice()) > '\u0000') {
                object3 = new String(new char[]{c});
                object2 = (RankingEntry)hashMap5.get(object3);
                if (object2 != null) {
                    ((RankingEntry)object2).inc();
                } else {
                    object = v2CResItem.getPostDeviceName(c);
                    object = object != null ? (String)object3 + ' ' + (String)object : object3;
                    hashMap5.put(object3, new RankingEntry((String)object, 1));
                }
            }
            if ((object3 = v2CResItem.getBeID()) != null) {
                object2 = (RankingEntry)hashMap6.get(object3);
                if (object2 != null) {
                    ((RankingEntry)object2).inc();
                } else {
                    object = V2CBeIDItem.get((Integer)object3);
                    String string4 = null;
                    if (object != null) {
                        string4 = ((V2CBeIDItem)object).getLabel();
                    }
                    String string5 = ((Integer)object3).toString();
                    if (string4 != null) {
                        string5 = string5 + " <" + string4 + '>';
                    }
                    hashMap6.put(object3, new RankingEntry(string5, 1));
                }
            }
            if ((object2 = v2CResItem.getAuxString()) == null) continue;
            V2CNameRankingPanel.addEntry(hashMap7, (String)object2, false);
        }
        this.elCaps = this.createEntryArray(hashMap);
        this.elTrips = this.createEntryArray(hashMap2);
        this.elNames = this.createEntryArray(hashMap3);
        this.elIDs = this.createEntryArray(hashMap4);
        this.elPostDevices = this.createEntryArray(hashMap5);
        this.elBEs = this.createEntryArray(hashMap6);
        this.elAuxs = this.createEntryArray(hashMap7);
    }

    private static String extractTrip(String string) {
        int n;
        int n2 = string.indexOf(9670);
        if (n2 < 0) {
            return null;
        }
        int n3 = string.length();
        int n4 = string.indexOf(32, n2 + 1);
        if (n4 > 0) {
            n3 = n4;
        }
        if ((n = string.indexOf(45, n2 + 1)) > 0) {
            n3 = n;
        }
        return string.substring(n2, n3);
    }

    private static void addEntry(HashMap hashMap, String string, boolean bl) {
        if (bl || hashMap.containsKey(string)) {
            Object v = hashMap.get(string);
            if (v != null) {
                ((RankingEntry)v).inc();
            } else {
                hashMap.put(string, new RankingEntry(string, bl ? 1 : 2));
            }
        } else {
            hashMap.put(string, null);
        }
    }

    private RankingEntry[] createEntryArray(HashMap hashMap) {
        RankingEntry[] rankingEntryArray;
        ArrayList<RankingEntry> arrayList = new ArrayList<RankingEntry>(hashMap.size() + 1);
        arrayList.add(new RankingEntry("\u9078\u629e\u306a\u3057"));
        if (hashMap.size() > 0) {
            rankingEntryArray = hashMap.keySet().iterator();
            while (rankingEntryArray.hasNext()) {
                Object e = rankingEntryArray.next();
                Object v = hashMap.get(e);
                if (v == null) continue;
                arrayList.add((RankingEntry)v);
            }
        }
        rankingEntryArray = new RankingEntry[arrayList.size()];
        if ((rankingEntryArray = arrayList.toArray(rankingEntryArray)).length > 1) {
            Arrays.sort(rankingEntryArray, 1, rankingEntryArray.length, this);
        }
        return rankingEntryArray;
    }

    boolean isChanging() {
        return this.bChanging;
    }

    void reset() {
        this.unselectOtherComboBoxes(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unselectOtherComboBoxes(JComboBox jComboBox) {
        this.bChanging = true;
        try {
            if (jComboBox != this.jcbCaps && this.jcbCaps.getSelectedIndex() > 0) {
                this.jcbCaps.setSelectedIndex(0);
            }
            if (jComboBox != this.jcbTrips && this.jcbTrips.getSelectedIndex() > 0) {
                this.jcbTrips.setSelectedIndex(0);
            }
            if (jComboBox != this.jcbNames && this.jcbNames.getSelectedIndex() > 0) {
                this.jcbNames.setSelectedIndex(0);
            }
            if (jComboBox != this.jcbIDs && this.jcbIDs.getSelectedIndex() > 0) {
                this.jcbIDs.setSelectedIndex(0);
            }
            if (jComboBox != this.jcbPostDevices && this.jcbPostDevices.getSelectedIndex() > 0) {
                this.jcbPostDevices.setSelectedIndex(0);
            }
            if (jComboBox != this.jcbBEs && this.jcbBEs.getSelectedIndex() > 0) {
                this.jcbBEs.setSelectedIndex(0);
            }
            if (jComboBox != this.jcbAuxs && this.jcbAuxs.getSelectedIndex() > 0) {
                this.jcbAuxs.setSelectedIndex(0);
            }
            Object var3_2 = null;
            this.bChanging = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.bChanging = false;
            throw throwable;
        }
    }

    void setSelectedName(String string, boolean bl) {
        String string2;
        if (string == null) {
            return;
        }
        this.setSelectedItem(this.jcbNames, string);
        if (!bl) {
            return;
        }
        if (string.indexOf(9733) >= 0) {
            this.setSelectedItem(this.jcbCaps, string);
        }
        if ((string2 = V2CNameRankingPanel.extractTrip(string)) != null) {
            this.setSelectedItem(this.jcbTrips, string2);
        }
    }

    void setSelectedCap(String string) {
        if (string != null) {
            this.setSelectedItem(this.jcbCaps, string);
        }
    }

    void setSelectedTrip(String string) {
        if (string != null) {
            this.setSelectedItem(this.jcbTrips, string);
        }
    }

    void setSelectedID(String string) {
        if (string != null) {
            this.setSelectedItem(this.jcbIDs, string);
        }
    }

    void setSelectedPostDevice(char c) {
        if (c > '\u0000') {
            JComboBox jComboBox = this.jcbPostDevices;
            int n = jComboBox.getItemCount();
            for (int i = 0; i < n; ++i) {
                RankingEntry rankingEntry = (RankingEntry)jComboBox.getItemAt(i);
                String string = rankingEntry.sName;
                if (string == null || string.length() <= 0 || string.charAt(0) != c) continue;
                jComboBox.setSelectedIndex(i);
                break;
            }
        }
    }

    void setSelectedBE(int n) {
        if (n > 0) {
            Matcher matcher = Pattern.compile(n + "(?: |$)").matcher("");
            JComboBox jComboBox = this.jcbBEs;
            int n2 = jComboBox.getItemCount();
            for (int i = 0; i < n2; ++i) {
                RankingEntry rankingEntry = (RankingEntry)jComboBox.getItemAt(i);
                String string = rankingEntry.sName;
                matcher.reset(string);
                if (!matcher.lookingAt()) continue;
                jComboBox.setSelectedIndex(i);
                break;
            }
        }
    }

    void setSelectedAux(String string) {
        if (string != null) {
            this.setSelectedItem(this.jcbAuxs, string);
        }
    }

    private void setSelectedItem(JComboBox jComboBox, String string) {
        int n = jComboBox.getItemCount();
        for (int i = 0; i < n; ++i) {
            RankingEntry rankingEntry = (RankingEntry)jComboBox.getItemAt(i);
            if (!string.equals(rankingEntry.sName)) continue;
            jComboBox.setSelectedIndex(i);
            break;
        }
    }

    String getSelectedName() {
        return ((RankingEntry)this.jcbNames.getSelectedItem()).getName();
    }

    String getSelectedCap() {
        return ((RankingEntry)this.jcbCaps.getSelectedItem()).getName();
    }

    String getSelectedTrip() {
        return ((RankingEntry)this.jcbTrips.getSelectedItem()).getName();
    }

    String getSelectedID() {
        return ((RankingEntry)this.jcbIDs.getSelectedItem()).getName();
    }

    char getSelectedPostDevice() {
        String string = ((RankingEntry)this.jcbPostDevices.getSelectedItem()).getName();
        return string != null && string.length() > 0 ? string.charAt(0) : (char)'\u0000';
    }

    int getSelectedBE() {
        int n;
        String string = ((RankingEntry)this.jcbBEs.getSelectedItem()).getName();
        if (string == null) {
            return 0;
        }
        int n2 = n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            n2 = i;
            break;
        }
        if (n2 <= 0) {
            return 0;
        }
        return V2CMiscUtil.parseInt(n2 == n ? string : string.substring(0, n2));
    }

    String getSelectedAux() {
        return ((RankingEntry)this.jcbAuxs.getSelectedItem()).getName();
    }

    private static class RankingEntry {
        int nFrequency;
        String sName;
        String sLabel;

        RankingEntry(String string) {
            this(string, -1);
        }

        RankingEntry(String string, int n) {
            this.sName = string;
            this.nFrequency = n;
            if (n < 0) {
                this.sLabel = string;
            }
        }

        void inc() {
            ++this.nFrequency;
        }

        String getName() {
            return this.nFrequency > 0 ? this.sName : null;
        }

        public String toString() {
            if (this.sLabel == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('[');
                stringBuffer.append(this.nFrequency);
                stringBuffer.append("] ");
                stringBuffer.append(this.sName);
                this.sLabel = stringBuffer.toString();
            }
            return this.sLabel;
        }
    }

    private static class CopyEntry {
        RankingEntry[] elRankingEntry;
        String sLabel;

        CopyEntry(RankingEntry[] rankingEntryArray, String string) {
            this.elRankingEntry = rankingEntryArray;
            this.sLabel = string;
        }

        public String toString() {
            return this.sLabel;
        }
    }
}

