/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.monazilla.v2c.V2CAbstractMiniSearch;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMacQuaquaSupport;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CMacMiniSearch
extends V2CAbstractMiniSearch {
    static final int nLeftMargin = 28;
    static final int nRightMargin = 10;
    static final int nTopMargin = 2;
    static final int nBottomMargin = 1;
    static final Color cTop0 = new Color(0x777777);
    static final Color cTop1 = new Color(0xC7C7C7);
    static final Color cBottom = new Color(0xD8D8D8);
    static final Image imgFindL;
    static final Image imgFindR;
    static final Image imgClear;
    static final int nClearRadius;
    Dimension dSize;
    int nDocumentLength;
    Point pClearButtonCenter;

    public V2CMacMiniSearch(int n) {
        super(n, null);
        this.setOpaque(false);
        this.nWidth = V2CMain.getUserProperty().getInt(this.sWidthKey, 130);
        int n2 = imgFindL.getHeight(null);
        this.dSize = new Dimension(this.nWidth, n2);
        this.pClearButtonCenter = new Point(this.nWidth - 10 - 1, n2 / 2);
        if (V2CMacQuaquaSupport.needsGeometryTweak()) {
            V2CMacQuaquaSupport.resetVisualMargin(this.jtfSearchWords);
        }
        this.jtfSearchWords.setOpaque(true);
        this.jtfSearchWords.setBorder(BorderFactory.createEmptyBorder());
        this.add(this.jtfSearchWords);
        this.resizeTextField();
        this.addMouseListener(new SearchListener(slPopupMenuName[n], (Component)this));
    }

    void setComponentSize() {
        super.setComponentSize();
        if (this.nWidth != this.dSize.width) {
            this.dSize.width = this.nWidth;
            this.pClearButtonCenter.x = this.nWidth - 10 - 1;
        }
        this.resizeTextField();
    }

    void resizeTextField() {
        this.jtfSearchWords.setBounds(28, 2, this.pClearButtonCenter.x - nClearRadius - 28, this.dSize.height - 2 - 1);
    }

    int getMinimumWidth() {
        return 50;
    }

    void clearText() {
        if (this.nCommittedCharacterCount == this.nCombinedCharacterCount) {
            this.jtfSearchWords.setText("");
            if (!this.bInISearch && !this.bRealTime) {
                this.resetDisplay();
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.nCommittedCharacterCount != this.nCombinedCharacterCount) {
            return;
        }
        super.changedUpdate(documentEvent);
        int n = this.jtfSearchWords.getDocument().getLength();
        if (this.nDocumentLength == 0 && n > 0 || this.nDocumentLength >= 0 && n == 0) {
            this.repaint();
        }
        this.nDocumentLength = n;
    }

    public void paintComponent(Graphics graphics) {
        int n = this.dSize.width - 10;
        graphics.drawImage(imgFindL, 0, 0, null);
        graphics.drawImage(imgFindR, n, 0, null);
        graphics.setColor(Color.WHITE);
        int n2 = this.pClearButtonCenter.x - nClearRadius;
        graphics.fillRect(n2, 2, n - n2, this.dSize.height - 3);
        if (this.nDocumentLength > 0) {
            graphics.drawImage(imgClear, n2, 5, null);
        }
        graphics.setColor(cTop0);
        graphics.drawLine(28, 0, n, 0);
        graphics.setColor(cTop1);
        graphics.drawLine(28, 1, n, 1);
        graphics.setColor(cBottom);
        graphics.drawLine(28, this.dSize.height - 1, n, this.dSize.height - 1);
    }

    public Dimension getMaximumSize() {
        return this.dSize;
    }

    public Dimension getPreferredSize() {
        return this.dSize;
    }

    public Dimension getMinimumSize() {
        return this.dSize;
    }

    static {
        String string = V2CLocalFileHandler.isBrushMetalLook() ? "m" : "a";
        ImageIcon imageIcon = V2CSwingUtil.getSystemImage("macfindl" + string);
        imgFindL = imageIcon.getImage();
        imageIcon = V2CSwingUtil.getSystemImage("macfindr" + string);
        imgFindR = imageIcon.getImage();
        imageIcon = V2CSwingUtil.getSystemIcon("macclear");
        imgClear = imageIcon.getImage();
        nClearRadius = imgClear.getWidth(null) / 2;
    }

    class SearchListener
    extends V2CAbstractMiniSearch.PopupListener {
        SearchListener(String string, Component component) {
            super(string, component);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (n >= 4 && n < 22 && n2 >= 4 && n2 < 20) {
                    this.showPopup(mouseEvent);
                    return;
                }
                if (V2CMacMiniSearch.this.pClearButtonCenter.distance(n, n2) <= (double)nClearRadius) {
                    V2CMacMiniSearch.this.clearText();
                    return;
                }
            }
            super.mousePressed(mouseEvent);
        }
    }
}

