/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import org.monazilla.v2c.V2CJPConverter;
import org.monazilla.v2c.V2CLink;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CMiscUtil2;
import org.monazilla.v2c.V2CMovieUtil;
import org.monazilla.v2c.V2CNGUrl;
import org.monazilla.v2c.V2CResTextSegment;
import org.monazilla.v2c.V2CShortURLUtil;
import org.monazilla.v2c.V2CURLHolder;

public final class V2CLinkTextSegment
extends V2CResTextSegment
implements V2CURLHolder {
    private static final HashSet hsWrongURLs = new HashSet();
    String expandedUrl;
    String sURL;
    V2CLink vlLink;
    Object oKey;
    int nLastCheckTime;
    boolean bSuppressAutoDL;
    boolean bTypeChecked;
    boolean bImage;
    boolean bMovie;
    short shShortURL;
    short shNGURL;

    public V2CLinkTextSegment(int i, char[] ac, int j, int k) {
        super(i, ac, j, k, 8);
    }

    public V2CLinkTextSegment(int i, char[] ac, int j, int k, String s, boolean flag) {
        super(i, ac, j, k, 8);
        this.bSuppressAutoDL = flag;
        this.parseURL(s);
    }

    void setLink(V2CLink v2clink) {
        V2CLink v2clink1 = this.vlLink;
        this.vlLink = v2clink;
        if (v2clink != v2clink1) {
            this.oKey = v2clink != null ? v2clink.getThumbnailKey() : null;
        }
    }

    void checkThumbnailKey() {
        if (this.vlLink != null && this.oKey == null) {
            this.oKey = this.vlLink.getThumbnailKey();
        }
    }

    public boolean parseURL() {
        return this.parseURL(new String(this.clMsg, this.iSegmentStart, this.nLength));
    }

    public boolean parseURL(boolean flag, int i, int j) {
        String s;
        if (!flag) {
            return this.parseURL();
        }
        StringBuffer stringbuffer = new StringBuffer(this.nLength + j * 4);
        stringbuffer.append(this.clMsg, this.iSegmentStart, i - this.iSegmentStart);
        stringbuffer.append("xn--");
        try {
            s = V2CMiscUtil2.toPunycode(new String(this.clMsg, i, j));
        }
        catch (Exception exception) {
            return false;
        }
        if (s == null) {
            return false;
        }
        stringbuffer.append(s);
        stringbuffer.append(this.clMsg, i + j, this.nLength - (i + j - this.iSegmentStart));
        return this.parseURL(stringbuffer.toString());
    }

    private boolean parseURL(String s) {
        char c = s.charAt(0);
        if (c != 'h') {
            if (c == 't') {
                s = s.charAt(1) == 't' ? "h" + s : "ht" + s;
            } else if (c == 'w') {
                s = "http://" + s;
            } else if (c == '@') {
                s = "http://twitter.com/" + s.substring(1);
            } else if (c == '#') {
                s = "http://twitter.com/#search?q=" + V2CJPConverter.urlEncode(s, "UTF-8");
            } else if (c == '\uff03') {
                s = "http://twitter.com/#search?q=%23" + V2CJPConverter.urlEncode(s.substring(1), "UTF-8");
            }
        }
        if (s.length() > 14 && s.charAt(13) == '/' && s.startsWith("http://ime.nu")) {
            s = "http://" + s.substring(14);
        }
        int byte0 = c == 'f' ? 6 : (int)((byte)(s.charAt(4) != ':' ? 8 : 7));
        if (s.length() <= byte0) {
            return false;
        }
        return this.setURLString(s);
    }

    boolean setURLString(String s) {
        String s1;
        this.sURL = s1 = V2CMiscUtil.replaceURLEscapes(s);
        try {
            new URL(s1);
        }
        catch (MalformedURLException malformedurlexception) {
            this.sURL = null;
            if (!hsWrongURLs.contains(s)) {
                V2CMiscUtil.printMalformedURLException(malformedurlexception);
                hsWrongURLs.add(s);
            }
            return false;
        }
        this.setLink(V2CLink.getFromHistory(s1));
        return true;
    }

    @Override
    public String getURLString() {
        return this.sURL;
    }

    String getInstagramImageUrl(String originUrl) {
        if (originUrl == null) {
            return null;
        }
        if (originUrl.indexOf("https://www.instagram.com/p/") == 0) {
            return String.valueOf(originUrl) + "media/";
        }
        if (originUrl.indexOf("https://instagram.com/p/") == 0) {
            return String.valueOf(originUrl) + "media/";
        }
        return null;
    }

    public String getImageURLString() {
        if (this.bImage) {
            String url = this.getInstagramImageUrl(this.sURL);
            if (url != null) {
                return url;
            }
            url = this.getInstagramImageUrl(this.expandedUrl);
            if (url != null) {
                return url;
            }
        }
        return this.sURL;
    }

    boolean isHTTP() {
        String s = this.sURL;
        return s != null && s.toLowerCase().startsWith("http");
    }

    V2CLink getLink(int i) {
        if (this.sURL != null && V2CLink.changedSince(this.nLastCheckTime)) {
            this.setLink(V2CLink.getFromHistory(this.sURL));
            this.nLastCheckTime = i;
        }
        return this.vlLink;
    }

    @Override
    public V2CLink getLink(boolean flag) {
        if (flag && this.sURL != null) {
            this.setLink(V2CLink.getFromHistory(this.sURL));
        }
        return this.vlLink;
    }

    V2CLink getLinkForNGFile() {
        V2CLink v2clink = this.vlLink;
        return v2clink == null ? V2CLink.getLinkForNGFile(this.sURL) : v2clink;
    }

    V2CLink getLinkOrCreate(boolean flag) {
        if (this.vlLink == null && this.sURL != null) {
            this.setLink(V2CLink.getLinkOrCreate0(this.sURL, flag));
        }
        return this.vlLink;
    }

    void addToNGFile(String s) {
        V2CLink v2clink = this.getLinkForNGFile();
        if (v2clink != null) {
            v2clink.addToNGFile(s);
        }
    }

    void deleteLinkCache() {
        V2CLink v2clink = this.vlLink;
        this.setLink(null);
        if (v2clink != null) {
            v2clink.deleteHistory();
        }
    }

    void disableLink() {
        if (this.vlLink == null) {
            if (this.sURL == null) {
                return;
            }
            this.setLink(V2CLink.getLinkOrCreate0(this.sURL, false));
        }
        if (this.vlLink != null) {
            this.vlLink.disable();
        }
    }

    boolean getSuppressAutoDL() {
        return this.bSuppressAutoDL;
    }

    void resetLinkTypeCheck() {
        this.bTypeChecked = false;
        this.bMovie = false;
        this.bImage = false;
        this.shNGURL = 0;
    }

    private synchronized void checkType() {
        if (this.bTypeChecked) {
            if (V2CShortURLUtil.isValid(this.shShortURL)) {
                return;
            }
            this.shShortURL = V2CShortURLUtil.getChangeCount();
            this.resetLinkTypeCheck();
        }
        this.bTypeChecked = true;
        String s = V2CShortURLUtil.expandTCo(this.sURL);
        if (s != null) {
            String instagramUrl;
            this.expandedUrl = s;
            if (V2CMovieUtil.isMovieURL(s)) {
                this.bMovie = true;
            }
            if (s.contains(".jpg:")) {
                this.bImage = true;
            }
            if ((instagramUrl = this.getInstagramImageUrl(s)) != null) {
                this.bImage = true;
            }
            if (V2CMiscUtil.checkImageLink(s)) {
                this.bImage = true;
            }
            this.shNGURL = V2CNGUrl.isNG(s);
        }
    }

    boolean isMovieLink() {
        this.checkType();
        return this.bMovie;
    }

    boolean isImageLink() {
        this.checkType();
        return this.bImage;
    }

    boolean isNGURL() {
        this.checkType();
        short word0 = this.shNGURL;
        if (!V2CNGUrl.isValid(word0)) {
            this.shNGURL = word0 = V2CNGUrl.isNG(V2CShortURLUtil.expandTCo(this.sURL));
        }
        return (word0 & 0x8000) != 0;
    }
}

