/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.monazilla.v2c.V2CAbstractImagePanel;
import org.monazilla.v2c.V2CAnimationController;
import org.monazilla.v2c.V2CGestureActionEvent;
import org.monazilla.v2c.V2CImageSet;
import org.monazilla.v2c.V2CImageViewer;
import org.monazilla.v2c.V2CLink;
import org.monazilla.v2c.V2CNGFileItem;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CThreadAndRes;
import org.monazilla.v2c.V2CThreadItem;
import org.monazilla.v2c.V2CThreadOpenRequest;
import org.monazilla.v2c.V2CThreadPanel;

public class V2CImageViewerPanel
extends V2CAbstractImagePanel {
    private static long ltLastKeyReleaseTime;
    private static boolean bKeyReleased;
    private static final KeyListener vKeyReleaseListener;
    V2CImageViewer vImageViewer;
    V2CThreadAndRes vThreadAndRes;
    boolean bSizeSet;

    public V2CImageViewerPanel(V2CLink v2CLink, int n, V2CThreadAndRes v2CThreadAndRes, V2CImageViewer v2CImageViewer) {
        super(v2CLink, n);
        this.vThreadAndRes = v2CThreadAndRes;
        this.vImageViewer = v2CImageViewer;
        V2CAbstractImagePanel.ImageMouseListener imageMouseListener = new V2CAbstractImagePanel.ImageMouseListener("ImageViewer");
        this.addMouseListener(imageMouseListener);
        this.addMouseMotionListener(imageMouseListener);
        this.addKeyListener(vKeyReleaseListener);
    }

    V2CImageViewer getParentViewer() {
        return this.vImageViewer;
    }

    boolean grabImageMemory() {
        return V2CImageViewer.bGrabImageMemory;
    }

    public void detouch() {
        if (this.vImageSet != null) {
            V2CAnimationController.imagePopupClosed(this.vImageSet);
        }
    }

    public boolean needsScrollPane() {
        return true;
    }

    void resizePanel(boolean bl) {
        this.resizePanel(null);
        this.vImageViewer.setDialogTitle();
    }

    void saveImage(File file, boolean bl) {
        this.saveImage(this.vImageViewer.jDialog, file, this.vThreadAndRes.getThreadItem(), bl);
    }

    void maximizeWindow() {
        this.vImageViewer.maximizeWindow();
    }

    void closeWindow() {
        this.vImageViewer.closeWindow();
    }

    void closeTab() {
        this.vImageViewer.closeTab(this.vLink);
    }

    void closeAllTabs() {
        this.vImageViewer.closeAllTabs();
    }

    void closeUnselectedTabs(int n) {
        this.vImageViewer.closeUnselectedTabs(n);
    }

    void selectTab(boolean bl, boolean bl2) {
        this.vImageViewer.selectTab(bl, bl2, null);
    }

    void showNextImage(boolean bl) {
        this.selectTab(false, bl);
    }

    void doSimpleWheelRotateAction(MouseWheelEvent mouseWheelEvent) {
        if (V2CLink.bScrollViewerByWheel) {
            super.doSimpleWheelRotateAction(mouseWheelEvent);
        } else {
            this.vImageViewer.selectTab(false, mouseWheelEvent.getWheelRotation() > 0, mouseWheelEvent);
        }
    }

    V2CThreadItem getThreadItem() {
        V2CThreadAndRes v2CThreadAndRes = this.vThreadAndRes;
        return v2CThreadAndRes != null ? v2CThreadAndRes.getThreadItem() : null;
    }

    void doDoubleClickAction(MouseEvent mouseEvent) {
        if (this.nB1Count < 2) {
            return;
        }
        int n = mouseEvent.getClickCount();
        if (n >= 2 && n % 2 == 0) {
            this.closeTab();
        }
    }

    void popupSourceRes(MouseEvent mouseEvent) {
        V2CThreadAndRes v2CThreadAndRes = this.vThreadAndRes;
        if (v2CThreadAndRes == null || !v2CThreadAndRes.isDefined()) {
            return;
        }
        V2CThreadPanel v2CThreadPanel = V2CThreadPanel.loadThreadIfNotLoaded(v2CThreadAndRes.getThreadItem());
        if (v2CThreadPanel != null) {
            v2CThreadPanel.popupResNumPopup(v2CThreadAndRes.getResIndex(), mouseEvent, null);
        }
    }

    void doMiddleClickAction(MouseEvent mouseEvent) {
        if (!V2CSwingUtil.isSimpleClick(mouseEvent, 2)) {
            return;
        }
        this.popupSourceRes(mouseEvent);
    }

    void performAction(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("ShowRes")) {
            V2CThreadAndRes v2CThreadAndRes = this.vThreadAndRes;
            if (v2CThreadAndRes == null || !v2CThreadAndRes.isDefined()) {
                return;
            }
            V2CThreadOpenRequest v2CThreadOpenRequest = new V2CThreadOpenRequest();
            v2CThreadOpenRequest.setResNumToGo(v2CThreadAndRes.getResIndex());
            V2CThreadPanel.open(v2CThreadAndRes.getThreadItem(), false, true, v2CThreadOpenRequest);
        }
    }

    void linkStateChanged(boolean bl) {
        V2CImageSet v2CImageSet = this.vImageSet;
        V2CImageSet v2CImageSet2 = this.vLink.getLocalImage();
        if (v2CImageSet2 != v2CImageSet) {
            this.vImageSet = v2CImageSet2;
            this.setWidthAndHeight();
            if (bl) {
                this.repaint();
            } else {
                this.releaseImageReference();
            }
        } else if (v2CImageSet != null && this.nDispWidth < 0) {
            this.setWidthAndHeight();
            if (bl) {
                this.repaint();
            } else {
                this.releaseImageReference();
            }
        }
    }

    void toggleCheckSelectedTab() {
        this.vImageViewer.toggleCheckSelectedTab();
    }

    void toggleProtectCache() {
        super.toggleProtectCache();
        this.vImageViewer.repaint();
    }

    void setProtectCache(boolean bl) {
        super.setProtectCache(bl);
        this.vImageViewer.repaint();
    }

    void disableLink() {
        this.vLink.disable();
    }

    void deleteLinkCache() {
        this.vLink.deleteHistory();
    }

    void addToNGFile(boolean bl, ActionEvent actionEvent) {
        String string;
        if (!this.imageLoaded()) {
            return;
        }
        if (!(actionEvent instanceof V2CGestureActionEvent) && !(actionEvent.getSource() instanceof JMenuItem)) {
            if (!bKeyReleased) {
                return;
            }
            bKeyReleased = false;
        }
        if (bl) {
            string = "";
        } else {
            string = V2CNGFileItem.getInputComment();
            if (string == null) {
                return;
            }
        }
        this.vLink.addToNGFile(string);
    }

    void tryDownloadImageAgain() {
        if (this.vLink.forceDownloadImageAgain(this.vThreadAndRes)) {
            this.resetImage(true);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.bSizeSet && this.nWidth > 0 && this.nHeight > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    V2CImageViewerPanel.this.vImageViewer.setDialogTitle();
                }
            });
        }
    }

    void appendStatusString(StringBuffer stringBuffer) {
        boolean bl;
        int n = this.nWidth;
        int n2 = this.nHeight;
        boolean bl2 = bl = n > 0 && n2 > 0;
        if (!bl) {
            this.setWidthAndHeight();
            n = this.nWidth;
            n2 = this.nHeight;
            bl = n > 0 && n2 > 0;
        }
        this.bSizeSet = bl;
        if (bl) {
            stringBuffer.append('[');
            stringBuffer.append(n);
            stringBuffer.append('\u00d7');
            stringBuffer.append(n2);
            double d = this.dScale;
            if (d > 0.0 && d != 1.0) {
                stringBuffer.append(',');
                stringBuffer.append((int)(d * 100.0));
                stringBuffer.append('%');
            }
            stringBuffer.append("] ");
        }
        stringBuffer.append(this.vLink.getURLString());
    }

    static {
        bKeyReleased = true;
        vKeyReleaseListener = new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                long l = keyEvent.getWhen();
                if (l == ltLastKeyReleaseTime) {
                    bKeyReleased = false;
                    ltLastKeyReleaseTime = 0L;
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                bKeyReleased = true;
                ltLastKeyReleaseTime = keyEvent.getWhen();
            }
        };
    }
}

