/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CLocalFileHandler;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CMiscUtil;
import org.monazilla.v2c.V2CSSFont;
import org.monazilla.v2c.V2CSwingUtil;

public class V2CImageInfo {
    private static final String sTagNameFile = "exif.txt";
    private static final String[] slFormatNames = new String[]{"UNKNOWN", "BYTE", "ASCII", "SHORT", "LONG", "RATIONAL", "SBYTE", "UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "FLOAT", "DOUBLE"};
    private static final String sFormatError = "\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30a8\u30e9\u30fc";
    private static final HashMap hmTagNames = new HashMap();
    private static final HashMap hmFormats = new HashMap();
    private static final HashMap hmParameters = new HashMap();
    private static final HashMap hmUnits = new HashMap();
    static final int FORMAT_JPEG = 1;
    static final int FORMAT_PNG = 2;
    static final int FORMAT_GIF = 3;
    static final int FORMAT_BMP = 4;
    static final int FORMAT_WEBP = 5;
    final File fImageFile;
    int nFormat;
    String sFormatName;
    int nWidth;
    int nHeight;
    boolean bExif;
    int nOrientation;
    boolean bJFIF;
    boolean bICC;
    boolean bJFIFBeforeICC;
    int nColorModel = -1;
    static final int COLORMODEL_UNKNOWN = -1;
    static final int COLORMODEL_NATIVE = 0;
    static final int COLORMODEL_RGB = 0;
    static final int COLORMODEL_CMYK = 1;
    static final int COLORMODEL_YCCK = 2;
    static final int COLORMODEL_YCBCR = 3;
    String sInfoString;
    private static final char[] clFilterColor = new char[]{'R', 'G', 'B', 'C', 'M', 'Y', 'W'};

    static {
        V2CImageInfo.restoreTagName();
    }

    private static int readInt(BufferedInputStream bufferedinputstream) throws IOException {
        int i = bufferedinputstream.read();
        int j = bufferedinputstream.read();
        int k = bufferedinputstream.read();
        int l = bufferedinputstream.read();
        return i < 0 || j < 0 || k < 0 || l < 0 ? -1 : i << 24 | j << 16 | k << 8 | l;
    }

    private static int readIntR(BufferedInputStream bufferedinputstream) throws IOException {
        int i = bufferedinputstream.read();
        int j = bufferedinputstream.read();
        int k = bufferedinputstream.read();
        int l = bufferedinputstream.read();
        return i < 0 || j < 0 || k < 0 || l < 0 ? -1 : l << 24 | k << 16 | j << 8 | i;
    }

    private static int readShort(BufferedInputStream bufferedinputstream) throws IOException {
        int i = bufferedinputstream.read();
        int j = bufferedinputstream.read();
        return i < 0 || j < 0 ? -1 : i << 8 | j;
    }

    private static int readShortR(BufferedInputStream bufferedinputstream) throws IOException {
        int i = bufferedinputstream.read();
        int j = bufferedinputstream.read();
        return i < 0 || j < 0 ? -1 : j << 8 | i;
    }

    private static void restoreTagName() {
        BufferedReader bufferedreader = V2CLocalFileHandler.getConfigReader(sTagNameFile);
        if (bufferedreader == null) {
            System.out.println("cannot read exif.txt !");
            return;
        }
        try {
            try {
                String s;
                Integer integer = null;
                while ((s = bufferedreader.readLine()) != null) {
                    if (s.length() == 0 || s.charAt(0) == '#') continue;
                    char c = s.charAt(0);
                    if (c == 'F') {
                        if (integer == null) continue;
                        hmFormats.put(integer, new DecimalFormat(s.substring(1)));
                        continue;
                    }
                    if (c == 'P') {
                        if (integer == null) continue;
                        String[] as = V2CMiscUtil.split(s.substring(1));
                        hmParameters.put(integer, as);
                        continue;
                    }
                    if (c == 'U') {
                        String[] as1;
                        if (integer == null || (as1 = V2CMiscUtil.split(s.substring(1))).length != 2) continue;
                        hmUnits.put(integer, as1);
                        continue;
                    }
                    if (c == 'T') {
                        String[] as2 = V2CMiscUtil.split(s.substring(1));
                        int i = as2.length;
                        if (i != 3) continue;
                        int j = 0;
                        try {
                            j = V2CMiscUtil.parseHexString(as2[0]);
                        }
                        catch (NumberFormatException numberformatexception) {
                            continue;
                        }
                        integer = new Integer(j);
                        hmTagNames.put(integer, as2[2]);
                        continue;
                    }
                    System.out.println("unknown type: " + s);
                }
            }
            catch (IOException ioexception) {
                System.out.println(ioexception.getMessage());
                try {
                    bufferedreader.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                bufferedreader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void appendToSB(String s, StringBuffer stringbuffer) {
        if (stringbuffer != null) {
            stringbuffer.append(s);
        }
    }

    private boolean appendIFDInfo(ByteArrayWithPointer bytearraywithpointer, StringBuffer stringbuffer, int[] ai, String s) {
        int i = bytearraywithpointer.getTIFFShort(-1);
        if (i == -1) {
            return false;
        }
        if (!bytearraywithpointer.checkLength(2 + i * 12 + 4)) {
            stringbuffer.append(" [Error: too many directory entries]");
            return false;
        }
        int j = 0;
        while (j < i) {
            block123: {
                int k = bytearraywithpointer.getTIFFShort(0);
                if (k == 0) {
                    return false;
                }
                int l = bytearraywithpointer.getTIFFShort(0);
                if (l == 0) {
                    return false;
                }
                int i1 = (int)bytearraywithpointer.getTIFFLong(0L);
                if (i1 == 0) {
                    return false;
                }
                if (k == 59932 && l == 7) {
                    bytearraywithpointer.getTIFFEntryUndefined(i1);
                } else {
                    stringbuffer.append('\n');
                    stringbuffer.append(s);
                    Integer integer = new Integer(k);
                    String s1 = (String)hmTagNames.get(integer);
                    if (s1 != null) {
                        stringbuffer.append(s1);
                    } else {
                        stringbuffer.append("0x");
                        stringbuffer.append(Integer.toHexString(k));
                    }
                    stringbuffer.append("\uff1a ");
                    if (k == 34665 || k == 40965) {
                        ByteArrayWithPointer bytearraywithpointer1 = new ByteArrayWithPointer(bytearraywithpointer);
                        int j1 = (int)bytearraywithpointer.getTIFFLong(0L);
                        if (j1 == 0) {
                            return false;
                        }
                        if (ai[0] >= ai.length - 1) {
                            stringbuffer.append(" [Error: stack overflow]");
                        } else {
                            int k1 = ai[0] + 1;
                            int i2 = 1;
                            while (i2 < k1) {
                                if (ai[i2] == j1) {
                                    stringbuffer.append(" [Error: directory loop]");
                                    break block123;
                                }
                                ++i2;
                            }
                            ai[k1] = j1;
                            ai[0] = k1;
                            bytearraywithpointer1.setPointer(j1);
                            boolean flag = this.appendIFDInfo(bytearraywithpointer1, stringbuffer, ai, String.valueOf(s) + "  ");
                            ai[0] = ai[0] - 1;
                            if (!flag) {
                                return false;
                            }
                        }
                    } else {
                        String s6;
                        String s2;
                        String[] as = (String[])hmUnits.get(integer);
                        if (as != null && (s2 = as[0]) != null && s2.length() > 0) {
                            stringbuffer.append(s2);
                        }
                        DecimalFormat decimalformat = (DecimalFormat)hmFormats.get(integer);
                        if (l == 2) {
                            String s3 = bytearraywithpointer.getTIFFEntryString(i1);
                            if (s3 != null) {
                                stringbuffer.append(s3);
                            }
                        } else if (l == 3) {
                            if (i1 == 1) {
                                String[] as1;
                                int l1 = bytearraywithpointer.getTIFFEntryShort();
                                if (k == 274) {
                                    this.nOrientation = l1;
                                }
                                if ((as1 = (String[])hmParameters.get(integer)) != null) {
                                    String s7 = null;
                                    if (l1 >= 0 && l1 < as1.length) {
                                        s7 = as1[l1];
                                    }
                                    if (s7 != null && s7.length() > 0) {
                                        stringbuffer.append(s7);
                                    } else {
                                        stringbuffer.append(l1);
                                    }
                                } else if (k == 40961) {
                                    if (l1 == 1) {
                                        stringbuffer.append("sRGB");
                                    } else if (l1 == 2) {
                                        stringbuffer.append("Adobe RGB");
                                    } else if (l1 == 65533) {
                                        stringbuffer.append("Wide Gamut RGB");
                                    } else if (l1 == 65534) {
                                        stringbuffer.append("ICC Profile");
                                    } else if (l1 == 65535) {
                                        stringbuffer.append("Uncalibrated");
                                    } else {
                                        stringbuffer.append(l1);
                                    }
                                } else if (k == 37385) {
                                    stringbuffer.append("\u767a\u5149");
                                    if ((l1 & 1) == 0) {
                                        stringbuffer.append("\u305b\u305a");
                                    }
                                    stringbuffer.append("\u3001\u30ea\u30bf\u30fc\u30f3\u691c\u51fa");
                                    byte byte0 = (byte)(l1 & 6);
                                    if (byte0 == 0) {
                                        stringbuffer.append("\u6a5f\u80fd\u306a\u3057");
                                    } else if (byte0 == 2) {
                                        stringbuffer.append("\u3055\u308c\u305a");
                                    }
                                    byte byte1 = (byte)(l1 >> 3 & 3);
                                    stringbuffer.append("\u3001\u30e2\u30fc\u30c9\uff1a");
                                    if (byte1 == 0) {
                                        stringbuffer.append("\u4e0d\u660e");
                                    } else if (byte1 == 1) {
                                        stringbuffer.append("\u5f37\u5236\u767a\u5149");
                                    } else if (byte1 == 2) {
                                        stringbuffer.append("\u767a\u5149\u7981\u6b62");
                                    } else if (byte1 == 3) {
                                        stringbuffer.append("\u30aa\u30fc\u30c8");
                                    }
                                    if ((l1 & 0x20) != 0) {
                                        stringbuffer.append("\u3001\u8d64\u76ee\u8efd\u6e1b\u30e2\u30fc\u30c9");
                                    }
                                } else if (k == 41989) {
                                    if (l1 == 0) {
                                        stringbuffer.append("\u4e0d\u660e");
                                    } else {
                                        stringbuffer.append(l1);
                                    }
                                } else {
                                    stringbuffer.append(l1);
                                }
                            } else {
                                bytearraywithpointer.skip(4);
                                V2CImageInfo.appendMultiParameterMessage(l, i1, stringbuffer);
                            }
                        } else if (l == 4) {
                            if (i1 == 1) {
                                long l2 = bytearraywithpointer.getTIFFEntryLong();
                                if (k == 256) {
                                    if (this.nWidth <= 0) {
                                        this.nWidth = (int)l2;
                                    }
                                } else if (k == 257 && this.nHeight <= 0) {
                                    this.nHeight = (int)l2;
                                }
                                stringbuffer.append(l2);
                            } else {
                                bytearraywithpointer.skip(4);
                                V2CImageInfo.appendMultiParameterMessage(l, i1, stringbuffer);
                            }
                        } else if (l == 5) {
                            if (i1 == 1) {
                                String s4 = bytearraywithpointer.getTIFFEntryRational();
                                if (s4 != null) {
                                    if (k == 33437 || k == 37381) {
                                        if (bytearraywithpointer.getTIFFEntryRationalDenominator() != 0L) {
                                            V2CImageInfo.appendRationalValue(bytearraywithpointer, decimalformat, s4, stringbuffer);
                                        } else {
                                            stringbuffer.append("\u4e0d\u660e");
                                        }
                                    } else if (k == 37382) {
                                        long l3 = bytearraywithpointer.getTIFFEntryRationalNumerator();
                                        if (l3 == 0xFFFFFFFFL) {
                                            stringbuffer.append("\u221e");
                                        } else if (l3 == 0L) {
                                            stringbuffer.append("\u4e0d\u660e");
                                        } else {
                                            V2CImageInfo.appendRationalValue(bytearraywithpointer, decimalformat, s4, stringbuffer);
                                        }
                                    } else if (k == 41988) {
                                        if (s4.startsWith("0/")) {
                                            stringbuffer.append("not used");
                                        } else {
                                            V2CImageInfo.appendRationalValue(bytearraywithpointer, decimalformat, s4, stringbuffer);
                                        }
                                    } else {
                                        V2CImageInfo.appendRationalValue(bytearraywithpointer, decimalformat, s4, stringbuffer);
                                    }
                                }
                            } else {
                                bytearraywithpointer.skip(4);
                                V2CImageInfo.appendMultiParameterMessage(l, i1, stringbuffer);
                            }
                        } else if (l == 7) {
                            byte[] abyte0 = bytearraywithpointer.getTIFFEntryUndefined(i1);
                            if (abyte0 != null && k != 37500 && k != 50341) {
                                if (k == 37121 && i1 == 4) {
                                    String[] as2 = new String[]{"\u7121\u3057", "Y", "Cb", "Cr", "R", "G", "B"};
                                    int j2 = 0;
                                    while (j2 < 4) {
                                        byte byte2 = abyte0[j2];
                                        if (byte2 >= 0 && byte2 <= 6) {
                                            stringbuffer.append(as2[byte2]);
                                        } else {
                                            stringbuffer.append(byte2);
                                        }
                                        stringbuffer.append(',');
                                        ++j2;
                                    }
                                    stringbuffer.setLength(stringbuffer.length() - 1);
                                } else if (k == 41730 && i1 == 8) {
                                    boolean flag1 = true;
                                    for (int k2 = 0; k2 < 4; ++k2) {
                                        if (abyte0[k2] == 0 || abyte0[k2] == 2) continue;
                                        flag1 = false;
                                        break;
                                    }
                                    if (flag1) {
                                        stringbuffer.append("[[");
                                        stringbuffer.append(V2CImageInfo.getFilterColor(abyte0[4]));
                                        stringbuffer.append(',');
                                        stringbuffer.append(V2CImageInfo.getFilterColor(abyte0[5]));
                                        stringbuffer.append("],[");
                                        stringbuffer.append(V2CImageInfo.getFilterColor(abyte0[6]));
                                        stringbuffer.append(',');
                                        stringbuffer.append(V2CImageInfo.getFilterColor(abyte0[7]));
                                        stringbuffer.append("]]");
                                    } else {
                                        V2CImageInfo.appendMultiParameterMessage(l, i1, stringbuffer);
                                    }
                                } else if (k == 41728) {
                                    if (abyte0.length == 1 && abyte0[0] == 3) {
                                        stringbuffer.append("DSC");
                                    } else {
                                        V2CImageInfo.appendUndefinedByteArray(abyte0, stringbuffer);
                                    }
                                } else if (k == 41729) {
                                    if (abyte0.length == 1 && abyte0[0] == 1) {
                                        stringbuffer.append("\u76f4\u63a5\u64ae\u5f71\u3055\u308c\u305f\u753b\u50cf");
                                    } else {
                                        V2CImageInfo.appendUndefinedByteArray(abyte0, stringbuffer);
                                    }
                                } else if (k == 37510) {
                                    V2CImageInfo.appendUserComment(abyte0, stringbuffer);
                                } else {
                                    V2CImageInfo.appendUndefinedByteArray(abyte0, stringbuffer);
                                }
                            } else {
                                V2CImageInfo.appendMultiParameterMessage(l, i1, stringbuffer);
                            }
                        } else if (l == 10) {
                            if (i1 == 1) {
                                String s5 = bytearraywithpointer.getTIFFEntrySRational();
                                if (s5 != null) {
                                    if (k == 37379) {
                                        if (bytearraywithpointer.getTIFFEntrySRationalNumerator() == -1) {
                                            stringbuffer.append("\u4e0d\u660e");
                                        } else {
                                            V2CImageInfo.appendSRationalValue(bytearraywithpointer, decimalformat, s5, stringbuffer);
                                        }
                                    } else {
                                        V2CImageInfo.appendSRationalValue(bytearraywithpointer, decimalformat, s5, stringbuffer);
                                    }
                                }
                            } else {
                                bytearraywithpointer.skip(4);
                                V2CImageInfo.appendMultiParameterMessage(l, i1, stringbuffer);
                            }
                        } else {
                            bytearraywithpointer.skip(4);
                            V2CImageInfo.appendMultiParameterMessage(l, i1, stringbuffer);
                        }
                        if (as != null && (s6 = as[1]) != null && s6.length() > 0) {
                            stringbuffer.append(s6);
                        }
                    }
                }
            }
            ++j;
        }
        return true;
    }

    private static void appendRationalValue(ByteArrayWithPointer bytearraywithpointer, DecimalFormat decimalformat, String s, StringBuffer stringbuffer) {
        if (bytearraywithpointer.getTIFFEntryRationalDenominator() != 0L) {
            if (decimalformat != null) {
                stringbuffer.append(decimalformat.format(bytearraywithpointer.getTIFFEntryRationalValue()));
            } else {
                stringbuffer.append(s);
            }
        } else {
            stringbuffer.append(s);
        }
    }

    private static char getFilterColor(byte byte0) {
        if (byte0 < 0 || byte0 > 6) {
            return '?';
        }
        return clFilterColor[byte0];
    }

    private static void appendSRationalValue(ByteArrayWithPointer bytearraywithpointer, DecimalFormat decimalformat, String s, StringBuffer stringbuffer) {
        if (bytearraywithpointer.getTIFFEntrySRationalDenominator() != 0) {
            if (decimalformat != null) {
                stringbuffer.append(decimalformat.format(bytearraywithpointer.getTIFFEntrySRationalValue()));
            } else {
                stringbuffer.append(s);
            }
        } else {
            stringbuffer.append(s);
        }
    }

    private static void appendUndefinedByteArray(byte[] abyte0, StringBuffer stringbuffer) {
        if (abyte0 == null || abyte0.length == 0) {
            return;
        }
        boolean flag = true;
        for (int i = 0; i < abyte0.length; ++i) {
            if (abyte0[i] == 0) continue;
            flag = false;
            break;
        }
        if (flag) {
            stringbuffer.append(abyte0.length);
            stringbuffer.append("bytes of 0's [TYPE:UNDEFINED]");
            return;
        }
        boolean flag1 = true;
        for (int j = 0; j < abyte0.length; ++j) {
            byte byte0 = abyte0[j];
            if (byte0 >= 32 && byte0 <= 126) continue;
            flag1 = false;
            break;
        }
        if (flag1) {
            stringbuffer.append(new String(abyte0, 0, abyte0.length));
        } else {
            int k = 0;
            while (k < abyte0.length) {
                stringbuffer.append("0x");
                stringbuffer.append(Integer.toHexString(abyte0[k] & 0xFF));
                stringbuffer.append(',');
                ++k;
            }
            stringbuffer.setLength(stringbuffer.length() - 1);
            stringbuffer.append(" [TYPE:UNDEFINED]");
        }
    }

    private static void appendUserComment(byte[] abyte0, StringBuffer stringbuffer) {
        int j;
        if (abyte0.length < 8) {
            V2CImageInfo.appendUndefinedByteArray(abyte0, stringbuffer);
            return;
        }
        int i = 8;
        String s = null;
        for (j = 1; j < 8; ++j) {
            if (abyte0[j] != 0) continue;
            i = j;
            break;
        }
        if (i > 0) {
            s = new String(abyte0, 0, i);
        }
        if (s != null) {
            s = s.equalsIgnoreCase("ASCII") ? "ASCII" : (s.equalsIgnoreCase("JIS") ? "ISO2022JP" : (s.equalsIgnoreCase("UNICODE") ? "UTF-8" : null));
        }
        j = 0;
        for (int k = 8; k < abyte0.length; ++k) {
            if (abyte0[k] != 0) continue;
            j = k - 8;
            break;
        }
        if (j <= 0) {
            return;
        }
        System.arraycopy(abyte0, 8, abyte0, 0, j);
        String s1 = null;
        if (s != null) {
            try {
                s1 = new String(abyte0, 0, j, s);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            s1 = V2CMiscUtil.jisAutoDetect(abyte0, j);
        }
        if (s1 == null) {
            return;
        }
        int l = -1;
        for (int i1 = s1.length() - 1; i1 >= 0; --i1) {
            if (s1.charAt(i1) == ' ') continue;
            l = i1;
            break;
        }
        if (l < 0) {
            return;
        }
        if (++l < s1.length()) {
            s1 = s1.substring(0, l);
        }
        stringbuffer.append(s1);
    }

    private static void appendMultiParameterMessage(int i, int j, StringBuffer stringbuffer) {
        String s = i > 0 && i < slFormatNames.length ? slFormatNames[i] : slFormatNames[0];
        stringbuffer.append(j);
        stringbuffer.append("*[");
        stringbuffer.append(s);
        stringbuffer.append(']');
    }

    private void appendExifInfo(byte[] abyte0, int i, StringBuffer stringbuffer) {
        boolean flag;
        if (i < 10) {
            return;
        }
        if (abyte0[0] != 69 || abyte0[1] != 120 || abyte0[2] != 105 || abyte0[3] != 102 || abyte0[4] != 0) {
            return;
        }
        System.arraycopy(abyte0, 6, abyte0, 0, i - 6);
        if (abyte0[0] == 77 && abyte0[1] == 77) {
            flag = true;
        } else if (abyte0[0] == 73 && abyte0[1] == 73) {
            flag = false;
        } else {
            return;
        }
        ByteArrayWithPointer bytearraywithpointer = new ByteArrayWithPointer(abyte0, 2, flag);
        int j = bytearraywithpointer.getTIFFShort(0);
        if (j != 42 && j != 10752) {
            return;
        }
        this.bExif = true;
        stringbuffer.append("Exif\uff1a");
        int[] ai = new int[5];
        int k = (int)bytearraywithpointer.getTIFFLong(0L);
        if (k <= 0) {
            if (k < 0) {
                stringbuffer.append("\nIFD\u30aa\u30d5\u30bb\u30c3\u30c8\u30a8\u30e9\u30fc\uff1a ");
                stringbuffer.append(k);
                stringbuffer.append("\n\n");
            }
            return;
        }
        bytearraywithpointer.setPointer(k);
        ai[0] = 1;
        ai[1] = k;
        this.appendIFDInfo(bytearraywithpointer, stringbuffer, ai, "  ");
    }

    private static boolean appendJFIFInfo(byte[] abyte0, int i, StringBuffer stringbuffer) {
        if (i < 14) {
            stringbuffer.append(sFormatError);
            stringbuffer.append("\n\n");
            return false;
        }
        if (abyte0[0] != 74 || abyte0[1] != 70 || abyte0[2] != 73 || abyte0[3] != 70 || abyte0[4] != 0) {
            int j = 0;
            while (j < 5 && abyte0[j] != 0) {
                stringbuffer.append((char)abyte0[j]);
                ++j;
            }
            stringbuffer.append("\n\n");
            return false;
        }
        String s = abyte0[7] == 1 ? "/inch" : (abyte0[7] == 2 ? "/cm" : null);
        stringbuffer.append("JFIF Ver.");
        stringbuffer.append(abyte0[5]);
        stringbuffer.append('.');
        stringbuffer.append(abyte0[6]);
        stringbuffer.append("\n  \u6c34\u5e73\u30d4\u30af\u30bb\u30eb\u5bc6\u5ea6\uff1a ");
        stringbuffer.append(((abyte0[8] & 0xFF) << 8) + (abyte0[9] & 0xFF));
        if (s != null) {
            stringbuffer.append(s);
        }
        stringbuffer.append("\n  \u5782\u76f4\u30d4\u30af\u30bb\u30eb\u5bc6\u5ea6\uff1a ");
        stringbuffer.append(((abyte0[10] & 0xFF) << 8) + (abyte0[11] & 0xFF));
        if (s != null) {
            stringbuffer.append(s);
        }
        stringbuffer.append("\n  \u30b5\u30e0\u30cd\u30a4\u30eb\uff1a ");
        byte byte0 = abyte0[12];
        byte byte1 = abyte0[13];
        if (byte0 == 0 || byte1 == 0) {
            stringbuffer.append("\u306a\u3057");
        } else {
            stringbuffer.append(byte0);
            stringbuffer.append('\u00d7');
            stringbuffer.append(byte1);
        }
        stringbuffer.append("\n\n");
        return true;
    }

    private byte[] checkBLSize(byte[] abyte0, int i) {
        return abyte0.length < i ? new byte[i] : abyte0;
    }

    private int getColorModel(int components, int color_trans) {
        int model = 0;
        if (components != 4) {
            model = 0;
        } else {
            switch (color_trans) {
                default: {
                    model = 1;
                    break;
                }
                case 1: {
                    model = 3;
                    break;
                }
                case 2: {
                    model = 2;
                }
            }
        }
        return model;
    }

    private boolean appendJPEGInfo(BufferedInputStream bufferedinputstream, StringBuffer stringbuffer) throws IOException {
        int i;
        byte[] abyte0 = new byte[64];
        int nSof0ColorComponets = -1;
        int nApp14AdobeColorTransform = -1;
        while (bufferedinputstream.read() == 255 && (i = bufferedinputstream.read()) != 0 && i != 255 && i != 217 && i != 218) {
            int j = V2CImageInfo.readShort(bufferedinputstream) - 2;
            if (j < 0) {
                return false;
            }
            if (i == 192) {
                bufferedinputstream.read();
                this.nHeight = V2CImageInfo.readShort(bufferedinputstream);
                this.nWidth = V2CImageInfo.readShort(bufferedinputstream);
                nSof0ColorComponets = bufferedinputstream.read();
                if (!V2CLocalFileHandler.skipInputStream(bufferedinputstream, j - 4)) {
                    return false;
                }
            } else if ((i & 0xF0) == 224) {
                int k = i & 0xF;
                if (k == 0) {
                    if (bufferedinputstream.read(abyte0 = this.checkBLSize(abyte0, j), 0, j) != j) {
                        return false;
                    }
                    this.bJFIF = V2CImageInfo.appendJFIFInfo(abyte0, j, stringbuffer);
                    j = 0;
                } else if (k == 1) {
                    if (bufferedinputstream.read(abyte0 = this.checkBLSize(abyte0, j), 0, j) != j) {
                        return false;
                    }
                    this.appendExifInfo(abyte0, j, stringbuffer);
                    j = 0;
                } else if (k == 2 && j > 12) {
                    if (bufferedinputstream.read(abyte0, 0, 12) != 12) {
                        return false;
                    }
                    if (abyte0[11] == 0 && new String(abyte0, 0, 11).equals("ICC_PROFILE")) {
                        this.bICC = true;
                        this.bJFIFBeforeICC = this.bJFIF;
                    }
                    j -= 12;
                } else if (k == 14 && j == 12) {
                    if (bufferedinputstream.read(abyte0, 0, 12) != 12) {
                        return false;
                    }
                    if (abyte0[5] == 0 && new String(abyte0, 0, 5).equals("Adobe")) {
                        nApp14AdobeColorTransform = abyte0[11];
                    }
                    j -= 12;
                }
            }
            if (j <= 0 || V2CLocalFileHandler.skipInputStream(bufferedinputstream, j)) continue;
            return false;
        }
        if (nSof0ColorComponets != -1 && nApp14AdobeColorTransform != -1) {
            this.nColorModel = this.getColorModel(nSof0ColorComponets, nApp14AdobeColorTransform);
        }
        return true;
    }

    private boolean appendGIFInfo(BufferedInputStream bufferedinputstream, StringBuffer stringbuffer) throws IOException {
        if (bufferedinputstream.read() != 70) {
            return false;
        }
        if (!V2CLocalFileHandler.skipInputStream(bufferedinputstream, 3)) {
            return false;
        }
        int i = V2CImageInfo.readShortR(bufferedinputstream);
        int j = V2CImageInfo.readShortR(bufferedinputstream);
        if (i <= 0 || j <= 0) {
            return false;
        }
        this.nWidth = i;
        this.nHeight = j;
        return true;
    }

    private boolean appendPNGInfo(BufferedInputStream bufferedinputstream, StringBuffer stringbuffer) throws IOException {
        int j;
        String s = "NG\r\n\u001a\n";
        int i = 0;
        while (i < s.length()) {
            if (bufferedinputstream.read() != s.charAt(i)) {
                return false;
            }
            ++i;
        }
        while ((j = V2CImageInfo.readInt(bufferedinputstream)) >= 0) {
            int k = V2CImageInfo.readInt(bufferedinputstream);
            if (k < 0) {
                return false;
            }
            if (k == 1229472850) {
                int l = V2CImageInfo.readInt(bufferedinputstream);
                int i1 = V2CImageInfo.readInt(bufferedinputstream);
                if (l <= 0 || i1 <= 0) {
                    return false;
                }
                this.nWidth = l;
                this.nHeight = i1;
                return true;
            }
            if (V2CLocalFileHandler.skipInputStream(bufferedinputstream, k + 4)) continue;
            return false;
        }
        return false;
    }

    private boolean appendBMPInfo(BufferedInputStream bufferedinputstream, StringBuffer stringbuffer) throws IOException {
        if (!V2CLocalFileHandler.skipInputStream(bufferedinputstream, 16)) {
            return false;
        }
        int i = V2CImageInfo.readIntR(bufferedinputstream);
        int j = V2CImageInfo.readIntR(bufferedinputstream);
        if (i <= 0 || j <= 0) {
            return false;
        }
        this.nWidth = i;
        this.nHeight = j;
        return true;
    }

    void parse(boolean flag, boolean flag1) {
        this.parse(flag, flag1, 0, 0);
    }

    void parse(boolean flag, boolean flag1, int i, int j) {
        StringBuffer stringbuffer;
        BufferedInputStream bufferedinputstream;
        block21: {
            byte[] abyte0;
            int k;
            block20: {
                this.nWidth = i;
                this.nHeight = j;
                if (this.fImageFile == null) {
                    return;
                }
                k = (int)this.fImageFile.length();
                if (k == 0) {
                    return;
                }
                bufferedinputstream = null;
                stringbuffer = flag1 ? new StringBuffer() : null;
                bufferedinputstream = new BufferedInputStream(new FileInputStream(this.fImageFile));
                abyte0 = new byte[2];
                if (bufferedinputstream.read(abyte0) == 2) break block20;
                this.sInfoString = sFormatError;
                V2CLocalFileHandler.closeInputStream(bufferedinputstream);
                return;
            }
            try {
                try {
                    Dimension dimension;
                    String s = null;
                    boolean flag2 = false;
                    if (abyte0[0] == -1 && abyte0[1] == -40) {
                        this.nFormat = 1;
                        s = "JPEG";
                        flag2 = this.appendJPEGInfo(bufferedinputstream, stringbuffer);
                    } else if (abyte0[0] == -119 && abyte0[1] == 80) {
                        this.nFormat = 2;
                        s = "PNG";
                        flag2 = this.appendPNGInfo(bufferedinputstream, stringbuffer);
                    } else if (abyte0[0] == 71 && abyte0[1] == 73) {
                        this.nFormat = 3;
                        s = "GIF";
                        flag2 = this.appendGIFInfo(bufferedinputstream, stringbuffer);
                    } else if (abyte0[0] == 66 && abyte0[1] == 77) {
                        this.nFormat = 4;
                        s = "BMP";
                        flag2 = this.appendBMPInfo(bufferedinputstream, stringbuffer);
                    } else if (abyte0[0] == 82 && abyte0[1] == 73) {
                        this.nFormat = 5;
                        s = "WEBP";
                        flag2 = true;
                    }
                    this.sFormatName = s;
                    if (flag && (this.nWidth <= 0 || this.nHeight <= 0) && (dimension = V2CImageInfo.getImageSize(this.fImageFile)) != null) {
                        this.nWidth = dimension.width;
                        this.nHeight = dimension.height;
                    }
                    if (stringbuffer == null) break block21;
                    if (!flag2) {
                        stringbuffer.append(sFormatError);
                    }
                    if (s == null) break block21;
                    StringBuffer stringbuffer1 = new StringBuffer();
                    stringbuffer1.append(s);
                    if (this.nWidth > 0 && this.nHeight > 0) {
                        V2CImageInfo.appendGeneralInfo(stringbuffer1, k, this.nWidth, this.nHeight);
                    }
                    stringbuffer1.append("\n\n");
                    stringbuffer1.append(stringbuffer.toString());
                    stringbuffer = stringbuffer1;
                }
                catch (IOException iOException) {
                    V2CLocalFileHandler.closeInputStream(bufferedinputstream);
                }
            }
            catch (Throwable throwable) {
                V2CLocalFileHandler.closeInputStream(bufferedinputstream);
                throw throwable;
            }
        }
        V2CLocalFileHandler.closeInputStream(bufferedinputstream);
        if (flag1) {
            this.sInfoString = stringbuffer.toString();
        }
    }

    private static void appendGeneralInfo(StringBuffer stringbuffer, int i, int j, int k) {
        DecimalFormat decimalformat = new DecimalFormat(",##0");
        stringbuffer.append("\n  \u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba\uff1a ");
        stringbuffer.append(decimalformat.format(i));
        stringbuffer.append("\n  \u5e45\u00d7\u9ad8\u3055\uff1a ");
        stringbuffer.append(decimalformat.format(j));
        stringbuffer.append("\u00d7");
        stringbuffer.append(decimalformat.format(k));
    }

    boolean isJPEG() {
        return this.nFormat == 1;
    }

    private static Dimension getImageSize(File file) {
        int j;
        int i;
        block18: {
            ImageReader imagereader = null;
            ImageInputStream imageinputstream = null;
            i = 0;
            j = 0;
            try {
                try {
                    Iterator<ImageReader> iterator;
                    imageinputstream = ImageIO.createImageInputStream(file);
                    if (imageinputstream != null && (iterator = ImageIO.getImageReaders(imageinputstream)).hasNext()) {
                        imagereader = iterator.next();
                        imagereader.setInput(imageinputstream);
                        i = imagereader.getWidth(0);
                        j = imagereader.getHeight(0);
                    }
                }
                catch (IOException iOException) {
                    if (imagereader != null) {
                        imagereader.dispose();
                    }
                    if (imageinputstream != null) {
                        try {
                            imageinputstream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (imagereader != null) {
                    imagereader.dispose();
                }
                if (imageinputstream != null) {
                    try {
                        imageinputstream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (imagereader != null) {
                imagereader.dispose();
            }
            if (imageinputstream != null) {
                try {
                    imageinputstream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return new Dimension(i, j);
    }

    static V2CImageInfo getImageInfo(File file, boolean flag, boolean flag1) {
        V2CImageInfo v2cimageinfo = new V2CImageInfo(file);
        v2cimageinfo.parse(flag, flag1);
        return v2cimageinfo;
    }

    static void showPanel(File file, int i, int j) {
        V2CImageInfo.showPanel(null, file, i, j);
    }

    static void showPanel(Component component, File file, int i, int j) {
        V2CImageInfo v2cimageinfo = new V2CImageInfo(file);
        v2cimageinfo.parse(true, true, i, j);
        String s = v2cimageinfo.sInfoString;
        if (s == null || s.length() == 0) {
            s = "\u60c5\u5831\u304c\u3042\u308a\u307e\u305b\u3093";
        }
        JTextArea jtextarea = new JTextArea(s);
        jtextarea.setMargin(new Insets(5, 5, 5, 10));
        jtextarea.setEditable(false);
        jtextarea.setFont(V2CSSFont.getDefaultFont().getAwtFont());
        Dimension dimension = jtextarea.getPreferredSize();
        JScrollPane jscrollpane = new JScrollPane(jtextarea);
        Insets insets = jscrollpane.getInsets();
        Rectangle rectangle = V2CMain.v2cMain.getBounds();
        Rectangle rectangle1 = V2CSwingUtil.getScreenBoundsAt(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        int k = dimension.width + insets.left + insets.right;
        int l = 2 * rectangle1.width / 3;
        int i1 = dimension.height + insets.top + insets.bottom;
        int j1 = 2 * rectangle1.height / 3;
        int k1 = UIManager.getInt("ScrollBar.width");
        if (V2CApp.isMacintosh()) {
            k += k1;
            i1 += k1;
        }
        if (k > l) {
            i1 += k1;
        }
        if (i1 > j1) {
            k += k1;
        }
        if (k > l) {
            k = l;
        }
        if (i1 > j1) {
            i1 = j1;
        }
        Dimension dimension1 = new Dimension(k, i1);
        jscrollpane.setPreferredSize(dimension1);
        jscrollpane.setMaximumSize(dimension1);
        jtextarea.setLineWrap(true);
        JOptionPane.showMessageDialog(component == null ? V2CMain.v2cMain : component, jscrollpane, "Image Info", -1);
    }

    private V2CImageInfo(File file) {
        this.fImageFile = file;
    }

    private static class ByteArrayWithPointer {
        byte[] blBytes;
        int iPointer;
        boolean bBigEndian;
        int iRational0;
        int iRational1;
        long lRational0;
        long lRational1;

        boolean checkLength(int i) {
            return this.blBytes.length >= this.iPointer + i;
        }

        void setPointer(int i) {
            this.iPointer = i;
        }

        void skip(int i) {
            this.iPointer += i;
        }

        int getTIFFSLong() {
            int i = 0;
            if (this.bBigEndian) {
                int j = 0;
                while (j < 4) {
                    i = (i << 8) + (this.blBytes[this.iPointer + j] & 0xFF);
                    ++j;
                }
            } else {
                int k = 3;
                while (k >= 0) {
                    i = (i << 8) + (this.blBytes[this.iPointer + k] & 0xFF);
                    --k;
                }
            }
            return i;
        }

        long getTIFFLong() {
            long l = 0L;
            if (this.bBigEndian) {
                int i = 0;
                while (i < 4) {
                    l = (l << 8) + (long)(this.blBytes[this.iPointer + i] & 0xFF);
                    ++i;
                }
            } else {
                int j = 3;
                while (j >= 0) {
                    l = (l << 8) + (long)(this.blBytes[this.iPointer + j] & 0xFF);
                    --j;
                }
            }
            return l;
        }

        long getTIFFLong(long l) {
            if (this.blBytes.length < this.iPointer + 4) {
                return l;
            }
            long l1 = this.getTIFFLong();
            this.iPointer += 4;
            return l1;
        }

        int getTIFFShort() {
            if (this.bBigEndian) {
                return ((this.blBytes[this.iPointer] & 0xFF) << 8) + (this.blBytes[this.iPointer + 1] & 0xFF);
            }
            return ((this.blBytes[this.iPointer + 1] & 0xFF) << 8) + (this.blBytes[this.iPointer] & 0xFF);
        }

        int getTIFFShort(int i) {
            if (this.blBytes.length < this.iPointer + 2) {
                return i;
            }
            int j = this.getTIFFShort();
            this.iPointer += 2;
            return j;
        }

        String getTIFFEntryString(int i) {
            int j = i > 4 ? (int)this.getTIFFLong() : this.iPointer;
            this.iPointer += 4;
            if (j <= 0 || this.blBytes.length < j + i) {
                return null;
            }
            if (this.blBytes[j + i - 1] != 0) {
                if (this.blBytes.length < j + ++i) {
                    return null;
                }
            } else {
                int k = j + i - 2;
                while (k >= j && this.blBytes[k] == 0) {
                    --i;
                    --k;
                }
            }
            return i <= 1 || this.blBytes[j + i - 1] != 0 ? null : new String(this.blBytes, j, i - 1);
        }

        int getTIFFEntryShort() {
            int i = this.getTIFFShort();
            this.iPointer += 4;
            return i;
        }

        long getTIFFEntryLong() {
            long l = this.getTIFFLong();
            this.iPointer += 4;
            return l;
        }

        String getTIFFEntryRational() {
            if (!this.setTIFFEntryRationalNumbers()) {
                return null;
            }
            this.reduceRational();
            return String.valueOf(String.valueOf(this.lRational0)) + "/" + String.valueOf(this.lRational1);
        }

        long getTIFFEntryRationalNumerator() {
            return this.lRational0;
        }

        long getTIFFEntryRationalDenominator() {
            return this.lRational1;
        }

        double getTIFFEntryRationalValue() {
            return (double)this.lRational0 / (double)this.lRational1;
        }

        boolean setTIFFEntryRationalNumbers() {
            int i = (int)this.getTIFFLong();
            this.iPointer += 4;
            if (i <= 0 || this.blBytes.length < i + 8) {
                return false;
            }
            int j = this.iPointer;
            this.iPointer = i;
            this.lRational0 = this.getTIFFLong();
            this.iPointer += 4;
            this.lRational1 = this.getTIFFLong();
            this.iPointer = j;
            return true;
        }

        void reduceRational() {
            boolean flag1;
            long l1;
            long l;
            boolean flag;
            if (this.lRational0 == 0L || this.lRational1 == 0L) {
                return;
            }
            if (this.lRational0 == this.lRational1) {
                this.lRational0 = 1L;
                this.lRational1 = 1L;
            } else if (this.lRational0 < this.lRational1) {
                if (this.lRational1 % this.lRational0 == 0L) {
                    this.lRational1 /= this.lRational0;
                    this.lRational0 = 1L;
                }
            } else if (this.lRational0 % this.lRational1 == 0L) {
                this.lRational0 /= this.lRational1;
                this.lRational1 = 1L;
            }
            if (this.lRational0 == 1L || this.lRational1 == 1L) {
                return;
            }
            boolean bl = flag = this.lRational0 < this.lRational1;
            if (flag) {
                l = this.lRational0;
                l1 = this.lRational1;
            } else {
                l = this.lRational1;
                l1 = this.lRational0;
            }
            if (l > 0xFFFFFFL) {
                return;
            }
            block0: do {
                flag1 = false;
                long l2 = l / 2L;
                for (long l3 = 2L; l3 < l2; ++l3) {
                    if (l % l3 != 0L || l1 % l3 != 0L) continue;
                    l /= l3;
                    l1 /= l3;
                    flag1 = true;
                    continue block0;
                }
            } while (flag1);
            if (flag) {
                this.lRational0 = l;
                this.lRational1 = l1;
            } else {
                this.lRational0 = l1;
                this.lRational1 = l;
            }
        }

        byte[] getTIFFEntryUndefined(int i) {
            if (i <= 0) {
                this.iPointer += 4;
                return null;
            }
            int j = i <= 4 ? this.iPointer : (int)this.getTIFFLong();
            this.iPointer += 4;
            if (j <= 0 || j + i > this.blBytes.length) {
                return null;
            }
            byte[] abyte0 = new byte[i];
            System.arraycopy(this.blBytes, j, abyte0, 0, i);
            return abyte0;
        }

        String getTIFFEntrySRational() {
            if (!this.setTIFFEntrySRationalNumbers()) {
                return null;
            }
            this.reduceSRational();
            return String.valueOf(String.valueOf(this.iRational0)) + "/" + String.valueOf(this.iRational1);
        }

        int getTIFFEntrySRationalNumerator() {
            return this.iRational0;
        }

        int getTIFFEntrySRationalDenominator() {
            return this.iRational1;
        }

        double getTIFFEntrySRationalValue() {
            return (double)this.iRational0 / (double)this.iRational1;
        }

        boolean setTIFFEntrySRationalNumbers() {
            int i = (int)this.getTIFFLong();
            this.iPointer += 4;
            if (i <= 0 || this.blBytes.length < i + 8) {
                return false;
            }
            int j = this.iPointer;
            this.iPointer = i;
            this.iRational0 = this.getTIFFSLong();
            this.iPointer += 4;
            this.iRational1 = this.getTIFFSLong();
            this.iPointer = j;
            return true;
        }

        void reduceSRational() {
            boolean flag1;
            int j;
            int i;
            boolean flag;
            if (this.iRational0 <= 0 || this.iRational1 <= 0) {
                return;
            }
            if (this.iRational0 == this.iRational1) {
                this.iRational0 = 1;
                this.iRational1 = 1;
            } else if (this.iRational0 < this.iRational1) {
                if (this.iRational1 % this.iRational0 == 0) {
                    this.iRational1 /= this.iRational0;
                    this.iRational0 = 1;
                }
            } else if (this.iRational0 % this.iRational1 == 0) {
                this.iRational0 /= this.iRational1;
                this.iRational1 = 1;
            }
            if (this.iRational0 == 1 || this.iRational1 == 1) {
                return;
            }
            boolean bl = flag = this.iRational0 < this.iRational1;
            if (flag) {
                i = this.iRational0;
                j = this.iRational1;
            } else {
                i = this.iRational1;
                j = this.iRational0;
            }
            block0: do {
                flag1 = false;
                int k = i / 2;
                for (int l = 2; l < k; ++l) {
                    if (i % l != 0 || j % l != 0) continue;
                    i /= l;
                    j /= l;
                    flag1 = true;
                    continue block0;
                }
            } while (flag1);
            if (flag) {
                this.iRational0 = i;
                this.iRational1 = j;
            } else {
                this.iRational0 = j;
                this.iRational1 = i;
            }
        }

        ByteArrayWithPointer(ByteArrayWithPointer bytearraywithpointer) {
            this.blBytes = bytearraywithpointer.blBytes;
            this.iPointer = bytearraywithpointer.iPointer;
            this.bBigEndian = bytearraywithpointer.bBigEndian;
        }

        ByteArrayWithPointer(byte[] abyte0, int i, boolean flag) {
            this.blBytes = abyte0;
            this.iPointer = i;
            this.bBigEndian = flag;
        }
    }
}

