/*
 * Decompiled with CFR 0.152.
 */
package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.RectangularShape;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.monazilla.v2c.V2CApp;
import org.monazilla.v2c.V2CCoveredComboBox;
import org.monazilla.v2c.V2CFont;
import org.monazilla.v2c.V2CJ2SE5Util;
import org.monazilla.v2c.V2CMain;
import org.monazilla.v2c.V2CPanel;
import org.monazilla.v2c.V2CPanelTransferable;
import org.monazilla.v2c.V2CPopupListener;
import org.monazilla.v2c.V2CProperty;
import org.monazilla.v2c.V2CSwingUtil;
import org.monazilla.v2c.V2CTabbedPane;
import org.monazilla.v2c.V2CTempFont;
import org.monazilla.v2c.V2CToolBar;

public abstract class V2CHistory
extends JComboBox {
    static ListCellRenderer lcDefaultRenderer;
    static final DataFlavor dfObjectFlavor;
    static final DataFlavor[] dflFlavors;
    String sID;
    int nFixedWidth;
    V2CPopupListener vPopupListener;
    boolean bPopupVisible;
    V2CCoveredComboBox vCoveredComboBox;
    boolean bActionEnabled = true;
    boolean bCleared;
    V2CPanel vDraggedPanel;
    V2CPanel vTargetPanel;
    private static final Dimension dMax;

    static Component createHistory(V2CHistory v2CHistory) {
        String string;
        if (V2CSwingUtil.bListenToComboBoxButton && ((string = UIManager.getLookAndFeel().getID()).equals("Motif") || string.equals("SkinLF"))) {
            V2CCoveredComboBox v2CCoveredComboBox;
            v2CHistory.vCoveredComboBox = v2CCoveredComboBox = new V2CCoveredComboBox(v2CHistory, v2CHistory.vPopupListener);
            return v2CCoveredComboBox;
        }
        return v2CHistory;
    }

    public V2CHistory(Vector vector, String string) {
        super(vector);
        this.sID = string;
        this.setLightWeightPopupEnabled(false);
        if (V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
            this.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    V2CHistory.this.bPopupVisible = true;
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    V2CHistory.this.bPopupVisible = false;
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
        }
        if (V2CSwingUtil.bListenToComboBoxButton) {
            this.vPopupListener = new V2CPopupListener(string, this);
            V2CSwingUtil.listenToComboBoxButton(this, this.vPopupListener);
        } else {
            this.setHistPopupMenu();
        }
        DragGestureRecognizer dragGestureRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 1, new DnDListener());
    }

    void setHistPopupMenu() {
        if (V2CSwingUtil.bListenToComboBoxButton || this.sID == null) {
            return;
        }
        JPopupMenu jPopupMenu = V2CMain.getPopupMenu(this.sID);
        if (jPopupMenu != null) {
            V2CJ2SE5Util.setComponentPopupMenu(this, jPopupMenu);
        }
    }

    public void doLayout() {
        super.doLayout();
        if (this.vCoveredComboBox != null) {
            this.vCoveredComboBox.layoutComboBoxDone();
        }
    }

    public int getSelectedIndex() {
        return this.bPopupVisible ? -1 : super.getSelectedIndex();
    }

    public int getRealSelectedIndex() {
        return super.getSelectedIndex();
    }

    boolean askClearHistory(String string) {
        if (!this.bCleared) {
            if (!V2CSwingUtil.showOKCancelWarningDialog(string + "\u306e\u5c65\u6b74\u3092\u5168\u3066\u6d88\u53bb\u3057\u307e\u3059\n\uff08\u4e00\u65e6OK\u3059\u308b\u3068V2C\u306e\u7d42\u4e86\u307e\u3067\u3053\u306e\u30c0\u30a4\u30a2\u30ed\u30b0\u306f\u8868\u793a\u3055\u308c\u307e\u305b\u3093\u3002\uff09")) {
                return false;
            }
            this.bCleared = true;
        }
        return true;
    }

    int getFixedWidth() {
        return this.nFixedWidth > 0 ? this.nFixedWidth : -this.getWidth();
    }

    void setComponentSize(String string, int n) {
        V2CProperty v2CProperty = V2CMain.getUserProperty();
        if (n == this.nFixedWidth) {
            return;
        }
        this.nFixedWidth = n;
        if (n > 0) {
            v2CProperty.putInt(string, n);
        } else {
            v2CProperty.remove(string);
        }
        this.invalidate();
        V2CToolBar v2CToolBar = (V2CToolBar)SwingUtilities.getAncestorOfClass(V2CToolBar.class, this);
        if (v2CToolBar != null) {
            v2CToolBar.revalidate();
            v2CToolBar.repaint();
        }
    }

    public Dimension getMaximumSize() {
        if (this.nFixedWidth > 0) {
            return new Dimension(this.nFixedWidth, Integer.MAX_VALUE);
        }
        return dMax;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.nFixedWidth > 0) {
            return new Dimension(this.nFixedWidth, dimension.height);
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (this.nFixedWidth > 0) {
            return new Dimension(this.nFixedWidth, dimension.height);
        }
        return dimension;
    }

    static void clearRendererFont() {
        HistoryRenderer.vFont = null;
        HistoryRenderer.fFont = null;
    }

    public void updateUI() {
        super.updateUI();
        ListCellRenderer listCellRenderer = this.getRenderer();
        if (!(listCellRenderer instanceof HistoryRenderer)) {
            lcDefaultRenderer = listCellRenderer;
        }
        if (V2CSwingUtil.bListenToComboBoxButton) {
            V2CSwingUtil.listenToComboBoxButton(this, this.vPopupListener);
        } else {
            this.setHistPopupMenu();
        }
    }

    void performHistoryAction(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("ClearAndRemove")) {
            this.clearHistoryAndRemoveTab();
        }
    }

    void clearHistoryAndRemoveTab() {
        Object var1_1 = this.getItemCount() > 0 ? this.getItemAt(0) : null;
        V2CTabbedPane v2CTabbedPane = this.getTabbedPane();
        V2CPanel v2CPanel = v2CTabbedPane.getSelectedPanel();
        if (v2CPanel != null) {
            v2CTabbedPane.removePanel(v2CPanel);
            if (v2CTabbedPane.getSelectedPanel() == v2CPanel) {
                return;
            }
        }
        if (var1_1 != null) {
            this.bActionEnabled = false;
            this.removeItem(var1_1);
            this.bActionEnabled = true;
        }
    }

    abstract V2CTabbedPane getTabbedPane();

    static {
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref; class=org.monazilla.v2c.V2CPanel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        dfObjectFlavor = dataFlavor;
        dflFlavors = new DataFlavor[]{dataFlavor};
        dMax = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private class DnDListener
    implements DragGestureListener,
    DragSourceListener {
        V2CPanel vDraggedPanel;

        private DnDListener() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            V2CPanel v2CPanel;
            V2CTabbedPane v2CTabbedPane = V2CHistory.this.getTabbedPane();
            this.vDraggedPanel = v2CPanel = v2CTabbedPane.getSelectedPanel();
            if (v2CPanel == null) {
                return;
            }
            Point point = dragGestureEvent.getDragOrigin();
            Component component = dragGestureEvent.getComponent();
            Point point2 = V2CSwingUtil.getMouseLocation(component);
            if (point2 == null || point2.y >= point.y) {
                return;
            }
            V2CPanelTransferable v2CPanelTransferable = new V2CPanelTransferable(v2CPanel);
            Cursor cursor = null;
            switch (dragGestureEvent.getDragAction()) {
                case 1: {
                    cursor = DragSource.DefaultMoveNoDrop;
                    break;
                }
                case 2: {
                    cursor = DragSource.DefaultCopyNoDrop;
                    break;
                }
                default: {
                    return;
                }
            }
            V2CHistory.this.hidePopup();
            dragGestureEvent.getDragSource().startDrag(dragGestureEvent, cursor, v2CPanelTransferable, this);
        }

        void checkDrag(DragSourceDragEvent dragSourceDragEvent) {
            DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
            boolean bl = dragSourceDragEvent.getDropAction() != 0;
            Cursor cursor = null;
            switch (dragSourceDragEvent.getUserAction()) {
                case 1: {
                    cursor = bl ? DragSource.DefaultCopyDrop : DragSource.DefaultCopyNoDrop;
                    break;
                }
                case 2: {
                    cursor = bl ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop;
                    break;
                }
                case 0x40000000: {
                    cursor = DragSource.DefaultLinkNoDrop;
                }
            }
            dragSourceContext.setCursor(cursor);
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            this.checkDrag(dragSourceDragEvent);
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            this.checkDrag(dragSourceDragEvent);
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            this.checkDrag(dragSourceDragEvent);
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
            DragSourceContext dragSourceContext = dragSourceEvent.getDragSourceContext();
            dragSourceContext.setCursor(DragSource.DefaultMoveNoDrop);
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            this.vDraggedPanel = null;
        }
    }

    static class HistoryRenderer
    extends DefaultListCellRenderer {
        static final StringBuffer sbTextBuffer = new StringBuffer();
        static final Insets insInsets = new Insets(0, 0, 0, 0);
        static V2CFont vFont;
        static Font fFont;
        static final boolean bCalcLayout;
        static FontRenderContext vFontRenderContext;
        static final boolean bSetFont;

        HistoryRenderer() {
        }

        boolean checkRendererFont() {
            Object object;
            if (fFont != null) {
                return false;
            }
            Font font = null;
            if (bSetFont && (object = UIManager.getDefaults().get("ComboBox.font")) instanceof Font) {
                font = (Font)object;
            }
            if (font == null) {
                font = this.getFont();
            }
            fFont = font;
            return true;
        }

        public Dimension getPreferredSize() {
            int n;
            Object object;
            if (!bCalcLayout) {
                return super.getPreferredSize();
            }
            if (vFont == null) {
                vFont = new V2CTempFont("TempHistory", this.getFont());
                vFont.createWidthCache();
            }
            Insets insets = this.getInsets(insInsets);
            String string = this.getText();
            int n2 = insets.left + insets.right;
            if (string != null && string.length() > 0) {
                Object object2;
                object = vFontRenderContext;
                if (object == null) {
                    object2 = (Graphics2D)this.getGraphics();
                    if (object2 != null) {
                        vFontRenderContext = object = ((Graphics2D)object2).getFontRenderContext();
                    } else {
                        object = new FontRenderContext(null, false, false);
                    }
                }
                object2 = vFont.getStringBounds(string, 0, string.length(), (FontRenderContext)object);
                n2 += (int)((RectangularShape)object2).getWidth();
                n = (int)((RectangularShape)object2).getHeight();
            } else {
                object = this.getFontMetrics(vFont.getAwtFont());
                n = ((FontMetrics)object).getHeight();
            }
            object = this.getIcon();
            if (object != null) {
                n2 += object.getIconWidth() + this.getIconTextGap();
                n = Math.max(n, object.getIconHeight());
            }
            return new Dimension(n2, n += insets.top + insets.bottom);
        }

        static {
            bCalcLayout = V2CApp.isMacintosh();
            bSetFont = V2CApp.isNimbus();
        }
    }
}

